/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.export.poke;

import com.siams.cv.monitor.plugin.poke.model.PokeClass;
import com.siams.cv.monitor.plugin.poke.model.StarePokePlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Set;
import javafx.scene.paint.Color;

public class ExportPokeClassesPaletteCsv {
    private String delimiter = new String(",");

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void exportAs(File saveTo, StarePokePlugin data) throws IOException {
        if (!Files.exists(saveTo.toPath(), new LinkOption[0])) {
            saveTo.createNewFile();
        }
        Set<PokeClass> pokeClasses = data.getPokeClasses();
        int columnCount = 4;
        try (FileOutputStream out = new FileOutputStream(saveTo);){
            ArrayList<String> headers = new ArrayList<String>(columnCount);
            headers.add("id");
            headers.add("float(red)");
            headers.add("float(green)");
            headers.add("float(blue)");
            String lineHeader = String.join((CharSequence)this.delimiter, headers);
            out.write(lineHeader.getBytes(StandardCharsets.UTF_8));
            out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            ArrayList<String> lineClassPalette = new ArrayList<String>();
            for (PokeClass pokeClass : pokeClasses) {
                Color color = Color.valueOf((String)pokeClass.getColor());
                lineClassPalette.clear();
                lineClassPalette.add(String.valueOf(pokeClass.getId()));
                lineClassPalette.add(String.valueOf(color.getRed()));
                lineClassPalette.add(String.valueOf(color.getGreen()));
                lineClassPalette.add(String.valueOf(color.getBlue()));
                out.write(String.join((CharSequence)this.delimiter, lineClassPalette).getBytes(StandardCharsets.UTF_8));
                out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

