/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.export;

import com.siams.cv.monitor.export.ExportCsv;
import com.siams.cv.monitor.ui.content.container.FunctionStatistic;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExportFunctionsListLogsCsv
extends ExportCsv {
    private final List<FunctionStatistic> statistics;

    public ExportFunctionsListLogsCsv(List<FunctionStatistic> statistics) {
        Objects.requireNonNull(statistics, "Statistics required");
        this.statistics = statistics;
    }

    @Override
    public boolean export(File saveTo) throws IOException {
        if (!Files.exists(saveTo.toPath(), new LinkOption[0])) {
            saveTo.createNewFile();
        }
        int columnCount = 5;
        try (FileOutputStream out = new FileOutputStream(saveTo);){
            ArrayList<String> headers = new ArrayList<String>(5);
            headers.add("Execution order");
            headers.add("Category");
            headers.add("Name");
            headers.add("Average, ms");
            headers.add("Min, ms");
            headers.add("Max, ms");
            headers.add("Range, ms");
            String lineHeader = String.join((CharSequence)this.delimiter, headers);
            out.write(lineHeader.getBytes(StandardCharsets.UTF_8));
            out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            ArrayList<String> lineStatistic = new ArrayList<String>();
            for (FunctionStatistic statistic : this.statistics) {
                lineStatistic.clear();
                lineStatistic.add(String.valueOf(statistic.getOrder()));
                lineStatistic.add("");
                lineStatistic.add(statistic.getName());
                lineStatistic.add(String.valueOf(statistic.getDurationAverage()));
                lineStatistic.add(String.valueOf(statistic.getDurationMin()));
                lineStatistic.add(String.valueOf(statistic.getDurationMax()));
                lineStatistic.add(String.valueOf(statistic.getDurationRange()));
                out.write(String.join((CharSequence)this.delimiter, lineStatistic).getBytes(StandardCharsets.UTF_8));
                out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            }
        }
        return true;
    }
}

