/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.BasePooling;
import com.siams.cv.monitor.application.StatisticPooling;
import com.siams.cv.monitor.message.ChainStatusChanged;
import com.siams.cv.monitor.message.ObjectStatusChanged;
import com.siams.cv.monitor.message.ProjectExecutionStatusChanged;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareServerTimeout;
import com.siams.stare.api.Any;
import com.siams.stare.api.ObjectStatus;
import com.siams.stare.api.ResourceFilter;
import com.siams.stare.api.data.worker.ExecutionStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ProjectStatusPooling
extends BasePooling {
    private final Logger logger = Logger.getLogger(StatisticPooling.class);
    private static ProjectStatusPooling instance;
    private ResourceFilter filter = new ResourceFilter();

    public static ProjectStatusPooling getInstance() {
        if (instance == null) {
            instance = new ProjectStatusPooling();
        }
        return instance;
    }

    private ProjectStatusPooling() {
        this.filter.setModifiedAfter(0L);
        this.subscribe();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        this.startPooling();
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    @Subscribe
    public void onStareServerTimeout(StareServerTimeout event) {
        this.stopPooling();
    }

    @Override
    public void release() {
        super.release();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @Override
    protected CompletableFuture<Void> timerTask() {
        CompletionStage<Void> deferred = new CompletableFuture<Void>();
        deferred.complete(null);
        try {
            boolean hasProjectUrl;
            App app = App.getInstance();
            boolean bl = hasProjectUrl = !app.getProject().getUrl().isEmpty();
            if (!hasProjectUrl) {
                return deferred;
            }
            long t0 = System.currentTimeMillis();
            deferred = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)app.rqExist("P").thenAccept(exist -> {
                if (!exist.booleanValue()) {
                    EventBus.getDefault().post((Object)ChainStatusChanged.undefined());
                    throw new CompletionException("Project not found", new Throwable(""));
                }
            })).thenCompose(v -> app.rqGetProjectStatus())).thenAccept(status -> {
                switch (status) {
                    case UNDEFINED: 
                    case READY: {
                        EventBus.getDefault().post((Object)ChainStatusChanged.paused());
                        break;
                    }
                    case QUEUE: 
                    case EXECUTING: {
                        EventBus.getDefault().post((Object)ChainStatusChanged.started());
                        break;
                    }
                    default: {
                        this.logger.error((Object)String.format("Unsupported project status: %s", status.toString()));
                    }
                }
            })).thenCompose(v -> app.rqGetListUrls("P/status", this.filter))).thenCompose(urls -> {
                List<String> ids = urls.stream().filter(url -> url.contains("/worker:")).map(App::extractUrlId).collect(Collectors.toList());
                return app.rqGetWorkersStatus(ids);
            })).thenAccept(entities -> {
                for (Any any : entities) {
                    this.filter.setModifiedAfter(Math.max(any.getModified(), this.filter.getModifiedAfter()));
                    any.getData(ObjectStatus.class).ifPresent(status -> {
                        String id = App.extractUrlId(any.getUrl());
                        EventBus.getDefault().post((Object)new ObjectStatusChanged(id, (ObjectStatus)status));
                    });
                }
            })).thenCompose(v -> app.rqProjectExecutionStatus())).thenAccept(executionStatus -> EventBus.getDefault().post((Object)new ProjectExecutionStatusChanged((ExecutionStatus)executionStatus)))).exceptionally(throwable -> {
                this.logger.error((Object)String.format("Fail to fetch project status: %s", throwable.getMessage()), throwable);
                throw new CompletionException((Throwable)throwable);
            });
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return deferred;
    }

    @Override
    public void startPooling() {
        super.startPooling("Project status pooling");
    }
}

