/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.BasePooling;
import com.siams.cv.monitor.application.StatisticPooling;
import com.siams.cv.monitor.message.BlockPreviewReceived;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareServerTimeout;
import com.siams.cv.monitor.transport.grpc.observer.stream.SImage;
import com.siams.stare.api.ResourceFilter;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class PreviewPooling
extends BasePooling {
    private final Logger logger = Logger.getLogger(StatisticPooling.class);
    private static PreviewPooling instance;
    private long lastModified = 0L;

    public static PreviewPooling getInstance() {
        if (instance == null) {
            instance = new PreviewPooling();
        }
        return instance;
    }

    private PreviewPooling() {
        this.subscribe();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        this.startPooling();
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    @Subscribe
    public void onStareServerTimeout(StareServerTimeout event) {
        this.stopPooling();
    }

    @Override
    public void release() {
        this.stopPooling();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @Override
    public void stopPooling() {
        super.stopPooling();
        this.lastModified = 0L;
    }

    @Override
    protected CompletableFuture<Void> timerTask() {
        CompletionStage<Void> deferred = new CompletableFuture<Void>();
        deferred.complete(null);
        try {
            boolean hasProjectUrl;
            App app = App.getInstance();
            boolean bl = hasProjectUrl = !app.getProject().getUrl().isEmpty();
            if (!hasProjectUrl) {
                return deferred;
            }
            ResourceFilter filter = new ResourceFilter();
            filter.setModifiedAfter(this.lastModified);
            deferred = ((CompletableFuture)app.rqGetListUrls("P/preview", filter).thenCompose(urls -> {
                if (urls.size() > 0) {
                    this.logger.debug((Object)String.format("list preview size: %d", urls.size()));
                }
                return app.rqForEachAnyIfExistWithWaiting((List<String>)urls, any -> {
                    this.lastModified = Math.max(this.lastModified, any.getModified());
                    try {
                        String objectId = App.extractUrlId(any.getUrl());
                        if (any.getData().isPresent()) {
                            Object value = any.getData().get();
                            Object data = BufferedImage.class.isAssignableFrom(value.getClass()) ? SImage.valueOf((BufferedImage)value) : value;
                            EventBus.getDefault().post((Object)new BlockPreviewReceived(objectId, data));
                        } else {
                            EventBus.getDefault().post((Object)new BlockPreviewReceived(objectId, null));
                        }
                    }
                    catch (Throwable t) {
                        this.logger.error((Object)"Failed extract object uuid", t);
                    }
                });
            })).exceptionally(t -> {
                this.logger.error((Object)"Failed get preview", t);
                throw new CompletionException(new Throwable("Failed get preview"));
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return deferred;
    }

    @Override
    public void startPooling() {
        super.startPooling("Preview pooling");
    }
}

