/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.message.NewNodeAdded;
import com.siams.cv.monitor.message.NodeModelChanged;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.ObjectPropertySet;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareProjectSaved;
import com.siams.general.Deletable;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ActionHistory
implements Deletable {
    private static Logger logger = Logger.getLogger(ActionHistory.class);
    private boolean changed = false;

    ActionHistory() {
        this.subscribe();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public boolean isChanged() {
        return this.changed;
    }

    @Subscribe
    public void onNewNodeAdded(NewNodeAdded event) {
        this.catchAction(event);
    }

    @Subscribe
    public void onNodeModelChanged(NodeModelChanged event) {
        this.catchAction(event);
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        this.catchAction(event);
    }

    @Subscribe
    public void onObjectPropertySet(ObjectPropertySet event) {
        this.catchAction(event);
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        logger.trace((Object)("Clear changes history by" + event.getClass().getName()));
        this.changed = false;
    }

    @Subscribe
    public void onStareProjectSaved(StareProjectSaved event) {
        logger.trace((Object)("Clear changes history by" + event.getClass().getName()));
        this.changed = false;
    }

    private void catchAction(Object event) {
        logger.trace((Object)("Project changed by " + event.getClass().getName()));
        this.changed = true;
    }

    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }
}

