/*
 * Decompiled with CFR 0.152.
 */
package com.scichains.ide.application;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.GlobalHotKeys;
import com.siams.cv.monitor.application.ProgramArguments;
import com.siams.cv.monitor.message.StareChainConfigLoaded;
import com.siams.cv.monitor.message.StareChainConfigSaved;
import com.siams.cv.monitor.message.StareMonitorStarted;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareProjectSaved;
import com.siams.cv.monitor.message.StareServerConnected;
import com.siams.cv.monitor.message.StareServerTimeout;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.transport.grpc.GrpcTransport;
import com.siams.cv.monitor.ui.content.container.RootPane;
import com.siams.cv.monitor.ui.content.windows.ConnectionWindow;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.javafx.utils.FxPlatform;
import com.siams.preferences.UIPreference;
import com.siams.stare.api.StareApi;
import com.siams.stare.grpc.StareGrpc;
import com.siams.stare.grpc.StareGrpcFutureStubImpl;
import io.grpc.ConnectivityState;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.app.Velocity;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class SciChainsIDE
extends Application
implements Deletable,
UIPreference {
    private static final String SERVER_EXECUTABLE = "bin/__algart-executor-service.exe";
    private static final String SERVER_CONFIG = "bin/config.json";
    private static final Logger logger = Logger.getLogger(SciChainsIDE.class);
    private Stage stage;
    private static App app;
    private static final ProgramArguments programArguments;
    private Process managedServerProcess = null;
    ChangeListener<Boolean> stageShowPropertyListener = (ob, o, n) -> {
        if (n.booleanValue()) {
            EventBus.getDefault().post((Object)new StareMonitorStarted());
        }
    };
    private ConnectivityState currentConnectivityState = ConnectivityState.SHUTDOWN;

    private void initializeStareApi() {
        Preferences preferences = Preferences.userNodeForPackage(ConnectionWindow.class);
        String host = preferences.get("host", GrpcTransport.DEFAULT_CONNECTION_HOST);
        int port = preferences.getInt("port", GrpcTransport.DEFAULT_CONNECTION_PORT);
        StareGrpcFutureStubImpl stareApi = (StareGrpcFutureStubImpl)StareGrpc.create((String)host, (int)port, connectivityState -> {
            if (this.currentConnectivityState != ConnectivityState.READY && connectivityState == ConnectivityState.READY) {
                this.currentConnectivityState = ConnectivityState.READY;
                EventBus.getDefault().post((Object)new StareServerConnected());
            } else if (this.currentConnectivityState != ConnectivityState.TRANSIENT_FAILURE && connectivityState == ConnectivityState.TRANSIENT_FAILURE) {
                this.currentConnectivityState = ConnectivityState.TRANSIENT_FAILURE;
                EventBus.getDefault().post((Object)new StareServerTimeout());
            }
        });
        stareApi.setUrlModifier(originalUrl -> originalUrl.startsWith("P") ? app.getProject().getUrl() + originalUrl.substring(1) : originalUrl);
        app.setStareApi((StareApi)stareApi);
    }

    private void initializeApp(Stage stage, RootPane root) {
        app = App.getInstance();
        app.setMainStage(stage);
        app.initializePlugins((Node)root);
        app.initializeStatisticPooling();
        app.initializePreviewPooling();
        app.initializeProjectStatusPooling();
        app.setProgramArguments(programArguments);
        this.startManagedServerProcessIfNecessary();
        this.initializeStareApi();
    }

    private void startManagedServerProcessIfNecessary() {
        if (programArguments.isManagedServer()) {
            Path home;
            Path envHome;
            Path parent = Paths.get("..", new String[0]).toAbsolutePath();
            String envHomeVariable = System.getenv("EXECUTORS_HOME");
            Path path = envHome = envHomeVariable == null ? null : Paths.get(envHomeVariable, new String[0]);
            if (Files.isExecutable(parent.resolve(SERVER_EXECUTABLE))) {
                home = parent;
            } else if (envHome != null && Files.isExecutable(envHome.resolve(SERVER_EXECUTABLE))) {
                home = envHome;
            } else {
                logger.warn((Object)"Server not found: bin/__algart-executor-service.exe");
                return;
            }
            home = home.toAbsolutePath();
            Path serverExecutable = home.resolve(SERVER_EXECUTABLE);
            List<String> commands = Arrays.asList(serverExecutable.toString(), "--config=" + String.valueOf(home.resolve(SERVER_CONFIG)));
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            processBuilder.directory(serverExecutable.getParent().toFile());
            processBuilder.inheritIO();
            try {
                this.managedServerProcess = processBuilder.start();
            }
            catch (IOException e) {
                logger.error((Object)("Failed execute: " + String.join((CharSequence)" ", commands)));
                throw new UncheckedIOException(e);
            }
        }
    }

    private void stopManagedServerProcessIfNecessary() {
        if (this.managedServerProcess != null && this.managedServerProcess.isAlive()) {
            this.managedServerProcess.destroy();
        }
    }

    public void start(Stage stage) {
        this.stage = stage;
        this.subscribe();
        RootPane root = this.initializeRootPane();
        Scene scene = this.initializeScene(root);
        GlobalHotKeys.initializeGlobalHotKeys(scene);
        this.restorePreference();
        this.initializeStage(stage);
        this.initializeApp(stage, root);
        stage.setScene(scene);
        stage.show();
    }

    private void initializeStage(Stage stage) {
        stage.setOnCloseRequest(e -> {
            boolean closed = app.close();
            if (!closed) {
                e.consume();
            }
        });
        stage.showingProperty().addListener(this.stageShowPropertyListener);
        this.stageShowPropertyListener.changed(null, (Object)false, (Object)true);
    }

    private RootPane initializeRootPane() {
        return RootPane.getInstance();
    }

    private Scene initializeScene(RootPane root) {
        Scene scene = new Scene((Parent)root);
        scene.getStylesheets().add((Object)"style.css");
        scene.getStylesheets().add((Object)"tooltip.css");
        root.widthProperty().add((ObservableNumberValue)scene.widthProperty());
        return scene;
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        String title = this.createTitle(event.getProject(), app.getCurrentProjectConfigPath());
        this.setTitle(title);
    }

    @Subscribe
    public void onStareProjectSaved(StareProjectSaved event) {
        String title = this.createTitle(event.getProject(), app.getCurrentProjectConfigPath());
        this.setTitle(title);
    }

    @Subscribe
    public void onStareChainConfigLoaded(StareChainConfigLoaded event) {
        String title = this.createTitle(app.getProject(), app.getCurrentProjectConfigPath());
        this.setTitle(title);
    }

    @Subscribe
    public void onStareChainConfigSaved(StareChainConfigSaved event) {
        String title = this.createTitle(app.getProject(), app.getCurrentProjectConfigPath());
        this.setTitle(title);
    }

    public void restorePreference() {
        boolean isMaximazed = this.getPreferredBoolean("isMaximized", true);
        if (isMaximazed) {
            this.stage.setMaximized(true);
        } else {
            this.stage.setWidth(this.getPreferredDouble("width", 600.0));
            this.stage.setHeight(this.getPreferredDouble("height", 800.0));
            this.stage.setX(this.getPreferredDouble("x", 0.0));
            this.stage.setY(this.getPreferredDouble("y", 0.0));
        }
    }

    public void savePreference() {
        this.putPreferredBoolean("isMaximized", this.stage.isMaximized());
        this.putPreferredDouble("width", this.stage.getWidth());
        this.putPreferredDouble("height", this.stage.getHeight());
        this.putPreferredDouble("x", this.stage.getX());
        this.putPreferredDouble("y", this.stage.getY());
    }

    private String getLocalHostName() {
        String hostName = "anonymous";
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostName = address.getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hostName;
    }

    private static void parseArgs(String[] args) {
        programArguments.parse(args);
    }

    public static void main(String[] args) {
        SciChainsIDE.initializeLog4j();
        logger.info((Object)"********************************* SciChains IDE *************************************************");
        SciChainsIDE.parseArgs(args);
        SciChainsIDE.initializeVelocity();
        SciChainsIDE.launch((String[])args);
    }

    private static void initializeLog4j() {
        PropertyConfigurator.configureAndWatch((String)"log4j.properties", (long)5000L);
    }

    private static void initializeVelocity() {
        Velocity.init((String)"velocity.properties");
    }

    public void stop() throws Exception {
        super.stop();
        this.savePreference();
        this.release();
        Thread.sleep(100L);
        this.stopManagedServerProcessIfNecessary();
        System.exit(0);
    }

    private static void debugShowNonDaemons() {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        System.out.println();
        for (Thread t : allStackTraces.keySet()) {
            if (!t.isDaemon()) continue;
            System.out.printf("%s (daemon)%n", t);
        }
        System.out.printf("%nNon daemons:%n", new Object[0]);
        for (Thread t : allStackTraces.keySet()) {
            if (t.isDaemon()) continue;
            System.out.printf("%n%s: %n%s%n", t, Arrays.stream(allStackTraces.get(t)).map(StackTraceElement::toString).collect(Collectors.joining("\n  ")));
        }
    }

    private String createTitle(Project project, Optional<Path> chainConfig) {
        String caption = project.getCaption();
        String config = chainConfig.map(path -> path.getFileName().toString()).orElse("");
        return config.isEmpty() ? String.format("%s", caption) : String.format("%s [%s]", caption, config);
    }

    public void setTitle(String title) {
        FxPlatform.RunFxThread(() -> this.stage.setTitle(title));
    }

    @Override
    public void release() {
        app.release();
    }

    static {
        programArguments = new ProgramArguments();
    }
}

