/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.matrices.spectra.SampleArray;

public abstract class RealVectorSampleArray
implements SampleArray {
    private static final int BUFFER_LENGTH = 32768;
    private static final int NUMBER_OF_BUFFERS = 2;
    private static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 65536);
    private static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 65536);
    final long vectorLength;
    final long vectorStep;
    final long length;
    final UpdatablePNumberArray samples;

    RealVectorSampleArray(UpdatablePNumberArray samples, long vectorLength, long vectorStep, long length) {
        Objects.requireNonNull(samples, "Null samples");
        if (vectorLength < 0L) {
            throw new IllegalArgumentException("Negative vectorLength = " + vectorLength);
        }
        if (vectorStep < vectorLength) {
            throw new IllegalArgumentException("vectorStep = " + vectorStep + " < vectorLength = " + vectorLength);
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Negative length = " + length);
        }
        long m = samples.length() - vectorLength;
        if (length > 0L && m < 0L || vectorStep > 0L && length - 1L > m / vectorStep) {
            throw new IllegalArgumentException("samples is too short: its length " + samples.length() + " < (length - 1) * vectorStep + vectorLength = " + (length - 1L) + " * " + vectorStep + " + " + vectorLength);
        }
        this.samples = samples;
        this.vectorLength = vectorLength;
        this.vectorStep = vectorStep;
        this.length = length;
    }

    public static RealVectorSampleArray asSampleArray(MemoryModel memoryModel, UpdatablePNumberArray samples, long vectorLength, long vectorStep, long length) {
        Objects.requireNonNull(samples, "Null samples");
        samples = (UpdatablePNumberArray)samples.asUnresizable();
        if (samples instanceof DirectAccessible && ((DirectAccessible)((Object)samples)).hasJavaArray() && vectorLength <= Arrays.SMM.maxSupportedLength(samples.elementType()) / 64L) {
            if (samples instanceof FloatArray) {
                return new DirectRealFloatVectorSampleArray(samples, vectorLength, vectorStep, length);
            }
            if (samples instanceof DoubleArray) {
                return new DirectRealDoubleVectorSampleArray(samples, vectorLength, vectorStep, length);
            }
        }
        if (vectorLength < 32768L) {
            if (samples instanceof FloatArray) {
                return new RealFloatVectorSampleArray(samples, vectorLength, vectorStep, length);
            }
            if (samples instanceof DoubleArray) {
                return new RealDoubleVectorSampleArray(samples, vectorLength, vectorStep, length);
            }
        }
        if (memoryModel == null) {
            memoryModel = Arrays.SMM;
        }
        if (vectorLength > memoryModel.maxSupportedLength(samples.elementType()) / 64L) {
            throw new TooLargeArrayException("Too large samples for the given memory model " + String.valueOf(memoryModel) + ": it cannot allocate 64 samples (each sample is a vector of " + vectorLength + " numbers");
        }
        return new CommonRealVectorSampleArray(memoryModel, samples, vectorLength, vectorStep, length);
    }

    @Override
    public final boolean isComplex() {
        return false;
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    public abstract RealVectorSampleArray newCompatibleSamplesArray(long var1);

    @Override
    public void copy(long destIndex, SampleArray src, long srcIndex) {
        RealVectorSampleArray a = (RealVectorSampleArray)src;
        this.v(destIndex).copy(a.v(srcIndex));
    }

    @Override
    public void swap(long firstIndex, long secondIndex) {
        this.samples.swap(firstIndex * this.vectorStep, secondIndex * this.vectorStep, this.vectorLength);
    }

    @Override
    public abstract void add(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void sub(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void add(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void sub(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void add(long var1, long var3, long var5);

    @Override
    public abstract void sub(long var1, long var3, long var5);

    @Override
    public abstract void multiplyByScalar(long var1, SampleArray var3, long var4, double var6, double var8);

    @Override
    public abstract void combineWithRealMultipliers(long var1, long var3, double var5, long var7, double var9);

    @Override
    public abstract void multiplyByRealScalar(long var1, double var3);

    @Override
    public String toString(String format, String separator, int maxStringLength) {
        Objects.requireNonNull(format, "Null format argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (this.length == 0L) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        long i = 0L;
        long disp = 0L;
        while (i < this.length) {
            if (sb.length() >= maxStringLength) {
                sb.append(separator).append("...");
                break;
            }
            if (i > 0L) {
                sb.append(" ").append(separator);
            }
            for (long j = 0L; j < this.vectorLength && sb.length() < maxStringLength; ++j) {
                sb.append(j == 0L ? "(" : separator);
                sb.append(String.format(format, this.samples.getDouble(disp + j)));
                if (j != this.vectorLength - 1L) continue;
                sb.append(")");
            }
            ++i;
            disp += this.vectorStep;
        }
        return sb.toString();
    }

    UpdatablePArray v(long index) {
        return this.samples.subArr(index * this.vectorStep, this.vectorLength);
    }

    static class DirectRealFloatVectorSampleArray
    extends RealVectorSampleArray {
        final float[] samples;
        final int ofs;
        final int vectorLen;

        DirectRealFloatVectorSampleArray(UpdatablePNumberArray samples, long vectorLength, long vectorStep, long length) {
            super(samples, vectorLength, vectorStep, length);
            DirectAccessible da = (DirectAccessible)((Object)((RealVectorSampleArray)this).samples);
            this.samples = (float[])da.javaArray();
            this.ofs = da.javaArrayOffset();
            assert (length <= Integer.MAX_VALUE);
            this.vectorLen = (int)vectorLength;
        }

        @Override
        public DirectRealFloatVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new DirectRealFloatVectorSampleArray(Arrays.SMM.newUnresizableFloatArray(length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealFloatVectorSampleArray a = (DirectRealFloatVectorSampleArray)src;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofs + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofs + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samples[k] = a.samples[i] + a.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealFloatVectorSampleArray a = (DirectRealFloatVectorSampleArray)src;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofs + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofs + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samples[k] = a.samples[i] - a.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealFloatVectorSampleArray a2 = (DirectRealFloatVectorSampleArray)src2;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofs + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] + a2.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealFloatVectorSampleArray a2 = (DirectRealFloatVectorSampleArray)src2;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofs + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] - a2.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofs + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] + this.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofs + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] - this.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectRealFloatVectorSampleArray a = (DirectRealFloatVectorSampleArray)src;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofs + (int)(srcIndex * a.vectorStep);
            while (k < kMax) {
                float v = a.samples[i];
                this.samples[k] = (float)((double)v * aRe);
                ++k;
                ++i;
            }
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofs + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samples[k] = (float)(a1 * (double)this.samples[i] + a2 * (double)this.samples[j]);
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            int k;
            int kMax = k + this.vectorLen;
            for (k = this.ofs + (int)(index * this.vectorStep); k < kMax; ++k) {
                this.samples[k] = (float)((double)this.samples[k] * a);
            }
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int disp;
            int dispMax = disp + (int)((toIndex - fromIndex) * this.vectorStep);
            for (disp = this.ofs + (int)(fromIndex * this.vectorStep); disp < dispMax; disp += (int)this.vectorStep) {
                int k;
                int kMax = k + this.vectorLen;
                for (k = disp; k < kMax; ++k) {
                    this.samples[k] = (float)((double)this.samples[k] * a);
                }
            }
        }
    }

    static class DirectRealDoubleVectorSampleArray
    extends RealVectorSampleArray {
        final double[] samples;
        final int ofs;
        final int vectorLen;

        DirectRealDoubleVectorSampleArray(UpdatablePNumberArray samples, long vectorLength, long vectorStep, long length) {
            super(samples, vectorLength, vectorStep, length);
            DirectAccessible da = (DirectAccessible)((Object)((RealVectorSampleArray)this).samples);
            this.samples = (double[])da.javaArray();
            this.ofs = da.javaArrayOffset();
            assert (length <= Integer.MAX_VALUE);
            this.vectorLen = (int)vectorLength;
        }

        @Override
        public DirectRealDoubleVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new DirectRealDoubleVectorSampleArray(Arrays.SMM.newUnresizableDoubleArray(length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealDoubleVectorSampleArray a = (DirectRealDoubleVectorSampleArray)src;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofs + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofs + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samples[k] = a.samples[i] + a.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealDoubleVectorSampleArray a = (DirectRealDoubleVectorSampleArray)src;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofs + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofs + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samples[k] = a.samples[i] - a.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealDoubleVectorSampleArray a2 = (DirectRealDoubleVectorSampleArray)src2;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofs + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] + a2.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealDoubleVectorSampleArray a2 = (DirectRealDoubleVectorSampleArray)src2;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofs + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] - a2.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofs + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] + this.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofs + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samples[k] = this.samples[i] - this.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectRealDoubleVectorSampleArray a = (DirectRealDoubleVectorSampleArray)src;
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofs + (int)(srcIndex * a.vectorStep);
            while (k < kMax) {
                double v = a.samples[i];
                this.samples[k] = v * aRe;
                ++k;
                ++i;
            }
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int k = this.ofs + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofs + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofs + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samples[k] = a1 * this.samples[i] + a2 * this.samples[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            int k;
            int kMax = k + this.vectorLen;
            for (k = this.ofs + (int)(index * this.vectorStep); k < kMax; ++k) {
                this.samples[k] = this.samples[k] * a;
            }
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int disp;
            int dispMax = disp + (int)((toIndex - fromIndex) * this.vectorStep);
            for (disp = this.ofs + (int)(fromIndex * this.vectorStep); disp < dispMax; disp += (int)this.vectorStep) {
                int k;
                int kMax = k + this.vectorLen;
                for (k = disp; k < kMax; ++k) {
                    this.samples[k] = this.samples[k] * a;
                }
            }
        }
    }

    static class RealFloatVectorSampleArray
    extends RealVectorSampleArray {
        final int vectorLen;

        RealFloatVectorSampleArray(UpdatablePNumberArray samples, long vectorLength, long vectorStep, long length) {
            super(samples, vectorLength, vectorStep, length);
            assert (length <= 32768L);
            this.vectorLen = (int)vectorLength;
        }

        @Override
        public RealVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new RealFloatVectorSampleArray((UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samples.elementType(), length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            RealFloatVectorSampleArray a = (RealFloatVectorSampleArray)src;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                a.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            RealFloatVectorSampleArray a = (RealFloatVectorSampleArray)src;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                a.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            RealFloatVectorSampleArray a2 = (RealFloatVectorSampleArray)src2;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a2.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            RealFloatVectorSampleArray a2 = (RealFloatVectorSampleArray)src2;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a2.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            RealFloatVectorSampleArray a = (RealFloatVectorSampleArray)src;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                a.samples.getData(srcIndex * this.vectorStep, buf, 0, this.vectorLen);
                for (int i = 0; i < this.vectorLen; ++i) {
                    buf[i] = (float)((double)buf[i] * aRe);
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByRealScalar(long index, double a) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samples.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                for (int i = 0; i < this.vectorLen; ++i) {
                    buf[i] = (float)((double)buf[i] * a);
                }
                this.samples.setData(index * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    buf[i] = (float)((double)buf[i] * a1 + (double)buf[j] * a2);
                    ++i;
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                for (long index = fromIndex; index < toIndex; ++index) {
                    this.samples.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                    for (int i = 0; i < this.vectorLen; ++i) {
                        buf[i] = (float)((double)buf[i] * a);
                    }
                    this.samples.setData(index * this.vectorStep, buf, 0, this.vectorLen);
                }
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }
    }

    static class RealDoubleVectorSampleArray
    extends RealVectorSampleArray {
        final int vectorLen;

        RealDoubleVectorSampleArray(UpdatablePNumberArray samples, long vectorLength, long vectorStep, long length) {
            super(samples, vectorLength, vectorStep, length);
            assert (length <= 32768L);
            this.vectorLen = (int)vectorLength;
        }

        @Override
        public RealVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new RealDoubleVectorSampleArray((UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samples.elementType(), length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            RealDoubleVectorSampleArray a = (RealDoubleVectorSampleArray)src;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                a.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            RealDoubleVectorSampleArray a = (RealDoubleVectorSampleArray)src;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                a.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            RealDoubleVectorSampleArray a2 = (RealDoubleVectorSampleArray)src2;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a2.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            RealDoubleVectorSampleArray a2 = (RealDoubleVectorSampleArray)src2;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a2.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            RealDoubleVectorSampleArray a = (RealDoubleVectorSampleArray)src;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                a.samples.getData(srcIndex * this.vectorStep, buf, 0, this.vectorLen);
                for (int i = 0; i < this.vectorLen; ++i) {
                    buf[i] = buf[i] * aRe;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByRealScalar(long index, double a) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samples.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                for (int i = 0; i < this.vectorLen; ++i) {
                    buf[i] = buf[i] * a;
                }
                this.samples.setData(index * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samples.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samples.getData(srcIndex2 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    buf[i] = buf[i] * a1 + buf[j] * a2;
                    ++i;
                    ++j;
                }
                this.samples.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                for (long index = fromIndex; index < toIndex; ++index) {
                    this.samples.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                    for (int i = 0; i < this.vectorLen; ++i) {
                        buf[i] = buf[i] * a;
                    }
                    this.samples.setData(index * this.vectorStep, buf, 0, this.vectorLen);
                }
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }
    }

    static class CommonRealVectorSampleArray
    extends RealVectorSampleArray {
        final MemoryModel mm;

        CommonRealVectorSampleArray(MemoryModel memoryModel, UpdatablePNumberArray samples, long vectorLength, long vectorStep, long length) {
            super(samples, vectorLength, vectorStep, length);
            assert (memoryModel != null);
            this.mm = memoryModel;
        }

        @Override
        public RealVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new CommonRealVectorSampleArray(this.mm, (UpdatablePNumberArray)this.mm.newUnresizableArray(this.samples.elementType(), length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonRealVectorSampleArray a = (CommonRealVectorSampleArray)src;
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.v(destIndex), a.v(srcIndex1), a.v(srcIndex2));
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonRealVectorSampleArray a = (CommonRealVectorSampleArray)src;
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.v(destIndex), a.v(srcIndex1), a.v(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonRealVectorSampleArray a2 = (CommonRealVectorSampleArray)src2;
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.v(destIndex), this.v(srcIndex1), a2.v(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonRealVectorSampleArray a2 = (CommonRealVectorSampleArray)src2;
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.v(destIndex), this.v(srcIndex1), a2.v(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.v(destIndex), this.v(srcIndex1), this.v(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.v(destIndex), this.v(srcIndex1), this.v(srcIndex2));
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            CommonRealVectorSampleArray a = (CommonRealVectorSampleArray)src;
            UpdatablePArray v = a.v(srcIndex);
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, aRe), this.v(destIndex), v);
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, a1, a2), this.v(destIndex), this.v(srcIndex1), this.v(srcIndex2));
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            UpdatablePArray v = this.v(index);
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, a), v, v);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            for (long index = fromIndex; index < toIndex; ++index) {
                this.multiplyByRealScalar(index, a);
            }
        }
    }
}

