/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PIntegerArray;

public abstract class SkeletonPixelClassifier {
    public static final int TYPE_USUAL_NODE = -1;
    public static final int TYPE_ISOLATED = -2;
    public static final int TYPE_FREE_BRANCH_END = -3;
    public static final int TYPE_USUAL_BRANCH = -4;
    public static final int TYPE_ILLEGAL = -5;
    public static final int TYPE_ZERO = -6;
    public static final int TYPE_NODE_OR_BRANCH_END_MIN = -3;
    public static final int TYPE_NODE_OR_BRANCH_END_MAX = -1;
    public static final int TYPE_BRANCH_MIN = -4;
    public static final int TYPE_BRANCH_MAX = -3;
    protected final int dimCount;
    protected final int numberOfNeighbours;

    protected SkeletonPixelClassifier(int dimCount) {
        if (dimCount <= 0) {
            throw new IllegalArgumentException("Zero or negative dimCount");
        }
        long m = 1L;
        for (int k = 0; k < dimCount; ++k) {
            if ((m *= 3L) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Too large number of dimensions " + dimCount + " of the skeleton matrix: 3x3x3x... aperture contains more than 2^31-1=2147483647 elements");
        }
        this.dimCount = dimCount;
        this.numberOfNeighbours = (int)(m - 1L);
    }

    public static boolean isNodePixelType(int pixelType) {
        return pixelType == -1 || pixelType == -2;
    }

    public static boolean isUsualBranchPixelType(int pixelType) {
        return pixelType == -4;
    }

    public static boolean isFreeBranchEndPixelType(int pixelType) {
        return pixelType == -3;
    }

    public static boolean isAttachableBranchEndPixelType(int pixelType) {
        return pixelType >= 0;
    }

    public static boolean isNodeOrFreeBranchEndPixelType(int pixelType) {
        return pixelType >= -3 && pixelType <= -1;
    }

    public static boolean isBranchPixelType(int pixelType) {
        return pixelType >= 0 || pixelType >= -4 && pixelType <= -3;
    }

    public static boolean isIllegalPixelType(int pixelType) {
        return pixelType == -5;
    }

    public final int dimCount() {
        return this.dimCount;
    }

    public final int numberOfNeighbours() {
        return this.numberOfNeighbours;
    }

    public final long[] neighbourOffset(int neighbourIndex) {
        long[] coordinateIncrements = new long[this.dimCount];
        this.neighbourOffset(coordinateIncrements, neighbourIndex);
        return coordinateIncrements;
    }

    public abstract void neighbourOffset(long[] var1, int var2);

    public abstract int reverseNeighbourIndex(int var1);

    public abstract Matrix<? extends PIntegerArray> asPixelTypes(Matrix<? extends BitArray> var1, AttachmentInformation var2);

    public abstract void markNeighbouringNodesNotConnectedViaDegeneratedBranches(int[] var1);

    public static enum AttachmentInformation {
        NEIGHBOUR_INDEX_OF_ATTACHING_BRANCH,
        NEIGHBOUR_INDEX_OF_ATTACHED_NODE;

    }
}

