/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.matrices.skeletons.ApertureBasedSkeletonPixelClassifier;

public class BasicSkeletonPixelClassifier2D
extends ApertureBasedSkeletonPixelClassifier {
    public static final int NEIGHBOUR_INDEX_XM_YM = 0;
    public static final int NEIGHBOUR_INDEX_YM = 1;
    public static final int NEIGHBOUR_INDEX_XP_YM = 2;
    public static final int NEIGHBOUR_INDEX_XP = 3;
    public static final int NEIGHBOUR_INDEX_XP_YP = 4;
    public static final int NEIGHBOUR_INDEX_YP = 5;
    public static final int NEIGHBOUR_INDEX_XM_YP = 6;
    public static final int NEIGHBOUR_INDEX_XM = 7;
    public static final int NEIGHBOUR_INDEX_MIN = 0;
    public static final int NEIGHBOUR_INDEX_MAX = 7;
    private static final long[][] SHIFTS_A = new long[][]{{-1L, -1L}, {0L, -1L}, {1L, -1L}, {1L, 0L}, {1L, 1L}, {0L, 1L}, {-1L, 1L}, {-1L, 0L}};
    private static final int[] OCTUPLE_THINNING_SKELETON_CLASSIFICATION_MAP = new int[]{0, -2, -2, 1, -3, -3, 2, -3, -3, 5, -4, -4, 9, -4, -4, 17, -4, -4, 18, -4, -4, 34, -4, -4, 13, 0, 3, 19, 4, 1, 21, -1, -1, 22, 4, 1, 25, 0, 3, 35, 5, 1, 37, -1, -1, 38, 5, 1, 41, -1, -1, 23, 4, 1, 29, 0, 3, 39, 5, 1, 45, -1, -1, 51, 5, 1, 53, -1, -1, 54, 5, 1, 57, -1, -1, 85, -1, -1, 86, -1, -1, 90, -1, -1, 102, 5, 1, 170, -1, -1, 55, 5, 1, 61, -1, -1, 87, -1, -1, 91, -1, -1, 94, -1, -1, 103, 5, 1, 171, -1, -1, 95, -1, -1, 119, 5, 1, 175, -1, -1, 187, -1, -1, 191, -1, -1, 255, -1, -1};
    private static final BasicSkeletonPixelClassifier2D BASIC_OCTUPLE_THINNING_SKELETON_PIXEL_CLASSIFIER_2_D = new BasicSkeletonPixelClassifier2D(OCTUPLE_THINNING_SKELETON_CLASSIFICATION_MAP, new int[0]);
    private static final BasicSkeletonPixelClassifier2D BASIC_QUADRUPLE_3X5_THINNING_SKELETON_PIXEL_CLASSIFIER_2_D = new BasicSkeletonPixelClassifier2D(OCTUPLE_THINNING_SKELETON_CLASSIFICATION_MAP, 91, 187, 191);
    private static final BasicSkeletonPixelClassifier2D BASIC_STRONG_QUADRUPLE_3X5_THINNING_SKELETON_PIXEL_CLASSIFIER_2_D = new BasicSkeletonPixelClassifier2D(OCTUPLE_THINNING_SKELETON_CLASSIFICATION_MAP, 91, 187, 191, 175, 255);
    private final int[] classificationTableWithAttachingBranches = new int[256];
    private final int[] classificationTableWithAttachedNodes = new int[256];

    private BasicSkeletonPixelClassifier2D(int[] classificationMap, int ... additionalIllegalConfigurations) {
        super(2, SHIFTS_A);
        int directionIndex;
        Objects.requireNonNull(classificationMap, "Null classificationMap argument");
        if (classificationMap.length % 3 != 0) {
            throw new IllegalArgumentException("Length of classificationMap does not divide by 3");
        }
        JArrays.fill(this.classificationTableWithAttachingBranches, -5);
        JArrays.fill(this.classificationTableWithAttachedNodes, -5);
        for (int k = 0; k < classificationMap.length; k += 3) {
            int bitsA = classificationMap[k];
            if (bitsA < 0 || bitsA > 255) {
                throw new IllegalArgumentException("First element of a triplet in classificationMap (bit configuration code) is out of 0..255 range");
            }
            int pixelTypeWithAttachingBranch = classificationMap[k + 1];
            if (pixelTypeWithAttachingBranch > 7) {
                throw new IllegalArgumentException("Second element of a triplet in classificationMap (pixel type or direction of attaching branch end) is greater than 7");
            }
            int pixelTypeWithAttachedNode = classificationMap[k + 2];
            if (pixelTypeWithAttachedNode > 7) {
                throw new IllegalArgumentException("Third element of a triplet in classificationMap (pixel type or direction of attached node) is greater than 7");
            }
            if ((pixelTypeWithAttachingBranch < 0 || pixelTypeWithAttachedNode < 0) && pixelTypeWithAttachedNode != pixelTypeWithAttachingBranch) {
                throw new IllegalArgumentException("Negative second and third elements of a triplet in classificationMap (pixel type or direction of attached node) are not equal: " + pixelTypeWithAttachingBranch + " and " + pixelTypeWithAttachedNode);
            }
            this.classificationTableWithAttachingBranches[bitsA] = pixelTypeWithAttachingBranch;
            this.classificationTableWithAttachedNodes[bitsA] = pixelTypeWithAttachedNode;
            for (directionIndex = 1; directionIndex <= 3; ++directionIndex) {
                bitsA = BasicSkeletonPixelClassifier2D.rotated90BitsA(bitsA);
                pixelTypeWithAttachingBranch = BasicSkeletonPixelClassifier2D.rotated90Direction(pixelTypeWithAttachingBranch);
                pixelTypeWithAttachedNode = BasicSkeletonPixelClassifier2D.rotated90Direction(pixelTypeWithAttachedNode);
                this.classificationTableWithAttachingBranches[bitsA] = pixelTypeWithAttachingBranch;
                this.classificationTableWithAttachedNodes[bitsA] = pixelTypeWithAttachedNode;
            }
        }
        for (int bitsA : additionalIllegalConfigurations) {
            this.classificationTableWithAttachingBranches[bitsA] = -5;
            this.classificationTableWithAttachedNodes[bitsA] = -5;
            for (directionIndex = 1; directionIndex <= 3; ++directionIndex) {
                bitsA = BasicSkeletonPixelClassifier2D.rotated90BitsA(bitsA);
                this.classificationTableWithAttachingBranches[bitsA] = -5;
                this.classificationTableWithAttachedNodes[bitsA] = -5;
            }
        }
    }

    public static BasicSkeletonPixelClassifier2D getOctupleThinningInstance() {
        return BASIC_OCTUPLE_THINNING_SKELETON_PIXEL_CLASSIFIER_2_D;
    }

    public static BasicSkeletonPixelClassifier2D getQuadruple3x5ThinningInstance() {
        return BASIC_QUADRUPLE_3X5_THINNING_SKELETON_PIXEL_CLASSIFIER_2_D;
    }

    public static BasicSkeletonPixelClassifier2D getStrongQuadruple3x5ThinningInstance() {
        return BASIC_STRONG_QUADRUPLE_3X5_THINNING_SKELETON_PIXEL_CLASSIFIER_2_D;
    }

    @Override
    protected int pixelTypeOrAttachingBranch(int apertureBits) {
        return this.classificationTableWithAttachingBranches[apertureBits];
    }

    @Override
    protected int pixelTypeOrAttachedNode(int apertureBits) {
        return this.classificationTableWithAttachedNodes[apertureBits];
    }

    private static int rotated90BitsA(int apertureBits) {
        assert (0 <= apertureBits && apertureBits < 256);
        int bit0 = apertureBits & 1;
        int bit1 = apertureBits >> 1 & 1;
        int bit2 = apertureBits >> 2 & 1;
        int bit3 = apertureBits >> 3 & 1;
        int bit4 = apertureBits >> 4 & 1;
        int bit5 = apertureBits >> 5 & 1;
        int bit6 = apertureBits >> 6 & 1;
        int bit7 = apertureBits >> 7 & 1;
        return bit6 | bit7 << 1 | bit0 << 2 | bit1 << 3 | bit2 << 4 | bit3 << 5 | bit4 << 6 | bit5 << 7;
    }

    private static int rotated90Direction(int pixelType) {
        if (pixelType < 0) {
            return pixelType;
        }
        return pixelType + 2 & 7;
    }
}

