/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayProcessorWithContextSwitching;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.ApertureProcessor;
import net.algart.matrices.DependenceApertureBuilder;
import net.algart.matrices.TiledApertureProcessorFactory;
import net.algart.matrices.morphology.Morphology;

public class TiledMorphology
implements Morphology {
    private final Morphology parent;
    final ArrayContext context;
    final TiledApertureProcessorFactory tiler;
    final int dimCount;

    TiledMorphology(Morphology parent, TiledApertureProcessorFactory tiler) {
        Objects.requireNonNull(parent, "Null parent morphology");
        Objects.requireNonNull(tiler, "Null tiler");
        this.parent = parent;
        this.context = parent.context() == null ? ArrayContext.DEFAULT : parent.context();
        this.tiler = tiler.context(this.context);
        this.dimCount = tiler.dimCount();
    }

    public static TiledMorphology getInstance(Morphology parent, TiledApertureProcessorFactory tiler) {
        return new TiledMorphology(parent, tiler);
    }

    public Morphology parent() {
        return this.parent;
    }

    public TiledApertureProcessorFactory tiler() {
        return this.tiler;
    }

    @Override
    public ArrayContext context() {
        return this.context;
    }

    @Override
    public Morphology context(ArrayContext newContext) {
        return new TiledMorphology(this.parent.context(newContext), this.tiler);
    }

    @Override
    public boolean isPseudoCyclic() {
        return this.tiler.continuationMode() == Matrix.ContinuationMode.PSEUDO_CYCLIC;
    }

    @Override
    public Matrix<? extends PArray> asDilation(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = (this.parent.isPseudoCyclic() ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, false);
        src = DependenceApertureBuilder.extend(src, a, this.tiler.continuationMode());
        return DependenceApertureBuilder.reduce(this.parent.asDilation(src, pattern), a);
    }

    @Override
    public Matrix<? extends PArray> asErosion(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = (this.parent.isPseudoCyclic() ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, true);
        src = DependenceApertureBuilder.extend(src, a, this.tiler.continuationMode());
        return DependenceApertureBuilder.reduce(this.parent.asErosion(src, pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> src, final Pattern pattern) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, false)){

            @Override
            public Matrix<? extends PArray> process(Matrix<? extends PArray> src) {
                return this.parent().dilation(src, pattern);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> src, final Pattern pattern) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, true)){

            @Override
            public Matrix<? extends PArray> process(Matrix<? extends PArray> src) {
                return this.parent().erosion(src, pattern);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> weakDilation(Matrix<? extends PArray> src, final Pattern pattern) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM_MAX_0.getAperture(this.dimCount, pattern, false, pattern, true)){

            @Override
            public Matrix<? extends PArray> process(Matrix<? extends PArray> src) {
                return this.parent().weakDilation(src, pattern);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> weakErosion(Matrix<? extends PArray> src, final Pattern pattern) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM_MAX_0.getAperture(this.dimCount, pattern, true, pattern, false)){

            @Override
            public Matrix<? extends PArray> process(Matrix<? extends PArray> src) {
                return this.parent().weakErosion(src, pattern);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> beucherGradient(Matrix<? extends PArray> src, final Pattern pattern) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.MAX.getAperture(this.dimCount, pattern, false, pattern, true)){

            @Override
            public Matrix<? extends PArray> process(Matrix<? extends PArray> src) {
                return this.parent().beucherGradient(src, pattern);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> src, final Pattern pattern, final Morphology.SubtractionMode subtractionMode) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, false)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().dilation(src, pattern, subtractionMode);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> src, final Pattern pattern, final Morphology.SubtractionMode subtractionMode) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, true)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().erosion(src, pattern, subtractionMode);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> closing(Matrix<? extends PArray> src, final Pattern pattern, final Morphology.SubtractionMode subtractionMode) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, false, pattern, true)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().closing(src, pattern, subtractionMode);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> opening(Matrix<? extends PArray> src, final Pattern pattern, final Morphology.SubtractionMode subtractionMode) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, true, pattern, false)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().opening(src, pattern, subtractionMode);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilationErosion(Matrix<? extends PArray> src, final Pattern ptn1, final Pattern ptn2, final Morphology.SubtractionMode subtractionMode) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, ptn1, false, ptn2, true)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().dilationErosion(src, ptn1, ptn2, subtractionMode);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosionDilation(Matrix<? extends PArray> src, final Pattern ptn1, final Pattern ptn2, final Morphology.SubtractionMode subtractionMode) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, ptn1, true, ptn2, false)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().erosionDilation(src, ptn1, ptn2, subtractionMode);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> maskedDilationErosion(Matrix<? extends PArray> src, final Pattern ptn1, final Pattern ptn2) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM_MAX_0.getAperture(this.dimCount, ptn1, false, ptn2, true)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().maskedDilationErosion(src, ptn1, ptn2);
            }
        }, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> maskedErosionDilation(Matrix<? extends PArray> src, final Pattern ptn1, final Pattern ptn2) {
        return this.tilingProcess(new MorphologyProcessor(this, DependenceApertureBuilder.SUM_MAX_0.getAperture(this.dimCount, ptn1, true, ptn2, false)){

            public Matrix<? extends UpdatablePArray> process(Matrix<? extends PArray> src) {
                return this.parent().maskedErosionDilation(src, ptn1, ptn2);
            }
        }, src);
    }

    @Override
    public void dilation(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final Pattern pattern, boolean disableMemoryAllocation) {
        Matrices.checkDimensionEquality(dest, src);
        if (disableMemoryAllocation) {
            this.parent.dilation(dest, src, pattern, true);
        } else {
            LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>> destMatrices = new LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>>();
            LinkedHashMap<Integer, Matrix<? extends PArray>> srcMatrices = new LinkedHashMap<Integer, Matrix<? extends PArray>>();
            destMatrices.put(0, dest);
            srcMatrices.put(0, src);
            this.tiler.tile(new MorphologyInPlaceProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, false)){

                @Override
                public void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
                    this.parent().dilation(dest, src, pattern, false);
                }
            }).process(destMatrices, srcMatrices);
        }
    }

    @Override
    public void erosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final Pattern pattern, boolean disableMemoryAllocation) {
        Matrices.checkDimensionEquality(dest, src);
        if (disableMemoryAllocation) {
            this.parent.erosion(dest, src, pattern, true);
        } else {
            LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>> destMatrices = new LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>>();
            LinkedHashMap<Integer, Matrix<? extends PArray>> srcMatrices = new LinkedHashMap<Integer, Matrix<? extends PArray>>();
            destMatrices.put(0, dest);
            srcMatrices.put(0, src);
            this.tiler.tile(new MorphologyInPlaceProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, true)){

                @Override
                public void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
                    this.parent().erosion(dest, src, pattern, false);
                }
            }).process(destMatrices, srcMatrices);
        }
    }

    @Override
    public void dilation(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        this.dilation(dest, src, pattern, false);
    }

    @Override
    public void erosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        this.erosion(dest, src, pattern, false);
    }

    private Matrix<? extends UpdatablePArray> tilingProcess(ApertureProcessor<Integer> processor, Matrix<? extends PArray> src) {
        LinkedHashMap destMatrices = new LinkedHashMap();
        LinkedHashMap<Integer, Matrix<? extends PArray>> srcMatrices = new LinkedHashMap<Integer, Matrix<? extends PArray>>();
        destMatrices.put(0, null);
        srcMatrices.put(0, src);
        this.tiler.tile(processor).process(destMatrices, srcMatrices);
        return ((Matrix)destMatrices.get(0)).cast(UpdatablePArray.class);
    }

    private abstract class MorphologyInPlaceProcessor
    extends AbstractArrayProcessorWithContextSwitching
    implements ApertureProcessor<Integer>,
    ArrayProcessorWithContextSwitching {
        private final IRectangularArea dependenceAperture;

        private MorphologyInPlaceProcessor(IRectangularArea dependenceAperture) {
            super(null);
            this.dependenceAperture = dependenceAperture;
        }

        public Morphology parent() {
            return TiledMorphology.this.parent.context(this.context());
        }

        @Override
        public void process(Map<Integer, Matrix<?>> dest, Map<Integer, Matrix<?>> src) {
            assert (src.size() == 1);
            assert (dest.size() == 1);
            this.process(dest.get(0).cast(UpdatablePArray.class), src.get(0).cast(PArray.class));
        }

        public abstract void process(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2);

        @Override
        public IRectangularArea dependenceAperture(Integer srcMatrixKey) {
            assert (srcMatrixKey == 0);
            return this.dependenceAperture;
        }
    }

    private abstract class MorphologyProcessor
    extends AbstractArrayProcessorWithContextSwitching
    implements ApertureProcessor<Integer>,
    ArrayProcessorWithContextSwitching {
        private final IRectangularArea dependenceAperture;

        private MorphologyProcessor(IRectangularArea dependenceAperture) {
            super(null);
            this.dependenceAperture = dependenceAperture;
        }

        public Morphology parent() {
            return TiledMorphology.this.parent.context(this.context());
        }

        @Override
        public void process(Map<Integer, Matrix<?>> dest, Map<Integer, Matrix<?>> src) {
            assert (src.size() == 1);
            assert (dest.size() == 1);
            dest.put(0, this.process(src.get(0).cast(PArray.class)));
        }

        public abstract Matrix<? extends PArray> process(Matrix<? extends PArray> var1);

        @Override
        public IRectangularArea dependenceAperture(Integer srcMatrixKey) {
            assert (srcMatrixKey == 0);
            return this.dependenceAperture;
        }
    }
}

