/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.AbstractIntArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayPool;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Histogram;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.functions.Func;
import net.algart.matrices.morphology.HistogramCache;
import net.algart.matrices.morphology.RankOperationProcessor;

class Ranker
extends RankOperationProcessor {
    private static final boolean DEBUG_MODE = false;
    private final boolean optimizeGetData = OPTIMIZE_GET_DATA;
    private final boolean optimizeDirectArrays = OPTIMIZE_DIRECT_ARRAYS;
    private final boolean inlineOneLevel = INLINE_ONE_LEVEL;
    private final boolean interpolated;

    Ranker(ArrayContext context, boolean interpolated, int[] bitLevels) {
        super(context, bitLevels);
        this.interpolated = interpolated;
    }

    @Override
    PArray asProcessed(Class<? extends PArray> desiredType, PArray src, PArray[] additional, long[] dimensions, long[] shifts, long[] left, long[] right) {
        PArray ra;
        PArray a;
        ArrayPool ap;
        if (additional.length == 0) {
            throw new IllegalArgumentException("One additional matrix is required (the matrix, which should be ranked in relation to this one)");
        }
        assert (left.length == right.length);
        boolean direct = this.optimizeDirectArrays && src instanceof DirectAccessible && ((DirectAccessible)((Object)src)).hasJavaArray();
        PArray rankedArray = additional[0];
        if (rankedArray.elementType() != src.elementType()) {
            rankedArray = Arrays.asFuncArray(Func.IDENTITY, src.type(), rankedArray);
        }
        ArrayPool arrayPool = ap = this.optimizeDirectArrays && (Arrays.isNCopies(rankedArray) || SimpleMemoryModel.isSimpleArray(rankedArray)) ? null : ArrayPool.getInstance(Arrays.SMM, rankedArray.elementType(), 65536L);
        if (src instanceof BitArray) {
            a = (BitArray)src;
            ra = (BitArray)rankedArray;
            HistogramCache histogramCache = new HistogramCache();
            switch (this.interpolated ? 1 : 0) {
                case 0: {
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (BitArray)ra, shifts, (BitArray)a, ap, histogramCache, right, left){
                        final /* synthetic */ BitArray val$ra;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ BitArray val$a;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = bitArray;
                            this.val$shifts = lArray;
                            this.val$a = bitArray2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            boolean level = this.val$ra.getBit(index);
                            if (!level) {
                                return 0;
                            }
                            int hist0 = 0;
                            for (long shift : this.val$shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (this.val$a.getBit(i)) continue;
                                ++hist0;
                            }
                            return hist0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableBitArray buf = this.val$ap == null ? null : (UpdatableBitArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            int[] hist = (int[])this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1];
                                for (long shift : this.val$shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if (this.val$a.getBit(i)) continue;
                                    hist[0] = hist[0] + 1;
                                }
                            }
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    boolean level = this.val$ap != null ? buf.getBit(k) : this.val$ra.getBit(arrayPos);
                                    dest[destArrayOffset] = level ? hist[0] : 0;
                                    for (long shift : this.val$right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if (this.val$a.getBit(i)) continue;
                                        hist[0] = hist[0] - 1;
                                        assert (hist[0] >= 0) : "Unbalanced 0 and 1 bits";
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : this.val$left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if (this.val$a.getBit(i)) continue;
                                        hist[0] = hist[0] + 1;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                case 1: {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (BitArray)ra, shifts, (BitArray)a, ap, histogramCache, right, left){
                        final /* synthetic */ BitArray val$ra;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ BitArray val$a;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = bitArray;
                            this.val$shifts = lArray;
                            this.val$a = bitArray2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public double getDouble(long index) {
                            boolean level = this.val$ra.getBit(index);
                            if (!level) {
                                return 0.0;
                            }
                            int hist0 = 0;
                            for (long shift : this.val$shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (this.val$a.getBit(i)) continue;
                                ++hist0;
                            }
                            return hist0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatableBitArray buf = this.val$ap == null ? null : (UpdatableBitArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            int[] hist = (int[])this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1];
                                for (long shift : this.val$shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if (this.val$a.getBit(i)) continue;
                                    hist[0] = hist[0] + 1;
                                }
                            }
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    boolean level = this.val$ap != null ? buf.getBit(k) : this.val$ra.getBit(arrayPos);
                                    dest[destArrayOffset] = level ? (double)hist[0] : 0.0;
                                    for (long shift : this.val$right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if (this.val$a.getBit(i)) continue;
                                        hist[0] = hist[0] - 1;
                                        assert (hist[0] >= 0) : "Unbalanced 0 and 1 bits";
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : this.val$left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if (this.val$a.getBit(i)) continue;
                                        hist[0] = hist[0] + 1;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
            }
        }
        if (src instanceof CharArray) {
            a = (CharArray)src;
            ra = (CharArray)rankedArray;
            int nab = Math.min(this.numberOfAnalyzedBits, 16);
            int bs = 16 - nab;
            if (direct) {
                boolean implementHere;
                char[] ja = (char[])((DirectAccessible)((Object)a)).javaArray();
                int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    HistogramCache histogramCache = new HistogramCache();
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (CharArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, right, left){
                        final /* synthetic */ CharArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ char[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = charArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = cArray;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = this.val$ra.getChar(index) >> this.val$bs;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableCharArray buf = this.val$ap == null ? null : (UpdatableCharArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            int[] hist = (int[])this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << this.val$nab];
                                for (long shift : this.val$shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int level;
                                    int n = level = this.val$ap != null ? buf.getChar(k) >> this.val$bs : this.val$ra.getChar(arrayPos) >> this.val$bs;
                                    if (level < currentIValue) {
                                        for (j = currentIValue - 1; j >= level; --j) {
                                            currentIRank -= hist[j];
                                        }
                                        assert (currentIRank >= 0);
                                    } else {
                                        for (j = currentIValue; j < level; ++j) {
                                            currentIRank += hist[j];
                                        }
                                        assert (currentIRank <= this.val$shifts.length);
                                    }
                                    currentIValue = level;
                                    dest[destArrayOffset] = currentIRank;
                                    for (long shift : this.val$right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n2 = value = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                        hist[n2] = hist[n2] - 1;
                                        if (hist[n2] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : this.val$left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n3 = value = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                        hist[n3] = hist[n3] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    HistogramCache histogramCache = new HistogramCache();
                    JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (CharArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, indexesPool, right, left){
                        final /* synthetic */ CharArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ char[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ JArrayPool val$indexesPool;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = charArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = cArray;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$indexesPool = jArrayPool;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = this.val$ra.getChar(index) >> this.val$bs;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long i;
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableCharArray buf = this.val$ap == null ? null : (UpdatableCharArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                                for (long shift : this.val$shifts) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include((this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs);
                                }
                            }
                            int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int j;
                                    int level = this.val$ap != null ? buf.getChar(k) >> this.val$bs : this.val$ra.getChar(arrayPos) >> this.val$bs;
                                    hist.moveToIValue(level);
                                    dest[destArrayOffset] = (int)hist.currentIRank();
                                    for (j = 0; j < this.val$right.length; ++j) {
                                        i = arrayPos - this.val$right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < this.val$left.length; ++j) {
                                        i = arrayPos - this.val$left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$indexesPool.releaseArray(barIndexes);
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                HistogramCache histogramCache = new HistogramCache();
                JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (CharArray)ra, bs, shifts, ja, jaOfs, nab, ap, histogramCache, indexesPool, right, left){
                    final /* synthetic */ CharArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ char[] val$ja;
                    final /* synthetic */ int val$jaOfs;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ JArrayPool val$indexesPool;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = charArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$ja = cArray;
                        this.val$jaOfs = n2;
                        this.val$nab = n3;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$indexesPool = jArrayPool;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public double getDouble(long index) {
                        double result;
                        int level = this.val$ra.getChar(index) >> this.val$bs;
                        int cnt = 0;
                        int left = -1;
                        int right = Integer.MAX_VALUE;
                        int leftBar = 157;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs) < level) {
                                ++cnt;
                                if (histIndex == left) {
                                    ++leftBar;
                                    continue;
                                }
                                if (histIndex <= left) continue;
                                left = histIndex;
                                leftBar = 1;
                                continue;
                            }
                            if (histIndex >= right) continue;
                            right = histIndex;
                        }
                        if (cnt == 0 || cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (right == level) {
                            result = cnt;
                        } else {
                            assert (left < level && level < right);
                            assert (leftBar > 0);
                            double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                            result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                        }
                        return result;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableCharArray buf = this.val$ap == null ? null : (UpdatableCharArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include((this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs);
                            }
                        }
                        int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int j;
                                int level = this.val$ap != null ? buf.getChar(k) >> this.val$bs : this.val$ra.getChar(arrayPos) >> this.val$bs;
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = hist.currentPreciseRank();
                                for (j = 0; j < this.val$right.length; ++j) {
                                    i = arrayPos - this.val$right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < this.val$left.length; ++j) {
                                    i = arrayPos - this.val$left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$indexesPool.releaseArray(barIndexes);
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                HistogramCache histogramCache = new HistogramCache();
                return new AbstractIntArray(src.length(), true, new Array[]{src}, (CharArray)ra, bs, shifts, (CharArray)a, ap, histogramCache, nab, right, left){
                    final /* synthetic */ CharArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ CharArray val$a;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = charArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$a = charArray2;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$nab = n2;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public int getInt(long index) {
                        int level = this.val$ra.getChar(index) >> this.val$bs;
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((histIndex = this.val$a.getInt(i) >> this.val$bs) >= level) continue;
                            ++cnt;
                        }
                        return cnt;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        int[] dest = (int[])destArray;
                        UpdatableCharArray buf = this.val$ap == null ? null : (UpdatableCharArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(this.val$a.getInt(i) >> this.val$bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int level = this.val$ap != null ? buf.getChar(k) >> this.val$bs : this.val$ra.getChar(arrayPos) >> this.val$bs;
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = (int)hist.currentIRank();
                                for (long shift : this.val$right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.exclude(this.val$a.getInt(i) >> this.val$bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : this.val$left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include(this.val$a.getInt(i) >> this.val$bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (CharArray)ra, bs, shifts, (CharArray)a, nab, ap, histogramCache, right, left){
                final /* synthetic */ CharArray val$ra;
                final /* synthetic */ int val$bs;
                final /* synthetic */ long[] val$shifts;
                final /* synthetic */ CharArray val$a;
                final /* synthetic */ int val$nab;
                final /* synthetic */ ArrayPool val$ap;
                final /* synthetic */ HistogramCache val$histogramCache;
                final /* synthetic */ long[] val$right;
                final /* synthetic */ long[] val$left;
                {
                    this.val$ra = charArray;
                    this.val$bs = n;
                    this.val$shifts = lArray;
                    this.val$a = charArray2;
                    this.val$nab = n2;
                    this.val$ap = arrayPool;
                    this.val$histogramCache = histogramCache;
                    this.val$right = lArray2;
                    this.val$left = lArray3;
                    super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                }

                @Override
                public double getDouble(long index) {
                    double result;
                    int level = this.val$ra.getChar(index) >> this.val$bs;
                    int cnt = 0;
                    int left = -1;
                    int right = Integer.MAX_VALUE;
                    int leftBar = 157;
                    for (long shift : this.val$shifts) {
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((histIndex = this.val$a.getInt(i) >> this.val$bs) < level) {
                            ++cnt;
                            if (histIndex == left) {
                                ++leftBar;
                                continue;
                            }
                            if (histIndex <= left) continue;
                            left = histIndex;
                            leftBar = 1;
                            continue;
                        }
                        if (histIndex >= right) continue;
                        right = histIndex;
                    }
                    if (cnt == 0 || cnt == this.val$shifts.length) {
                        return cnt;
                    }
                    assert (this.val$shifts.length > 0);
                    if (right == level) {
                        result = cnt;
                    } else {
                        assert (left < level && level < right);
                        assert (leftBar > 0);
                        double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                        result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Ranker.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Ranker.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatableCharArray buf = this.val$ap == null ? null : (UpdatableCharArray)this.val$ap.requestArray();
                    int bufLen = this.val$ap == null ? count : 65536;
                    Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                        for (long shift : this.val$shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist.include(this.val$a.getInt(i) >> this.val$bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (this.val$ap != null) {
                            buf.copy(this.val$ra.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            int level = this.val$ap != null ? buf.getChar(k) >> this.val$bs : this.val$ra.getChar(arrayPos) >> this.val$bs;
                            hist.moveToIValue(level);
                            dest[destArrayOffset] = hist.currentPreciseRank();
                            for (long shift : this.val$right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.exclude(this.val$a.getInt(i) >> this.val$bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : this.val$left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(this.val$a.getInt(i) >> this.val$bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    this.val$histogramCache.put(arrayPos, hist);
                    if (this.val$ap != null) {
                        this.val$ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof ByteArray) {
            a = (ByteArray)src;
            ra = (ByteArray)rankedArray;
            int nab = Math.min(this.numberOfAnalyzedBits, 8);
            int bs = 8 - nab;
            if (direct) {
                boolean implementHere;
                byte[] ja = (byte[])((DirectAccessible)((Object)a)).javaArray();
                int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    HistogramCache histogramCache = new HistogramCache();
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (ByteArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, right, left){
                        final /* synthetic */ ByteArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ byte[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = byteArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = byArray;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = this.val$ra.getByte(index) >> this.val$bs;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableByteArray buf = this.val$ap == null ? null : (UpdatableByteArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            int[] hist = (int[])this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << this.val$nab];
                                for (long shift : this.val$shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int level;
                                    int n = level = this.val$ap != null ? buf.getByte(k) >> this.val$bs : this.val$ra.getByte(arrayPos) >> this.val$bs;
                                    if (level < currentIValue) {
                                        for (j = currentIValue - 1; j >= level; --j) {
                                            currentIRank -= hist[j];
                                        }
                                        assert (currentIRank >= 0);
                                    } else {
                                        for (j = currentIValue; j < level; ++j) {
                                            currentIRank += hist[j];
                                        }
                                        assert (currentIRank <= this.val$shifts.length);
                                    }
                                    currentIValue = level;
                                    dest[destArrayOffset] = currentIRank;
                                    for (long shift : this.val$right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n2 = value = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs;
                                        hist[n2] = hist[n2] - 1;
                                        if (hist[n2] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : this.val$left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n3 = value = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs;
                                        hist[n3] = hist[n3] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    HistogramCache histogramCache = new HistogramCache();
                    JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (ByteArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, indexesPool, right, left){
                        final /* synthetic */ ByteArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ byte[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ JArrayPool val$indexesPool;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = byteArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = byArray;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$indexesPool = jArrayPool;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = this.val$ra.getByte(index) >> this.val$bs;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long i;
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableByteArray buf = this.val$ap == null ? null : (UpdatableByteArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                                for (long shift : this.val$shifts) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include((this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs);
                                }
                            }
                            int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int j;
                                    int level = this.val$ap != null ? buf.getByte(k) >> this.val$bs : this.val$ra.getByte(arrayPos) >> this.val$bs;
                                    hist.moveToIValue(level);
                                    dest[destArrayOffset] = (int)hist.currentIRank();
                                    for (j = 0; j < this.val$right.length; ++j) {
                                        i = arrayPos - this.val$right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < this.val$left.length; ++j) {
                                        i = arrayPos - this.val$left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$indexesPool.releaseArray(barIndexes);
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                HistogramCache histogramCache = new HistogramCache();
                JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (ByteArray)ra, bs, shifts, ja, jaOfs, nab, ap, histogramCache, indexesPool, right, left){
                    final /* synthetic */ ByteArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ byte[] val$ja;
                    final /* synthetic */ int val$jaOfs;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ JArrayPool val$indexesPool;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = byteArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$ja = byArray;
                        this.val$jaOfs = n2;
                        this.val$nab = n3;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$indexesPool = jArrayPool;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public double getDouble(long index) {
                        double result;
                        int level = this.val$ra.getByte(index) >> this.val$bs;
                        int cnt = 0;
                        int left = -1;
                        int right = Integer.MAX_VALUE;
                        int leftBar = 157;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs) < level) {
                                ++cnt;
                                if (histIndex == left) {
                                    ++leftBar;
                                    continue;
                                }
                                if (histIndex <= left) continue;
                                left = histIndex;
                                leftBar = 1;
                                continue;
                            }
                            if (histIndex >= right) continue;
                            right = histIndex;
                        }
                        if (cnt == 0 || cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (right == level) {
                            result = cnt;
                        } else {
                            assert (left < level && level < right);
                            assert (leftBar > 0);
                            double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                            result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                        }
                        return result;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableByteArray buf = this.val$ap == null ? null : (UpdatableByteArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include((this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs);
                            }
                        }
                        int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int j;
                                int level = this.val$ap != null ? buf.getByte(k) >> this.val$bs : this.val$ra.getByte(arrayPos) >> this.val$bs;
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = hist.currentPreciseRank();
                                for (j = 0; j < this.val$right.length; ++j) {
                                    i = arrayPos - this.val$right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < this.val$left.length; ++j) {
                                    i = arrayPos - this.val$left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFF) >> this.val$bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$indexesPool.releaseArray(barIndexes);
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                HistogramCache histogramCache = new HistogramCache();
                return new AbstractIntArray(src.length(), true, new Array[]{src}, (ByteArray)ra, bs, shifts, (ByteArray)a, ap, histogramCache, nab, right, left){
                    final /* synthetic */ ByteArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ ByteArray val$a;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = byteArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$a = byteArray2;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$nab = n2;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public int getInt(long index) {
                        int level = this.val$ra.getByte(index) >> this.val$bs;
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((histIndex = this.val$a.getInt(i) >> this.val$bs) >= level) continue;
                            ++cnt;
                        }
                        return cnt;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        int[] dest = (int[])destArray;
                        UpdatableByteArray buf = this.val$ap == null ? null : (UpdatableByteArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(this.val$a.getInt(i) >> this.val$bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int level = this.val$ap != null ? buf.getByte(k) >> this.val$bs : this.val$ra.getByte(arrayPos) >> this.val$bs;
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = (int)hist.currentIRank();
                                for (long shift : this.val$right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.exclude(this.val$a.getInt(i) >> this.val$bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : this.val$left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include(this.val$a.getInt(i) >> this.val$bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (ByteArray)ra, bs, shifts, (ByteArray)a, nab, ap, histogramCache, right, left){
                final /* synthetic */ ByteArray val$ra;
                final /* synthetic */ int val$bs;
                final /* synthetic */ long[] val$shifts;
                final /* synthetic */ ByteArray val$a;
                final /* synthetic */ int val$nab;
                final /* synthetic */ ArrayPool val$ap;
                final /* synthetic */ HistogramCache val$histogramCache;
                final /* synthetic */ long[] val$right;
                final /* synthetic */ long[] val$left;
                {
                    this.val$ra = byteArray;
                    this.val$bs = n;
                    this.val$shifts = lArray;
                    this.val$a = byteArray2;
                    this.val$nab = n2;
                    this.val$ap = arrayPool;
                    this.val$histogramCache = histogramCache;
                    this.val$right = lArray2;
                    this.val$left = lArray3;
                    super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                }

                @Override
                public double getDouble(long index) {
                    double result;
                    int level = this.val$ra.getByte(index) >> this.val$bs;
                    int cnt = 0;
                    int left = -1;
                    int right = Integer.MAX_VALUE;
                    int leftBar = 157;
                    for (long shift : this.val$shifts) {
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((histIndex = this.val$a.getInt(i) >> this.val$bs) < level) {
                            ++cnt;
                            if (histIndex == left) {
                                ++leftBar;
                                continue;
                            }
                            if (histIndex <= left) continue;
                            left = histIndex;
                            leftBar = 1;
                            continue;
                        }
                        if (histIndex >= right) continue;
                        right = histIndex;
                    }
                    if (cnt == 0 || cnt == this.val$shifts.length) {
                        return cnt;
                    }
                    assert (this.val$shifts.length > 0);
                    if (right == level) {
                        result = cnt;
                    } else {
                        assert (left < level && level < right);
                        assert (leftBar > 0);
                        double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                        result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Ranker.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Ranker.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatableByteArray buf = this.val$ap == null ? null : (UpdatableByteArray)this.val$ap.requestArray();
                    int bufLen = this.val$ap == null ? count : 65536;
                    Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                        for (long shift : this.val$shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist.include(this.val$a.getInt(i) >> this.val$bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (this.val$ap != null) {
                            buf.copy(this.val$ra.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            int level = this.val$ap != null ? buf.getByte(k) >> this.val$bs : this.val$ra.getByte(arrayPos) >> this.val$bs;
                            hist.moveToIValue(level);
                            dest[destArrayOffset] = hist.currentPreciseRank();
                            for (long shift : this.val$right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.exclude(this.val$a.getInt(i) >> this.val$bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : this.val$left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(this.val$a.getInt(i) >> this.val$bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    this.val$histogramCache.put(arrayPos, hist);
                    if (this.val$ap != null) {
                        this.val$ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof ShortArray) {
            a = (ShortArray)src;
            ra = (ShortArray)rankedArray;
            int nab = Math.min(this.numberOfAnalyzedBits, 16);
            int bs = 16 - nab;
            if (direct) {
                boolean implementHere;
                short[] ja = (short[])((DirectAccessible)((Object)a)).javaArray();
                int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    HistogramCache histogramCache = new HistogramCache();
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (ShortArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, right, left){
                        final /* synthetic */ ShortArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ short[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = shortArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = sArray;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = this.val$ra.getShort(index) >> this.val$bs;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableShortArray buf = this.val$ap == null ? null : (UpdatableShortArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            int[] hist = (int[])this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << this.val$nab];
                                for (long shift : this.val$shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int level;
                                    int n = level = this.val$ap != null ? buf.getShort(k) >> this.val$bs : this.val$ra.getShort(arrayPos) >> this.val$bs;
                                    if (level < currentIValue) {
                                        for (j = currentIValue - 1; j >= level; --j) {
                                            currentIRank -= hist[j];
                                        }
                                        assert (currentIRank >= 0);
                                    } else {
                                        for (j = currentIValue; j < level; ++j) {
                                            currentIRank += hist[j];
                                        }
                                        assert (currentIRank <= this.val$shifts.length);
                                    }
                                    currentIValue = level;
                                    dest[destArrayOffset] = currentIRank;
                                    for (long shift : this.val$right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n2 = value = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                        hist[n2] = hist[n2] - 1;
                                        if (hist[n2] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : this.val$left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n3 = value = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                        hist[n3] = hist[n3] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    HistogramCache histogramCache = new HistogramCache();
                    JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (ShortArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, indexesPool, right, left){
                        final /* synthetic */ ShortArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ short[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ JArrayPool val$indexesPool;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = shortArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = sArray;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$indexesPool = jArrayPool;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = this.val$ra.getShort(index) >> this.val$bs;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long i;
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableShortArray buf = this.val$ap == null ? null : (UpdatableShortArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                                for (long shift : this.val$shifts) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include((this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs);
                                }
                            }
                            int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int j;
                                    int level = this.val$ap != null ? buf.getShort(k) >> this.val$bs : this.val$ra.getShort(arrayPos) >> this.val$bs;
                                    hist.moveToIValue(level);
                                    dest[destArrayOffset] = (int)hist.currentIRank();
                                    for (j = 0; j < this.val$right.length; ++j) {
                                        i = arrayPos - this.val$right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < this.val$left.length; ++j) {
                                        i = arrayPos - this.val$left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$indexesPool.releaseArray(barIndexes);
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                HistogramCache histogramCache = new HistogramCache();
                JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (ShortArray)ra, bs, shifts, ja, jaOfs, nab, ap, histogramCache, indexesPool, right, left){
                    final /* synthetic */ ShortArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ short[] val$ja;
                    final /* synthetic */ int val$jaOfs;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ JArrayPool val$indexesPool;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = shortArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$ja = sArray;
                        this.val$jaOfs = n2;
                        this.val$nab = n3;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$indexesPool = jArrayPool;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public double getDouble(long index) {
                        double result;
                        int level = this.val$ra.getShort(index) >> this.val$bs;
                        int cnt = 0;
                        int left = -1;
                        int right = Integer.MAX_VALUE;
                        int leftBar = 157;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((histIndex = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs) < level) {
                                ++cnt;
                                if (histIndex == left) {
                                    ++leftBar;
                                    continue;
                                }
                                if (histIndex <= left) continue;
                                left = histIndex;
                                leftBar = 1;
                                continue;
                            }
                            if (histIndex >= right) continue;
                            right = histIndex;
                        }
                        if (cnt == 0 || cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (right == level) {
                            result = cnt;
                        } else {
                            assert (left < level && level < right);
                            assert (leftBar > 0);
                            double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                            result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                        }
                        return result;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableShortArray buf = this.val$ap == null ? null : (UpdatableShortArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include((this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs);
                            }
                        }
                        int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int j;
                                int level = this.val$ap != null ? buf.getShort(k) >> this.val$bs : this.val$ra.getShort(arrayPos) >> this.val$bs;
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = hist.currentPreciseRank();
                                for (j = 0; j < this.val$right.length; ++j) {
                                    i = arrayPos - this.val$right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < this.val$left.length; ++j) {
                                    i = arrayPos - this.val$left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (this.val$ja[this.val$jaOfs + (int)i] & 0xFFFF) >> this.val$bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$indexesPool.releaseArray(barIndexes);
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                HistogramCache histogramCache = new HistogramCache();
                return new AbstractIntArray(src.length(), true, new Array[]{src}, (ShortArray)ra, bs, shifts, (ShortArray)a, ap, histogramCache, nab, right, left){
                    final /* synthetic */ ShortArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ ShortArray val$a;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = shortArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$a = shortArray2;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$nab = n2;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public int getInt(long index) {
                        int level = this.val$ra.getShort(index) >> this.val$bs;
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((histIndex = this.val$a.getInt(i) >> this.val$bs) >= level) continue;
                            ++cnt;
                        }
                        return cnt;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        int[] dest = (int[])destArray;
                        UpdatableShortArray buf = this.val$ap == null ? null : (UpdatableShortArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(this.val$a.getInt(i) >> this.val$bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int level = this.val$ap != null ? buf.getShort(k) >> this.val$bs : this.val$ra.getShort(arrayPos) >> this.val$bs;
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = (int)hist.currentIRank();
                                for (long shift : this.val$right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.exclude(this.val$a.getInt(i) >> this.val$bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : this.val$left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include(this.val$a.getInt(i) >> this.val$bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (ShortArray)ra, bs, shifts, (ShortArray)a, nab, ap, histogramCache, right, left){
                final /* synthetic */ ShortArray val$ra;
                final /* synthetic */ int val$bs;
                final /* synthetic */ long[] val$shifts;
                final /* synthetic */ ShortArray val$a;
                final /* synthetic */ int val$nab;
                final /* synthetic */ ArrayPool val$ap;
                final /* synthetic */ HistogramCache val$histogramCache;
                final /* synthetic */ long[] val$right;
                final /* synthetic */ long[] val$left;
                {
                    this.val$ra = shortArray;
                    this.val$bs = n;
                    this.val$shifts = lArray;
                    this.val$a = shortArray2;
                    this.val$nab = n2;
                    this.val$ap = arrayPool;
                    this.val$histogramCache = histogramCache;
                    this.val$right = lArray2;
                    this.val$left = lArray3;
                    super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                }

                @Override
                public double getDouble(long index) {
                    double result;
                    int level = this.val$ra.getShort(index) >> this.val$bs;
                    int cnt = 0;
                    int left = -1;
                    int right = Integer.MAX_VALUE;
                    int leftBar = 157;
                    for (long shift : this.val$shifts) {
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((histIndex = this.val$a.getInt(i) >> this.val$bs) < level) {
                            ++cnt;
                            if (histIndex == left) {
                                ++leftBar;
                                continue;
                            }
                            if (histIndex <= left) continue;
                            left = histIndex;
                            leftBar = 1;
                            continue;
                        }
                        if (histIndex >= right) continue;
                        right = histIndex;
                    }
                    if (cnt == 0 || cnt == this.val$shifts.length) {
                        return cnt;
                    }
                    assert (this.val$shifts.length > 0);
                    if (right == level) {
                        result = cnt;
                    } else {
                        assert (left < level && level < right);
                        assert (leftBar > 0);
                        double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                        result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Ranker.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Ranker.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatableShortArray buf = this.val$ap == null ? null : (UpdatableShortArray)this.val$ap.requestArray();
                    int bufLen = this.val$ap == null ? count : 65536;
                    Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                        for (long shift : this.val$shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist.include(this.val$a.getInt(i) >> this.val$bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (this.val$ap != null) {
                            buf.copy(this.val$ra.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            int level = this.val$ap != null ? buf.getShort(k) >> this.val$bs : this.val$ra.getShort(arrayPos) >> this.val$bs;
                            hist.moveToIValue(level);
                            dest[destArrayOffset] = hist.currentPreciseRank();
                            for (long shift : this.val$right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.exclude(this.val$a.getInt(i) >> this.val$bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : this.val$left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(this.val$a.getInt(i) >> this.val$bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    this.val$histogramCache.put(arrayPos, hist);
                    if (this.val$ap != null) {
                        this.val$ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof IntArray) {
            a = (IntArray)src;
            ra = (IntArray)rankedArray;
            int nab = Math.min(this.numberOfAnalyzedBits, 30);
            int bs = 31 - nab;
            HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                int[] ja = (int[])((DirectAccessible)((Object)a)).javaArray();
                int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (IntArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, indexesPool, right, left){
                        final /* synthetic */ IntArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ int[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ JArrayPool val$indexesPool;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = intArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = nArray;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$indexesPool = jArrayPool;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = this.val$ra.getInt(index) >> this.val$bs;
                            if (level <= 0) {
                                return 0;
                            }
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                int v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                if ((histIndex = v >> this.val$bs) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            int v;
                            long i;
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableIntArray buf = this.val$ap == null ? null : (UpdatableIntArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                                for (long shift : this.val$shifts) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    hist.include(v >> this.val$bs);
                                }
                            }
                            int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int j;
                                    int level;
                                    int n = level = this.val$ap != null ? buf.getInt(k) >> this.val$bs : this.val$ra.getInt(arrayPos) >> this.val$bs;
                                    if (level < 0) {
                                        level = 0;
                                    }
                                    hist.moveToIValue(level);
                                    dest[destArrayOffset] = (int)hist.currentIRank();
                                    for (j = 0; j < this.val$right.length; ++j) {
                                        i = arrayPos - this.val$right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> this.val$bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < this.val$left.length; ++j) {
                                        i = arrayPos - this.val$left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> this.val$bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$indexesPool.releaseArray(barIndexes);
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (IntArray)ra, bs, shifts, ja, jaOfs, nab, ap, histogramCache, indexesPool, right, left){
                    final /* synthetic */ IntArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ int[] val$ja;
                    final /* synthetic */ int val$jaOfs;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ JArrayPool val$indexesPool;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = intArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$ja = nArray;
                        this.val$jaOfs = n2;
                        this.val$nab = n3;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$indexesPool = jArrayPool;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public double getDouble(long index) {
                        double result;
                        int level = this.val$ra.getInt(index) >> this.val$bs;
                        int left = -1;
                        int right = Integer.MAX_VALUE;
                        int leftBar = 157;
                        if (level <= 0) {
                            return 0.0;
                        }
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                v = 0;
                            }
                            if ((histIndex = v >> this.val$bs) < level) {
                                ++cnt;
                                if (histIndex == left) {
                                    ++leftBar;
                                    continue;
                                }
                                if (histIndex <= left) continue;
                                left = histIndex;
                                leftBar = 1;
                                continue;
                            }
                            if (histIndex >= right) continue;
                            right = histIndex;
                        }
                        if (cnt == 0 || cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (right == level) {
                            result = cnt;
                        } else {
                            assert (left < level && level < right);
                            assert (leftBar > 0);
                            double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                            result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                        }
                        return result;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        int v;
                        long i;
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableIntArray buf = this.val$ap == null ? null : (UpdatableIntArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                hist.include(v >> this.val$bs);
                            }
                        }
                        int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int j;
                                int level;
                                int n = level = this.val$ap != null ? buf.getInt(k) >> this.val$bs : this.val$ra.getInt(arrayPos) >> this.val$bs;
                                if (level < 0) {
                                    level = 0;
                                }
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = hist.currentPreciseRank();
                                for (j = 0; j < this.val$right.length; ++j) {
                                    i = arrayPos - this.val$right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> this.val$bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < this.val$left.length; ++j) {
                                    i = arrayPos - this.val$left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> this.val$bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$indexesPool.releaseArray(barIndexes);
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractIntArray(src.length(), true, new Array[]{src}, (IntArray)ra, bs, shifts, (IntArray)a, ap, histogramCache, nab, right, left){
                    final /* synthetic */ IntArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ IntArray val$a;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = intArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$a = intArray2;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$nab = n2;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public int getInt(long index) {
                        int level = this.val$ra.getInt(index) >> this.val$bs;
                        if (level <= 0) {
                            return 0;
                        }
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = this.val$a.getInt(i)) < 0) {
                                v = 0;
                            }
                            if ((histIndex = v >> this.val$bs) >= level) continue;
                            ++cnt;
                        }
                        return cnt;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        int[] dest = (int[])destArray;
                        UpdatableIntArray buf = this.val$ap == null ? null : (UpdatableIntArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist.include(v >> this.val$bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                int level;
                                int n = level = this.val$ap != null ? buf.getInt(k) >> this.val$bs : this.val$ra.getInt(arrayPos) >> this.val$bs;
                                if (level < 0) {
                                    level = 0;
                                }
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = (int)hist.currentIRank();
                                for (long shift : this.val$right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist.exclude(v >> this.val$bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : this.val$left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist.include(v >> this.val$bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (IntArray)ra, bs, shifts, (IntArray)a, nab, ap, histogramCache, right, left){
                final /* synthetic */ IntArray val$ra;
                final /* synthetic */ int val$bs;
                final /* synthetic */ long[] val$shifts;
                final /* synthetic */ IntArray val$a;
                final /* synthetic */ int val$nab;
                final /* synthetic */ ArrayPool val$ap;
                final /* synthetic */ HistogramCache val$histogramCache;
                final /* synthetic */ long[] val$right;
                final /* synthetic */ long[] val$left;
                {
                    this.val$ra = intArray;
                    this.val$bs = n;
                    this.val$shifts = lArray;
                    this.val$a = intArray2;
                    this.val$nab = n2;
                    this.val$ap = arrayPool;
                    this.val$histogramCache = histogramCache;
                    this.val$right = lArray2;
                    this.val$left = lArray3;
                    super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                }

                @Override
                public double getDouble(long index) {
                    double result;
                    int level = this.val$ra.getInt(index) >> this.val$bs;
                    int left = -1;
                    int right = Integer.MAX_VALUE;
                    int leftBar = 157;
                    if (level <= 0) {
                        return 0.0;
                    }
                    int cnt = 0;
                    for (long shift : this.val$shifts) {
                        int histIndex;
                        int v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = this.val$a.getInt(i)) < 0) {
                            v = 0;
                        }
                        if ((histIndex = v >> this.val$bs) < level) {
                            ++cnt;
                            if (histIndex == left) {
                                ++leftBar;
                                continue;
                            }
                            if (histIndex <= left) continue;
                            left = histIndex;
                            leftBar = 1;
                            continue;
                        }
                        if (histIndex >= right) continue;
                        right = histIndex;
                    }
                    if (cnt == 0 || cnt == this.val$shifts.length) {
                        return cnt;
                    }
                    assert (this.val$shifts.length > 0);
                    if (right == level) {
                        result = cnt;
                    } else {
                        assert (left < level && level < right);
                        assert (leftBar > 0);
                        double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                        result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Ranker.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Ranker.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatableIntArray buf = this.val$ap == null ? null : (UpdatableIntArray)this.val$ap.requestArray();
                    int bufLen = this.val$ap == null ? count : 65536;
                    Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                        for (long shift : this.val$shifts) {
                            int v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = this.val$a.getInt(i)) < 0) {
                                v = 0;
                            }
                            hist.include(v >> this.val$bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (this.val$ap != null) {
                            buf.copy(this.val$ra.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int v;
                            long i;
                            int level;
                            int n = level = this.val$ap != null ? buf.getInt(k) >> this.val$bs : this.val$ra.getInt(arrayPos) >> this.val$bs;
                            if (level < 0) {
                                level = 0;
                            }
                            hist.moveToIValue(level);
                            dest[destArrayOffset] = hist.currentPreciseRank();
                            for (long shift : this.val$right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist.exclude(v >> this.val$bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : this.val$left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist.include(v >> this.val$bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    this.val$histogramCache.put(arrayPos, hist);
                    if (this.val$ap != null) {
                        this.val$ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof LongArray) {
            a = (LongArray)src;
            ra = (LongArray)rankedArray;
            int nab = Math.min(this.numberOfAnalyzedBits, 30);
            int bs = 63 - nab;
            HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                long[] ja = (long[])((DirectAccessible)((Object)a)).javaArray();
                int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractIntArray(src.length(), true, new Array[]{src}, (LongArray)ra, bs, shifts, ja, jaOfs, ap, histogramCache, nab, indexesPool, right, left){
                        final /* synthetic */ LongArray val$ra;
                        final /* synthetic */ int val$bs;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ long[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ int val$nab;
                        final /* synthetic */ JArrayPool val$indexesPool;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = longArray;
                            this.val$bs = n;
                            this.val$shifts = lArray;
                            this.val$ja = lArray2;
                            this.val$jaOfs = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$nab = n3;
                            this.val$indexesPool = jArrayPool;
                            this.val$right = lArray3;
                            this.val$left = lArray4;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public int getInt(long index) {
                            int level = (int)(this.val$ra.getLong(index) >> this.val$bs);
                            if (level <= 0) {
                                return 0;
                            }
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                long v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                if ((histIndex = (int)(v >> this.val$bs)) >= level) continue;
                                ++cnt;
                            }
                            return cnt;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long v;
                            long i;
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatableLongArray buf = this.val$ap == null ? null : (UpdatableLongArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                                for (long shift : this.val$shifts) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    hist.include((int)(v >> this.val$bs));
                                }
                            }
                            int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int j;
                                    int level = (int)(this.val$ap != null ? buf.getLong(k) >> this.val$bs : this.val$ra.getLong(arrayPos) >> this.val$bs);
                                    if (level < 0) {
                                        level = 0;
                                    }
                                    hist.moveToIValue(level);
                                    dest[destArrayOffset] = (int)hist.currentIRank();
                                    for (j = 0; j < this.val$right.length; ++j) {
                                        i = arrayPos - this.val$right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> this.val$bs);
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < this.val$left.length; ++j) {
                                        i = arrayPos - this.val$left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> this.val$bs);
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$indexesPool.releaseArray(barIndexes);
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (LongArray)ra, bs, shifts, ja, jaOfs, nab, ap, histogramCache, indexesPool, right, left){
                    final /* synthetic */ LongArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ long[] val$ja;
                    final /* synthetic */ int val$jaOfs;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ JArrayPool val$indexesPool;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = longArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$ja = lArray2;
                        this.val$jaOfs = n2;
                        this.val$nab = n3;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$indexesPool = jArrayPool;
                        this.val$right = lArray3;
                        this.val$left = lArray4;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public double getDouble(long index) {
                        double result;
                        int level = (int)(this.val$ra.getLong(index) >> this.val$bs);
                        int left = -1;
                        int right = Integer.MAX_VALUE;
                        int leftBar = 157;
                        if (level <= 0) {
                            return 0.0;
                        }
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                v = 0L;
                            }
                            if ((histIndex = (int)(v >> this.val$bs)) < level) {
                                ++cnt;
                                if (histIndex == left) {
                                    ++leftBar;
                                    continue;
                                }
                                if (histIndex <= left) continue;
                                left = histIndex;
                                leftBar = 1;
                                continue;
                            }
                            if (histIndex >= right) continue;
                            right = histIndex;
                        }
                        if (cnt == 0 || cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (right == level) {
                            result = cnt;
                        } else {
                            assert (left < level && level < right);
                            assert (leftBar > 0);
                            double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                            result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                        }
                        return result;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long v;
                        long i;
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableLongArray buf = this.val$ap == null ? null : (UpdatableLongArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                hist.include((int)(v >> this.val$bs));
                            }
                        }
                        int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int j;
                                int level = (int)(this.val$ap != null ? buf.getLong(k) >> this.val$bs : this.val$ra.getLong(arrayPos) >> this.val$bs);
                                if (level < 0) {
                                    level = 0;
                                }
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = hist.currentPreciseRank();
                                for (j = 0; j < this.val$right.length; ++j) {
                                    i = arrayPos - this.val$right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> this.val$bs);
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < this.val$left.length; ++j) {
                                    i = arrayPos - this.val$left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$ja[this.val$jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> this.val$bs);
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$indexesPool.releaseArray(barIndexes);
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractIntArray(src.length(), true, new Array[]{src}, (LongArray)ra, bs, shifts, (LongArray)a, ap, histogramCache, nab, right, left){
                    final /* synthetic */ LongArray val$ra;
                    final /* synthetic */ int val$bs;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ LongArray val$a;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ int val$nab;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = longArray;
                        this.val$bs = n;
                        this.val$shifts = lArray;
                        this.val$a = longArray2;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$nab = n2;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public int getInt(long index) {
                        int level = (int)(this.val$ra.getLong(index) >> this.val$bs);
                        if (level <= 0) {
                            return 0;
                        }
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = this.val$a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            if ((histIndex = (int)(v >> this.val$bs)) >= level) continue;
                            ++cnt;
                        }
                        return cnt;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        int[] dest = (int[])destArray;
                        UpdatableLongArray buf = this.val$ap == null ? null : (UpdatableLongArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist.include((int)(v >> this.val$bs));
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                int level = (int)(this.val$ap != null ? buf.getLong(k) >> this.val$bs : this.val$ra.getLong(arrayPos) >> this.val$bs);
                                if (level < 0) {
                                    level = 0;
                                }
                                hist.moveToIValue(level);
                                dest[destArrayOffset] = (int)hist.currentIRank();
                                for (long shift : this.val$right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist.exclude((int)(v >> this.val$bs));
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : this.val$left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = this.val$a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist.include((int)(v >> this.val$bs));
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (LongArray)ra, bs, shifts, (LongArray)a, nab, ap, histogramCache, right, left){
                final /* synthetic */ LongArray val$ra;
                final /* synthetic */ int val$bs;
                final /* synthetic */ long[] val$shifts;
                final /* synthetic */ LongArray val$a;
                final /* synthetic */ int val$nab;
                final /* synthetic */ ArrayPool val$ap;
                final /* synthetic */ HistogramCache val$histogramCache;
                final /* synthetic */ long[] val$right;
                final /* synthetic */ long[] val$left;
                {
                    this.val$ra = longArray;
                    this.val$bs = n;
                    this.val$shifts = lArray;
                    this.val$a = longArray2;
                    this.val$nab = n2;
                    this.val$ap = arrayPool;
                    this.val$histogramCache = histogramCache;
                    this.val$right = lArray2;
                    this.val$left = lArray3;
                    super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                }

                @Override
                public double getDouble(long index) {
                    double result;
                    int level = (int)(this.val$ra.getLong(index) >> this.val$bs);
                    int left = -1;
                    int right = Integer.MAX_VALUE;
                    int leftBar = 157;
                    if (level <= 0) {
                        return 0.0;
                    }
                    int cnt = 0;
                    for (long shift : this.val$shifts) {
                        int histIndex;
                        long v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = this.val$a.getLong(i)) < 0L) {
                            v = 0L;
                        }
                        if ((histIndex = (int)(v >> this.val$bs)) < level) {
                            ++cnt;
                            if (histIndex == left) {
                                ++leftBar;
                                continue;
                            }
                            if (histIndex <= left) continue;
                            left = histIndex;
                            leftBar = 1;
                            continue;
                        }
                        if (histIndex >= right) continue;
                        right = histIndex;
                    }
                    if (cnt == 0 || cnt == this.val$shifts.length) {
                        return cnt;
                    }
                    assert (this.val$shifts.length > 0);
                    if (right == level) {
                        result = cnt;
                    } else {
                        assert (left < level && level < right);
                        assert (leftBar > 0);
                        double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                        result = (double)(cnt - 1) + ((double)level - v1) / ((double)right - v1);
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Ranker.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Ranker.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatableLongArray buf = this.val$ap == null ? null : (UpdatableLongArray)this.val$ap.requestArray();
                    int bufLen = this.val$ap == null ? count : 65536;
                    Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << this.val$nab, Ranker.this.bitLevels);
                        for (long shift : this.val$shifts) {
                            long v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = this.val$a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            hist.include((int)(v >> this.val$bs));
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (this.val$ap != null) {
                            buf.copy(this.val$ra.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long v;
                            long i;
                            int level = (int)(this.val$ap != null ? buf.getLong(k) >> this.val$bs : this.val$ra.getLong(arrayPos) >> this.val$bs);
                            if (level < 0) {
                                level = 0;
                            }
                            hist.moveToIValue(level);
                            dest[destArrayOffset] = hist.currentPreciseRank();
                            for (long shift : this.val$right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist.exclude((int)(v >> this.val$bs));
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : this.val$left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = this.val$a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist.include((int)(v >> this.val$bs));
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    this.val$histogramCache.put(arrayPos, hist);
                    if (this.val$ap != null) {
                        this.val$ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof FloatArray) {
            a = (FloatArray)src;
            ra = (FloatArray)rankedArray;
            int histLength = 1 << this.numberOfAnalyzedBits;
            double multiplier = histLength - 1;
            HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                float[] ja = (float[])((DirectAccessible)((Object)a)).javaArray();
                int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (FloatArray)ra, shifts, multiplier, ja, jaOfs, histLength, ap, histogramCache, indexesPool, right, left){
                        final /* synthetic */ FloatArray val$ra;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ double val$multiplier;
                        final /* synthetic */ float[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ int val$histLength;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ JArrayPool val$indexesPool;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = floatArray;
                            this.val$shifts = lArray;
                            this.val$multiplier = d;
                            this.val$ja = fArray;
                            this.val$jaOfs = n;
                            this.val$histLength = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$indexesPool = jArrayPool;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public double getDouble(long index) {
                            double w = this.val$ra.getDouble(index);
                            Ranker.checkNaN(w);
                            if (w <= 0.0) {
                                return 0.0;
                            }
                            if (w > 1.0) {
                                return this.val$shifts.length;
                            }
                            int level = (int)(w *= this.val$multiplier);
                            int currentBar = 0;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                double v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                if (histIndex < level) {
                                    ++cnt;
                                    continue;
                                }
                                if (histIndex != level) continue;
                                ++currentBar;
                            }
                            if (cnt == this.val$shifts.length) {
                                return cnt;
                            }
                            assert (this.val$shifts.length > 0);
                            if (currentBar <= 0) {
                                return cnt;
                            }
                            double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                            double result = (double)cnt + indexInBar;
                            return result;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatableFloatArray buf = this.val$ap == null ? null : (UpdatableFloatArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                                for (long shift : this.val$shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    hist.include(histIndex);
                                }
                            }
                            int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                                    Ranker.checkNaN(w);
                                    if (w <= 0.0) {
                                        dest[destArrayOffset] = 0.0;
                                    } else if (w > 1.0) {
                                        dest[destArrayOffset] = this.val$shifts.length;
                                    } else {
                                        hist.moveToValue(w * this.val$multiplier);
                                        dest[destArrayOffset] = hist.currentRank();
                                    }
                                    for (j = 0; j < this.val$right.length; ++j) {
                                        i = arrayPos - this.val$right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < this.val$left.length; ++j) {
                                        i = arrayPos - this.val$left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$indexesPool.releaseArray(barIndexes);
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (FloatArray)ra, shifts, multiplier, ja, jaOfs, histLength, ap, histogramCache, indexesPool, right, left){
                    final /* synthetic */ FloatArray val$ra;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ double val$multiplier;
                    final /* synthetic */ float[] val$ja;
                    final /* synthetic */ int val$jaOfs;
                    final /* synthetic */ int val$histLength;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ JArrayPool val$indexesPool;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = floatArray;
                        this.val$shifts = lArray;
                        this.val$multiplier = d;
                        this.val$ja = fArray;
                        this.val$jaOfs = n;
                        this.val$histLength = n2;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$indexesPool = jArrayPool;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public double getDouble(long index) {
                        double w = this.val$ra.getDouble(index);
                        Ranker.checkNaN(w);
                        if (w <= 0.0) {
                            return 0.0;
                        }
                        if (w > 1.0) {
                            return this.val$shifts.length;
                        }
                        int level = (int)(w *= this.val$multiplier);
                        int left = -1;
                        int right = Integer.MAX_VALUE;
                        int leftBar = 157;
                        int currentBar = 0;
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            double v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                            if (histIndex < level) {
                                ++cnt;
                                if (histIndex == left) {
                                    ++leftBar;
                                    continue;
                                }
                                if (histIndex <= left) continue;
                                left = histIndex;
                                leftBar = 1;
                                continue;
                            }
                            if (histIndex > level) {
                                if (histIndex >= right) continue;
                                right = histIndex;
                                continue;
                            }
                            ++currentBar;
                        }
                        if (cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (currentBar > 0) {
                            if (currentBar > 1) {
                                double d;
                                double indexInBar = (w - (double)level) * (double)currentBar;
                                if (d <= (double)(currentBar - 1)) {
                                    return (double)cnt + indexInBar;
                                }
                            }
                            if (cnt + currentBar == this.val$shifts.length) {
                                double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                                return w == (double)level ? (double)cnt : (double)cnt + indexInBar;
                            }
                            if (w == (double)level) {
                                if ($assertionsDisabled) return cnt;
                                if (currentBar == 1) return cnt;
                                throw new AssertionError();
                            }
                            assert (right != Integer.MAX_VALUE);
                            double v1 = currentBar == 1 ? (double)level : (double)level + (double)(currentBar - 1) / (double)currentBar;
                            return (double)(cnt + currentBar - 1) + (w - v1) / ((double)right - v1);
                        }
                        if (cnt == 0) {
                            return 0.0;
                        }
                        assert (left != -1);
                        assert (right != Integer.MAX_VALUE);
                        if (!$assertionsDisabled) {
                            if (left >= level) throw new AssertionError();
                            if (level >= right) {
                                throw new AssertionError();
                            }
                        }
                        double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                        return (double)(cnt - 1) + (w - v1) / ((double)right - v1);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableFloatArray buf = this.val$ap == null ? null : (UpdatableFloatArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.include(histIndex);
                            }
                        }
                        int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                                Ranker.checkNaN(w);
                                if (w <= 0.0) {
                                    dest[destArrayOffset] = 0.0;
                                } else if (w > 1.0) {
                                    dest[destArrayOffset] = this.val$shifts.length;
                                } else {
                                    hist.moveToValue(w * this.val$multiplier);
                                    dest[destArrayOffset] = hist.currentPreciseRank();
                                }
                                for (j = 0; j < this.val$right.length; ++j) {
                                    i = arrayPos - this.val$right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < this.val$left.length; ++j) {
                                    i = arrayPos - this.val$left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$indexesPool.releaseArray(barIndexes);
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (FloatArray)ra, shifts, multiplier, (FloatArray)a, histLength, ap, histogramCache, right, left){
                    final /* synthetic */ FloatArray val$ra;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ double val$multiplier;
                    final /* synthetic */ FloatArray val$a;
                    final /* synthetic */ int val$histLength;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = floatArray;
                        this.val$shifts = lArray;
                        this.val$multiplier = d;
                        this.val$a = floatArray2;
                        this.val$histLength = n;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public double getDouble(long index) {
                        double w = this.val$ra.getDouble(index);
                        Ranker.checkNaN(w);
                        if (w <= 0.0) {
                            return 0.0;
                        }
                        if (w > 1.0) {
                            return this.val$shifts.length;
                        }
                        int level = (int)(w *= this.val$multiplier);
                        int currentBar = 0;
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            double v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                            if (histIndex < level) {
                                ++cnt;
                                continue;
                            }
                            if (histIndex != level) continue;
                            ++currentBar;
                        }
                        if (cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (currentBar <= 0) {
                            return cnt;
                        }
                        double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                        double result = (double)cnt + indexInBar;
                        return result;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableFloatArray buf = this.val$ap == null ? null : (UpdatableFloatArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.include(histIndex);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                                Ranker.checkNaN(w);
                                if (w <= 0.0) {
                                    dest[destArrayOffset] = 0.0;
                                } else if (w > 1.0) {
                                    dest[destArrayOffset] = this.val$shifts.length;
                                } else {
                                    hist.moveToValue(w * this.val$multiplier);
                                    dest[destArrayOffset] = hist.currentRank();
                                }
                                for (long shift : this.val$right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    hist.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : this.val$left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    hist.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (FloatArray)ra, shifts, multiplier, (FloatArray)a, histLength, ap, histogramCache, right, left){
                final /* synthetic */ FloatArray val$ra;
                final /* synthetic */ long[] val$shifts;
                final /* synthetic */ double val$multiplier;
                final /* synthetic */ FloatArray val$a;
                final /* synthetic */ int val$histLength;
                final /* synthetic */ ArrayPool val$ap;
                final /* synthetic */ HistogramCache val$histogramCache;
                final /* synthetic */ long[] val$right;
                final /* synthetic */ long[] val$left;
                {
                    this.val$ra = floatArray;
                    this.val$shifts = lArray;
                    this.val$multiplier = d;
                    this.val$a = floatArray2;
                    this.val$histLength = n;
                    this.val$ap = arrayPool;
                    this.val$histogramCache = histogramCache;
                    this.val$right = lArray2;
                    this.val$left = lArray3;
                    super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public double getDouble(long index) {
                    double w = this.val$ra.getDouble(index);
                    Ranker.checkNaN(w);
                    if (w <= 0.0) {
                        return 0.0;
                    }
                    if (w > 1.0) {
                        return this.val$shifts.length;
                    }
                    int level = (int)(w *= this.val$multiplier);
                    int left = -1;
                    int right = Integer.MAX_VALUE;
                    int leftBar = 157;
                    int currentBar = 0;
                    int cnt = 0;
                    for (long shift : this.val$shifts) {
                        int histIndex;
                        double v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                        if (histIndex < level) {
                            ++cnt;
                            if (histIndex == left) {
                                ++leftBar;
                                continue;
                            }
                            if (histIndex <= left) continue;
                            left = histIndex;
                            leftBar = 1;
                            continue;
                        }
                        if (histIndex > level) {
                            if (histIndex >= right) continue;
                            right = histIndex;
                            continue;
                        }
                        ++currentBar;
                    }
                    if (cnt == this.val$shifts.length) {
                        return cnt;
                    }
                    assert (this.val$shifts.length > 0);
                    if (currentBar > 0) {
                        if (currentBar > 1) {
                            double d;
                            double indexInBar = (w - (double)level) * (double)currentBar;
                            if (d <= (double)(currentBar - 1)) {
                                return (double)cnt + indexInBar;
                            }
                        }
                        if (cnt + currentBar == this.val$shifts.length) {
                            double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                            return w == (double)level ? (double)cnt : (double)cnt + indexInBar;
                        }
                        if (w == (double)level) {
                            if ($assertionsDisabled) return cnt;
                            if (currentBar == 1) return cnt;
                            throw new AssertionError();
                        }
                        assert (right != Integer.MAX_VALUE);
                        double v1 = currentBar == 1 ? (double)level : (double)level + (double)(currentBar - 1) / (double)currentBar;
                        return (double)(cnt + currentBar - 1) + (w - v1) / ((double)right - v1);
                    }
                    if (cnt == 0) {
                        return 0.0;
                    }
                    assert (left != -1);
                    assert (right != Integer.MAX_VALUE);
                    if (!$assertionsDisabled) {
                        if (left >= level) throw new AssertionError();
                        if (level >= right) {
                            throw new AssertionError();
                        }
                    }
                    double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                    return (double)(cnt - 1) + (w - v1) / ((double)right - v1);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Ranker.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Ranker.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatableFloatArray buf = this.val$ap == null ? null : (UpdatableFloatArray)this.val$ap.requestArray();
                    int bufLen = this.val$ap == null ? count : 65536;
                    Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                        for (long shift : this.val$shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                            hist.include(histIndex);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (this.val$ap != null) {
                            buf.copy(this.val$ra.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                            Ranker.checkNaN(w);
                            if (w <= 0.0) {
                                dest[destArrayOffset] = 0.0;
                            } else if (w > 1.0) {
                                dest[destArrayOffset] = this.val$shifts.length;
                            } else {
                                hist.moveToValue(w * this.val$multiplier);
                                dest[destArrayOffset] = hist.currentPreciseRank();
                            }
                            for (long shift : this.val$right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : this.val$left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    this.val$histogramCache.put(arrayPos, hist);
                    if (this.val$ap != null) {
                        this.val$ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof DoubleArray) {
            a = (DoubleArray)src;
            ra = (DoubleArray)rankedArray;
            int histLength = 1 << this.numberOfAnalyzedBits;
            double multiplier = histLength - 1;
            HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                double[] ja = (double[])((DirectAccessible)((Object)a)).javaArray();
                int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (DoubleArray)ra, shifts, multiplier, ja, jaOfs, histLength, ap, histogramCache, indexesPool, right, left){
                        final /* synthetic */ DoubleArray val$ra;
                        final /* synthetic */ long[] val$shifts;
                        final /* synthetic */ double val$multiplier;
                        final /* synthetic */ double[] val$ja;
                        final /* synthetic */ int val$jaOfs;
                        final /* synthetic */ int val$histLength;
                        final /* synthetic */ ArrayPool val$ap;
                        final /* synthetic */ HistogramCache val$histogramCache;
                        final /* synthetic */ JArrayPool val$indexesPool;
                        final /* synthetic */ long[] val$right;
                        final /* synthetic */ long[] val$left;
                        {
                            this.val$ra = doubleArray;
                            this.val$shifts = lArray;
                            this.val$multiplier = d;
                            this.val$ja = dArray;
                            this.val$jaOfs = n;
                            this.val$histLength = n2;
                            this.val$ap = arrayPool;
                            this.val$histogramCache = histogramCache;
                            this.val$indexesPool = jArrayPool;
                            this.val$right = lArray2;
                            this.val$left = lArray3;
                            super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                        }

                        @Override
                        public double getDouble(long index) {
                            double w = this.val$ra.getDouble(index);
                            Ranker.checkNaN(w);
                            if (w <= 0.0) {
                                return 0.0;
                            }
                            if (w > 1.0) {
                                return this.val$shifts.length;
                            }
                            int level = (int)(w *= this.val$multiplier);
                            int currentBar = 0;
                            int cnt = 0;
                            for (long shift : this.val$shifts) {
                                int histIndex;
                                double v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                if (histIndex < level) {
                                    ++cnt;
                                    continue;
                                }
                                if (histIndex != level) continue;
                                ++currentBar;
                            }
                            if (cnt == this.val$shifts.length) {
                                return cnt;
                            }
                            assert (this.val$shifts.length > 0);
                            if (currentBar <= 0) {
                                return cnt;
                            }
                            double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                            double result = (double)cnt + indexInBar;
                            return result;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Ranker.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Ranker.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatableDoubleArray buf = this.val$ap == null ? null : (UpdatableDoubleArray)this.val$ap.requestArray();
                            int bufLen = this.val$ap == null ? count : 65536;
                            Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                                for (long shift : this.val$shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    hist.include(histIndex);
                                }
                            }
                            int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (this.val$ap != null) {
                                    buf.copy(this.val$ra.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                                    Ranker.checkNaN(w);
                                    if (w <= 0.0) {
                                        dest[destArrayOffset] = 0.0;
                                    } else if (w > 1.0) {
                                        dest[destArrayOffset] = this.val$shifts.length;
                                    } else {
                                        hist.moveToValue(w * this.val$multiplier);
                                        dest[destArrayOffset] = hist.currentRank();
                                    }
                                    for (j = 0; j < this.val$right.length; ++j) {
                                        i = arrayPos - this.val$right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < this.val$left.length; ++j) {
                                        i = arrayPos - this.val$left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            this.val$indexesPool.releaseArray(barIndexes);
                            this.val$histogramCache.put(arrayPos, hist);
                            if (this.val$ap != null) {
                                this.val$ap.releaseArray(buf);
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (DoubleArray)ra, shifts, multiplier, ja, jaOfs, histLength, ap, histogramCache, indexesPool, right, left){
                    final /* synthetic */ DoubleArray val$ra;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ double val$multiplier;
                    final /* synthetic */ double[] val$ja;
                    final /* synthetic */ int val$jaOfs;
                    final /* synthetic */ int val$histLength;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ JArrayPool val$indexesPool;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = doubleArray;
                        this.val$shifts = lArray;
                        this.val$multiplier = d;
                        this.val$ja = dArray;
                        this.val$jaOfs = n;
                        this.val$histLength = n2;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$indexesPool = jArrayPool;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public double getDouble(long index) {
                        double w = this.val$ra.getDouble(index);
                        Ranker.checkNaN(w);
                        if (w <= 0.0) {
                            return 0.0;
                        }
                        if (w > 1.0) {
                            return this.val$shifts.length;
                        }
                        int level = (int)(w *= this.val$multiplier);
                        int left = -1;
                        int right = Integer.MAX_VALUE;
                        int leftBar = 157;
                        int currentBar = 0;
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            double v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                            if (histIndex < level) {
                                ++cnt;
                                if (histIndex == left) {
                                    ++leftBar;
                                    continue;
                                }
                                if (histIndex <= left) continue;
                                left = histIndex;
                                leftBar = 1;
                                continue;
                            }
                            if (histIndex > level) {
                                if (histIndex >= right) continue;
                                right = histIndex;
                                continue;
                            }
                            ++currentBar;
                        }
                        if (cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (currentBar > 0) {
                            if (currentBar > 1) {
                                double d;
                                double indexInBar = (w - (double)level) * (double)currentBar;
                                if (d <= (double)(currentBar - 1)) {
                                    return (double)cnt + indexInBar;
                                }
                            }
                            if (cnt + currentBar == this.val$shifts.length) {
                                double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                                return w == (double)level ? (double)cnt : (double)cnt + indexInBar;
                            }
                            if (w == (double)level) {
                                if ($assertionsDisabled) return cnt;
                                if (currentBar == 1) return cnt;
                                throw new AssertionError();
                            }
                            assert (right != Integer.MAX_VALUE);
                            double v1 = currentBar == 1 ? (double)level : (double)level + (double)(currentBar - 1) / (double)currentBar;
                            return (double)(cnt + currentBar - 1) + (w - v1) / ((double)right - v1);
                        }
                        if (cnt == 0) {
                            return 0.0;
                        }
                        assert (left != -1);
                        assert (right != Integer.MAX_VALUE);
                        if (!$assertionsDisabled) {
                            if (left >= level) throw new AssertionError();
                            if (level >= right) {
                                throw new AssertionError();
                            }
                        }
                        double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                        return (double)(cnt - 1) + (w - v1) / ((double)right - v1);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableDoubleArray buf = this.val$ap == null ? null : (UpdatableDoubleArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.include(histIndex);
                            }
                        }
                        int[] barIndexes = (int[])this.val$indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                                Ranker.checkNaN(w);
                                if (w <= 0.0) {
                                    dest[destArrayOffset] = 0.0;
                                } else if (w > 1.0) {
                                    dest[destArrayOffset] = this.val$shifts.length;
                                } else {
                                    hist.moveToValue(w * this.val$multiplier);
                                    dest[destArrayOffset] = hist.currentPreciseRank();
                                }
                                for (j = 0; j < this.val$right.length; ++j) {
                                    i = arrayPos - this.val$right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < this.val$left.length; ++j) {
                                    i = arrayPos - this.val$left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = this.val$ja[this.val$jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$indexesPool.releaseArray(barIndexes);
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (DoubleArray)ra, shifts, multiplier, (DoubleArray)a, histLength, ap, histogramCache, right, left){
                    final /* synthetic */ DoubleArray val$ra;
                    final /* synthetic */ long[] val$shifts;
                    final /* synthetic */ double val$multiplier;
                    final /* synthetic */ DoubleArray val$a;
                    final /* synthetic */ int val$histLength;
                    final /* synthetic */ ArrayPool val$ap;
                    final /* synthetic */ HistogramCache val$histogramCache;
                    final /* synthetic */ long[] val$right;
                    final /* synthetic */ long[] val$left;
                    {
                        this.val$ra = doubleArray;
                        this.val$shifts = lArray;
                        this.val$multiplier = d;
                        this.val$a = doubleArray2;
                        this.val$histLength = n;
                        this.val$ap = arrayPool;
                        this.val$histogramCache = histogramCache;
                        this.val$right = lArray2;
                        this.val$left = lArray3;
                        super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                    }

                    @Override
                    public double getDouble(long index) {
                        double w = this.val$ra.getDouble(index);
                        Ranker.checkNaN(w);
                        if (w <= 0.0) {
                            return 0.0;
                        }
                        if (w > 1.0) {
                            return this.val$shifts.length;
                        }
                        int level = (int)(w *= this.val$multiplier);
                        int currentBar = 0;
                        int cnt = 0;
                        for (long shift : this.val$shifts) {
                            int histIndex;
                            double v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                            if (histIndex < level) {
                                ++cnt;
                                continue;
                            }
                            if (histIndex != level) continue;
                            ++currentBar;
                        }
                        if (cnt == this.val$shifts.length) {
                            return cnt;
                        }
                        assert (this.val$shifts.length > 0);
                        if (currentBar <= 0) {
                            return cnt;
                        }
                        double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                        double result = (double)cnt + indexInBar;
                        return result;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Ranker.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Ranker.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatableDoubleArray buf = this.val$ap == null ? null : (UpdatableDoubleArray)this.val$ap.requestArray();
                        int bufLen = this.val$ap == null ? count : 65536;
                        Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                            for (long shift : this.val$shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.include(histIndex);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (this.val$ap != null) {
                                buf.copy(this.val$ra.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                                Ranker.checkNaN(w);
                                if (w <= 0.0) {
                                    dest[destArrayOffset] = 0.0;
                                } else if (w > 1.0) {
                                    dest[destArrayOffset] = this.val$shifts.length;
                                } else {
                                    hist.moveToValue(w * this.val$multiplier);
                                    dest[destArrayOffset] = hist.currentRank();
                                }
                                for (long shift : this.val$right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    hist.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : this.val$left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                    hist.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        this.val$histogramCache.put(arrayPos, hist);
                        if (this.val$ap != null) {
                            this.val$ap.releaseArray(buf);
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}, (DoubleArray)ra, shifts, multiplier, (DoubleArray)a, histLength, ap, histogramCache, right, left){
                final /* synthetic */ DoubleArray val$ra;
                final /* synthetic */ long[] val$shifts;
                final /* synthetic */ double val$multiplier;
                final /* synthetic */ DoubleArray val$a;
                final /* synthetic */ int val$histLength;
                final /* synthetic */ ArrayPool val$ap;
                final /* synthetic */ HistogramCache val$histogramCache;
                final /* synthetic */ long[] val$right;
                final /* synthetic */ long[] val$left;
                {
                    this.val$ra = doubleArray;
                    this.val$shifts = lArray;
                    this.val$multiplier = d;
                    this.val$a = doubleArray2;
                    this.val$histLength = n;
                    this.val$ap = arrayPool;
                    this.val$histogramCache = histogramCache;
                    this.val$right = lArray2;
                    this.val$left = lArray3;
                    super(initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public double getDouble(long index) {
                    double w = this.val$ra.getDouble(index);
                    Ranker.checkNaN(w);
                    if (w <= 0.0) {
                        return 0.0;
                    }
                    if (w > 1.0) {
                        return this.val$shifts.length;
                    }
                    int level = (int)(w *= this.val$multiplier);
                    int left = -1;
                    int right = Integer.MAX_VALUE;
                    int leftBar = 157;
                    int currentBar = 0;
                    int cnt = 0;
                    for (long shift : this.val$shifts) {
                        int histIndex;
                        double v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (histIndex = v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                        if (histIndex < level) {
                            ++cnt;
                            if (histIndex == left) {
                                ++leftBar;
                                continue;
                            }
                            if (histIndex <= left) continue;
                            left = histIndex;
                            leftBar = 1;
                            continue;
                        }
                        if (histIndex > level) {
                            if (histIndex >= right) continue;
                            right = histIndex;
                            continue;
                        }
                        ++currentBar;
                    }
                    if (cnt == this.val$shifts.length) {
                        return cnt;
                    }
                    assert (this.val$shifts.length > 0);
                    if (currentBar > 0) {
                        if (currentBar > 1) {
                            double d;
                            double indexInBar = (w - (double)level) * (double)currentBar;
                            if (d <= (double)(currentBar - 1)) {
                                return (double)cnt + indexInBar;
                            }
                        }
                        if (cnt + currentBar == this.val$shifts.length) {
                            double indexInBar = currentBar == 1 ? w - (double)level : (w - (double)level) * (double)currentBar;
                            return w == (double)level ? (double)cnt : (double)cnt + indexInBar;
                        }
                        if (w == (double)level) {
                            if ($assertionsDisabled) return cnt;
                            if (currentBar == 1) return cnt;
                            throw new AssertionError();
                        }
                        assert (right != Integer.MAX_VALUE);
                        double v1 = currentBar == 1 ? (double)level : (double)level + (double)(currentBar - 1) / (double)currentBar;
                        return (double)(cnt + currentBar - 1) + (w - v1) / ((double)right - v1);
                    }
                    if (cnt == 0) {
                        return 0.0;
                    }
                    assert (left != -1);
                    assert (right != Integer.MAX_VALUE);
                    if (!$assertionsDisabled) {
                        if (left >= level) throw new AssertionError();
                        if (level >= right) {
                            throw new AssertionError();
                        }
                    }
                    double v1 = (double)left + (double)(leftBar - 1) / (double)leftBar;
                    return (double)(cnt - 1) + (w - v1) / ((double)right - v1);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Ranker.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Ranker.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatableDoubleArray buf = this.val$ap == null ? null : (UpdatableDoubleArray)this.val$ap.requestArray();
                    int bufLen = this.val$ap == null ? count : 65536;
                    Histogram hist = (Histogram)this.val$histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(this.val$histLength, Ranker.this.bitLevels);
                        for (long shift : this.val$shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                            hist.include(histIndex);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (this.val$ap != null) {
                            buf.copy(this.val$ra.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double w = this.val$ap != null ? buf.getDouble(k) : this.val$ra.getDouble(arrayPos);
                            Ranker.checkNaN(w);
                            if (w <= 0.0) {
                                dest[destArrayOffset] = 0.0;
                            } else if (w > 1.0) {
                                dest[destArrayOffset] = this.val$shifts.length;
                            } else {
                                hist.moveToValue(w * this.val$multiplier);
                                dest[destArrayOffset] = hist.currentPreciseRank();
                            }
                            for (long shift : this.val$right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : this.val$left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = this.val$a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? this.val$histLength - 1 : (int)(v * this.val$multiplier));
                                hist.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    this.val$histogramCache.put(arrayPos, hist);
                    if (this.val$ap != null) {
                        this.val$ap.releaseArray(buf);
                    }
                }
            };
        }
        throw new AssertionError((Object)("Illegal array type (" + String.valueOf(src.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
    }

    private static void checkRanges(long length, long arrayPos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("arrayPos = " + arrayPos + " < 0");
        }
        if (arrayPos > length - (long)count) {
            throw new IndexOutOfBoundsException("arrayPos+count = " + arrayPos + "+" + count + " > length=" + length);
        }
    }

    private static void checkNaN(double rank) {
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal value (NaN) in some ranked elements");
        }
    }
}

