/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.AbstractIterativeArrayProcessor;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.IterativeArrayProcessor;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.matrices.morphology.IterativeErosion;
import net.algart.matrices.morphology.Morphology;

public class IterativeOpening
extends AbstractIterativeArrayProcessor<Matrix<? extends UpdatablePArray>>
implements IterativeArrayProcessor<Matrix<? extends UpdatablePArray>> {
    private static final int NUMBER_OF_STORED_OPENINGS = 8;
    private final Morphology morphology;
    private final Pattern[] patterns;
    private final Matrix<? extends UpdatablePArray> result;
    private final Matrix<? extends UpdatablePArray> temp1;
    private final Matrix<? extends UpdatablePArray> temp2;
    private final Matrix<? extends UpdatablePArray> temp3;
    private final MutableDoubleArray sumsOfOpenings;
    private final List<Matrix<? extends UpdatablePArray>> store;
    private final boolean onlyGranulometry;
    private final int numberOfStoredOpenings;
    private int numberOfPerformedErosions = 0;
    private int patternIndex = 0;
    private int storeSize = 0;
    private boolean firstIteration = true;
    private boolean useCarcasses = false;
    private boolean done = false;

    private IterativeOpening(Morphology morphology, Class<? extends UpdatablePArray> requiredType, Matrix<? extends PArray> matrix, Pattern[] patterns, boolean onlyGranulometry) {
        super(morphology.context());
        Objects.requireNonNull(matrix, "Null matrix argument");
        if (patterns.length == 0) {
            throw new IllegalArgumentException("Empty patterns[] argument");
        }
        for (int k = 0; k < patterns.length; ++k) {
            Objects.requireNonNull(patterns[k], "Null patterns[" + k + "]");
        }
        this.onlyGranulometry = onlyGranulometry;
        this.numberOfStoredOpenings = onlyGranulometry ? 0 : 8;
        MemoryModel mmTemp = IterativeErosion.mm(this.memoryModel, matrix, 2 + this.numberOfStoredOpenings);
        this.morphology = morphology;
        this.patterns = (Pattern[])patterns.clone();
        if (onlyGranulometry) {
            long minDim = matrix.dim(0);
            int dimCount = matrix.dimCount();
            for (int coord = 1; coord < dimCount; ++coord) {
                minDim = Math.min(minDim, matrix.dim(coord));
            }
            MemoryModel mmGran = minDim <= Arrays.SystemSettings.maxTempJavaMemory() / 8L ? SimpleMemoryModel.getInstance() : this.memoryModel;
            this.result = null;
            this.sumsOfOpenings = mmGran.newEmptyDoubleArray();
        } else {
            Class<?> reType = Arrays.elementType(requiredType);
            MemoryModel mmRes = IterativeErosion.mm(this.memoryModel, matrix, Arrays.sizeOf(reType) / Arrays.sizeOf(matrix.elementType()));
            this.result = mmRes.newMatrix(requiredType, reType, matrix.dimensions());
            this.sumsOfOpenings = null;
        }
        this.temp1 = mmTemp.newLazyCopy(UpdatablePArray.class, matrix);
        this.temp2 = mmTemp.newMatrix(UpdatablePArray.class, matrix);
        this.temp3 = mmTemp.newMatrix(UpdatablePArray.class, matrix);
        if (!onlyGranulometry) {
            this.store = new ArrayList<Matrix<? extends UpdatablePArray>>();
            this.store.add(this.result);
            for (int k = 0; k < this.numberOfStoredOpenings; ++k) {
                this.store.add(mmTemp.newMatrix(UpdatablePArray.class, matrix));
            }
            this.store.add(this.temp3);
        } else {
            this.store = null;
        }
    }

    public static IterativeOpening getInstance(Morphology morphology, Class<? extends UpdatablePArray> requiredType, Matrix<? extends PArray> matrix, Pattern ... patterns) {
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        return new IterativeOpening(morphology, requiredType, matrix, patterns, false);
    }

    public static IterativeOpening getGranulometryInstance(Morphology morphology, Matrix<? extends PArray> matrix, Pattern ... patterns) {
        return new IterativeOpening(morphology, null, matrix, patterns, true);
    }

    public PNumberArray sumsOfOpenings() {
        return this.sumsOfOpenings == null ? null : this.sumsOfOpenings.asImmutable();
    }

    @Override
    public void performIteration(ArrayContext context) {
        Pattern ptnOrCarcass;
        Pattern ptn = this.patterns[this.patternIndex];
        Pattern pattern = ptnOrCarcass = this.useCarcasses ? ptn.carcass() : ptn;
        if (this.firstIteration) {
            if (this.onlyGranulometry) {
                this.sumsOfOpenings.pushDouble(Arrays.sumOf(IterativeOpening.part(context, 0.0, 0.05), this.temp1.array()));
            } else {
                Matrices.applyFunc(IterativeOpening.part(context, 0.0, 0.05), Func.IDENTITY, this.result, this.temp1);
            }
        }
        this.morphology.context(IterativeOpening.part(context, this.firstIteration ? 0.05 : 0.0, 0.2)).erosion(this.temp2, this.temp1, ptnOrCarcass);
        boolean bl = this.done = this.numberOfPerformedErosions == Integer.MAX_VALUE || !Matrices.compareAndCopy(IterativeOpening.part(context, 0.2, 0.25), this.temp1, this.temp2).changed();
        if (!this.done) {
            ++this.numberOfPerformedErosions;
            this.morphology.context(IterativeOpening.part(context, 0.25, 0.9)).dilation(this.temp3, this.temp2, Patterns.newMinkowskiMultiplePattern(ptn, this.numberOfPerformedErosions));
            if (this.onlyGranulometry) {
                this.sumsOfOpenings.pushDouble(Arrays.sumOf(IterativeOpening.part(context, 0.9, 1.0), this.temp3.array()));
            }
        }
        this.firstIteration = false;
        ++this.patternIndex;
        if (this.patternIndex == this.patterns.length) {
            this.useCarcasses = true;
            this.patternIndex = 0;
        }
        if (!this.onlyGranulometry) {
            if (this.done || this.storeSize == this.numberOfStoredOpenings) {
                int n;
                int n2 = n = this.done ? 1 + this.storeSize : 2 + this.numberOfStoredOpenings;
                if (n > 1) {
                    LinearFunc f = LinearFunc.getInstance(0.0, Arrays.nDoubleCopies(n, 1.0).toJavaArray());
                    Matrices.applyFunc(IterativeOpening.part(context, 0.9, 1.0), (Func)f, this.result, this.store.subList(0, n));
                }
                this.storeSize = 0;
            } else if (this.numberOfStoredOpenings > 0) {
                Matrices.copy(IterativeOpening.part(context, 0.9, 1.0), this.store.get(1 + this.storeSize), this.temp3);
                ++this.storeSize;
            }
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public long estimatedNumberOfIterations() {
        return IterativeErosion.estimatedNumberOfIterations(this.temp1, this.patterns[0]);
    }

    @Override
    public Matrix<? extends UpdatablePArray> result() {
        return this.result;
    }

    @Override
    public void freeResources(ArrayContext context) {
        if (this.result != null) {
            this.temp1.freeResources(context == null ? null : context.part(0.0, 0.2));
            this.temp2.freeResources(context == null ? null : context.part(0.2, 0.4));
            this.temp3.freeResources(context == null ? null : context.part(0.4, 0.6));
            this.result.freeResources(context == null ? null : context.part(0.6, 0.8));
            this.sumsOfOpenings.freeResources(context == null ? null : context.part(0.8, 1.0));
        } else {
            this.temp1.freeResources(context == null ? null : context.part(0.0, 0.25));
            this.temp2.freeResources(context == null ? null : context.part(0.25, 0.5));
            this.temp3.freeResources(context == null ? null : context.part(0.5, 0.75));
            this.sumsOfOpenings.freeResources(context == null ? null : context.part(0.75, 1.0));
        }
    }

    public String toString() {
        return "iterative opening by patterns: " + JArrays.toString(this.patterns, ", ", 1000);
    }
}

