/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.linearfiltering;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.matrices.linearfiltering.AbstractDerivator;
import net.algart.matrices.linearfiltering.Derivator;

public class ContinuedDerivator
implements Derivator {
    private final Derivator parent;
    private final ArrayContext context;
    private final Matrix.ContinuationMode continuationMode;

    private ContinuedDerivator(Derivator parent, Matrix.ContinuationMode continuationMode) {
        Objects.requireNonNull(parent, "Null parent derivator");
        Objects.requireNonNull(continuationMode, "Null continuationMode derivator");
        if (continuationMode == Matrix.ContinuationMode.NONE) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be used with continuation mode \"" + String.valueOf(continuationMode) + "\"");
        }
        this.parent = parent;
        this.context = parent.context() == null ? ArrayContext.DEFAULT : parent.context();
        this.continuationMode = continuationMode;
    }

    public static ContinuedDerivator getInstance(Derivator parent, Matrix.ContinuationMode continuationMode) {
        return new ContinuedDerivator(parent, continuationMode);
    }

    public Derivator parent() {
        return this.parent;
    }

    public Matrix.ContinuationMode continuationMode() {
        return this.continuationMode;
    }

    @Override
    public ArrayContext context() {
        return this.context;
    }

    @Override
    public Derivator context(ArrayContext newContext) {
        return new ContinuedDerivator(this.parent.context(newContext), this.continuationMode);
    }

    @Override
    public boolean isPseudoCyclic() {
        return this.continuationMode == Matrix.ContinuationMode.PSEUDO_CYCLIC;
    }

    @Override
    public double decrement(Class<?> elementType) {
        return this.parent.decrement(elementType);
    }

    @Override
    public Matrix<? extends PArray> asMaximumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends PArray> result = this.parent.asMaximumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public Matrix<? extends UpdatablePArray> maximumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends UpdatablePArray> result = this.parent.maximumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public void maximumFromShiftedForwardAndBackward(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<UpdatablePArray> temp = this.context.getMemoryModel().newMatrix(UpdatablePArray.class, dest);
        this.parent.context(this.context.part(0.0, 0.95)).maximumFromShiftedForwardAndBackward(temp, src, directionIndexes, directions);
        Matrices.copy(this.context.part(0.95, 1.0), dest, temp.subMatr(origin, dim));
    }

    @Override
    public Matrix<? extends BitArray> asMaskOfMaximums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends BitArray> result = this.parent.asMaskOfMaximums(src, mode, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public Matrix<? extends UpdatableBitArray> maskOfMaximums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends UpdatableBitArray> result = this.parent.maskOfMaximums(src, mode, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public void maskOfMaximums(Matrix<? extends UpdatableBitArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<UpdatableBitArray> temp = this.context.getMemoryModel().newBitMatrix(dest.dimensions());
        this.parent.context(this.context.part(0.0, 0.95)).maskOfMaximums(temp, src, mode, directionIndexes, directions);
        Matrices.copy(this.context.part(0.95, 1.0), dest, temp.subMatr(origin, dim));
    }

    @Override
    public Matrix<? extends PArray> asNonMaximumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends PArray> result = this.parent.asNonMaximumSuppression(src, mode, filler, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public Matrix<? extends UpdatablePArray> nonMaximumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends UpdatablePArray> result = this.parent.nonMaximumSuppression(src, mode, filler, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public void nonMaximumSuppression(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<UpdatablePArray> temp = this.context.getMemoryModel().newMatrix(UpdatablePArray.class, dest);
        this.parent.context(this.context.part(0.0, 0.95)).nonMaximumSuppression(temp, src, mode, filler, directionIndexes, directions);
        Matrices.copy(this.context.part(0.95, 1.0), dest, temp.subMatr(origin, dim));
    }

    @Override
    public Matrix<? extends PArray> asMinimumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends PArray> result = this.parent.asMinimumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public Matrix<? extends UpdatablePArray> minimumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends UpdatablePArray> result = this.parent.minimumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public void minimumFromShiftedForwardAndBackward(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<UpdatablePArray> temp = this.context.getMemoryModel().newMatrix(UpdatablePArray.class, dest);
        this.parent.context(this.context.part(0.0, 0.95)).minimumFromShiftedForwardAndBackward(temp, src, directionIndexes, directions);
        Matrices.copy(this.context.part(0.95, 1.0), dest, temp.subMatr(origin, dim));
    }

    @Override
    public Matrix<? extends BitArray> asMaskOfMinimums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends BitArray> result = this.parent.asMaskOfMinimums(src, mode, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public Matrix<? extends UpdatableBitArray> maskOfMinimums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends UpdatableBitArray> result = this.parent.maskOfMinimums(src, mode, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public void maskOfMinimums(Matrix<? extends UpdatableBitArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<UpdatableBitArray> temp = this.context.getMemoryModel().newBitMatrix(dest.dimensions());
        this.parent.context(this.context.part(0.0, 0.95)).maskOfMinimums(temp, src, mode, directionIndexes, directions);
        Matrices.copy(this.context.part(0.95, 1.0), dest, temp.subMatr(origin, dim));
    }

    @Override
    public Matrix<? extends PArray> asNonMinimumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends PArray> result = this.parent.asNonMinimumSuppression(src, mode, filler, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public Matrix<? extends UpdatablePArray> nonMinimumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<? extends UpdatablePArray> result = this.parent.nonMinimumSuppression(src, mode, filler, directionIndexes, directions);
        return result.subMatr(origin, dim);
    }

    @Override
    public void nonMinimumSuppression(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        long[] dim = src.dimensions();
        long[] increasedDim = ContinuedDerivator.increaseDimensions(dim, directions);
        long[] origin = new long[dim.length];
        src = src.subMatr(origin, increasedDim, this.continuationMode);
        directionIndexes = directionIndexes.subMatr(origin, increasedDim, Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix<UpdatablePArray> temp = this.context.getMemoryModel().newMatrix(UpdatablePArray.class, dest);
        this.parent.context(this.context.part(0.0, 0.95)).nonMinimumSuppression(temp, src, mode, filler, directionIndexes, directions);
        Matrices.copy(this.context.part(0.95, 1.0), dest, temp.subMatr(origin, dim));
    }

    @Override
    public <T extends PArray> Matrix<T> asModuleOfVector(Class<? extends T> requiredType, List<? extends Matrix<? extends PArray>> vectorComponents) {
        return this.parent.asModuleOfVector(requiredType, vectorComponents);
    }

    @Override
    public Matrix<? extends PIntegerArray> asRoundedDirectionIndex2D(Matrix<? extends PArray> vectorX, Matrix<? extends PArray> vectorY) {
        return this.parent.asRoundedDirectionIndex2D(vectorX, vectorY);
    }

    @Override
    public IPoint[] roundedDirections2D() {
        return this.parent.roundedDirections2D();
    }

    private static long[] increaseDimensions(long[] dim, IPoint ... directions) {
        long[] max = new long[dim.length];
        for (IPoint dir : directions) {
            for (int k = 0; k < max.length; ++k) {
                max[k] = Math.max(max[k], 2L * dir.coord(k));
            }
        }
        long[] result = new long[dim.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = dim[k] + 8L + max[k];
        }
        return result;
    }
}

