/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.linearfiltering;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.IPoint;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.WeightedPattern;
import net.algart.matrices.linearfiltering.AbstractConvolution;
import net.algart.matrices.linearfiltering.Convolution;

public class BasicConvolution
extends AbstractConvolution
implements Convolution {
    private BasicConvolution(ArrayContext context, boolean incrementForUnsigned, boolean incrementByHalfForInteger) {
        super(context, incrementForUnsigned, incrementByHalfForInteger);
    }

    public static BasicConvolution getInstance(ArrayContext context, boolean incrementByHalfForInteger) {
        return new BasicConvolution(context, false, incrementByHalfForInteger);
    }

    public static BasicConvolution getCorrectingUnsignedInstance(ArrayContext context) {
        return new BasicConvolution(context, true, false);
    }

    @Override
    public boolean isPseudoCyclic() {
        return true;
    }

    @Override
    public <T extends PArray> Matrix<T> asConvolution(Class<? extends T> requiredType, Matrix<? extends PArray> src, WeightedPattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        Set<IPoint> points = pattern.roundedPoints();
        ArrayList<Matrix<PArray>> shifted = new ArrayList<Matrix<PArray>>();
        double[] weights = new double[points.size()];
        for (IPoint ip : points) {
            double w = pattern.weight(ip);
            if (w == 0.0) continue;
            Matrix<PArray> m = Matrices.asShifted(src, ip.coordinates()).cast(PArray.class);
            weights[shifted.size()] = w;
            shifted.add(m);
        }
        if (weights.length > shifted.size()) {
            weights = JArrays.copyOfRange(weights, 0, shifted.size());
        }
        double increment = this.increment(Arrays.elementType(requiredType));
        return Matrices.asFuncMatrix((Func)LinearFunc.getInstance(increment, weights), requiredType, shifted);
    }
}

