/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.Point;
import net.algart.math.patterns.Pattern;

public abstract class StreamingApertureProcessor
extends AbstractArrayProcessorWithContextSwitching {
    private static final boolean ENABLE_STREAMING = Arrays.SystemSettings.getBooleanProperty("net.algart.matrices.StreamingApertureProcessor.enableStreaming", true);

    protected StreamingApertureProcessor(ArrayContext context) {
        super(context);
    }

    @Override
    public StreamingApertureProcessor context(ArrayContext newContext) {
        return (StreamingApertureProcessor)super.context(newContext);
    }

    public boolean isStandardImplementation() {
        return true;
    }

    public final <T extends PArray> Matrix<T> asProcessed(Class<? extends T> requiredType, Matrix<? extends PArray> src, Pattern pattern) {
        return this.asProcessed(requiredType, src, Matrices.several(PArray.class, new Matrix[0]), pattern);
    }

    public final <T extends PArray> Matrix<T> asProcessed(Class<? extends T> requiredType, Matrix<? extends PArray> src, Matrix<? extends PArray> additionalMatrix, Pattern pattern) {
        return this.asProcessed(requiredType, src, Matrices.several(PArray.class, additionalMatrix), pattern);
    }

    public final <T extends PArray> Matrix<T> asProcessed(Class<? extends T> requiredType, Matrix<? extends PArray> src, Matrix<? extends PArray> additionalMatrix1, Matrix<? extends PArray> additionalMatrix2, Pattern pattern) {
        return this.asProcessed(requiredType, src, Matrices.several(PArray.class, additionalMatrix1, additionalMatrix2), pattern);
    }

    public final <T extends PArray> Matrix<T> asProcessed(Class<? extends T> requiredType, Matrix<? extends PArray> src, Matrix<? extends PArray> additionalMatrix1, Matrix<? extends PArray> additionalMatrix2, Matrix<? extends PArray> additionalMatrix3, Pattern pattern) {
        return this.asProcessed(requiredType, src, Matrices.several(PArray.class, additionalMatrix1, additionalMatrix2, additionalMatrix3), pattern);
    }

    public abstract <T extends PArray> Matrix<T> asProcessed(Class<? extends T> var1, Matrix<? extends PArray> var2, List<? extends Matrix<? extends PArray>> var3, Pattern var4);

    public final void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        this.process(dest, src, Matrices.several(PArray.class, new Matrix[0]), pattern);
    }

    public final void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> additionalMatrix, Pattern pattern) {
        this.process(dest, src, Matrices.several(PArray.class, additionalMatrix), pattern);
    }

    public final void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> additionalMatrix1, Matrix<? extends PArray> additionalMatrix2, Pattern pattern) {
        this.process(dest, src, Matrices.several(PArray.class, additionalMatrix1, additionalMatrix2), pattern);
    }

    public final void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> additionalMatrix1, Matrix<? extends PArray> additionalMatrix2, Matrix<? extends PArray> additionalMatrix3, Pattern pattern) {
        this.process(dest, src, Matrices.several(PArray.class, additionalMatrix1, additionalMatrix2, additionalMatrix3), pattern);
    }

    public void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, List<? extends Matrix<? extends PArray>> additionalMatrices, Pattern pattern) {
        long nPerThisLoop;
        boolean direct;
        Objects.requireNonNull(additionalMatrices, "Null additionalMatrices argument");
        additionalMatrices = new ArrayList<Matrix<? extends PArray>>(additionalMatrices);
        StreamingApertureProcessor.checkArguments(dest, src, additionalMatrices, pattern);
        pattern = pattern.round();
        Class<PArray> requiredType = dest.type(PArray.class);
        PArray sa = src.array();
        UpdatablePArray da = dest.array();
        long size = sa.length();
        if (size == 0L) {
            return;
        }
        long bufSize = Math.min(size, this.maxTempBufferSize(sa));
        ArrayContext arrayContext = this.context();
        if (size <= bufSize) {
            IPoint min = pattern.coordMin().toRoundedPoint();
            Pattern shiftedPattern = pattern.shift(min.symmetric().toPoint());
            Matrix<Array> shiftedSrc = Matrices.asShifted(src, min.coordinates());
            Matrix<UpdatablePArray> clone = Arrays.SMM.newMatrix(UpdatablePArray.class, src);
            Matrices.copy(arrayContext == null ? null : arrayContext.part(0.0, 0.05), clone, shiftedSrc);
            Matrix<PArray> lazy = this.asProcessed(requiredType, clone, additionalMatrices, shiftedPattern);
            new Arrays.Copier(arrayContext == null ? null : arrayContext.part(0.05, 1.0), dest.array(), lazy.array(), 0, 1L).process();
            return;
        }
        boolean bl = direct = sa instanceof DirectAccessible && ((DirectAccessible)((Object)sa)).hasJavaArray();
        if (direct || !ENABLE_STREAMING) {
            Matrix<PArray> lazy = this.asProcessed(requiredType, src, additionalMatrices, pattern);
            new Arrays.Copier(arrayContext, dest.array(), lazy.array(), 0, 1L).process();
            return;
        }
        assert (bufSize < size);
        IPoint min = pattern.coordMin().toRoundedPoint();
        Pattern shiftedPattern = pattern.shift(min.symmetric().toPoint());
        Matrix<PArray> shiftedSrc = Matrices.asShifted(src, min.coordinates()).cast(PArray.class);
        long[] dimensions = src.dimensions();
        long lSize = Arrays.longMul(dimensions, 0, dimensions.length - 1);
        long lastDim = dimensions[dimensions.length - 1];
        assert (lastDim * lSize == size);
        long nBuf = bufSize / lSize;
        long[] shifts = StreamingApertureProcessor.toShifts(dimensions, shiftedPattern);
        long nPattern = 1L;
        for (long shift : shifts) {
            assert (shift < size);
            long layerIndex = shift / lSize;
            if (layerIndex + 1L <= nPattern) continue;
            nPattern = layerIndex + 1L;
        }
        if (nPattern >= nBuf) {
            Matrix<PArray> lazy = this.asProcessed(requiredType, src, additionalMatrices, pattern);
            Matrices.copy(arrayContext, dest, lazy);
            return;
        }
        assert (++nPattern >= 2L);
        sa = shiftedSrc.array();
        assert (nPattern - 1L < nBuf);
        assert (nBuf <= lastDim);
        assert (lastDim > 0L);
        long nPerLoop = nBuf - nPattern + 1L;
        long gapSize = (nPattern - 1L) * lSize;
        long[] layerDimensions = (long[])dimensions.clone();
        layerDimensions[dimensions.length - 1] = nBuf;
        Matrix<UpdatablePArray> buf = Arrays.SMM.newMatrix(UpdatablePArray.class, sa.elementType(), layerDimensions);
        UpdatablePArray ba = buf.array();
        ArrayList<Matrix<PArray>> additionalBuf = new ArrayList<Matrix<PArray>>();
        PArray[] additionalArrays = (PArray[])Matrices.arraysOfParallelMatrices(PArray.class, additionalMatrices);
        for (long i = 0L; i < lastDim; i += nPerThisLoop) {
            ArrayContext ac;
            assert (nPerLoop + nPattern - 1L == nBuf);
            nPerThisLoop = Math.min(nPerLoop, lastDim - i);
            long nBufThisLoop = nPerThisLoop + nPattern - 1L;
            long bufSizeThisLoop = nBufThisLoop * lSize;
            ArrayContext arrayContext2 = ac = arrayContext == null ? null : arrayContext.part(i, i + nPerThisLoop, lastDim);
            if (i == 0L) {
                ba.copy(sa.subArray((lastDim - nPattern + 1L) * lSize, size));
            } else {
                ba.copy(0L, nPerLoop * lSize, gapSize);
            }
            ba.subArr(gapSize, nPerThisLoop * lSize).copy(sa.subArr(i * lSize, nPerThisLoop * lSize));
            if (nPerThisLoop < nPerLoop) {
                layerDimensions[dimensions.length - 1] = nBufThisLoop;
                buf = Matrices.matrix(ba.subArr(0L, bufSizeThisLoop), layerDimensions);
            }
            additionalBuf.clear();
            for (PArray additionalArray : additionalArrays) {
                PArray a;
                if (i < nPattern - 1L) {
                    long extra = nPattern - 1L - i;
                    assert (extra <= lastDim);
                    assert (nPerThisLoop == nPerLoop);
                    a = (PArray)Arrays.asConcatenation(additionalArray.subArray((lastDim - extra) * lSize, size), additionalArray.subArray(0L, (i + nPerThisLoop) * lSize));
                    assert (a.length() == nBuf * lSize);
                } else {
                    a = (PArray)additionalArray.subArray((i - nPattern + 1L) * lSize, (i + nPerThisLoop) * lSize);
                    assert (a.length() == bufSizeThisLoop);
                }
                additionalBuf.add(Matrices.matrix(a, layerDimensions));
            }
            Matrix<PArray> lazy = this.asProcessed(requiredType, buf, additionalBuf, shiftedPattern);
            new Arrays.Copier(ac, da.subArr(i * lSize, nPerThisLoop * lSize), lazy.array().subArr(gapSize, nPerThisLoop * lSize), 0, 1L).process();
        }
    }

    protected long maxTempBufferSize(PArray src) {
        return Math.round(8.0 / (double)src.bitsPerElement() * (double)Math.max((long)Arrays.SystemSettings.MIN_OPTIMIZATION_JAVA_MEMORY, Arrays.SystemSettings.maxTempJavaMemory()));
    }

    protected static void checkArguments(Matrix<? extends PArray> dest, Matrix<? extends PArray> src, List<? extends Matrix<? extends PArray>> additionalMatrices, Pattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(additionalMatrices, "Null additionalMatrices argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        if (!dest.dimEquals(src)) {
            throw new SizeMismatchException("Destination and source matrix dimensions mismatch: " + String.valueOf(dest) + " and " + String.valueOf(src));
        }
        int n = additionalMatrices.size();
        for (int k = 0; k < n; ++k) {
            Matrix<? extends PArray> m = additionalMatrices.get(k);
            Objects.requireNonNull(m, "Null additional matrix #" + k);
            if (m.dimEquals(src)) continue;
            throw new SizeMismatchException("The additional matrix #" + k + " and the src matrix dimensions mismatch: the additional matrix #" + k + " is " + String.valueOf(m) + ", the src matrix is " + String.valueOf(src));
        }
    }

    private static long[] toShifts(long[] dimensions, Pattern pattern) {
        Set<Point> points = pattern.points();
        long[] result = new long[points.size()];
        int k = 0;
        for (Point p : points) {
            result[k++] = p.toRoundedPoint().toOneDimensional(dimensions, true);
        }
        return result;
    }
}

