/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.rectangles;

import net.algart.math.rectangles.IRectanglesUnion;

class IBracket
implements Comparable<IBracket> {
    final IRectanglesUnion.FrameSide intersectingSide;
    final long coord;
    final boolean first;
    int followingCoveringDepth = -157;

    public IBracket(IRectanglesUnion.FrameSide intersectingSide, boolean first) {
        this.intersectingSide = intersectingSide;
        this.coord = intersectingSide.coord();
        this.first = first;
        assert (intersectingSide.first == first);
    }

    public boolean covers(long transversalCoord) {
        return this.intersectingSide.from() <= transversalCoord && this.intersectingSide.to() >= transversalCoord;
    }

    @Override
    public int compareTo(IBracket o) {
        if (this.coord < o.coord) {
            return -1;
        }
        if (this.coord > o.coord) {
            return 1;
        }
        if (this.first && !o.first) {
            return -1;
        }
        if (!this.first && o.first) {
            return 1;
        }
        int thisUniqueId = this.intersectingSide.frame.index;
        int otherUniqueId = o.intersectingSide.frame.index;
        return Integer.compare(thisUniqueId, otherUniqueId);
    }

    public String toString() {
        return (this.first ? "opening" : "closing") + " bracket " + this.coord + ", covering level after it: " + this.followingCoveringDepth;
    }
}

