/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

public abstract class HyperboloidOfRevolutionFunc
extends AbstractFunc
implements Func {
    final double scale;
    final double scaleInvSqr;
    final double semiAxisForResultingCoordinate;
    final double resultAtOrigin;
    final double increment;

    private HyperboloidOfRevolutionFunc(double scale, double semiAxisForResultingCoordinate, double resultAtOrigin) {
        if (scale < 0.0) {
            throw new IllegalArgumentException("Negative scale");
        }
        if (semiAxisForResultingCoordinate < 0.0) {
            throw new IllegalArgumentException("Negative semi-axis for the resulting coordinate");
        }
        this.scale = scale;
        this.scaleInvSqr = 1.0 / (scale * scale);
        this.semiAxisForResultingCoordinate = semiAxisForResultingCoordinate;
        this.resultAtOrigin = resultAtOrigin;
        this.increment = resultAtOrigin - semiAxisForResultingCoordinate;
    }

    public static HyperboloidOfRevolutionFunc getUpperInstance(double scale, double semiAxisForResultingCoordinate, double resultAtOrigin) {
        return new HyperboloidOfRevolutionFunc(scale, semiAxisForResultingCoordinate, resultAtOrigin){

            @Override
            public double get(double ... x) {
                double xSqr = 0.0;
                for (double coord : x) {
                    xSqr += coord * coord;
                }
                if (xSqr == 0.0) {
                    return this.resultAtOrigin;
                }
                return (StrictMath.sqrt(1.0 + xSqr * this.scaleInvSqr) - 1.0) * this.semiAxisForResultingCoordinate + this.resultAtOrigin;
            }

            public String toString() {
                return "hyperboloid of revolution function (upper part) f(r)=" + this.semiAxisForResultingCoordinate + "*(sqrt(1+(r/" + this.scale + ")^2)-1)+" + this.resultAtOrigin;
            }
        };
    }

    public static HyperboloidOfRevolutionFunc getLowerInstance(double scale, double semiAxisForResultingCoordinate, double resultAtOrigin) {
        return new HyperboloidOfRevolutionFunc(scale, semiAxisForResultingCoordinate, resultAtOrigin){

            @Override
            public double get(double ... x) {
                double xSqr = 0.0;
                for (double coord : x) {
                    xSqr += coord * coord;
                }
                if (xSqr == 0.0) {
                    return this.resultAtOrigin;
                }
                return (1.0 - StrictMath.sqrt(1.0 + xSqr * this.scaleInvSqr)) * this.semiAxisForResultingCoordinate + this.resultAtOrigin;
            }

            public String toString() {
                return "hyperboloid of revolution function (lower part) f(r)=" + this.semiAxisForResultingCoordinate + "*(1-sqrt(1+(r/" + this.scale + ")^2))+" + this.resultAtOrigin;
            }
        };
    }

    @Override
    public abstract double get(double ... var1);
}

