/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import net.algart.math.IPoint;
import net.algart.math.Range;
import net.algart.math.patterns.AbstractWeightedPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.WeightedPattern;

class ConstantWeightedPattern
extends AbstractWeightedPattern
implements WeightedPattern {
    private final double constantWeight;

    ConstantWeightedPattern(Pattern parent, double constantWeight) {
        super(parent);
        if (Double.isNaN(constantWeight)) {
            throw new IllegalArgumentException("Cannot create " + this.getClass().getName() + ": NaN weight is not allowed");
        }
        this.constantWeight = constantWeight;
    }

    @Override
    public WeightedPattern shift(IPoint shift) {
        return new ConstantWeightedPattern(this.parent.shift(shift.toPoint()), this.constantWeight);
    }

    @Override
    public WeightedPattern scale(double ... multipliers) {
        Pattern newPattern = this.parent.scale(multipliers);
        double newConstantWeight = this.constantWeight * newPattern.largePointCount() / this.largePointCount();
        return new ConstantWeightedPattern(newPattern, newConstantWeight);
    }

    @Override
    public double weight(IPoint point) {
        return this.constantWeight;
    }

    @Override
    public Range weightRange() {
        return Range.valueOf(this.constantWeight, this.constantWeight);
    }
}

