/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.geometry;

public class IntegerCirclePointsGenerator {
    private static final int DEBUG_LEVEL = 0;
    private static final int MAX_CACHED_RADIUS = 300;
    private static final int MAX_NUMBER_OF_CACHED_DELTAR = 10;
    private final CirclePointsReference circlePointsReference = new CirclePointsReference();
    private static final double SQRT2 = Math.sqrt(2.0);
    private static boolean isTrueStaticFlag;

    private IntegerCirclePointsGenerator() {
    }

    public static IntegerCirclePointsGenerator getInstance() {
        return new IntegerCirclePointsGenerator();
    }

    public int[] getCirclePoints(int r) {
        if (r < 0 || r > 10000000) {
            throw new IllegalArgumentException("All radii should be in range 0..10000000");
        }
        if (r == 0) {
            return new int[]{0, 0};
        }
        int[] result = this.circlePointsReference.getCirclePoints(r, 0);
        if (result == null) {
            int[] xyBuff = new int[8 * ((int)(SQRT2 * (double)r) + 5)];
            int quarterArrayLen = IntegerCirclePointsGenerator.getCircleQuarter1Points(r, xyBuff);
            int arrayLen = IntegerCirclePointsGenerator.appendCircleQuarters234Points(quarterArrayLen, xyBuff);
            result = new int[arrayLen];
            System.arraycopy(xyBuff, 0, result, 0, arrayLen);
            this.circlePointsReference.putCirclePoints(r, 0, result);
        }
        return result;
    }

    public int[] getExternalCirclePoints(int r, int delta) {
        if (r < 0 || r > 10000000) {
            throw new IllegalArgumentException("All radii should be in range 0..10000000");
        }
        if (delta < 0) {
            throw new IllegalArgumentException("Delta argument should be >=0");
        }
        if (delta == 0) {
            return this.getCirclePoints(r);
        }
        if (r == 0) {
            return new int[]{0, 0};
        }
        int[] result = this.circlePointsReference.getCirclePoints(r, delta);
        if (result == null) {
            int[] xyBuff = new int[8 * ((int)(SQRT2 * (double)r) + 5)];
            int quarterArrayLen = IntegerCirclePointsGenerator.getCircleQuarter1Points(r, xyBuff);
            int rHalf = r / 2;
            for (int disp = 0; disp < quarterArrayLen; disp += 2) {
                int x = xyBuff[disp];
                int y = xyBuff[disp + 1];
                xyBuff[disp] = (x * (r + delta) + rHalf) / r;
                xyBuff[disp + 1] = (y * (r + delta) + rHalf) / r;
            }
            int arrayLen = IntegerCirclePointsGenerator.appendCircleQuarters234Points(quarterArrayLen, xyBuff);
            result = new int[arrayLen];
            System.arraycopy(xyBuff, 0, result, 0, arrayLen);
            this.circlePointsReference.putCirclePoints(r, delta, result);
        }
        return result;
    }

    public void dispose() {
        this.circlePointsReference.dispose();
    }

    private static int getCircleQuarter1Points(int r, int[] xyBuff) {
        int disp = 0;
        int x = r;
        int y = 0;
        int d = 3 - 2 * r;
        while (x >= y) {
            xyBuff[disp++] = x;
            xyBuff[disp++] = y;
            if (d < 0) {
                d += 4 * y + 6;
                ++y;
                continue;
            }
            d += 4 * (y - x) + 10;
            --x;
            ++y;
        }
        for (int symDisp = disp - 2; symDisp > 0; symDisp -= 2) {
            xyBuff[disp] = xyBuff[symDisp + 1];
            xyBuff[disp + 1] = xyBuff[symDisp];
            disp += 2;
        }
        return disp;
    }

    private static int appendCircleQuarters234Points(int quarterArrayLen, int[] xyBuff) {
        int k = 0;
        int disp = quarterArrayLen;
        while (k < quarterArrayLen) {
            xyBuff[disp] = -xyBuff[k + 1];
            xyBuff[disp + 1] = xyBuff[k];
            k += 2;
            disp += 2;
        }
        k = 0;
        disp = 2 * quarterArrayLen;
        while (k < quarterArrayLen) {
            xyBuff[disp] = -xyBuff[k];
            xyBuff[disp + 1] = -xyBuff[k + 1];
            k += 2;
            disp += 2;
        }
        k = 0;
        disp = 3 * quarterArrayLen;
        while (k < quarterArrayLen) {
            xyBuff[disp] = xyBuff[k + 1];
            xyBuff[disp + 1] = -xyBuff[k];
            k += 2;
            disp += 2;
        }
        return 4 * quarterArrayLen;
    }

    private static class CirclePointsReference {
        final CirclePointsTable[] tables = new CirclePointsTable[10];
        int tablesLen = 0;

        private CirclePointsReference() {
        }

        synchronized int[] getCirclePoints(int r, int deltaR) {
            if (r > 300) {
                return null;
            }
            for (int k = 0; k < this.tablesLen; ++k) {
                if (this.tables[k].deltaR != deltaR) continue;
                CirclePointsTable table = this.tables[k];
                System.arraycopy(this.tables, 0, this.tables, 1, k);
                this.tables[0] = table;
                return table.circlePoints[r];
            }
            return null;
        }

        synchronized void putCirclePoints(int r, int deltaR, int[] circlePoints) {
            if (r > 300) {
                return;
            }
            for (int k = 0; k < this.tablesLen; ++k) {
                if (this.tables[k].deltaR != deltaR) continue;
                this.tables[k].circlePoints[r] = circlePoints;
                return;
            }
            this.tablesLen = Math.min(this.tablesLen + 1, this.tables.length);
            System.arraycopy(this.tables, 0, this.tables, 1, this.tablesLen - 1);
            this.tables[0] = new CirclePointsTable();
            this.tables[0].deltaR = deltaR;
            this.tables[0].circlePoints[r] = circlePoints;
        }

        synchronized void dispose() {
            for (int k = 0; k < this.tablesLen; ++k) {
                this.tables[k] = null;
            }
            this.tablesLen = 0;
        }
    }

    private static class CirclePointsTable {
        int deltaR;
        final int[][] circlePoints = new int[301][];

        private CirclePointsTable() {
        }
    }
}

