/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math;

import java.math.BigInteger;
import java.util.Objects;

public final class MutableInt128
implements Cloneable,
Comparable<MutableInt128> {
    private static final double EXP_2_63 = StrictMath.scalb(1.0, 63);
    private static final double EXP_2_64 = StrictMath.scalb(1.0, 64);
    private static final double EXP_2_127 = StrictMath.scalb(1.0, 127);
    private static final double EXP_2_128 = StrictMath.scalb(1.0, 128);
    private long high64Bits = 0L;
    private long low64Bits = 0L;
    private boolean negative = false;

    public MutableInt128() {
    }

    private MutableInt128(long high64Bits, long low64Bits, boolean negative) {
        this.high64Bits = high64Bits;
        this.low64Bits = low64Bits;
        this.negative = negative;
    }

    static MutableInt128 valueOfBits(long high64Bits, long low64Bits, boolean negative) {
        return new MutableInt128(high64Bits, low64Bits, negative);
    }

    public static MutableInt128 valueOf(long value) {
        return new MutableInt128().setToLong(value);
    }

    public static MutableInt128 valueOfUnsigned(long value) {
        return new MutableInt128().setToUnsignedLong(value);
    }

    public static MutableInt128 valueOfDouble(double value) {
        return new MutableInt128().setToDouble(value);
    }

    public static MutableInt128 newZero() {
        return new MutableInt128();
    }

    public static MutableInt128 newOne() {
        return new MutableInt128().one();
    }

    public static MutableInt128 newMinValue() {
        return new MutableInt128().minValue();
    }

    public static MutableInt128 newMaxValue() {
        return new MutableInt128().maxValue();
    }

    public boolean isZero() {
        return this.low64Bits == 0L && this.high64Bits == 0L;
    }

    public boolean isPositive() {
        return !this.negative && !this.isZero();
    }

    public boolean isNegative() {
        return this.negative && !this.isZero();
    }

    public int signum() {
        return this.isZero() ? 0 : (this.negative ? -1 : 1);
    }

    public long low64Bits() {
        return this.low64Bits;
    }

    public long high64Bits() {
        return this.high64Bits;
    }

    public boolean isExactlyConvertibleToDouble() {
        return this.numberOfLeadingZeros() + this.numberOfTrailingZeros() >= 75;
    }

    public double toDouble() {
        boolean increment;
        long mantissa;
        if (this.high64Bits == 0L && this.low64Bits >= 0L) {
            return this.negative ? -((double)this.low64Bits) : (double)this.low64Bits;
        }
        int leadingZeros = Long.numberOfLeadingZeros(this.high64Bits);
        if (leadingZeros > 11) {
            int leftShift = leadingZeros - 11;
            int lowBitsRightShift = 64 - leftShift;
            mantissa = (this.high64Bits << leftShift | this.low64Bits >>> lowBitsRightShift) & 0xFFFFFFFFFFFFFL;
            long middle = 1L << lowBitsRightShift - 1;
            long otherBits = this.low64Bits & (middle << 1) - 1L;
            increment = otherBits == middle ? (mantissa & 1L) != 0L : (otherBits & middle) != 0L;
        } else {
            long middle;
            long otherHighBits;
            int rightShift = 11 - leadingZeros;
            mantissa = this.high64Bits >>> rightShift & 0xFFFFFFFFFFFFFL;
            increment = rightShift == 0 ? (this.low64Bits == Long.MIN_VALUE ? (mantissa & 1L) != 0L : this.low64Bits < 0L) : ((otherHighBits = this.high64Bits & ((middle = 1L << rightShift - 1) << 1) - 1L) == middle && this.low64Bits == 0L ? (mantissa & 1L) != 0L : otherHighBits >= middle);
        }
        long exponent = 1150 - leadingZeros;
        if (increment && ++mantissa == 0x10000000000000L) {
            mantissa = 0L;
            ++exponent;
        }
        long ieeeDouble = mantissa | exponent << 52 | (this.negative ? Long.MIN_VALUE : 0L);
        return Double.longBitsToDouble(ieeeDouble);
    }

    public boolean isConvertibleToLong() {
        return this.high64Bits == 0L && (this.low64Bits >= 0L || this.low64Bits == Long.MIN_VALUE && this.negative);
    }

    public long toLongExact() {
        if (!this.isConvertibleToLong()) {
            throw new ArithmeticException("This number is out of long range");
        }
        return this.negative ? -this.low64Bits : this.low64Bits;
    }

    public BigInteger toBigInteger() {
        BigInteger result = BigInteger.valueOf(this.high64Bits & Long.MAX_VALUE);
        result = result.shiftLeft(64).or(BigInteger.valueOf(this.low64Bits & Long.MAX_VALUE));
        if (this.low64Bits < 0L) {
            result = result.setBit(63);
        }
        if (this.high64Bits < 0L) {
            result = result.setBit(127);
        }
        if (this.isNegative()) {
            result = result.negate();
        }
        return result;
    }

    public MutableInt128 setTo(MutableInt128 other) {
        Objects.requireNonNull(other, "Null other");
        this.low64Bits = other.low64Bits;
        this.high64Bits = other.high64Bits;
        this.negative = other.negative;
        return this;
    }

    public MutableInt128 setToLong(long value) {
        this.negative = value < 0L;
        this.low64Bits = Math.abs(value);
        this.high64Bits = 0L;
        return this;
    }

    public MutableInt128 setToUnsignedLong(long value) {
        this.negative = false;
        this.low64Bits = value;
        this.high64Bits = 0L;
        return this;
    }

    public MutableInt128 setToDouble(double value) {
        double valueDivided2Exp64;
        boolean bl = this.negative = value < 0.0;
        if (this.negative) {
            value = -value;
        }
        if ((valueDivided2Exp64 = StrictMath.floor(StrictMath.scalb(value, -64))) >= EXP_2_64) {
            this.high64Bits = -1L;
            this.low64Bits = -1L;
            return this;
        }
        long l = this.high64Bits = valueDivided2Exp64 >= EXP_2_63 ? (long)(valueDivided2Exp64 - EXP_2_63) | Long.MIN_VALUE : (long)valueDivided2Exp64;
        assert (value < EXP_2_128);
        this.low64Bits = (value -= StrictMath.scalb(valueDivided2Exp64, 64)) >= EXP_2_63 ? (long)(value - EXP_2_63) | Long.MIN_VALUE : (long)value;
        return this;
    }

    public MutableInt128 zero() {
        this.low64Bits = 0L;
        this.high64Bits = 0L;
        this.negative = false;
        return this;
    }

    public MutableInt128 one() {
        this.low64Bits = 1L;
        this.high64Bits = 0L;
        this.negative = false;
        return this;
    }

    public MutableInt128 minValue() {
        this.low64Bits = -1L;
        this.high64Bits = -1L;
        this.negative = true;
        return this;
    }

    public MutableInt128 maxValue() {
        this.low64Bits = -1L;
        this.high64Bits = -1L;
        this.negative = false;
        return this;
    }

    public boolean getBit(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative bit index");
        }
        if (index >= 128) {
            return false;
        }
        if (index >= 64) {
            return (this.high64Bits >>> index - 64 & 1L) != 0L;
        }
        return (this.low64Bits >>> index & 1L) != 0L;
    }

    public MutableInt128 setBit(int index, boolean value) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative bit index");
        }
        if (index >= 128) {
            return this;
        }
        if (value) {
            if (index >= 64) {
                this.high64Bits |= 1L << index - 64;
            } else {
                this.low64Bits |= 1L << index;
            }
        } else if (index >= 64) {
            this.high64Bits &= 1L << index - 64 ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.low64Bits &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this;
    }

    public MutableInt128 shiftRight(int shift) {
        if (shift < 0) {
            throw new IllegalArgumentException("Negative shift");
        }
        if (shift == 0) {
            return this;
        }
        if (shift >= 128) {
            this.high64Bits = 0L;
            this.low64Bits = 0L;
            return this;
        }
        if (shift >= 64) {
            this.low64Bits = this.high64Bits >>> shift - 64;
            this.high64Bits = 0L;
            return this;
        }
        this.low64Bits = this.low64Bits >>> shift | this.high64Bits << 64 - shift;
        this.high64Bits >>>= shift;
        return this;
    }

    public MutableInt128 shiftLeft(int shift) {
        if (shift < 0) {
            throw new IllegalArgumentException("Negative shift");
        }
        if (shift == 0 || this.low64Bits == 0L && this.high64Bits == 0L) {
            return this;
        }
        if (shift >= 128) {
            throw new ArithmeticException("128-bit overflow while left shift <<" + shift);
        }
        if (shift >= 64) {
            if (this.high64Bits != 0L) {
                throw new ArithmeticException("128-bit overflow while left shift <<" + shift);
            }
            long newHigh64Bits = this.low64Bits << shift - 64;
            if (newHigh64Bits >>> shift - 64 != this.low64Bits) {
                throw new ArithmeticException("128-bit overflow while left shift <<" + shift);
            }
            this.high64Bits = newHigh64Bits;
            this.low64Bits = 0L;
            return this;
        }
        long newHigh64Bits = this.high64Bits << shift | this.low64Bits >>> 64 - shift;
        if (newHigh64Bits >>> shift != this.high64Bits) {
            throw new ArithmeticException("128-bit overflow while left shift <<" + shift);
        }
        this.high64Bits = newHigh64Bits;
        this.low64Bits <<= shift;
        return this;
    }

    public MutableInt128 shiftRightRounding(int shift) {
        if (shift < 0) {
            throw new IllegalArgumentException("Negative shift");
        }
        if (shift == 0) {
            return this;
        }
        if (shift >= 128) {
            this.high64Bits = 0L;
            this.low64Bits = 0L;
            return this;
        }
        if (shift > 64) {
            long middle = 1L << (shift -= 64) - 1;
            long otherBits = this.high64Bits & (middle << 1) - 1L;
            long newLow64Bits = this.high64Bits >>> shift;
            if (otherBits == middle && this.low64Bits == 0L ? (newLow64Bits & 1L) == 1L : otherBits >= middle) {
                ++newLow64Bits;
            }
            this.high64Bits = 0L;
            this.low64Bits = newLow64Bits;
            return this;
        }
        if (shift == 64) {
            long newLow64Bits = this.high64Bits;
            this.high64Bits = 0L;
            if ((this.low64Bits == Long.MIN_VALUE ? (newLow64Bits & 1L) == 1L : this.low64Bits < 0L) && ++newLow64Bits == 0L) {
                ++this.high64Bits;
            }
            this.low64Bits = newLow64Bits;
            return this;
        }
        long middle = 1L << shift - 1;
        long otherBits = this.low64Bits & (middle << 1) - 1L;
        long newLow64Bits = this.low64Bits >>> shift | this.high64Bits << 64 - shift;
        long newHigh64Bits = this.high64Bits >>> shift;
        if ((otherBits == middle ? (newLow64Bits & 1L) == 1L : otherBits >= middle) && ++newLow64Bits == 0L) {
            ++newHigh64Bits;
        }
        this.high64Bits = newHigh64Bits;
        this.low64Bits = newLow64Bits;
        return this;
    }

    public MutableInt128 and(MutableInt128 other) {
        this.high64Bits &= other.high64Bits;
        this.low64Bits &= other.low64Bits;
        return this;
    }

    public MutableInt128 or(MutableInt128 other) {
        this.high64Bits |= other.high64Bits;
        this.low64Bits |= other.low64Bits;
        return this;
    }

    public MutableInt128 xor(MutableInt128 other) {
        this.high64Bits ^= other.high64Bits;
        this.low64Bits ^= other.low64Bits;
        return this;
    }

    public MutableInt128 not() {
        this.high64Bits ^= 0xFFFFFFFFFFFFFFFFL;
        this.low64Bits ^= 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    public int numberOfLeadingZeros() {
        return this.high64Bits != 0L ? Long.numberOfLeadingZeros(this.high64Bits) : 64 + Long.numberOfLeadingZeros(this.low64Bits);
    }

    public int numberOfTrailingZeros() {
        return this.low64Bits != 0L ? Long.numberOfTrailingZeros(this.low64Bits) : 64 + Long.numberOfTrailingZeros(this.high64Bits);
    }

    public int bitCount() {
        return Long.bitCount(this.high64Bits) + Long.bitCount(this.low64Bits);
    }

    public MutableInt128 negate() {
        if (!this.isZero()) {
            this.negative = !this.negative;
        }
        return this;
    }

    public MutableInt128 abs() {
        this.negative = false;
        return this;
    }

    public MutableInt128 add(MutableInt128 other) throws ArithmeticException {
        this.add(other.high64Bits, other.low64Bits, other.negative);
        return this;
    }

    public MutableInt128 subtract(MutableInt128 other) throws ArithmeticException {
        this.add(other.high64Bits, other.low64Bits, !other.negative);
        return this;
    }

    public MutableInt128 addLong(long value) {
        this.add(0L, Math.abs(value), value < 0L);
        return this;
    }

    public MutableInt128 setToLongLongProduct(long firstMultiplier, long secondMultiplier) {
        this.negative = firstMultiplier < 0L != secondMultiplier < 0L;
        long a = firstMultiplier < 0L ? -firstMultiplier : firstMultiplier;
        long b = secondMultiplier < 0L ? -secondMultiplier : secondMultiplier;
        long a0 = a & 0xFFFFFFFFL;
        long a1 = a >>> 32;
        long b0 = b & 0xFFFFFFFFL;
        long b1 = b >>> 32;
        long w0 = a0 * b0;
        long t = (w0 >>> 32) + a1 * b0;
        long w1 = t & 0xFFFFFFFFL;
        long w2 = t >>> 32;
        this.low64Bits = (w0 & 0xFFFFFFFFL) + ((w1 += a0 * b1) << 32);
        this.high64Bits = a1 * b1 + w2 + (w1 >>> 32);
        assert (this.high64Bits >= 0L);
        return this;
    }

    public MutableInt128 setToLongIntProduct(long firstMultiplier, int secondMultiplier) {
        this.negative = firstMultiplier < 0L != secondMultiplier < 0;
        long a = firstMultiplier < 0L ? -firstMultiplier : firstMultiplier;
        long b = (long)(secondMultiplier < 0 ? -secondMultiplier : secondMultiplier) & 0xFFFFFFFFL;
        long a0 = a & 0xFFFFFFFFL;
        long a1 = a >>> 32;
        long w0 = a0 * b;
        long t = (w0 >>> 32) + a1 * b;
        this.low64Bits = (w0 & 0xFFFFFFFFL) + (t << 32);
        this.high64Bits = t >>> 32;
        assert (this.high64Bits >= 0L);
        return this;
    }

    public MutableInt128 setToUnsignedLongLongProduct(long firstMultiplier, long secondMultiplier) {
        this.negative = false;
        long a0 = firstMultiplier & 0xFFFFFFFFL;
        long a1 = firstMultiplier >>> 32;
        long b0 = secondMultiplier & 0xFFFFFFFFL;
        long b1 = secondMultiplier >>> 32;
        long w0 = a0 * b0;
        long t = (w0 >>> 32) + a1 * b0;
        long w1 = t & 0xFFFFFFFFL;
        long w2 = t >>> 32;
        this.low64Bits = (w0 & 0xFFFFFFFFL) + ((w1 += a0 * b1) << 32);
        this.high64Bits = a1 * b1 + w2 + (w1 >>> 32);
        return this;
    }

    public MutableInt128 setToLongSqr(long value) {
        this.negative = false;
        long a = value < 0L ? -value : value;
        long a0 = a & 0xFFFFFFFFL;
        long a1 = a >>> 32;
        long w0 = a0 * a0;
        long t = (w0 >>> 32) + (a1 * a0 << 1);
        long w1 = t & 0xFFFFFFFFL;
        long w2 = t >>> 32;
        this.low64Bits = (w0 & 0xFFFFFFFFL) + (w1 << 32);
        this.high64Bits = a1 * a1 + w2;
        assert (this.high64Bits >= 0L);
        return this;
    }

    public MutableInt128 addLongLongProduct(long firstMultiplier, long secondMultiplier) {
        boolean productNegative = firstMultiplier < 0L != secondMultiplier < 0L;
        long a = firstMultiplier < 0L ? -firstMultiplier : firstMultiplier;
        long b = secondMultiplier < 0L ? -secondMultiplier : secondMultiplier;
        long a0 = a & 0xFFFFFFFFL;
        long a1 = a >>> 32;
        long b0 = b & 0xFFFFFFFFL;
        long b1 = b >>> 32;
        long w0 = a0 * b0;
        long t = (w0 >>> 32) + a1 * b0;
        long w1 = t & 0xFFFFFFFFL;
        long w2 = t >>> 32;
        long productLow64Bits = (w0 & 0xFFFFFFFFL) + ((w1 += a0 * b1) << 32);
        long productHigh64Bits = a1 * b1 + w2 + (w1 >>> 32);
        assert (productHigh64Bits >= 0L);
        this.add(productHigh64Bits, productLow64Bits, productNegative);
        return this;
    }

    public MutableInt128 addLongIntProduct(long firstMultiplier, int secondMultiplier) {
        boolean productNegative = firstMultiplier < 0L != secondMultiplier < 0;
        long a = firstMultiplier < 0L ? -firstMultiplier : firstMultiplier;
        long b = (long)(secondMultiplier < 0 ? -secondMultiplier : secondMultiplier) & 0xFFFFFFFFL;
        long a0 = a & 0xFFFFFFFFL;
        long a1 = a >>> 32;
        long w0 = a0 * b;
        long t = (w0 >>> 32) + a1 * b;
        long productLow64Bits = (w0 & 0xFFFFFFFFL) + (t << 32);
        long productHigh64Bits = t >>> 32;
        assert (productHigh64Bits >= 0L);
        this.add(productHigh64Bits, productLow64Bits, productNegative);
        return this;
    }

    public MutableInt128 addUnsignedLongLongProduct(long firstMultiplier, long secondMultiplier) {
        long a0 = firstMultiplier & 0xFFFFFFFFL;
        long a1 = firstMultiplier >>> 32;
        long b0 = secondMultiplier & 0xFFFFFFFFL;
        long b1 = secondMultiplier >>> 32;
        long w0 = a0 * b0;
        long t = (w0 >>> 32) + a1 * b0;
        long w1 = t & 0xFFFFFFFFL;
        long w2 = t >>> 32;
        long productLow64Bits = (w0 & 0xFFFFFFFFL) + ((w1 += a0 * b1) << 32);
        long productHigh64Bits = a1 * b1 + w2 + (w1 >>> 32);
        this.add(productHigh64Bits, productLow64Bits, false);
        return this;
    }

    public MutableInt128 addLongSqr(long value) {
        long a = value < 0L ? -value : value;
        long a0 = a & 0xFFFFFFFFL;
        long a1 = a >>> 32;
        long w0 = a0 * a0;
        long t = (w0 >>> 32) + (a1 * a0 << 1);
        long w1 = t & 0xFFFFFFFFL;
        long w2 = t >>> 32;
        long productLow64Bits = (w0 & 0xFFFFFFFFL) + (w1 << 32);
        long productHigh64Bits = a1 * a1 + w2;
        assert (productHigh64Bits >= 0L);
        this.add(productHigh64Bits, productLow64Bits, false);
        return this;
    }

    public MutableInt128 clone() {
        try {
            return (MutableInt128)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public int compareTo(MutableInt128 o) {
        if (o.isZero()) {
            return this.signum();
        }
        if (this.negative != o.negative) {
            return this.negative ? -1 : 1;
        }
        int result = MutableInt128.lessUnsigned(this.high64Bits, o.high64Bits) ? -1 : (this.high64Bits != o.high64Bits ? 1 : (MutableInt128.lessUnsigned(this.low64Bits, o.low64Bits) ? -1 : (this.low64Bits != o.low64Bits ? 1 : 0)));
        return this.negative ? -result : result;
    }

    public String toString() {
        return this.toBigInteger().toString();
    }

    public String toString(int radix) {
        return this.toBigInteger().toString(radix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableInt128 that = (MutableInt128)o;
        return this.low64Bits == that.low64Bits && this.high64Bits == that.high64Bits && (this.negative == that.negative || this.isZero() && that.isZero());
    }

    public int hashCode() {
        if (this.isZero()) {
            return 771650340;
        }
        int result = MutableInt128.hashCode(this.low64Bits);
        result = 37 * result + MutableInt128.hashCode(this.high64Bits);
        result = 37 * result + (this.negative ? 157 : 932);
        return result;
    }

    public static double unsignedToDouble(long value) {
        if (value >= 0L) {
            return value;
        }
        long mantissa = value >>> 11 & 0xFFFFFFFFFFFFFL;
        long otherBits = value & 0x7FFL;
        boolean increment = otherBits == 1024L ? (mantissa & 1L) != 0L : (otherBits & 0x400L) != 0L;
        long exponent = 1086L;
        if (increment && ++mantissa == 0x10000000000000L) {
            mantissa = 0L;
            ++exponent;
        }
        long ieeeDouble = mantissa | exponent << 52;
        return Double.longBitsToDouble(ieeeDouble);
    }

    public static long shiftRightRounding(long value, int shift) {
        if (shift < 0) {
            throw new IllegalArgumentException("Negative shift");
        }
        if (shift == 0) {
            return value;
        }
        if (shift >= 64) {
            return 0L;
        }
        long middle = 1L << shift - 1;
        long otherBits = value & (middle << 1) - 1L;
        long result = value >> shift;
        if (otherBits == middle ? (result & 1L) == 1L : otherBits >= middle) {
            ++result;
        }
        return result;
    }

    public static long unsignedShiftRightRounding(long value, int shift) {
        if (shift < 0) {
            throw new IllegalArgumentException("Negative shift");
        }
        if (shift == 0) {
            return value;
        }
        if (shift >= 64) {
            return 0L;
        }
        long middle = 1L << shift - 1;
        long otherBits = value & (middle << 1) - 1L;
        long result = value >>> shift;
        if (otherBits == middle ? (result & 1L) == 1L : otherBits >= middle) {
            ++result;
        }
        return result;
    }

    double toDoubleByAdding() {
        double resultAbs = (double)(this.low64Bits & Long.MAX_VALUE) + (this.low64Bits < 0L ? EXP_2_63 : 0.0) + StrictMath.scalb((double)(this.high64Bits & Long.MAX_VALUE), 64) + (this.high64Bits < 0L ? EXP_2_127 : 0.0);
        return this.negative ? -resultAbs : resultAbs;
    }

    private void add(long otherHigh64Bits, long otherLow64Bits, boolean otherNegative) throws ArithmeticException {
        long newHigh64Bits = this.high64Bits;
        long newLow64Bits = this.low64Bits;
        if (this.negative == otherNegative) {
            long carryBit = (this.low64Bits & otherLow64Bits | (this.low64Bits | otherLow64Bits) & ((newLow64Bits += otherLow64Bits) ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63 & 1L;
            if ((this.high64Bits & otherHigh64Bits | (this.high64Bits | otherHigh64Bits) & ((newHigh64Bits += otherHigh64Bits + carryBit) ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
                throw new ArithmeticException("128-bit overflow: absolute value ||a|+|b||>2^128");
            }
        } else {
            long carryBit = ((this.low64Bits ^ 0xFFFFFFFFFFFFFFFFL) & otherLow64Bits | (this.low64Bits ^ 0xFFFFFFFFFFFFFFFFL | otherLow64Bits) & (newLow64Bits -= otherLow64Bits)) >>> 63 & 1L;
            if (((this.high64Bits ^ 0xFFFFFFFFFFFFFFFFL) & otherHigh64Bits | (this.high64Bits ^ 0xFFFFFFFFFFFFFFFFL | otherHigh64Bits) & (newHigh64Bits -= otherHigh64Bits + carryBit)) < 0L) {
                newHigh64Bits ^= 0xFFFFFFFFFFFFFFFFL;
                newLow64Bits ^= 0xFFFFFFFFFFFFFFFFL;
                if (++newLow64Bits == 0L) {
                    ++newHigh64Bits;
                }
                this.negative = !this.negative;
            }
        }
        this.high64Bits = newHigh64Bits;
        this.low64Bits = newLow64Bits;
    }

    private static int hashCode(long value) {
        return Long.hashCode(value);
    }

    private static boolean lessUnsigned(long a, long b) {
        return a - b >= 0L ? ((a ^ 0xFFFFFFFFFFFFFFFFL) & b) < 0L : (a ^ 0xFFFFFFFFFFFFFFFFL | b) < 0L;
    }
}

