/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import net.algart.arrays.ArraySelector;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;
import net.algart.math.IRangeConsumer;
import net.algart.math.IRangeFinderWithoutOptimization;

public class IRangeFinder {
    private static final int MAX_NUMBER_OF_RANGES = 0x2AAAAAAA;
    private static final boolean MEDIAN_OF_BOTH_ENDS = true;
    private static final int THRESHOLD_FOR_STORING_SHORT_LISTS = 16;
    static final boolean OPTIMIZE_ADDITIONAL_SEARCH = true;
    private static final ArraySelector ARRAY_SELECTOR = ArraySelector.getQuickSelector();
    private IntUnaryOperator left = null;
    private IntUnaryOperator right = null;
    int n = 0;
    private IntPredicate indexActual = value -> true;
    private long[] tree = new long[]{1L};
    private int[] work = JArrays.EMPTY_INTS;
    int treeOffset = 0;

    IRangeFinder() {
    }

    public static IRangeFinder getEmptyInstance() {
        return new IRangeFinder();
    }

    public static IRangeFinder getEmptyUnoptimizedInstance() {
        return new IRangeFinderWithoutOptimization();
    }

    public static IRangeFinder getInstance(IntUnaryOperator left, IntUnaryOperator right, int numberOfRanges) {
        return new IRangeFinder().setRanges(left, right, numberOfRanges);
    }

    public static IRangeFinder getInstance(int[] left, int[] right) {
        return new IRangeFinder().setRanges(left, right);
    }

    public final IntUnaryOperator left() {
        return this.left;
    }

    public final IntUnaryOperator right() {
        return this.right;
    }

    public final int left(int k) {
        return this.left.applyAsInt(k);
    }

    public final int right(int k) {
        return this.right.applyAsInt(k);
    }

    public final int numberOfRanges() {
        return this.n;
    }

    public final IRangeFinder setRanges(IntUnaryOperator left, IntUnaryOperator right, int numberOfRanges) {
        if (numberOfRanges < 0) {
            throw new IllegalArgumentException("Negative number of ranges " + numberOfRanges);
        }
        if (numberOfRanges > 0) {
            Objects.requireNonNull(left, "Null operator for getting left bounds");
            Objects.requireNonNull(right, "Null operator for getting right bounds");
        }
        if (numberOfRanges > 0x2AAAAAAA) {
            throw new TooLargeArrayException("Too large number of ranges " + numberOfRanges + ": cannot be >715827882");
        }
        this.left = left;
        this.right = right;
        this.n = numberOfRanges;
        this.build();
        return this;
    }

    public final IRangeFinder setRanges(int[] left, int[] right) {
        Objects.requireNonNull(left, "Null left");
        Objects.requireNonNull(right, "Null right");
        if (left.length != right.length) {
            throw new IllegalArgumentException("Different lengths of arrays of left/right coordinates");
        }
        return this.setRanges(i -> left[i], i -> right[i], left.length);
    }

    public final IRangeFinder setIndexedRanges(int[] allLeft, int[] allRight, int[] indexes, int numberOfRanges) {
        Objects.requireNonNull(allLeft, "Null allLeft");
        Objects.requireNonNull(allRight, "Null allRight");
        Objects.requireNonNull(indexes, "Null indexes");
        if (allLeft.length != allRight.length) {
            throw new IllegalArgumentException("Different lengths of arrays of left/right coordinates");
        }
        if (numberOfRanges < 0) {
            throw new IllegalArgumentException("Negative number of ranges");
        }
        if (numberOfRanges > indexes.length) {
            throw new IllegalArgumentException("Number of ranges " + numberOfRanges + " > indexes array length = " + indexes.length);
        }
        return this.setRanges(i -> allLeft[indexes[i]], i -> allRight[indexes[i]], numberOfRanges);
    }

    public final IRangeFinder setIndexActual(IntPredicate indexActual) {
        this.indexActual = Objects.requireNonNull(indexActual, "Null predicate, is an index necessary");
        return this;
    }

    public final IRangeFinder setAllIndexesActual() {
        return this.setIndexActual(value -> true);
    }

    public final boolean indexActual(int k) {
        return this.indexActual.test(k);
    }

    public IRangeFinder compact() {
        long workLength;
        int treeLength = this.treeOffset + this.treeLength(this.treeOffset);
        if (treeLength < this.tree.length) {
            this.tree = Arrays.copyOf(this.tree, treeLength);
        }
        if ((workLength = this.workLength()) < (long)this.work.length) {
            this.work = Arrays.copyOf(this.work, (int)workLength);
        }
        return this;
    }

    public void findContaining(int point, IRangeConsumer rangeConsumer) {
        this.findContainingPoint(this.treeOffset, point, rangeConsumer);
    }

    public void findContaining(int point, IntConsumer indexConsumer) {
        this.findContainingPoint(this.treeOffset, point, indexConsumer);
    }

    public int findContaining(int point, int[] resultIndexes) {
        IntArrayAppender appender = new IntArrayAppender(resultIndexes);
        this.findContaining(point, (IntConsumer)appender);
        return appender.offset();
    }

    public void findContaining(double point, IRangeConsumer rangeConsumer) {
        if (point < -2.147483648E9 || point > 2.147483647E9) {
            return;
        }
        int roundedPoint = (int)Math.round(point);
        if ((double)roundedPoint == point) {
            this.findContaining(roundedPoint, rangeConsumer);
        } else {
            this.findContaining(roundedPoint, (int index, int left, int right) -> {
                if ((double)left <= point && point <= (double)right) {
                    rangeConsumer.accept(index, left, right);
                }
            });
        }
    }

    public void findContaining(double point, IntConsumer indexConsumer) {
        if (point < -2.147483648E9 || point > 2.147483647E9) {
            return;
        }
        int roundedPoint = (int)Math.round(point);
        if ((double)roundedPoint == point) {
            this.findContaining(roundedPoint, indexConsumer);
        } else {
            this.findContaining(roundedPoint, (int index, int left, int right) -> {
                if ((double)left <= point && point <= (double)right) {
                    indexConsumer.accept(index);
                }
            });
        }
    }

    public int findContaining(double point, int[] resultIndexes) {
        IntArrayAppender appender = new IntArrayAppender(resultIndexes);
        this.findContaining(point, (IntConsumer)appender);
        return appender.offset();
    }

    public void findIntersecting(int min, int max, IRangeConsumer rangeConsumer) {
        int p = this.findContainingPointAndMinGreater(this.treeOffset, min, rangeConsumer);
        this.findIntervalsLeftInRangeFromKnown(max, rangeConsumer, p);
    }

    public void findIntersecting(int min, int max, IntConsumer indexConsumer) {
        int p = this.findContainingPointAndMinGreater(this.treeOffset, min, indexConsumer);
        this.findIntervalsLeftInRangeFromKnown(max, indexConsumer, p);
    }

    public int findIntersecting(int min, int max, int[] resultIndexes) {
        IntArrayAppender appender = new IntArrayAppender(resultIndexes);
        this.findIntersecting(min, max, appender);
        return appender.offset();
    }

    public void clear() {
        this.left = null;
        this.right = null;
        this.n = 0;
        this.tree = new long[]{1L};
        this.work = JArrays.EMPTY_INTS;
        this.treeOffset = 0;
    }

    public String toString() {
        return "integer ranges finder (interval tree) for " + this.n + " ranges" + (this.n == 0 ? " (empty)" : "") + " (" + this.treeOffset + "+" + this.treeLength(this.treeOffset) + " elements, capacity " + this.tree.length + ")";
    }

    IRangeFinder build() {
        this.ensureWorkCapacity(this.workLength());
        this.ensureTreeCapacity(2L * (long)this.n + 1L);
        this.packInitialLeftIndexes();
        this.sortLeftIndexes();
        this.treeOffset = this.n;
        this.buildTreePart(this.treeOffset, 0, this.n);
        this.findFirstPositionInSortedArrayWithSameLeft();
        return this;
    }

    private void packInitialLeftIndexes() {
        IntStream.range(0, this.n + 255 >>> 8).parallel().forEach(block -> {
            int k;
            int to = (int)Math.min((long)k + 256L, (long)this.n);
            for (k = block << 8; k < to; ++k) {
                int right;
                int left = this.left(k);
                if (left > (right = this.right(k))) {
                    throw new IllegalStateException("Illegal range #" + k + ": left > right");
                }
                this.tree[k] = IRangeFinder.packLowAndHigh(k, left);
            }
        });
    }

    private void sortLeftIndexes() {
        Arrays.parallelSort(this.tree, 0, this.n);
    }

    private void findFirstPositionInSortedArrayWithSameLeft() {
        int firstPositionWithThisLeft = -1;
        int lastLeft = 157;
        for (int k = 0; k < this.n; ++k) {
            long packed = this.tree[k];
            int left = IRangeFinder.unpackHigh(packed);
            if (firstPositionWithThisLeft == -1 || left != lastLeft) {
                firstPositionWithThisLeft = k;
                lastLeft = left;
            }
            int index = IRangeFinder.unpackLow(packed);
            this.work[index] = firstPositionWithThisLeft;
        }
    }

    private int firstPositionInSortedArrayWithSameLeft(int index) {
        return this.work[index];
    }

    private int buildTreePart(int resultTreeOffset, int indexesFrom, int indexesTo) {
        int count = indexesTo - indexesFrom;
        assert (count >= 0);
        if (count <= 16) {
            return this.buildShortList(resultTreeOffset, indexesFrom, count);
        }
        this.ensureTreeCapacity((long)resultTreeOffset + 2L);
        int c = this.medianPoint(indexesFrom, indexesTo);
        this.tree[resultTreeOffset] = -1L;
        this.tree[resultTreeOffset + 1] = c;
        int iccOffset = IRangeFinder.iccOffset(resultTreeOffset);
        int lTreeOffset = this.buildICC(iccOffset, c, indexesFrom, indexesTo);
        int afterLIndexes = this.extractIndexesOfStrictlyLeft(lTreeOffset, c, indexesFrom, indexesTo);
        int lTreeLength = this.buildTreePart(afterLIndexes, lTreeOffset, afterLIndexes);
        System.arraycopy(this.tree, afterLIndexes, this.tree, lTreeOffset, lTreeLength);
        int rTreeOffset = lTreeOffset + lTreeLength;
        int afterRIndexes = this.extractIndexesOfStrictlyRight(rTreeOffset, c, indexesFrom, indexesTo);
        int rTreeLength = this.buildTreePart(afterRIndexes, rTreeOffset, afterRIndexes);
        System.arraycopy(this.tree, afterRIndexes, this.tree, rTreeOffset, rTreeLength);
        int treeLength = rTreeOffset + rTreeLength - resultTreeOffset;
        this.tree[resultTreeOffset] = IRangeFinder.addTreeLengthSignature(treeLength);
        assert (lTreeOffset == IRangeFinder.leftTreeOffset(resultTreeOffset, this.iccLength(resultTreeOffset)));
        assert (rTreeOffset == this.leftToRightTreeOffset(lTreeOffset));
        this.treeLength(lTreeOffset);
        this.treeLength(rTreeOffset);
        return treeLength;
    }

    private int buildShortList(int resultListOffset, int indexesOffset, int count) {
        int result = count + 1;
        this.ensureTreeCapacity((long)resultListOffset + (long)result);
        this.tree[resultListOffset] = result;
        System.arraycopy(this.tree, indexesOffset, this.tree, resultListOffset + 1, count);
        return result;
    }

    private int medianPoint(int indexesFrom, int indexesTo) {
        int m = 0;
        for (int k = indexesFrom; k < indexesTo; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            int left = IRangeFinder.unpackHigh(packed);
            this.work[m++] = left;
            this.work[m++] = this.right(index);
        }
        return ARRAY_SELECTOR.select(0, m, m >> 1, this.work);
    }

    private int buildICC(int resultICCOffset, int center, int indexesFrom, int indexesTo) {
        int leftBoundariesOffset;
        this.ensureTreeCapacity((long)resultICCOffset + 1L + (long)(indexesTo - indexesFrom));
        int offset = leftBoundariesOffset = resultICCOffset + 1;
        int minGreaterLeft = -1;
        int minGreaterLeftIndex = -1;
        for (int k = indexesFrom; k < indexesTo; ++k) {
            long packed = this.tree[k];
            int left = IRangeFinder.unpackHigh(packed);
            int index = IRangeFinder.unpackLow(packed);
            assert (left == this.left(index));
            if (left > center) {
                if (minGreaterLeftIndex != -1 && left >= minGreaterLeft) continue;
                minGreaterLeft = left;
                minGreaterLeftIndex = index;
                continue;
            }
            if (this.right(index) < center) continue;
            this.tree[offset++] = packed;
        }
        int rightBoundariesOffset = offset;
        int numberOfIntervalsContainingCenter = offset - leftBoundariesOffset;
        this.ensureTreeCapacity((long)offset + (long)numberOfIntervalsContainingCenter);
        for (int k = leftBoundariesOffset; k < rightBoundariesOffset; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            int right = this.right(index);
            this.tree[offset++] = IRangeFinder.packLowAndHigh(index, right);
        }
        this.tree[resultICCOffset] = IRangeFinder.packICCCount(numberOfIntervalsContainingCenter, minGreaterLeftIndex);
        Arrays.parallelSort(this.tree, rightBoundariesOffset, offset);
        return offset;
    }

    private int extractIndexesOfStrictlyLeft(int resultOffset, int center, int indexesFrom, int indexesTo) {
        int offset = resultOffset;
        for (int k = indexesFrom; k < indexesTo; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            int right = this.right(index);
            if (right >= center) continue;
            if (offset >= this.tree.length) {
                this.ensureTreeCapacity((long)offset + 1L);
            }
            this.tree[offset++] = packed;
        }
        return offset;
    }

    private int extractIndexesOfStrictlyRight(int resultOffset, int center, int indexesFrom, int indexesTo) {
        int offset = resultOffset;
        for (int k = indexesFrom; k < indexesTo; ++k) {
            long packed = this.tree[k];
            int left = IRangeFinder.unpackHigh(packed);
            if (left <= center) continue;
            if (offset >= this.tree.length) {
                this.ensureTreeCapacity((long)offset + 1L);
            }
            this.tree[offset++] = packed;
        }
        return offset;
    }

    int findContainingPointAndMinGreater(int subtreeOffset, int point, IRangeConsumer rangeConsumer) {
        int minGreater = this.n;
        while (true) {
            long packedTreeLength;
            int treeLength;
            if ((long)(treeLength = (int)(packedTreeLength = this.tree[subtreeOffset])) == packedTreeLength) {
                assert (treeLength >= 1);
                int p = this.findShortListAndMinGreater(point, rangeConsumer, subtreeOffset + 1, subtreeOffset + treeLength);
                if (p >= minGreater) break;
                minGreater = p;
                break;
            }
            int center = this.unpackTreeCenterAtOffset(subtreeOffset + 1);
            int iccOffset = IRangeFinder.iccOffset(subtreeOffset);
            long iccHeader = this.tree[iccOffset];
            int iccCount = this.unpackICCCount(iccHeader);
            int iccLeftOffset = iccOffset + 1;
            int iccRightOffset = iccLeftOffset + iccCount;
            int leftTreeOffset = iccRightOffset + iccCount;
            if (point <= center) {
                int minGreaterCenter = this.unpackIndexOfIntervalWithMinimalLeftGreaterCenter(iccHeader);
                int p = this.n;
                if (iccCount > 0) {
                    p = this.findICCLeftAndMinGreater(point, rangeConsumer, iccLeftOffset, iccRightOffset);
                }
                if (p == this.n && minGreaterCenter >= 0) {
                    p = this.firstPositionInSortedArrayWithSameLeft(minGreaterCenter);
                }
                if (p < minGreater) {
                    minGreater = p;
                }
                if (point == center) break;
                subtreeOffset = leftTreeOffset;
                continue;
            }
            if (iccCount > 0) {
                this.findICCRight(point, rangeConsumer, iccRightOffset, leftTreeOffset);
            }
            subtreeOffset = this.leftToRightTreeOffset(leftTreeOffset);
        }
        return minGreater;
    }

    void findContainingPoint(int subtreeOffset, int point, IRangeConsumer rangeConsumer) {
        int treeLength;
        while (true) {
            long packedTreeLength;
            if ((long)(treeLength = (int)(packedTreeLength = this.tree[subtreeOffset])) == packedTreeLength) {
                assert (treeLength >= 1);
                break;
            }
            int center = this.unpackTreeCenterAtOffset(subtreeOffset + 1);
            int iccOffset = IRangeFinder.iccOffset(subtreeOffset);
            long iccHeader = this.tree[iccOffset];
            int iccCount = this.unpackICCCount(iccHeader);
            int iccLeftOffset = iccOffset + 1;
            int iccRightOffset = iccLeftOffset + iccCount;
            int leftTreeOffset = iccRightOffset + iccCount;
            if (point <= center) {
                if (iccCount > 0) {
                    this.findICCLeft(point, rangeConsumer, iccLeftOffset, iccRightOffset);
                }
                if (point == center) {
                    return;
                }
                subtreeOffset = leftTreeOffset;
                continue;
            }
            if (iccCount > 0) {
                this.findICCRight(point, rangeConsumer, iccRightOffset, leftTreeOffset);
            }
            subtreeOffset = this.leftToRightTreeOffset(leftTreeOffset);
        }
        this.findShortList(point, rangeConsumer, subtreeOffset + 1, subtreeOffset + treeLength);
    }

    int findContainingPointAndMinGreater(int subtreeOffset, int point, IntConsumer indexConsumer) {
        int minGreater = this.n;
        while (true) {
            long packedTreeLength;
            int treeLength;
            if ((long)(treeLength = (int)(packedTreeLength = this.tree[subtreeOffset])) == packedTreeLength) {
                assert (treeLength >= 1);
                int p = this.findShortListAndMinGreater(point, indexConsumer, subtreeOffset + 1, subtreeOffset + treeLength);
                if (p >= minGreater) break;
                minGreater = p;
                break;
            }
            int center = this.unpackTreeCenterAtOffset(subtreeOffset + 1);
            int iccOffset = IRangeFinder.iccOffset(subtreeOffset);
            long iccHeader = this.tree[iccOffset];
            int iccCount = this.unpackICCCount(iccHeader);
            int iccLeftOffset = iccOffset + 1;
            int iccRightOffset = iccLeftOffset + iccCount;
            int leftTreeOffset = iccRightOffset + iccCount;
            if (point <= center) {
                int minGreaterCenter = this.unpackIndexOfIntervalWithMinimalLeftGreaterCenter(iccHeader);
                int p = this.n;
                if (iccCount > 0) {
                    p = this.findICCLeftAndMinGreater(point, indexConsumer, iccLeftOffset, iccRightOffset);
                }
                if (p == this.n && minGreaterCenter >= 0) {
                    p = this.firstPositionInSortedArrayWithSameLeft(minGreaterCenter);
                }
                if (p < minGreater) {
                    minGreater = p;
                }
                if (point == center) break;
                subtreeOffset = leftTreeOffset;
                continue;
            }
            if (iccCount > 0) {
                this.findICCRight(point, indexConsumer, iccRightOffset, leftTreeOffset);
            }
            subtreeOffset = this.leftToRightTreeOffset(leftTreeOffset);
        }
        return minGreater;
    }

    void findContainingPoint(int subtreeOffset, int point, IntConsumer indexConsumer) {
        int treeLength;
        while (true) {
            long packedTreeLength;
            if ((long)(treeLength = (int)(packedTreeLength = this.tree[subtreeOffset])) == packedTreeLength) {
                assert (treeLength >= 1);
                break;
            }
            int center = this.unpackTreeCenterAtOffset(subtreeOffset + 1);
            int iccOffset = IRangeFinder.iccOffset(subtreeOffset);
            long iccHeader = this.tree[iccOffset];
            int iccCount = this.unpackICCCount(iccHeader);
            int iccLeftOffset = iccOffset + 1;
            int iccRightOffset = iccLeftOffset + iccCount;
            int leftTreeOffset = iccRightOffset + iccCount;
            if (point <= center) {
                if (iccCount > 0) {
                    this.findICCLeft(point, indexConsumer, iccLeftOffset, iccRightOffset);
                }
                if (point == center) {
                    return;
                }
                subtreeOffset = leftTreeOffset;
                continue;
            }
            if (iccCount > 0) {
                this.findICCRight(point, indexConsumer, iccRightOffset, leftTreeOffset);
            }
            subtreeOffset = this.leftToRightTreeOffset(leftTreeOffset);
        }
        this.findShortList(point, indexConsumer, subtreeOffset + 1, subtreeOffset + treeLength);
    }

    private int findShortListAndMinGreater(int point, IRangeConsumer rangeConsumer, int from, int to) {
        for (int k = from; k < to; ++k) {
            long packed = this.tree[k];
            int left = IRangeFinder.unpackHigh(packed);
            int index = IRangeFinder.unpackLow(packed);
            if (left > point) {
                return this.firstPositionInSortedArrayWithSameLeft(index);
            }
            int right = this.right(index);
            if (point > right || !this.indexActual.test(index)) continue;
            rangeConsumer.accept(index, left, right);
        }
        return this.n;
    }

    private int findShortListAndMinGreater(int point, IntConsumer indexConsumer, int from, int to) {
        for (int k = from; k < to; ++k) {
            long packed = this.tree[k];
            int left = IRangeFinder.unpackHigh(packed);
            int index = IRangeFinder.unpackLow(packed);
            if (left > point) {
                return this.firstPositionInSortedArrayWithSameLeft(index);
            }
            int right = this.right(index);
            if (point > right || !this.indexActual.test(index)) continue;
            indexConsumer.accept(index);
        }
        return this.n;
    }

    private void findShortList(int point, IRangeConsumer rangeConsumer, int from, int to) {
        for (int k = from; k < to; ++k) {
            long packed = this.tree[k];
            int left = IRangeFinder.unpackHigh(packed);
            if (left > point) {
                return;
            }
            int index = IRangeFinder.unpackLow(packed);
            int right = this.right(index);
            if (point > right || !this.indexActual.test(index)) continue;
            rangeConsumer.accept(index, left, right);
        }
    }

    private void findShortList(int point, IntConsumer indexConsumer, int from, int to) {
        for (int k = from; k < to; ++k) {
            long packed = this.tree[k];
            int left = IRangeFinder.unpackHigh(packed);
            if (left > point) {
                return;
            }
            int index = IRangeFinder.unpackLow(packed);
            int right = this.right(index);
            if (point > right || !this.indexActual.test(index)) continue;
            indexConsumer.accept(index);
        }
    }

    private int findICCLeftAndMinGreater(int point, IRangeConsumer rangeConsumer, int from, int to) {
        int firstGreaterHigh = IRangeFinder.findFirstGreaterHigh(this.tree, from, to, point);
        for (int k = from; k < firstGreaterHigh; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            rangeConsumer.accept(index, IRangeFinder.unpackHigh(packed), this.right(index));
        }
        return firstGreaterHigh == to ? this.n : this.firstPositionInSortedArrayWithSameLeft(IRangeFinder.unpackLow(this.tree[firstGreaterHigh]));
    }

    private int findICCLeftAndMinGreater(int point, IntConsumer indexConsumer, int from, int to) {
        int firstGreaterHigh = IRangeFinder.findFirstGreaterHigh(this.tree, from, to, point);
        for (int k = from; k < firstGreaterHigh; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            indexConsumer.accept(index);
        }
        return firstGreaterHigh == to ? this.n : this.firstPositionInSortedArrayWithSameLeft(IRangeFinder.unpackLow(this.tree[firstGreaterHigh]));
    }

    private void findICCLeft(int point, IRangeConsumer rangeConsumer, int from, int to) {
        int firstGreaterHigh = IRangeFinder.findFirstGreaterHigh(this.tree, from, to, point);
        for (int k = from; k < firstGreaterHigh; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            rangeConsumer.accept(index, IRangeFinder.unpackHigh(packed), this.right(index));
        }
    }

    private void findICCLeft(int point, IntConsumer indexConsumer, int from, int to) {
        int firstGreaterHigh = IRangeFinder.findFirstGreaterHigh(this.tree, from, to, point);
        for (int k = from; k < firstGreaterHigh; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            indexConsumer.accept(index);
        }
    }

    private void findICCRight(int point, IRangeConsumer rangeConsumer, int from, int to) {
        for (int k = from = IRangeFinder.findFirstGreaterOrEqualHigh(this.tree, from, to, point); k < to; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            rangeConsumer.accept(index, this.left(index), IRangeFinder.unpackHigh(packed));
        }
    }

    private void findICCRight(int point, IntConsumer indexConsumer, int from, int to) {
        for (int k = from = IRangeFinder.findFirstGreaterOrEqualHigh(this.tree, from, to, point); k < to; ++k) {
            long packed = this.tree[k];
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            indexConsumer.accept(index);
        }
    }

    void findIntervalsLeftInRangeFromKnown(int max, IRangeConsumer rangeConsumer, int from) {
        long packed;
        int left;
        for (int k = from; k < this.n && (left = IRangeFinder.unpackHigh(packed = this.tree[k])) <= max; ++k) {
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            rangeConsumer.accept(index, left, this.right(index));
        }
    }

    void findIntervalsLeftInRange(int minExcluding, int max, IRangeConsumer rangeConsumer) {
        int from;
        long packed;
        int left;
        for (int k = from = IRangeFinder.findFirstGreaterHigh(this.tree, 0, this.n, minExcluding); k < this.n && (left = IRangeFinder.unpackHigh(packed = this.tree[k])) <= max; ++k) {
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            rangeConsumer.accept(index, left, this.right(index));
        }
    }

    void findIntervalsLeftInRangeFromKnown(int max, IntConsumer indexConsumer, int from) {
        long packed;
        int left;
        for (int k = from; k < this.n && (left = IRangeFinder.unpackHigh(packed = this.tree[k])) <= max; ++k) {
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            indexConsumer.accept(index);
        }
    }

    void findIntervalsLeftInRange(int minExcluding, int max, IntConsumer indexConsumer) {
        int from;
        long packed;
        int left;
        for (int k = from = IRangeFinder.findFirstGreaterHigh(this.tree, 0, this.n, minExcluding); k < this.n && (left = IRangeFinder.unpackHigh(packed = this.tree[k])) <= max; ++k) {
            int index = IRangeFinder.unpackLow(packed);
            if (!this.indexActual.test(index)) continue;
            indexConsumer.accept(index);
        }
    }

    private long workLength() {
        return 2L * (long)this.n;
    }

    private void ensureTreeCapacity(long newTreeLength) {
        if (newTreeLength > (long)this.tree.length) {
            if (newTreeLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large array is necessary for interval tree: >=2^31 elements");
            }
            int newLength = Math.max(16, Math.max((int)newTreeLength, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.tree.length))));
            this.tree = Arrays.copyOf(this.tree, newLength);
        }
    }

    private void ensureWorkCapacity(long newWorkLength) {
        if (newWorkLength > (long)this.work.length) {
            if (newWorkLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large array is necessary for interval tree: >=2^31 elements");
            }
            int newLength = Math.max(16, Math.max((int)newWorkLength, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.work.length))));
            this.work = Arrays.copyOf(this.work, newLength);
        }
    }

    private int treeLength(int treeOffset) {
        return this.unpackTreeLengthAtOffset(treeOffset);
    }

    private static int iccOffset(int treeOffset) {
        return treeOffset + 2;
    }

    private int iccCount(int treeOffset) {
        return this.unpackICCCountAtOffset(IRangeFinder.iccOffset(treeOffset));
    }

    private int iccLength(int treeOffset) {
        return 2 * this.iccCount(treeOffset) + 1;
    }

    private static int leftTreeOffset(int treeOffset, int iccLength) {
        return IRangeFinder.iccOffset(treeOffset) + iccLength;
    }

    private int leftToRightTreeOffset(int leftTreeOffset) {
        return leftTreeOffset + this.unpackTreeLengthAtOffset(leftTreeOffset);
    }

    private static long addTreeLengthSignature(int length) {
        return IRangeFinder.packLowAndHigh(length, 1953654117);
    }

    private int unpackTreeLengthAtOffset(int offset) {
        return this.unpackTreeLength(this.tree[offset]);
    }

    private boolean isShortList(long packedTreeLength) {
        return packedTreeLength == (long)((int)packedTreeLength);
    }

    private int unpackTreeLength(long packedTreeLength) {
        int result = IRangeFinder.unpackLow(packedTreeLength);
        if (this.isShortList(packedTreeLength)) {
            if (result <= 0) {
                throw new AssertionError((Object)("Damaged interval tree: " + packedTreeLength + " is not a correct subtree length"));
            }
            return result;
        }
        if (IRangeFinder.unpackHigh(packedTreeLength) != 1953654117 || result <= 0) {
            throw new AssertionError((Object)("Damaged interval tree: 0x" + Long.toHexString(packedTreeLength) + " is not a correct subtree length"));
        }
        return result;
    }

    private int unpackTreeCenterAtOffset(int offset) {
        long packed = this.tree[offset];
        int result = (int)packed;
        if (packed != (long)result) {
            throw new AssertionError((Object)("Damaged interval tree: tree[" + offset + "] = 0x" + Long.toHexString(packed) + " is not a correct center (it is not 32-bit integer)"));
        }
        return result;
    }

    private static long packICCCount(int numberOfIntervals, int indexOfIntervalWithMinimalLeftGreaterCenter) {
        return IRangeFinder.packLowAndHigh(numberOfIntervals, indexOfIntervalWithMinimalLeftGreaterCenter);
    }

    private int unpackICCCountAtOffset(int offset) {
        return this.unpackICCCount(this.tree[offset]);
    }

    private int unpackICCCount(long iccHeader) {
        return IRangeFinder.unpackLow(iccHeader);
    }

    private int unpackIndexOfIntervalWithMinimalLeftGreaterCenter(long iccHeader) {
        int result = IRangeFinder.unpackHigh(iccHeader);
        if (result < -1) {
            throw new AssertionError((Object)"Damaged interval tree: ICC header contains incorrect index");
        }
        return result;
    }

    private static int findFirstGreaterHigh(long[] sortedArray, int from, int to, int high) {
        long key = IRangeFinder.packHigh(high);
        int index = -1;
        int left = from;
        int right = to - 1;
        while (left <= right) {
            int mid = left + right >>> 1;
            long midVal = sortedArray[mid];
            if (midVal < key) {
                left = mid + 1;
                continue;
            }
            if (midVal > key) {
                right = mid - 1;
                continue;
            }
            index = mid;
            break;
        }
        if (index == -1) {
            index = left;
        }
        while (index < to && IRangeFinder.unpackHigh(sortedArray[index]) == high) {
            ++index;
        }
        return index;
    }

    private static int findFirstGreaterOrEqualHigh(long[] sortedArray, int from, int to, int high) {
        long key = IRangeFinder.packHigh(high);
        int index = -1;
        int left = from;
        int right = to - 1;
        while (left <= right) {
            int mid = left + right >>> 1;
            long midVal = sortedArray[mid];
            if (midVal < key) {
                left = mid + 1;
                continue;
            }
            if (midVal > key) {
                right = mid - 1;
                continue;
            }
            index = mid;
            break;
        }
        if (index < 0) {
            index = left;
        }
        while (index > 0 && IRangeFinder.unpackHigh(sortedArray[index - 1]) == high) {
            --index;
        }
        return index;
    }

    private static long packLowAndHigh(int low, int high) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    private static long packHigh(int high) {
        return (long)high << 32;
    }

    public static int unpackHigh(long packed) {
        return (int)(packed >>> 32);
    }

    public static int unpackLow(long packed) {
        return (int)packed;
    }

    public static class IntArrayAppender
    implements IntConsumer {
        private final int[] array;
        private int offset;

        public IntArrayAppender(int[] array) {
            this.array = array;
            this.offset = 0;
        }

        public IntArrayAppender(int[] array, int offset) {
            this.array = array;
            this.offset = offset;
        }

        public int[] array() {
            return this.array;
        }

        public int offset() {
            return this.offset;
        }

        public IntArrayAppender reset(int offset) {
            this.offset = offset;
            return this;
        }

        public IntArrayAppender reset() {
            this.offset = 0;
            return this;
        }

        @Override
        public void accept(int value) {
            this.array[this.offset++] = value;
        }
    }
}

