/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contours;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.algart.arrays.TooLargeArrayException;

class JoinedLabelsLists {
    final int[] indexes;
    final int[] offsets;
    final int maxListLength;
    final int numberOfLists;
    int[] clusterMinX = null;
    int[] clusterMaxX = null;
    int[] clusterMinY = null;
    int[] clusterMaxY = null;

    JoinedLabelsLists(int[] reindexedLabels) {
        int i;
        int label2;
        int maxReindexedLabel = 0;
        for (int label2 : reindexedLabels) {
            if (label2 <= maxReindexedLabel) continue;
            maxReindexedLabel = label2;
        }
        if (maxReindexedLabel > 0x7FFFFFFE) {
            throw new TooLargeArrayException("Cannot process reindexed object label > Integer.MAX_VALUE-1");
        }
        this.numberOfLists = maxReindexedLabel + 1;
        this.offsets = new int[this.numberOfLists + 1];
        this.indexes = new int[reindexedLabels.length];
        int[] nArray = reindexedLabels;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int n2 = label2 = nArray[j];
            this.offsets[n2] = this.offsets[n2] + 1;
        }
        int offset = 0;
        int maxLength = 0;
        for (i = 0; i < this.numberOfLists; ++i) {
            int length = this.offsets[i];
            this.offsets[i] = offset;
            offset += length;
            if (length <= maxLength) continue;
            maxLength = length;
        }
        assert (offset == reindexedLabels.length);
        this.maxListLength = maxLength;
        i = 0;
        while (i < reindexedLabels.length) {
            int n3 = label2 = reindexedLabels[i];
            int n4 = this.offsets[n3];
            this.offsets[n3] = n4 + 1;
            this.indexes[n4] = i++;
        }
        System.arraycopy(this.offsets, 0, this.offsets, 1, this.numberOfLists);
        this.offsets[0] = 0;
    }

    int length(int reindexedLabel) {
        return this.offsets[reindexedLabel + 1] - this.offsets[reindexedLabel];
    }

    boolean hasNeighboursToJoin(int reindexedLabel) {
        return this.length(reindexedLabel) > 1;
    }

    void initializeNonEmptyClusterRectangles(int[] allMinX, int[] allMaxX, int[] allMinY, int[] allMaxY) {
        this.clusterMinX = new int[this.numberOfLists];
        this.clusterMaxX = new int[this.numberOfLists];
        this.clusterMinY = new int[this.numberOfLists];
        this.clusterMaxY = new int[this.numberOfLists];
        IntStream.range(0, this.numberOfLists + 255 >>> 8).parallel().forEach(block -> {
            int label;
            int to = (int)Math.min((long)label + 256L, (long)this.numberOfLists);
            for (label = block << 8; label < to; ++label) {
                if (!this.hasNeighboursToJoin(label)) continue;
                int clusterMinX = Integer.MAX_VALUE;
                int clusterMaxX = Integer.MIN_VALUE;
                int clusterMinY = Integer.MAX_VALUE;
                int clusterMaxY = Integer.MIN_VALUE;
                int kTo = this.offsets[label + 1];
                for (int k = this.offsets[label]; k < kTo; ++k) {
                    int index = this.indexes[k];
                    int minX = allMinX[index];
                    int maxX = allMaxX[index];
                    int minY = allMinY[index];
                    int maxY = allMaxY[index];
                    if (minX < clusterMinX) {
                        clusterMinX = minX;
                    }
                    if (maxX > clusterMaxX) {
                        clusterMaxX = maxX;
                    }
                    if (minY < clusterMinY) {
                        clusterMinY = minY;
                    }
                    if (maxY <= clusterMaxY) continue;
                    clusterMaxY = maxY;
                }
                this.clusterMinX[label] = clusterMinX;
                this.clusterMaxX[label] = clusterMaxX;
                this.clusterMinY[label] = clusterMinY;
                this.clusterMaxY[label] = clusterMaxY;
            }
        });
    }

    long estimateMaxClusterMatrixSize() {
        return LongStream.range(0L, this.numberOfLists + 255 >>> 8).parallel().map(block -> {
            int i;
            long max = -1L;
            int to = (int)Math.min((long)i + 256L, (long)this.numberOfLists);
            for (i = (int)block << 8; i < to; ++i) {
                int diffX = this.clusterMaxX[i] - this.clusterMinX[i];
                int diffY = this.clusterMaxY[i] - this.clusterMinY[i];
                assert (diffX >= 0 && diffY >= 0) : "Overflow in sizes of containing rectangle for cluster #" + i + "; it must be impossible due to check of Contour2DArray.MAX_ABSOLUTE_COORDINATE";
                long matrixSize = (1L + (long)diffX) * (1L + (long)diffY);
                if (matrixSize <= max) continue;
                max = matrixSize;
            }
            return max;
        }).max().orElse(0L);
    }

    long maxClusterGridMatrixSize(int gridStepLog, boolean require31BitResult) {
        if (gridStepLog < 0) {
            throw new IllegalArgumentException("Negative gridStepLog");
        }
        long result = LongStream.range(0L, this.numberOfLists + 255 >>> 8).parallel().map(block -> {
            int i;
            long max = -1L;
            int log = gridStepLog;
            int to = (int)Math.min((long)i + 256L, (long)this.numberOfLists);
            for (i = (int)block << 8; i < to; ++i) {
                int diffX = (this.clusterMaxX[i] >> log) - (this.clusterMinX[i] >> log);
                int diffY = (this.clusterMaxY[i] >> log) - (this.clusterMinY[i] >> log);
                assert (diffX >= 0 && diffY >= 0) : "Overflow in sizes of containing rectangle for cluster #" + i + "; it must be impossible due to check of Contour2DArray.MAX_ABSOLUTE_COORDINATE";
                long matrixSize = (1L + (long)diffX) * (1L + (long)diffY);
                if (matrixSize > Integer.MAX_VALUE && require31BitResult) {
                    throw new TooLargeArrayException("Too large maximal cluster (set of contours that should be joined): its containing rectangle " + (this.clusterMinX[i] << log) + ".." + (this.clusterMaxX[i] << log) + " x " + (this.clusterMinY[i] << log) + ".." + (this.clusterMaxY[i] << log) + " requires grid " + (1L + (long)diffX) + " x " + (1L + (long)diffY) + " >= 2^31 elements; probably you must increase gridStepLog = " + log + " and, so, reduce scale of the grid 2^gridStepLog = " + (1 << log));
                }
                if (matrixSize <= max) continue;
                max = matrixSize;
            }
            return max;
        }).max().orElse(0L);
        if (require31BitResult) assert (result == (long)((int)result));
        return result;
    }

    public static void main(String[] args) {
        int[] labels = new int[]{0, 1, 2, 1, 1, 0};
        JoinedLabelsLists result = new JoinedLabelsLists(labels);
        System.out.println(Arrays.toString(result.indexes));
        System.out.println(Arrays.toString(result.offsets));
        System.out.println(result.maxListLength);
    }
}

