/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contours;

import java.util.function.DoublePredicate;

public final class InsideContourStatus
extends Enum<InsideContourStatus> {
    public static final /* enum */ InsideContourStatus INSIDE = new InsideContourStatus(information -> information > 0.0);
    public static final /* enum */ InsideContourStatus BOUNDARY = new InsideContourStatus(information -> information < 0.0);
    public static final /* enum */ InsideContourStatus OUTSIDE = new InsideContourStatus(Double::isNaN);
    private static final double MAX_COORDINATE = 4.294967296E9;
    private static final double MIN_COORDINATE = -4.294967296E9;
    private static final double COORDINATE_SHIFT_1 = 4.294967296E9;
    private static final double COORDINATE_THRESHOLD_1 = -8.589934592E9;
    private static final double COORDINATE_SHIFT_2 = 1.2884901888E10;
    private static final double COORDINATE_THRESHOLD_2 = -1.7179869184E10;
    private static final double COORDINATE_SHIFT_3 = 2.147483648E10;
    private static final double COORDINATE_THRESHOLD_3 = -2.5769803776E10;
    private static final double FURTHER_PROCESSING_NECESSARY_CODE = -3.4359738368E10;
    final DoublePredicate statusChecker;
    private static final /* synthetic */ InsideContourStatus[] $VALUES;

    public static InsideContourStatus[] values() {
        return (InsideContourStatus[])$VALUES.clone();
    }

    public static InsideContourStatus valueOf(String name) {
        return Enum.valueOf(InsideContourStatus.class, name);
    }

    private InsideContourStatus(DoublePredicate statusChecker) {
        this.statusChecker = statusChecker;
    }

    public boolean isStrictlyInside() {
        return this == INSIDE;
    }

    public boolean isBoundary() {
        return this == BOUNDARY;
    }

    public boolean isStrictlyOutside() {
        return this == OUTSIDE;
    }

    public boolean matchesStatus(double information) {
        return this.statusChecker.test(information);
    }

    public static boolean isStrictlyInside(double information) {
        return INSIDE.matchesStatus(information);
    }

    public static boolean isBoundary(double information) {
        return BOUNDARY.matchesStatus(information);
    }

    public static boolean isStrictlyOutside(double information) {
        return OUTSIDE.matchesStatus(information);
    }

    public static double getInsideSectionWidth(double insideStatus) {
        if (!INSIDE.matchesStatus(insideStatus)) {
            throw new IllegalArgumentException("Information does not correspond to inside status: " + insideStatus);
        }
        return insideStatus;
    }

    public static boolean isHorizontalBoundary(double boundaryStatus) {
        return boundaryStatus == Double.NEGATIVE_INFINITY;
    }

    public static boolean isLeftBoundary(double boundaryStatus) {
        return InsideContourStatus.isBoundary(boundaryStatus) && boundaryStatus > -8.589934592E9;
    }

    public static boolean isRightBoundary(double boundaryStatus) {
        return boundaryStatus <= -8.589934592E9 && boundaryStatus > -1.7179869184E10;
    }

    public static boolean isNormalLeftRightBoundary(double boundaryStatus) {
        return InsideContourStatus.isBoundary(boundaryStatus) && boundaryStatus > -1.7179869184E10;
    }

    public static boolean isDegeneratedLeftRightBoundary(double boundaryStatus) {
        return boundaryStatus <= -1.7179869184E10 && boundaryStatus > -2.5769803776E10;
    }

    public static double getBoundarySectionSecondEnd(double boundaryStatus) {
        InsideContourStatus.checkBoundary(boundaryStatus);
        if (boundaryStatus > -8.589934592E9) {
            return boundaryStatus + 4.294967296E9;
        }
        if (boundaryStatus > -1.7179869184E10) {
            return boundaryStatus + 1.2884901888E10;
        }
        if (boundaryStatus > -2.5769803776E10) {
            return boundaryStatus + 2.147483648E10;
        }
        if (!InsideContourStatus.isHorizontalBoundary(boundaryStatus)) {
            throw new IllegalArgumentException("Information corresponds to a horizontal section of the boundary; coordinate of the second section end is unavailable in this case");
        }
        throw new IllegalArgumentException("Unallowable boundary information " + boundaryStatus + " - it is not a correct point status");
    }

    public static InsideContourStatus valueOfInformation(double information) {
        for (InsideContourStatus status : InsideContourStatus.values()) {
            if (!status.matchesStatus(information)) continue;
            return status;
        }
        throw new IllegalArgumentException("Illegal packed information " + information + ": it does not match to any status");
    }

    static double makeStrictlyInsideStatus(double minX, double maxX) {
        double result = maxX - minX;
        assert (result > 0.0);
        return result;
    }

    static double makeHorizontalBoundaryStatus() {
        return Double.NEGATIVE_INFINITY;
    }

    static double makeLeftBoundaryStatus(double rightX) {
        assert (InsideContourStatus.permittedCoordinate(rightX));
        return rightX - 4.294967296E9;
    }

    static double makeRightBoundaryStatus(double leftX) {
        assert (InsideContourStatus.permittedCoordinate(leftX));
        return leftX - 1.2884901888E10;
    }

    static double makeDegeneratedLeftRightBoundaryStatus(double x) {
        assert (InsideContourStatus.permittedCoordinate(x));
        return x - 2.147483648E10;
    }

    static double makeStrictlyOutsideStatus() {
        return Double.NaN;
    }

    static boolean isFurtherProcessingNecessaryStatus(double information) {
        return information == -3.4359738368E10;
    }

    static double makeFurtherProcessingNecessaryStatus() {
        return -3.4359738368E10;
    }

    static boolean permittedCoordinate(double x) {
        return x > -4.294967296E9 && x < 4.294967296E9;
    }

    private static void checkBoundary(double boundaryStatus) {
        if (!BOUNDARY.matchesStatus(boundaryStatus)) {
            throw new IllegalArgumentException("Information does not correspond to boundary: " + boundaryStatus);
        }
    }

    private static /* synthetic */ InsideContourStatus[] $values() {
        return new InsideContourStatus[]{INSIDE, BOUNDARY, OUTSIDE};
    }

    static {
        $VALUES = InsideContourStatus.$values();
    }
}

