/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.EOFException;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.AbstractDataFileModel;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataFile;
import net.algart.arrays.DataFileModel;
import net.algart.arrays.DefaultDataFileModel;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.LargeMemoryModel;
import net.algart.arrays.MappedDataStorages;

public class StandardIODataFileModel
extends AbstractDataFileModel
implements DataFileModel<File> {
    private static final int STANDARD_IO_NUMBER_OF_BANKS = MappedDataStorages.MappingSettings.nearestCorrectNumberOfBanks(InternalUtils.getIntProperty("net.algart.arrays.StandardIODataFileModel.numberOfBanks", 32));
    private static final int STANDARD_IO_BANK_SIZE = MappedDataStorages.MappingSettings.nearestCorrectBankSize(InternalUtils.getIntProperty("net.algart.arrays.StandardIODataFileModel.bankSize", 65536));
    private static final boolean DEFAULT_DIRECT_BUFFERS = InternalUtils.getBooleanProperty("net.algart.arrays.StandardIODataFileModel.directBuffers", true);
    private static final long STANDARD_IO_PREFIX_SIZE = Math.max(0L, (long)InternalUtils.getIntProperty("net.algart.arrays.StandardIODataFileModel.prefixSize", 0));
    private static final int ALLOCATE_NUMBER_OF_ATTEMPTS = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.StandardIODataFileModel.allocateNumberOfAttempts", 2));
    private static final int ALLOCATE_NUMBER_OF_ATTEMPTS_WITH_GC = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.StandardIODataFileModel.allocateNumberOfAttemptsWithGc", 6));
    private static final boolean DEFAULT_CACHE_READING = true;
    private final boolean cacheReading;
    private final boolean directBuffers;

    public static boolean defaultDirectBuffers() {
        return DEFAULT_DIRECT_BUFFERS;
    }

    public StandardIODataFileModel() {
        this(null, STANDARD_IO_PREFIX_SIZE, true, StandardIODataFileModel.defaultDirectBuffers());
    }

    public StandardIODataFileModel(boolean cacheReading, boolean directBuffers) {
        this(null, STANDARD_IO_PREFIX_SIZE, cacheReading, directBuffers);
    }

    public StandardIODataFileModel(File tempPath) {
        this(tempPath, STANDARD_IO_PREFIX_SIZE, true, StandardIODataFileModel.defaultDirectBuffers());
    }

    public StandardIODataFileModel(File tempPath, boolean cacheReading) {
        this(tempPath, STANDARD_IO_PREFIX_SIZE, cacheReading, DEFAULT_DIRECT_BUFFERS);
    }

    public StandardIODataFileModel(File tempPath, boolean cacheReading, boolean directBuffers) {
        this(tempPath, STANDARD_IO_PREFIX_SIZE, cacheReading, directBuffers);
    }

    public StandardIODataFileModel(File tempPath, long prefixSize, boolean cacheReading, boolean directBuffers) {
        super(tempPath, prefixSize);
        this.cacheReading = cacheReading;
        this.directBuffers = directBuffers;
    }

    public final boolean isDirectBuffers() {
        return this.directBuffers;
    }

    @Override
    public DataFile getDataFile(File path, ByteOrder byteOrder) {
        Objects.requireNonNull(path, "Null path argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder argument");
        return new StandardIOFile(path, byteOrder, this.cacheReading, this.directBuffers);
    }

    @Override
    public File getPath(DataFile dataFile) {
        return ((DefaultDataFileModel.MappableFile)dataFile).file.getAbsoluteFile();
    }

    @Override
    public boolean isAutoDeletionRequested() {
        return true;
    }

    @Override
    public int recommendedNumberOfBanks() {
        return STANDARD_IO_NUMBER_OF_BANKS;
    }

    @Override
    public int recommendedBankSize(boolean unresizable) {
        return STANDARD_IO_BANK_SIZE;
    }

    @Override
    public String temporaryFilePrefix() {
        return "stdmm";
    }

    public String toString() {
        return "standard I/O data file model: " + this.recommendedNumberOfBanks() + " banks per " + this.recommendedBankSize(false) + " bytes" + (this.directBuffers ? ", direct buffers" : ", Java heap buffers") + (this.cacheReading ? ", cached reading" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readAllBuffer(FileChannel fileChannel, long position, ByteBuffer dest) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        long savePosition = fileChannel.position();
        try {
            fileChannel.position(position);
            ByteBuffer dup = dest.duplicate();
            dup.rewind();
            int ofs = 0;
            int k = 0;
            int n = dup.limit();
            while (ofs < n) {
                if (k > 2 * n) {
                    throw new EOFException("Cannot read " + n + " bytes from the file at the position " + position);
                }
                int res = fileChannel.read(dup);
                if (res < 0) {
                    throw new EOFException("Cannot read " + n + " bytes from the file at the position " + position + ": file is exhausted");
                }
                ofs += res;
                ++k;
            }
        }
        finally {
            fileChannel.position(savePosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllBuffer(FileChannel fileChannel, long position, ByteBuffer src) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        long savePosition = fileChannel.position();
        try {
            fileChannel.position(position);
            ByteBuffer dup = src.duplicate();
            dup.rewind();
            int ofs = 0;
            int k = 0;
            int n = src.limit();
            while (ofs < n) {
                if (k > 2 * n) {
                    throw new EOFException("Cannot write " + n + " bytes to the file at the position " + position);
                }
                int res = fileChannel.write(dup);
                if (res < 0) {
                    throw new EOFException("Cannot write " + n + " bytes to the file at the position " + position + ": the disk if probably full");
                }
                ofs += res;
                ++k;
            }
        }
        finally {
            fileChannel.position(savePosition);
        }
    }

    private static ByteBuffer allocateWithSeveralAttempts(int capacity, boolean directBuffers) {
        long t1 = System.nanoTime();
        int numberOfAttempts = 0;
        int numberOfGc = 0;
        Error error = null;
        ByteBuffer result = null;
        int count = ALLOCATE_NUMBER_OF_ATTEMPTS + ALLOCATE_NUMBER_OF_ATTEMPTS_WITH_GC;
        while (true) {
            try {
                result = directBuffers ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
            }
            catch (Error e) {
                error = e;
                ++numberOfAttempts;
                if (count <= 0) break;
                boolean doGc = count <= ALLOCATE_NUMBER_OF_ATTEMPTS_WITH_GC;
                LargeMemoryModel.LOGGER.config("SSSS allocate" + (directBuffers ? "Direct" : "") + ": problem with allocating memory, new attempt #" + numberOfAttempts + (doGc ? " with gc" : ""));
                if (doGc) {
                    System.gc();
                    ++numberOfGc;
                }
                --count;
                continue;
            }
            break;
        }
        long t2 = System.nanoTime();
        if (result == null) {
            assert (error != null);
            LargeMemoryModel.LOGGER.warning(String.format(Locale.US, "SSSS allocate" + (directBuffers ? "Direct" : "") + ": cannot allocate data in %.2f sec, " + numberOfAttempts + " attempts" + (String)(numberOfGc > 0 ? ", " + numberOfGc + " with gc" : "") + " (%s)", (double)(t2 - t1) * 1.0E-9, error));
            throw error;
        }
        return result;
    }

    static class StandardIOFile
    extends DefaultDataFileModel.MappableFile {
        private final List<ByteBuffer> unusedBuffersPool;
        private final boolean cacheReading;
        private final boolean directBuffers;

        StandardIOFile(File file, ByteOrder byteOrder, boolean cacheReading, boolean directBuffers) {
            super(file, byteOrder, false);
            this.cacheReading = cacheReading;
            this.directBuffers = directBuffers;
            this.unusedBuffersPool = cacheReading ? null : new ArrayList();
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                if (!this.cacheReading) {
                    this.unusedBuffersPool.clear();
                }
            }
        }

        @Override
        public void force() {
        }

        @Override
        public DataFile.BufferHolder map(DataFile.Range range, boolean notLoadDataFromFile) {
            boolean foundInCache;
            assert (range.length() == (long)((int)range.length()));
            ByteBuffer bb = null;
            DefaultDataFileModel.RangeWeakReference br = null;
            if (this.cacheReading) {
                br = (DefaultDataFileModel.RangeWeakReference)this.mappingCache.get(range);
                bb = br == null ? null : (ByteBuffer)br.get();
            }
            boolean bl = foundInCache = bb != null;
            if (foundInCache) {
                LargeMemoryModel.LOGGER.finest("SSSS quick loading " + String.valueOf(br.key) + " of " + String.valueOf(this.file));
            } else {
                if (this.cacheReading) {
                    this.reap();
                    bb = StandardIODataFileModel.allocateWithSeveralAttempts((int)range.length(), this.directBuffers);
                } else {
                    int n;
                    while ((n = this.unusedBuffersPool.size()) > 0) {
                        ByteBuffer unusedBb = this.unusedBuffersPool.remove(n - 1);
                        if ((long)unusedBb.limit() != range.length()) continue;
                        bb = unusedBb;
                        bb.rewind();
                        break;
                    }
                    if (bb == null) {
                        bb = StandardIODataFileModel.allocateWithSeveralAttempts((int)range.length(), this.directBuffers);
                    }
                }
                bb.order(this.byteOrder());
                if (!notLoadDataFromFile) {
                    ByteBuffer bbLocal = bb;
                    try {
                        Arrays.SystemSettings.globalDiskSynchronizer().doSynchronously(this.file.getPath(), () -> {
                            StandardIODataFileModel.readAllBuffer(this.fc, range.position(), bbLocal);
                            return null;
                        });
                    }
                    catch (IOException ex) {
                        throw new IOError(ex);
                    }
                    catch (Exception ex) {
                        throw new AssertionError((Object)("Unexpected exception type: " + String.valueOf(ex)));
                    }
                    bb.rewind();
                }
                if (this.cacheReading) {
                    this.mappingCache.put(range, new DefaultDataFileModel.RangeWeakReference<ByteBuffer>(bb, this.fileIndex, this.file.getPath(), range, this.reaped));
                    LargeMemoryModel.LOGGER.finest("SSSS caching " + String.valueOf(range) + " of " + String.valueOf(this.file));
                }
            }
            return new DirectByteBufferHolder(bb, this.file.getPath(), this.fc, range, foundInCache, this.isReadOnly(), this.unusedBuffersPool);
        }

        static class DirectByteBufferHolder
        implements DataFile.BufferHolder {
            private ByteBuffer bb;
            private final String fileName;
            private FileChannel fc;
            private final DataFile.Range range;
            private final boolean fromCache;
            private final boolean readOnly;
            private final List<ByteBuffer> unusedBuffersPool;

            DirectByteBufferHolder(ByteBuffer bb, String fileName, FileChannel fc, DataFile.Range range, boolean fromCache, boolean readOnly, List<ByteBuffer> unusedBuffersPool) {
                this.bb = bb;
                this.fileName = fileName;
                this.fc = fc;
                this.range = range;
                this.fromCache = fromCache;
                this.readOnly = readOnly;
                this.unusedBuffersPool = unusedBuffersPool;
            }

            @Override
            public DataFile.Range range() {
                return this.range;
            }

            @Override
            public ByteBuffer data() {
                Objects.requireNonNull(this.bb, "Cannot call data() method: the buffer was already unmapped or disposed");
                return this.bb;
            }

            @Override
            public Object mappingObject() {
                return null;
            }

            @Override
            public void load() {
                Objects.requireNonNull(this.bb, "Cannot call load() method: the buffer was already unmapped or disposed");
            }

            @Override
            public void flush(boolean forcePhysicalWriting) {
                Objects.requireNonNull(this.bb, "Cannot call flush() method: the buffer was already unmapped or disposed");
                if (!this.readOnly) {
                    try {
                        Arrays.SystemSettings.globalDiskSynchronizer().doSynchronously(this.fileName, () -> {
                            StandardIODataFileModel.writeAllBuffer(this.fc, this.range.position(), this.bb);
                            return null;
                        });
                    }
                    catch (IOException ex) {
                        throw new IOError(ex);
                    }
                    catch (Exception ex) {
                        throw new AssertionError((Object)("Unexpected exception type: " + String.valueOf(ex)));
                    }
                }
            }

            @Override
            public void unmap(boolean forcePhysicalWriting) {
                Objects.requireNonNull(this.bb, "Cannot call unmap() method: the buffer was already unmapped or disposed");
                try {
                    this.flush(forcePhysicalWriting);
                }
                finally {
                    if (this.unusedBuffersPool != null) {
                        this.unusedBuffersPool.add(this.bb);
                    }
                    this.bb = null;
                    this.fc = null;
                }
            }

            @Override
            public boolean dispose() {
                Objects.requireNonNull(this.bb, "Cannot call dispose() method: the buffer was already unmapped or disposed");
                this.bb = null;
                this.fc = null;
                return false;
            }

            @Override
            public boolean isLoadedFromCache() {
                return this.fromCache;
            }

            public String toString() {
                return "block " + String.valueOf(this.range) + " of " + this.fileName + " [" + DefaultDataFileModel.MappableFile.byteBufferToString(this.bb) + "]";
            }
        }
    }
}

