/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractMemoryModel;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.MutableArray;
import net.algart.arrays.UnsupportedElementTypeException;
import net.algart.arrays.UpdatableArray;

public class SignalMemoryModel
extends AbstractMemoryModel {
    private static final SignalMemoryModel INSTANCE = new SignalMemoryModel();

    private SignalMemoryModel() {
    }

    public static SignalMemoryModel getInstance() {
        return INSTANCE;
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType) {
        return this.newEmptyArray(elementType, 157L);
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType, long initialCapacity) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initial capacity");
        }
        throw new UnsupportedElementTypeException("SignalMemoryModel cannot create any AlgART arrays");
    }

    @Override
    public MutableArray newArray(Class<?> elementType, long initialLength) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (initialLength < 0L) {
            throw new IllegalArgumentException("Negative initial length");
        }
        throw new UnsupportedElementTypeException("SignalMemoryModel cannot create any AlgART arrays");
    }

    @Override
    public UpdatableArray newUnresizableArray(Class<?> elementType, long length) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (length < 0L) {
            throw new IllegalArgumentException("Negative array length");
        }
        throw new UnsupportedElementTypeException("SignalMemoryModel cannot create any AlgART arrays");
    }

    @Override
    public boolean isElementTypeSupported(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        return false;
    }

    @Override
    public boolean areAllPrimitiveElementTypesSupported() {
        return false;
    }

    @Override
    public boolean areAllElementTypesSupported() {
        return false;
    }

    @Override
    public long maxSupportedLength(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        return -1L;
    }

    @Override
    public boolean isCreatedBy(Array array) {
        return false;
    }
}

