/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.LongBuffer;
import java.util.Objects;
import net.algart.arrays.JBuffers;
import net.algart.arrays.PackedBitArrays;

public class PackedBitBuffers {
    private PackedBitBuffers() {
    }

    public static long unpackedLength(long numberOfLongs) {
        return PackedBitArrays.unpackedLength(numberOfLongs);
    }

    public static long unpackedLength(LongBuffer buffer) {
        return (long)buffer.limit() << 6;
    }

    public static long packedLength(long numberOfBits) {
        return PackedBitArrays.packedLength(numberOfBits);
    }

    public static int packedLength32(long numberOfBits) {
        return PackedBitArrays.packedLength32(numberOfBits);
    }

    public static int packedLength32(int numberOfBits) {
        return PackedBitArrays.packedLength32(numberOfBits);
    }

    public static Object getLock(LongBuffer buffer) {
        return buffer.hasArray() ? (Object)buffer.array() : buffer;
    }

    public static boolean getBit(LongBuffer src, long index) {
        return (src.get((int)(index >>> 6)) & 1L << (int)(index & 0x3FL)) != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBit(LongBuffer dest, long index, boolean value) {
        Object object = PackedBitBuffers.getLock(dest);
        synchronized (object) {
            if (value) {
                dest.put((int)(index >>> 6), dest.get((int)(index >>> 6)) | 1L << (int)(index & 0x3FL));
            } else {
                dest.put((int)(index >>> 6), dest.get((int)(index >>> 6)) & (1L << (int)(index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
    }

    public static void setBitNoSync(LongBuffer dest, long index, boolean value) {
        if (value) {
            dest.put((int)(index >>> 6), dest.get((int)(index >>> 6)) | 1L << (int)(index & 0x3FL));
        } else {
            dest.put((int)(index >>> 6), dest.get((int)(index >>> 6)) & (1L << (int)(index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static long getBits64(LongBuffer src, long srcPos, int count) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IndexOutOfBoundsException("Negative srcPos argument: " + srcPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
        }
        long srcPosDiv64 = srcPos >>> 6;
        int length = src.limit();
        if (count == 0 || srcPosDiv64 >= (long)length) {
            return 0L;
        }
        int sPosRem = (int)(srcPos & 0x3FL);
        int sPos = (int)srcPosDiv64;
        int bitsLeft = 64 - sPosRem;
        if (count > bitsLeft) {
            long actualBitsLow = src.get(sPos) >>> sPosRem;
            if (++sPos >= length) {
                return actualBitsLow;
            }
            long actualBitsHigh = src.get(sPos) & -1L >>> 64 - (count - bitsLeft);
            return actualBitsLow | actualBitsHigh << bitsLeft;
        }
        return (src.get(sPos) & -1L >>> bitsLeft - count) >>> sPosRem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBits64(LongBuffer dest, long destPos, long bits, int count) {
        Objects.requireNonNull(dest, "Null dest");
        if (destPos < 0L) {
            throw new IndexOutOfBoundsException("Negative destPos argument: " + destPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64 method");
        }
        long destPosDiv64 = destPos >>> 6;
        int length = dest.limit();
        if (count == 0 || destPosDiv64 >= (long)length) {
            return;
        }
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if (cntStart > count) {
            cntStart = count;
            maskStart &= (1L << dPosRem + count) - 1L;
        }
        int dPos = (int)destPosDiv64;
        Object object = PackedBitBuffers.getLock(dest);
        synchronized (object) {
            if (cntStart > 0) {
                dest.put(dPos, bits << dPosRem & maskStart | dest.get(dPos) & (maskStart ^ 0xFFFFFFFFFFFFFFFFL));
                ++dPos;
                count -= cntStart;
                bits >>>= cntStart;
            }
            if (count > 0 && dPos < length) {
                long maskFinish = (2L << count - 1) - 1L;
                dest.put(dPos, bits & maskFinish | dest.get(dPos) & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
    }

    public static void setBits64NoSync(LongBuffer dest, long destPos, long bits, int count) {
        Objects.requireNonNull(dest, "Null dest");
        if (destPos < 0L) {
            throw new IndexOutOfBoundsException("Negative destPos argument: " + destPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64NoSync method");
        }
        long destPosDiv64 = destPos >>> 6;
        int length = dest.limit();
        if (count == 0 || destPosDiv64 >= (long)length) {
            return;
        }
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if (cntStart > count) {
            cntStart = count;
            maskStart &= (1L << dPosRem + count) - 1L;
        }
        int dPos = (int)destPosDiv64;
        if (cntStart > 0) {
            dest.put(dPos, bits << dPosRem & maskStart | dest.get(dPos) & (maskStart ^ 0xFFFFFFFFFFFFFFFFL));
            ++dPos;
            count -= cntStart;
            bits >>>= cntStart;
        }
        if (count > 0 && dPos < length) {
            long maskFinish = (2L << count - 1) - 1L;
            dest.put(dPos, bits & maskFinish | dest.get(dPos) & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static void copyBits(LongBuffer dest, long destPos, LongBuffer src, long srcPos, long count) {
        if (src == dest && srcPos == destPos && src != null) {
            return;
        }
        PackedBitBuffers.copyBits(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBits(LongBuffer dest, long destPos, LongBuffer src, long srcPos, long count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (reverseOrder) {
            if (sPosRem == dPosRem) {
                int sPosStart = sPos++;
                int dPosStart = dPos++;
                if (cntStart > 0) {
                    count -= (long)cntStart;
                }
                int cnt = (int)(count >>> 6);
                int cntFinish = (int)(count & 0x3FL);
                if (cntFinish > 0) {
                    long maskFinish = (1L << cntFinish) - 1L;
                    Object object = PackedBitBuffers.getLock(dest);
                    synchronized (object) {
                        dest.put(dPos + cnt, src.get(sPos + cnt) & maskFinish | dest.get(dPos + cnt) & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
                JBuffers.copyLongBuffer(dest, dPos, src, sPos, cnt, reverseOrder);
                if (cntStart > 0) {
                    Object maskFinish = PackedBitBuffers.getLock(dest);
                    synchronized (maskFinish) {
                        dest.put(dPosStart, src.get(sPosStart) & maskStart | dest.get(dPosStart) & (maskStart ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            } else {
                long sPrev;
                int shift = dPosRem - sPosRem;
                int sPosStart = sPos++;
                int dPosStart = dPos;
                int sPosRemStart = sPosRem;
                if (cntStart > 0) {
                    sPosRem = sPosRem + cntStart <= 64 ? (sPosRem += cntStart) : sPosRem + cntStart & 0x3F;
                    count -= (long)cntStart;
                    ++dPos;
                }
                int cnt2 = (int)(count >>> 6);
                long dPosMin = dPos;
                sPos += cnt2;
                dPos += cnt2;
                int cntFinish = (int)(count & 0x3FL);
                int sPosRem64 = 64 - sPosRem;
                if (cntFinish > 0) {
                    long v;
                    long maskFinish = (1L << cntFinish) - 1L;
                    if (sPosRem + cntFinish <= 64) {
                        sPrev = src.get(sPos);
                        v = sPrev >>> sPosRem;
                    } else {
                        sPrev = src.get(sPos);
                        v = sPrev >>> sPosRem | src.get(sPos + 1) << sPosRem64;
                    }
                    Object object = PackedBitBuffers.getLock(dest);
                    synchronized (object) {
                        dest.put(dPos, v & maskFinish | dest.get(dPos) & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                } else {
                    long l = sPrev = cnt2 == 0 ? 0L : src.get(sPos);
                }
                while ((long)dPos > dPosMin) {
                    long l = sPrev << sPosRem64;
                    sPrev = src.get(--sPos);
                    dest.put(--dPos, l | sPrev >>> sPosRem);
                }
                if (cntStart > 0) {
                    long v = sPosRemStart + cntStart <= 64 ? (shift > 0 ? src.get(sPosStart) << shift : src.get(sPosStart) >>> -shift) : src.get(sPosStart) >>> -shift | src.get(sPosStart + 1) << 64 + shift;
                    Object object = PackedBitBuffers.getLock(dest);
                    synchronized (object) {
                        dest.put(dPosStart, v & maskStart | dest.get(dPosStart) & (maskStart ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        } else if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                Object shift = PackedBitBuffers.getLock(dest);
                synchronized (shift) {
                    dest.put(dPos, src.get(sPos) & maskStart | dest.get(dPos) & (maskStart ^ 0xFFFFFFFFFFFFFFFFL));
                }
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int cnt = (int)(count >>> 6);
            JBuffers.copyLongBuffer(dest, dPos, src, sPos, cnt, reverseOrder);
            sPos += cnt;
            dPos += cnt;
            int cntFinish = (int)(count & 0x3FL);
            if (cntFinish > 0) {
                long maskFinish = (1L << cntFinish) - 1L;
                Object cnt2 = PackedBitBuffers.getLock(dest);
                synchronized (cnt2) {
                    dest.put(dPos, src.get(sPos) & maskFinish | dest.get(dPos) & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        } else {
            long sNext;
            int shift = dPosRem - sPosRem;
            if (cntStart > 0) {
                long v;
                if (sPosRem + cntStart <= 64) {
                    if (shift > 0) {
                        sNext = src.get(sPos);
                        v = sNext << shift;
                    } else {
                        sNext = src.get(sPos);
                        v = sNext >>> -shift;
                    }
                    sPosRem += cntStart;
                } else {
                    sNext = src.get(sPos + 1);
                    v = src.get(sPos) >>> -shift | sNext << 64 + shift;
                    ++sPos;
                    sPosRem = sPosRem + cntStart & 0x3F;
                }
                Object dPosMin = PackedBitBuffers.getLock(dest);
                synchronized (dPosMin) {
                    dest.put(dPos, v & maskStart | dest.get(dPos) & (maskStart ^ 0xFFFFFFFFFFFFFFFFL));
                }
                if ((count -= (long)cntStart) == 0L) {
                    return;
                }
                ++dPos;
            } else {
                if (count == 0L) {
                    return;
                }
                sNext = src.get(sPos);
            }
            int sPosRem64 = 64 - sPosRem;
            int dPosMax = dPos + (int)(count >>> 6);
            while (dPos < dPosMax) {
                long l = sNext >>> sPosRem;
                sNext = src.get(++sPos);
                dest.put(dPos, l | sNext << sPosRem64);
                ++dPos;
            }
            int cntFinish = (int)(count & 0x3FL);
            if (cntFinish > 0) {
                long maskFinish = (1L << cntFinish) - 1L;
                long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src.get(sPos + 1) << sPosRem64;
                Object object = PackedBitBuffers.getLock(dest);
                synchronized (object) {
                    dest.put(dPos, v & maskFinish | dest.get(dPos) & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swapBits(LongBuffer first, long firstPos, LongBuffer second, long secondPos, long count) {
        Objects.requireNonNull(first, "Null first");
        Objects.requireNonNull(second, "Null second");
        long firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            Object object = PackedBitBuffers.getLock(first);
            synchronized (object) {
                Object object2 = PackedBitBuffers.getLock(second);
                synchronized (object2) {
                    boolean v2;
                    boolean v1 = (first.get((int)(firstPos >>> 6)) & 1L << (int)(firstPos & 0x3FL)) != 0L;
                    boolean bl = v2 = (second.get((int)(secondPos >>> 6)) & 1L << (int)(secondPos & 0x3FL)) != 0L;
                    if (v1 != v2) {
                        if (v2) {
                            first.put((int)(firstPos >>> 6), first.get((int)(firstPos >>> 6)) | 1L << (int)(firstPos & 0x3FL));
                        } else {
                            first.put((int)(firstPos >>> 6), first.get((int)(firstPos >>> 6)) & (1L << (int)(firstPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL));
                        }
                        if (v1) {
                            second.put((int)(secondPos >>> 6), second.get((int)(secondPos >>> 6)) | 1L << (int)(secondPos & 0x3FL));
                        } else {
                            second.put((int)(secondPos >>> 6), second.get((int)(secondPos >>> 6)) & (1L << (int)(secondPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL));
                        }
                    }
                }
            }
            ++firstPos;
            ++secondPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packBits(LongBuffer dest, long destPos, boolean[] src, int srcPos, int count) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            Object object = PackedBitBuffers.getLock(dest);
            synchronized (object) {
                int srcPosMax = srcPos + countStart;
                while (srcPos < srcPosMax) {
                    if (src[srcPos]) {
                        dest.put((int)(destPos >>> 6), dest.get((int)(destPos >>> 6)) | 1L << (int)(destPos & 0x3FL));
                    } else {
                        dest.put((int)(destPos >>> 6), dest.get((int)(destPos >>> 6)) & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                    ++srcPos;
                    ++destPos;
                }
            }
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; ++k) {
            int low = (src[srcPos] ? 1 : 0) | (src[srcPos + 1] ? 2 : 0) | (src[srcPos + 2] ? 4 : 0) | (src[srcPos + 3] ? 8 : 0) | (src[srcPos + 4] ? 16 : 0) | (src[srcPos + 5] ? 32 : 0) | (src[srcPos + 6] ? 64 : 0) | (src[srcPos + 7] ? 128 : 0) | (src[srcPos + 8] ? 256 : 0) | (src[srcPos + 9] ? 512 : 0) | (src[srcPos + 10] ? 1024 : 0) | (src[srcPos + 11] ? 2048 : 0) | (src[srcPos + 12] ? 4096 : 0) | (src[srcPos + 13] ? 8192 : 0) | (src[srcPos + 14] ? 16384 : 0) | (src[srcPos + 15] ? 32768 : 0) | (src[srcPos + 16] ? 65536 : 0) | (src[srcPos + 17] ? 131072 : 0) | (src[srcPos + 18] ? 262144 : 0) | (src[srcPos + 19] ? 524288 : 0) | (src[srcPos + 20] ? 0x100000 : 0) | (src[srcPos + 21] ? 0x200000 : 0) | (src[srcPos + 22] ? 0x400000 : 0) | (src[srcPos + 23] ? 0x800000 : 0) | (src[srcPos + 24] ? 0x1000000 : 0) | (src[srcPos + 25] ? 0x2000000 : 0) | (src[srcPos + 26] ? 0x4000000 : 0) | (src[srcPos + 27] ? 0x8000000 : 0) | (src[srcPos + 28] ? 0x10000000 : 0) | (src[srcPos + 29] ? 0x20000000 : 0) | (src[srcPos + 30] ? 0x40000000 : 0) | (src[srcPos + 31] ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] ? 1 : 0) | (src[srcPos + 1] ? 2 : 0) | (src[srcPos + 2] ? 4 : 0) | (src[srcPos + 3] ? 8 : 0) | (src[srcPos + 4] ? 16 : 0) | (src[srcPos + 5] ? 32 : 0) | (src[srcPos + 6] ? 64 : 0) | (src[srcPos + 7] ? 128 : 0) | (src[srcPos + 8] ? 256 : 0) | (src[srcPos + 9] ? 512 : 0) | (src[srcPos + 10] ? 1024 : 0) | (src[srcPos + 11] ? 2048 : 0) | (src[srcPos + 12] ? 4096 : 0) | (src[srcPos + 13] ? 8192 : 0) | (src[srcPos + 14] ? 16384 : 0) | (src[srcPos + 15] ? 32768 : 0) | (src[srcPos + 16] ? 65536 : 0) | (src[srcPos + 17] ? 131072 : 0) | (src[srcPos + 18] ? 262144 : 0) | (src[srcPos + 19] ? 524288 : 0) | (src[srcPos + 20] ? 0x100000 : 0) | (src[srcPos + 21] ? 0x200000 : 0) | (src[srcPos + 22] ? 0x400000 : 0) | (src[srcPos + 23] ? 0x800000 : 0) | (src[srcPos + 24] ? 0x1000000 : 0) | (src[srcPos + 25] ? 0x2000000 : 0) | (src[srcPos + 26] ? 0x4000000 : 0) | (src[srcPos + 27] ? 0x8000000 : 0) | (src[srcPos + 28] ? 0x10000000 : 0) | (src[srcPos + 29] ? 0x20000000 : 0) | (src[srcPos + 30] ? 0x40000000 : 0) | (src[srcPos + 31] ? Integer.MIN_VALUE : 0);
            srcPos += 32;
            dest.put(k, (long)low & 0xFFFFFFFFL | (long)high << 32);
            destPos += 64L;
        }
        int countFinish = count & 0x3F;
        if (countFinish > 0) {
            Object object = PackedBitBuffers.getLock(dest);
            synchronized (object) {
                int srcPosMax = srcPos + countFinish;
                while (srcPos < srcPosMax) {
                    if (src[srcPos]) {
                        dest.put((int)(destPos >>> 6), dest.get((int)(destPos >>> 6)) | 1L << (int)(destPos & 0x3FL));
                    } else {
                        dest.put((int)(destPos >>> 6), dest.get((int)(destPos >>> 6)) & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                    ++srcPos;
                    ++destPos;
                }
            }
        }
    }

    public static void unpackBits(boolean[] dest, int destPos, LongBuffer src, long srcPos, int count) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src.get((int)(srcPos >>> 6)) & 1L << (int)(srcPos & 0x3FL)) != 0L;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            long value = src.get(k);
            int low = (int)value;
            int high = (int)(value >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0;
            dest[destPos + 1] = (low & 2) != 0;
            dest[destPos + 2] = (low & 4) != 0;
            dest[destPos + 3] = (low & 8) != 0;
            dest[destPos + 4] = (low & 0x10) != 0;
            dest[destPos + 5] = (low & 0x20) != 0;
            dest[destPos + 6] = (low & 0x40) != 0;
            dest[destPos + 7] = (low & 0x80) != 0;
            dest[destPos + 8] = (low & 0x100) != 0;
            dest[destPos + 9] = (low & 0x200) != 0;
            dest[destPos + 10] = (low & 0x400) != 0;
            dest[destPos + 11] = (low & 0x800) != 0;
            dest[destPos + 12] = (low & 0x1000) != 0;
            dest[destPos + 13] = (low & 0x2000) != 0;
            dest[destPos + 14] = (low & 0x4000) != 0;
            dest[destPos + 15] = (low & 0x8000) != 0;
            dest[destPos + 16] = (low & 0x10000) != 0;
            dest[destPos + 17] = (low & 0x20000) != 0;
            dest[destPos + 18] = (low & 0x40000) != 0;
            dest[destPos + 19] = (low & 0x80000) != 0;
            dest[destPos + 20] = (low & 0x100000) != 0;
            dest[destPos + 21] = (low & 0x200000) != 0;
            dest[destPos + 22] = (low & 0x400000) != 0;
            dest[destPos + 23] = (low & 0x800000) != 0;
            dest[destPos + 24] = (low & 0x1000000) != 0;
            dest[destPos + 25] = (low & 0x2000000) != 0;
            dest[destPos + 26] = (low & 0x4000000) != 0;
            dest[destPos + 27] = (low & 0x8000000) != 0;
            dest[destPos + 28] = (low & 0x10000000) != 0;
            dest[destPos + 29] = (low & 0x20000000) != 0;
            dest[destPos + 30] = (low & 0x40000000) != 0;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0;
            dest[destPos + 32] = (high & 1) != 0;
            dest[destPos + 33] = (high & 2) != 0;
            dest[destPos + 34] = (high & 4) != 0;
            dest[destPos + 35] = (high & 8) != 0;
            dest[destPos + 36] = (high & 0x10) != 0;
            dest[destPos + 37] = (high & 0x20) != 0;
            dest[destPos + 38] = (high & 0x40) != 0;
            dest[destPos + 39] = (high & 0x80) != 0;
            dest[destPos + 40] = (high & 0x100) != 0;
            dest[destPos + 41] = (high & 0x200) != 0;
            dest[destPos + 42] = (high & 0x400) != 0;
            dest[destPos + 43] = (high & 0x800) != 0;
            dest[destPos + 44] = (high & 0x1000) != 0;
            dest[destPos + 45] = (high & 0x2000) != 0;
            dest[destPos + 46] = (high & 0x4000) != 0;
            dest[destPos + 47] = (high & 0x8000) != 0;
            dest[destPos + 48] = (high & 0x10000) != 0;
            dest[destPos + 49] = (high & 0x20000) != 0;
            dest[destPos + 50] = (high & 0x40000) != 0;
            dest[destPos + 51] = (high & 0x80000) != 0;
            dest[destPos + 52] = (high & 0x100000) != 0;
            dest[destPos + 53] = (high & 0x200000) != 0;
            dest[destPos + 54] = (high & 0x400000) != 0;
            dest[destPos + 55] = (high & 0x800000) != 0;
            dest[destPos + 56] = (high & 0x1000000) != 0;
            dest[destPos + 57] = (high & 0x2000000) != 0;
            dest[destPos + 58] = (high & 0x4000000) != 0;
            dest[destPos + 59] = (high & 0x8000000) != 0;
            dest[destPos + 60] = (high & 0x10000000) != 0;
            dest[destPos + 61] = (high & 0x20000000) != 0;
            dest[destPos + 62] = (high & 0x40000000) != 0;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src.get((int)(srcPos >>> 6)) & 1L << (int)(srcPos & 0x3FL)) != 0L;
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillBits(LongBuffer dest, long destPos, long count, boolean value) {
        Objects.requireNonNull(dest, "Null dest");
        int dPos = (int)(destPos >>> 6);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (cntStart > 0) {
            Object object = PackedBitBuffers.getLock(dest);
            synchronized (object) {
                if (value) {
                    dest.put(dPos, dest.get(dPos) | maskStart);
                } else {
                    dest.put(dPos, dest.get(dPos) & (maskStart ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
            count -= (long)cntStart;
            ++dPos;
        }
        long longValue = value ? -1L : 0L;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            dest.put(dPos, longValue);
            ++dPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish > 0) {
            long maskFinish = (1L << cntFinish) - 1L;
            Object object = PackedBitBuffers.getLock(dest);
            synchronized (object) {
                if (value) {
                    dest.put(dPos, dest.get(dPos) | maskFinish);
                } else {
                    dest.put(dPos, dest.get(dPos) & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void notBits(long[] dest, long destPos, LongBuffer src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = (src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = (src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                dest[dPos] = src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL;
                ++dPos;
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src.get(sPos);
                    v = sNext << shift;
                } else {
                    sNext = src.get(sPos);
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src.get(sPos + 1);
                v = src.get(sPos) >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = (v ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src.get(sPos);
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            long l = sNext >>> sPosRem;
            sNext = src.get(++sPos);
            dest[dPos] = (l | sNext << sPosRem64) ^ 0xFFFFFFFFFFFFFFFFL;
            ++dPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src.get(sPos + 1) << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = (v ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void andBits(long[] dest, long destPos, LongBuffer src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                int n = dPos++;
                dest[n] = dest[n] & (src.get(sPos) | maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    int n = dPos;
                    dest[n] = dest[n] & (src.get(sPos) | maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] & src.get(sPos);
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src.get(sPos);
                    v = sNext << shift;
                } else {
                    sNext = src.get(sPos);
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src.get(sPos + 1);
                v = src.get(sPos) >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            int n = dPos++;
            dest[n] = dest[n] & (v | maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src.get(sPos);
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src.get(++sPos);
            dest[n] = dest[n] & (l | sNext << sPosRem64);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src.get(sPos + 1) << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        int n = dPos;
        dest[n] = dest[n] & (v | maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void orBits(long[] dest, long destPos, LongBuffer src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                int n = dPos++;
                dest[n] = dest[n] | src.get(sPos) & maskStart;
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    int n = dPos;
                    dest[n] = dest[n] | src.get(sPos) & maskFinish;
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] | src.get(sPos);
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src.get(sPos);
                    v = sNext << shift;
                } else {
                    sNext = src.get(sPos);
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src.get(sPos + 1);
                v = src.get(sPos) >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            int n = dPos++;
            dest[n] = dest[n] | v & maskStart;
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src.get(sPos);
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src.get(++sPos);
            dest[n] = dest[n] | (l | sNext << sPosRem64);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src.get(sPos + 1) << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        int n = dPos;
        dest[n] = dest[n] | v & maskFinish;
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void xorBits(long[] dest, long destPos, LongBuffer src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = (dest[dPos] ^ src.get(sPos)) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = (dest[dPos] ^ src.get(sPos)) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] ^ src.get(sPos);
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src.get(sPos);
                    v = sNext << shift;
                } else {
                    sNext = src.get(sPos);
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src.get(sPos + 1);
                v = src.get(sPos) >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = (dest[dPos] ^ v) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src.get(sPos);
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src.get(++sPos);
            dest[n] = dest[n] ^ (l | sNext << sPosRem64);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src.get(sPos + 1) << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = (dest[dPos] ^ v) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void andNotBits(long[] dest, long destPos, LongBuffer src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = dest[dPos] & (src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = dest[dPos] & (src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] & (src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL);
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src.get(sPos);
                    v = sNext << shift;
                } else {
                    sNext = src.get(sPos);
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src.get(sPos + 1);
                v = src.get(sPos) >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = dest[dPos] & (v ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src.get(sPos);
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src.get(++sPos);
            dest[n] = dest[n] & ((l | sNext << sPosRem64) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src.get(sPos + 1) << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = dest[dPos] & (v ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void orNotBits(long[] dest, long destPos, LongBuffer src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = (dest[dPos] | src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = (dest[dPos] | src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] | src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL;
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src.get(sPos);
                    v = sNext << shift;
                } else {
                    sNext = src.get(sPos);
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src.get(sPos + 1);
                v = src.get(sPos) >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = (dest[dPos] | v ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src.get(sPos);
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src.get(++sPos);
            dest[n] = dest[n] | (l | sNext << sPosRem64) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src.get(sPos + 1) << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = (dest[dPos] | v ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    public static long indexOfBit(LongBuffer src, long lowIndex, long highIndex, boolean value) {
        long maskFinish;
        int index;
        int cntFinish;
        Objects.requireNonNull(src, "Null src");
        if (lowIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: low index = " + lowIndex);
        }
        if (highIndex > (long)src.limit() << 6) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: high index = " + highIndex);
        }
        if (lowIndex >= highIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        int sPos = (int)(lowIndex >>> 6);
        int sPosRem = (int)(lowIndex & 0x3FL);
        int cntStart = -sPosRem & 0x3F;
        long fromAligned = lowIndex - (long)sPosRem;
        long maskStart = -1L << sPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << sPosRem + cntStart) - 1L;
        }
        if (cntStart > 0) {
            int index2 = Long.numberOfTrailingZeros((value ? src.get(sPos) : src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskStart);
            if (index2 != 64) {
                return fromAligned + (long)index2;
            }
            count -= (long)cntStart;
            ++sPos;
            fromAligned += 64L;
        }
        if (value) {
            sPosMax = sPos + (int)(count >>> 6);
            while (sPos < sPosMax) {
                index = Long.numberOfTrailingZeros(src.get(sPos));
                if (index != 64) {
                    return fromAligned + (long)index;
                }
                ++sPos;
                fromAligned += 64L;
            }
        } else {
            sPosMax = sPos + (int)(count >>> 6);
            while (sPos < sPosMax) {
                index = Long.numberOfTrailingZeros(src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL);
                if (index != 64) {
                    return fromAligned + (long)index;
                }
                ++sPos;
                fromAligned += 64L;
            }
        }
        if ((cntFinish = (int)(count & 0x3FL)) > 0 && (index = Long.numberOfTrailingZeros((value ? src.get(sPos) : src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & (maskFinish = (1L << cntFinish) - 1L))) != 64) {
            return fromAligned + (long)index;
        }
        return -1L;
    }

    public static long lastIndexOfBit(LongBuffer src, long lowIndex, long highIndex, boolean value) {
        long maskFinish;
        int index;
        int cntFinish;
        Objects.requireNonNull(src, "Null src");
        if (lowIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: low index = " + lowIndex);
        }
        if (highIndex > (long)src.limit() << 6) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: high index = " + highIndex);
        }
        if (lowIndex >= highIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        int sPos = (int)(highIndex - 1L >>> 6);
        int cntStart = (int)highIndex & 0x3F;
        long fromAligned = (highIndex - 1L & 0xFFFFFFFFFFFFFFC0L) + 63L;
        long maskStart = (1L << cntStart) - 1L;
        if ((long)cntStart > count) {
            maskStart &= -1L << (int)((long)cntStart - count);
            cntStart = (int)count;
        }
        if (cntStart > 0) {
            int index2 = Long.numberOfLeadingZeros((value ? src.get(sPos) : src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & maskStart);
            if (index2 != 64) {
                return fromAligned - (long)index2;
            }
            count -= (long)cntStart;
            --sPos;
            fromAligned -= 64L;
        }
        if (value) {
            sPosMin = sPos - (int)(count >>> 6);
            while (sPos > sPosMin) {
                index = Long.numberOfLeadingZeros(src.get(sPos));
                if (index != 64) {
                    return fromAligned - (long)index;
                }
                --sPos;
                fromAligned -= 64L;
            }
        } else {
            sPosMin = sPos - (int)(count >>> 6);
            while (sPos > sPosMin) {
                index = Long.numberOfLeadingZeros(src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL);
                if (index != 64) {
                    return fromAligned - (long)index;
                }
                --sPos;
                fromAligned -= 64L;
            }
        }
        if ((cntFinish = (int)(count & 0x3FL)) > 0 && (index = Long.numberOfLeadingZeros((value ? src.get(sPos) : src.get(sPos) ^ 0xFFFFFFFFFFFFFFFFL) & (maskFinish = -1L << 64 - cntFinish))) != 64) {
            return fromAligned - (long)index;
        }
        return -1L;
    }

    public static long cardinality(LongBuffer src, long fromIndex, long toIndex) {
        Objects.requireNonNull(src, "Null src argument in cardinality method");
        if (fromIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: initial index = " + fromIndex);
        }
        if (toIndex > (long)src.limit() << 6) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: end index = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        long count = toIndex - fromIndex;
        int sPos = (int)(fromIndex >>> 6);
        int sPosRem = (int)(fromIndex & 0x3FL);
        int cntStart = -sPosRem & 0x3F;
        long maskStart = -1L << sPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << sPosRem + cntStart) - 1L;
        }
        long result = 0L;
        if (cntStart > 0) {
            result += (long)Long.bitCount(src.get(sPos) & maskStart);
            count -= (long)cntStart;
            ++sPos;
        }
        int sPosMax = sPos + (int)(count >>> 6);
        result += PackedBitBuffers.bitCount(src, sPos, sPosMax);
        sPos = sPosMax;
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish > 0) {
            long maskFinish = (1L << cntFinish) - 1L;
            result += (long)Long.bitCount(src.get(sPos) & maskFinish);
        }
        return result;
    }

    static long bitCount(LongBuffer src, int from, int to) {
        long result = 0L;
        for (int i = from; i < to; ++i) {
            result += (long)Long.bitCount(src.get(i));
        }
        return result;
    }
}

