/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutablePArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;

public interface PArray
extends Array {
    public long bitsPerElement();

    public double minPossibleValue(double var1);

    public double maxPossibleValue(double var1);

    public double getDouble(long var1);

    public long indexOf(long var1, long var3, double var5);

    public long lastIndexOf(long var1, long var3, double var5);

    public boolean isZeroFilled();

    public Class<? extends PArray> type();

    public Class<? extends UpdatablePArray> updatableType();

    public Class<? extends MutablePArray> mutableType();

    @Override
    public PArray asImmutable();

    @Override
    public PArray asTrustedImmutable();

    @Override
    public MutablePArray mutableClone(MemoryModel var1);

    @Override
    public UpdatablePArray updatableClone(MemoryModel var1);

    default public Matrix<? extends PArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    default public byte[] toByte() {
        return this.toByte(null);
    }

    default public byte[] toByte(byte[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java byte[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new byte[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array byte[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof ByteArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, ByteArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public char[] toChar() {
        return this.toChar(null);
    }

    default public char[] toChar(char[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java char[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new char[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array char[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof CharArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, CharArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public short[] toShort() {
        return this.toShort(null);
    }

    default public short[] toShort(short[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java short[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new short[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array short[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof ShortArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, ShortArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public int[] toInt() {
        return this.toInt(null);
    }

    default public int[] toInt(int[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java int[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new int[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array int[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof IntArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, IntArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public long[] toLong() {
        return this.toLong(null);
    }

    default public long[] toLong(long[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java long[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new long[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array long[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof LongArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, LongArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public float[] toFloat() {
        return this.toFloat(null);
    }

    default public float[] toFloat(float[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java float[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new float[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array float[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof FloatArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, FloatArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public double[] toDouble() {
        return this.toDouble(null);
    }

    default public double[] toDouble(double[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java double[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new double[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array double[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof DoubleArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, DoubleArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public boolean[] toBoolean() {
        return this.toBoolean(null);
    }

    default public boolean[] toBoolean(boolean[] result) {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java boolean[] array, because it is too large: " + String.valueOf(this));
        }
        if (result == null) {
            result = new boolean[(int)len];
        } else if ((long)result.length < len) {
            throw new IndexOutOfBoundsException("Result array boolean[" + result.length + "] is too short to read " + len + " elements of " + String.valueOf(this));
        }
        PArray array = this;
        if (!(array instanceof BitArray)) {
            array = Arrays.asFuncArray(Func.IDENTITY, BitArray.class, array);
        }
        array.getData(0L, result);
        return result;
    }

    default public byte[] jaByte() {
        byte[] byArray;
        PArray pArray = this;
        if (pArray instanceof ByteArray) {
            ByteArray a = (ByteArray)pArray;
            byArray = a.ja();
        } else {
            byArray = this.toByte();
        }
        return byArray;
    }

    default public char[] jaChar() {
        char[] cArray;
        PArray pArray = this;
        if (pArray instanceof CharArray) {
            CharArray a = (CharArray)pArray;
            cArray = a.ja();
        } else {
            cArray = this.toChar();
        }
        return cArray;
    }

    default public short[] jaShort() {
        short[] sArray;
        PArray pArray = this;
        if (pArray instanceof ShortArray) {
            ShortArray a = (ShortArray)pArray;
            sArray = a.ja();
        } else {
            sArray = this.toShort();
        }
        return sArray;
    }

    default public int[] jaInt() {
        int[] nArray;
        PArray pArray = this;
        if (pArray instanceof IntArray) {
            IntArray a = (IntArray)pArray;
            nArray = a.ja();
        } else {
            nArray = this.toInt();
        }
        return nArray;
    }

    default public long[] jaLong() {
        long[] lArray;
        PArray pArray = this;
        if (pArray instanceof LongArray) {
            LongArray a = (LongArray)pArray;
            lArray = a.ja();
        } else {
            lArray = this.toLong();
        }
        return lArray;
    }

    default public float[] jaFloat() {
        float[] fArray;
        PArray pArray = this;
        if (pArray instanceof FloatArray) {
            FloatArray a = (FloatArray)pArray;
            fArray = a.ja();
        } else {
            fArray = this.toFloat();
        }
        return fArray;
    }

    default public double[] jaDouble() {
        double[] dArray;
        PArray pArray = this;
        if (pArray instanceof DoubleArray) {
            DoubleArray a = (DoubleArray)pArray;
            dArray = a.ja();
        } else {
            dArray = this.toDouble();
        }
        return dArray;
    }

    public static UpdatablePArray newArray(MemoryModel memoryModel, Class<?> elementType, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(elementType, "Null element type");
        if (!elementType.isPrimitive()) {
            throw new IllegalArgumentException("Not a primitive type: " + String.valueOf(elementType));
        }
        return (UpdatablePArray)memoryModel.newUnresizableArray(elementType, length);
    }

    public static UpdatablePArray newArray(Class<?> elementType, long length) {
        return PArray.newArray(Arrays.SMM, elementType, length);
    }

    public static UpdatablePArray as(Object array) {
        return SimpleMemoryModel.asUpdatablePArray(array);
    }
}

