/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitStack;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutablePFixedArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;

public interface MutableBitArray
extends BitStack,
UpdatableBitArray,
MutablePFixedArray {
    @Override
    public MutableBitArray setData(long var1, Object var3, int var4, int var5);

    @Override
    public MutableBitArray setData(long var1, Object var3);

    @Override
    public MutableBitArray copy(Array var1);

    @Override
    public MutableBitArray swap(UpdatableArray var1);

    @Override
    public MutableBitArray length(long var1);

    @Override
    public MutableBitArray ensureCapacity(long var1);

    @Override
    public MutableBitArray trim();

    @Override
    public MutableBitArray append(Array var1);

    @Override
    public MutableBitArray asCopyOnNextWrite();

    @Override
    public MutableBitArray shallowClone();

    public static MutableBitArray newArray(MemoryModel memoryModel) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newEmptyBitArray();
    }

    public static MutableBitArray newArray() {
        return Arrays.SMM.newEmptyBitArray();
    }

    default public void addBit(boolean value) {
        this.pushBit(value);
    }
}

