/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.arrays.AbstractMatrix;
import net.algart.arrays.Arrays;
import net.algart.arrays.IllegalInfoSyntaxException;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;

public abstract class MatrixInfo {
    public static final int MAX_SERIALIZED_MATRIX_INFO_LENGTH = 8192;
    public static final int MAX_NUMBER_OF_PROPERTIES_IN_MATRIX_INFO = 10000;
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    public static final String DEFAULT_VERSION = "1.2";
    private static final String ELEMENT_TYPE_PROPERTY_NAME = "__element";
    private static final String BYTE_ORDER_PROPERTY_NAME = "__order";
    private static final String SIZE_PROPERTY_NAME = "__size";
    private static final String DIMENSIONS_PROPERTY_NAME = "__dimensions";
    private static final String DATA_OFFSET_PROPERTY_NAME = "__offset";
    final Class<?> elementType;
    final long bitsPerElement;
    final ByteOrder byteOrder;
    final long size;
    final long[] dimensions;
    final long dataOffset;
    final String version;

    private MatrixInfo(Class<?> elementType, ByteOrder byteOrder, long size, long[] dimensions, long dataOffset, String version) {
        assert (dimensions.length <= 9);
        assert (elementType != null);
        assert (byteOrder != null);
        this.elementType = elementType;
        this.bitsPerElement = Arrays.bitsPerElement(elementType);
        this.size = size;
        this.byteOrder = byteOrder;
        this.dimensions = dimensions;
        this.dataOffset = dataOffset;
        this.version = version;
    }

    public static MatrixInfo valueOf(Matrix<? extends PArray> matrix, long dataOffset) {
        return MatrixInfo.valueOf(matrix, dataOffset, "1.2");
    }

    public static MatrixInfo valueOf(Matrix<? extends PArray> matrix, long dataOffset, String version) {
        Objects.requireNonNull(version, "Null version argument");
        if (matrix.dimCount() > 9) {
            throw new TooLargeArrayException("Too large number of matrix dimensions: " + matrix.dimCount());
        }
        PArray array = matrix.array();
        assert (array.isUnresizable());
        long[] dimensions = matrix.dimensions();
        assert (dimensions.length > 0);
        assert (array.length() == Arrays.longMul(dimensions));
        if (version.equals(VERSION_1_1)) {
            return new Version1_1(array.elementType(), array.byteOrder(), array.length(), dimensions, dataOffset);
        }
        if (version.equals("1.2")) {
            return new Version1_2(array.elementType(), array.byteOrder(), array.length(), dimensions, dataOffset, Collections.emptyMap());
        }
        throw new IllegalArgumentException("The version \"" + version + "\" is not supported by " + String.valueOf(MatrixInfo.class));
    }

    public static MatrixInfo valueOf(byte[] bytes) throws IllegalInfoSyntaxException {
        char[] chars = new char[Math.min(bytes.length, 8192)];
        for (int k = 0; k < chars.length; ++k) {
            chars[k] = (char)(bytes[k] & 0xFF);
        }
        return MatrixInfo.valueOf(String.valueOf(chars));
    }

    public static MatrixInfo valueOf(String chars) throws IllegalInfoSyntaxException {
        if (Version1_2.isVersion1_2(chars)) {
            return Version1_2.valueOf(chars);
        }
        if (Version1_1.isVersion1_1(chars)) {
            return Version1_1.valueOf(chars);
        }
        throw new IllegalInfoSyntaxException("The char sequence does not contain valid start signature");
    }

    public static boolean isCorrectAdditionalPropertyName(String name) {
        Objects.requireNonNull(name, "Null name argument");
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (ch == '_' || ch >= '0' && ch <= '9') {
            return false;
        }
        for (int j = 0; j < len; ++j) {
            ch = name.charAt(j);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.') continue;
            return false;
        }
        return true;
    }

    public final String version() {
        return this.version;
    }

    public final Class<?> elementType() {
        return this.elementType;
    }

    public long bitsPerElement() {
        return this.bitsPerElement;
    }

    public final ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public final long size() {
        return this.size;
    }

    public final long[] dimensions() {
        return (long[])this.dimensions.clone();
    }

    public final int dimCount() {
        return this.dimensions.length;
    }

    public final long dim(int n) {
        return n < this.dimensions.length ? this.dimensions[n] : 1L;
    }

    public final long dataOffset() {
        return this.dataOffset;
    }

    public abstract Map<String, String> additionalProperties();

    public abstract MatrixInfo cloneWithOtherByteOrder(ByteOrder var1);

    public MatrixInfo cloneWithOtherVersion(String version) {
        Objects.requireNonNull(version, "Null version argument");
        if (version.equals(VERSION_1_1)) {
            int size = this.additionalProperties().size();
            if (size != 0) {
                throw new UnsupportedOperationException("This instance contains " + size + " additional properties, but the specified version " + version + " does not support this feature");
            }
            return new Version1_1(this.elementType, this.byteOrder, size, this.dimensions, this.dataOffset);
        }
        if (version.equals("1.2")) {
            return new Version1_2(this.elementType, this.byteOrder, this.size, this.dimensions, this.dataOffset, this.additionalProperties());
        }
        throw new IllegalArgumentException("The version \"" + version + "\" is not supported by " + String.valueOf(MatrixInfo.class));
    }

    public abstract MatrixInfo cloneWithOtherDataOffset(long var1);

    public abstract MatrixInfo cloneWithOtherAdditionalProperties(Map<String, String> var1);

    public byte[] toBytes() {
        String chars = this.toChars();
        byte[] result = new byte[chars.length()];
        for (int k = 0; k < result.length; ++k) {
            char ch = chars.charAt(k);
            if (ch >= '\u0100') {
                throw new AssertionError((Object)"Cannot convert to bytes: some additional properties contain characters with codes higher than ASCII 255");
            }
            result[k] = (byte)ch;
        }
        return result;
    }

    public abstract String toChars();

    public boolean matches(Matrix<?> matrix) {
        return matrix.elementType().equals(this.elementType) && matrix.array().byteOrder() == this.byteOrder && matrix.dimEquals(this.dimensions);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("AlgART matrix descriptor v");
        result.append(this.version).append(": ");
        if (this.elementType == Boolean.TYPE) {
            result.append("bit[");
        } else if (this.elementType == Character.TYPE) {
            result.append("char[");
        } else if (this.elementType == Byte.TYPE) {
            result.append("byte[");
        } else if (this.elementType == Short.TYPE) {
            result.append("short[");
        } else if (this.elementType == Integer.TYPE) {
            result.append("int[");
        } else if (this.elementType == Long.TYPE) {
            result.append("long[");
        } else if (this.elementType == Float.TYPE) {
            result.append("float[");
        } else if (this.elementType == Double.TYPE) {
            result.append("double[");
        } else {
            throw new AssertionError((Object)"Illegal element type");
        }
        result.append(this.dimensions[0]);
        for (int n = 1; n < this.dimensions.length; ++n) {
            result.append('x').append(this.dimensions[n]);
        }
        result.append("] ").append(this.byteOrder);
        result.append(", dataOffset=").append(this.dataOffset);
        return result.toString();
    }

    public int hashCode() {
        int result = this.elementType.toString().hashCode();
        result = 31 * result + this.byteOrder.toString().hashCode();
        result = 31 * result + JArrays.arrayHashCode(this.dimensions, 0, this.dimensions.length);
        result = 31 * result + ((int)this.dataOffset ^ (int)(this.dataOffset >>> 32));
        result = 31 * result + this.additionalProperties().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MatrixInfo)) {
            return false;
        }
        MatrixInfo mi = (MatrixInfo)obj;
        return mi.elementType.equals(this.elementType) && mi.byteOrder == this.byteOrder && java.util.Arrays.equals(mi.dimensions, this.dimensions) && mi.dataOffset == this.dataOffset && mi.additionalProperties().equals(this.additionalProperties());
    }

    static final class Version1_1
    extends MatrixInfo {
        private static final String SIGNATURE_BE_1_1 = "AlgART Matrix BE v1.1~~~";
        private static final String SIGNATURE_LE_1_1 = "AlgART Matrix LE v1.1~~~";
        private static final int FIXED_PART_LENGTH_1_1 = 75;

        private Version1_1(Class<?> elementType, ByteOrder byteOrder, long size, long[] dimensions, long dataOffset) {
            super(elementType, byteOrder, size, dimensions, dataOffset, MatrixInfo.VERSION_1_1);
        }

        public static boolean isVersion1_1(String chars) {
            return chars.startsWith(SIGNATURE_BE_1_1) || chars.startsWith(SIGNATURE_LE_1_1);
        }

        public static MatrixInfo valueOf(String chars) throws IllegalInfoSyntaxException {
            long[] dimensions;
            long length;
            Class<Comparable<Boolean>> elementType;
            long dataOffset;
            ByteOrder byteOrder;
            if (chars.startsWith("AlgART Matrix BE v1.1~~~ OFFSET=")) {
                byteOrder = ByteOrder.BIG_ENDIAN;
            } else if (chars.startsWith("AlgART Matrix LE v1.1~~~ OFFSET=")) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else {
                throw new IllegalInfoSyntaxException("The char sequence does not contain valid start signature");
            }
            if (chars.length() < 75) {
                throw new IllegalInfoSyntaxException("The char sequence is too short");
            }
            try {
                String tn;
                dataOffset = Long.parseLong(chars.substring(32, 48), 16);
                elementType = switch (tn = chars.substring(48, 56)) {
                    case "    bit[" -> Boolean.TYPE;
                    case "   char[" -> Character.TYPE;
                    case "   byte[" -> Byte.TYPE;
                    case "  short[" -> Short.TYPE;
                    case "    int[" -> Integer.TYPE;
                    case "   long[" -> Long.TYPE;
                    case "  float[" -> Float.TYPE;
                    case " double[" -> Double.TYPE;
                    default -> throw new IllegalInfoSyntaxException("The char sequence does not contain valid element type");
                };
                length = Long.parseLong(chars.substring(56, 72), 16);
                if (!chars.substring(72, 75).equals("] [")) {
                    throw new IllegalInfoSyntaxException("The char sequence does not contain \"] [\" after the length");
                }
                int p = chars.indexOf("]~~~~", 75);
                if (p == -1) {
                    throw new IllegalInfoSyntaxException("The char sequence does not contain final \"]~~~~\" combination");
                }
                dimensions = new long[9];
                int dimCount = 0;
                for (int q = 75; q < p; q += 17) {
                    if (dimCount >= dimensions.length) {
                        throw new IllegalInfoSyntaxException("The char sequence contains more than 9 dimensions");
                    }
                    String value = chars.substring(q, Math.min(p, q + 16));
                    dimensions[dimCount++] = Long.parseLong(value, 16);
                }
                dimensions = JArrays.copyOfRange(dimensions, 0, dimCount);
            }
            catch (NumberFormatException ex) {
                IllegalInfoSyntaxException e = new IllegalInfoSyntaxException("Illegal numeric format in the char sequence");
                e.initCause(ex);
                throw e;
            }
            try {
                AbstractMatrix.checkDimensions(dimensions, length);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalInfoSyntaxException(ex.getMessage());
            }
            return new Version1_1(elementType, byteOrder, length, dimensions, dataOffset);
        }

        @Override
        public Map<String, String> additionalProperties() {
            return new LinkedHashMap<String, String>();
        }

        @Override
        public MatrixInfo cloneWithOtherByteOrder(ByteOrder byteOrder) {
            Objects.requireNonNull(byteOrder, "Null byteOrder");
            return new Version1_1(this.elementType, byteOrder, this.size, this.dimensions, this.dataOffset);
        }

        @Override
        public MatrixInfo cloneWithOtherDataOffset(long dataOffset) {
            return new Version1_1(this.elementType, this.byteOrder, this.size, this.dimensions, dataOffset);
        }

        @Override
        public MatrixInfo cloneWithOtherAdditionalProperties(Map<String, String> additionalProperties) {
            throw new UnsupportedOperationException("This version does not support additional properties: " + String.valueOf(this));
        }

        @Override
        public String toChars() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.byteOrder == ByteOrder.BIG_ENDIAN ? SIGNATURE_BE_1_1 : SIGNATURE_LE_1_1);
            assert (sb.length() == 24);
            sb.append(" OFFSET=").append(InternalUtils.toHexString(this.dataOffset));
            assert (sb.length() == 48);
            if (this.elementType == Boolean.TYPE) {
                sb.append("    bit[");
            } else if (this.elementType == Character.TYPE) {
                sb.append("   char[");
            } else if (this.elementType == Byte.TYPE) {
                sb.append("   byte[");
            } else if (this.elementType == Short.TYPE) {
                sb.append("  short[");
            } else if (this.elementType == Integer.TYPE) {
                sb.append("    int[");
            } else if (this.elementType == Long.TYPE) {
                sb.append("   long[");
            } else if (this.elementType == Float.TYPE) {
                sb.append("  float[");
            } else if (this.elementType == Double.TYPE) {
                sb.append(" double[");
            } else {
                throw new AssertionError((Object)"Illegal element type");
            }
            assert (sb.length() == 56);
            sb.append(InternalUtils.toHexString(this.size)).append("] [");
            assert (sb.length() == 75);
            sb.append(InternalUtils.toHexString(this.dimensions[0]));
            for (int k = 1; k < this.dimensions.length; ++k) {
                sb.append("x").append(InternalUtils.toHexString(this.dimensions[k]));
            }
            sb.append("]~~~~");
            assert (sb.length() <= 8192);
            return sb.toString();
        }
    }

    static final class Version1_2
    extends MatrixInfo {
        private static final String SIGNATURE_NAME_1_2 = "__cfgtype";
        private static final String SIGNATURE_VALUE_1_2 = "AlgART Matrix v1.2";
        private final Map<String, String> additionalProperties;

        private Version1_2(Class<?> elementType, ByteOrder byteOrder, long size, long[] dimensions, long dataOffset, Map<String, String> additionalProperties) {
            super(elementType, byteOrder, size, dimensions, dataOffset, "1.2");
            Objects.requireNonNull(additionalProperties, "Null additional properties");
            if (additionalProperties.size() > 10000) {
                throw new IllegalArgumentException("Too many additional properties: " + additionalProperties.size() + ">10000");
            }
            for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
                if (Version1_2.isCorrectAdditionalPropertyName(entry.getKey())) continue;
                throw new IllegalArgumentException("Illegal additional property name (empty or containing unallowed characters) \"" + entry.getKey() + "\"");
            }
            this.additionalProperties = additionalProperties;
        }

        public static boolean isVersion1_2(String chars) {
            int p = chars.indexOf("\n");
            String line = p == -1 ? chars : chars.substring(0, p);
            int q = line.indexOf("=");
            if (q == -1) {
                return false;
            }
            String name = line.substring(0, q).trim();
            String value = line.substring(q + 1).trim();
            return name.equals(SIGNATURE_NAME_1_2) && value.equals(SIGNATURE_VALUE_1_2);
        }

        public static MatrixInfo valueOf(String chars) throws IllegalInfoSyntaxException {
            Class<Comparable<Boolean>> elementType = null;
            ByteOrder byteOrder = null;
            long length = -1L;
            long[] dimensions = null;
            long dataOffset = -1L;
            LinkedHashMap<String, String> additional = new LinkedHashMap<String, String>();
            int p = 0;
            int lineIndex = 0;
            int len = chars.length();
            while (p < len) {
                String line;
                if (lineIndex > 10500) {
                    throw new IllegalInfoSyntaxException("More than 10500 system and additional properties are found in the serialized form");
                }
                int q = chars.indexOf("\n", p);
                if (++q == 0) {
                    q = len;
                }
                if ((line = chars.substring(p, q).trim()).isEmpty()) break;
                if (!line.startsWith("#")) {
                    int r = line.indexOf("=");
                    if (r == -1) {
                        throw new IllegalInfoSyntaxException("= character expected in the line #" + lineIndex + ": \"" + line + "\"");
                    }
                    String name = line.substring(0, r).trim();
                    String value = line.substring(r + 1).trim();
                    try {
                        switch (name) {
                            case "__cfgtype": {
                                if (!value.equals(SIGNATURE_VALUE_1_2)) {
                                    throw new IllegalInfoSyntaxException("Illegal signature in the line #" + lineIndex + ": \"" + line + "\"");
                                }
                                break;
                            }
                            case "__element": {
                                if (elementType == null) {
                                    elementType = switch (value) {
                                        case "bit" -> Boolean.TYPE;
                                        case "char" -> Character.TYPE;
                                        case "byte" -> Byte.TYPE;
                                        case "short" -> Short.TYPE;
                                        case "int" -> Integer.TYPE;
                                        case "long" -> Long.TYPE;
                                        case "float" -> Float.TYPE;
                                        case "double" -> Double.TYPE;
                                        default -> throw new IllegalInfoSyntaxException("Unsupported element type in the line #" + lineIndex + ": \"" + line + "\"");
                                    };
                                }
                                break;
                            }
                            case "__order": {
                                if (byteOrder == null) {
                                    if (value.equals("BE")) {
                                        byteOrder = ByteOrder.BIG_ENDIAN;
                                        break;
                                    }
                                    if (value.equals("LE")) {
                                        byteOrder = ByteOrder.LITTLE_ENDIAN;
                                        break;
                                    }
                                    throw new IllegalInfoSyntaxException("Unsupported byte order (not \"BE\" or \"LE\") in the line #" + lineIndex + ": \"" + line + "\"");
                                }
                                break;
                            }
                            case "__size": {
                                if (length == -1L && (length = Long.parseLong(value)) < 0L) {
                                    throw new IllegalInfoSyntaxException("Negative array length in the line #" + lineIndex + ": \"" + line + "\"");
                                }
                                break;
                            }
                            case "__dimensions": {
                                if (dimensions == null) {
                                    String[] dimValues = value.split("x", 10);
                                    if (dimValues.length > 9) {
                                        throw new IllegalInfoSyntaxException("Too many matrix dimensions in the line #" + lineIndex + ": \"" + line + "\" (maximal allowed number of dimensions is 9)");
                                    }
                                    dimensions = new long[dimValues.length];
                                    for (int k = 0; k < dimValues.length; ++k) {
                                        dimensions[k] = Long.parseLong(dimValues[k]);
                                    }
                                }
                                break;
                            }
                            case "__offset": {
                                if (dataOffset == -1L && (dataOffset = Long.parseLong(value)) < 0L) {
                                    throw new IllegalInfoSyntaxException("Negative data offset in the line #" + lineIndex + ": \"" + line + "\"");
                                }
                                break;
                            }
                            default: {
                                String decodedValue;
                                if (!Version1_2.isCorrectAdditionalPropertyName(name)) {
                                    throw new IllegalInfoSyntaxException("Illegal additional property name (empty or containing unallowed characters) in the line #" + lineIndex + ": \"" + line + "\"");
                                }
                                if (additional.containsKey(name)) break;
                                try {
                                    decodedValue = URLDecoder.decode(value, StandardCharsets.UTF_8);
                                }
                                catch (IllegalArgumentException e) {
                                    IllegalInfoSyntaxException ex = new IllegalInfoSyntaxException("URLDecoder cannot decode additional property value in the line #" + lineIndex + ": \"" + line + "\"");
                                    ex.initCause(e);
                                    throw ex;
                                }
                                additional.put(name, decodedValue);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        IllegalInfoSyntaxException ex = new IllegalInfoSyntaxException("Illegal numeric format in the line #" + lineIndex + ": \"" + line + "\"");
                        ex.initCause(e);
                        throw ex;
                    }
                }
                p = q;
                ++lineIndex;
            }
            Objects.requireNonNull(elementType, "__element=... property expected");
            Objects.requireNonNull(byteOrder, "__order=... property expected");
            if (length == -1L) {
                throw new IllegalInfoSyntaxException("__size=... property expected");
            }
            Objects.requireNonNull(dimensions, "__dimensions=... property expected");
            if (dataOffset == -1L) {
                throw new IllegalInfoSyntaxException("__offset=... property expected");
            }
            try {
                AbstractMatrix.checkDimensions(dimensions, length);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalInfoSyntaxException(ex.getMessage());
            }
            return new Version1_2(elementType, byteOrder, length, dimensions, dataOffset, additional);
        }

        @Override
        public Map<String, String> additionalProperties() {
            return new LinkedHashMap<String, String>(this.additionalProperties);
        }

        @Override
        public MatrixInfo cloneWithOtherByteOrder(ByteOrder byteOrder) {
            Objects.requireNonNull(byteOrder, "Null byteOrder");
            return new Version1_2(this.elementType, byteOrder, this.size, this.dimensions, this.dataOffset, this.additionalProperties);
        }

        @Override
        public MatrixInfo cloneWithOtherDataOffset(long dataOffset) {
            return new Version1_2(this.elementType, this.byteOrder, this.size, this.dimensions, dataOffset, this.additionalProperties);
        }

        @Override
        public MatrixInfo cloneWithOtherAdditionalProperties(Map<String, String> additionalProperties) {
            Objects.requireNonNull(additionalProperties, "Null additionalProperties argument");
            LinkedHashMap<String, String> additional = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> e : additionalProperties.entrySet()) {
                String key = e.getKey();
                Objects.requireNonNull(key, "Null name of additional property");
                String value = e.getValue();
                Objects.requireNonNull(value, "Null value of additional property");
                additional.put(key, value);
            }
            return new Version1_2(this.elementType, this.byteOrder, this.size, this.dimensions, this.dataOffset, additional);
        }

        @Override
        public String toChars() {
            StringBuilder sb = new StringBuilder();
            sb.append(SIGNATURE_NAME_1_2).append('=').append(SIGNATURE_VALUE_1_2).append('\n');
            sb.append(MatrixInfo.ELEMENT_TYPE_PROPERTY_NAME).append('=');
            if (this.elementType == Boolean.TYPE) {
                sb.append("bit");
            } else if (this.elementType == Character.TYPE) {
                sb.append("char");
            } else if (this.elementType == Byte.TYPE) {
                sb.append("byte");
            } else if (this.elementType == Short.TYPE) {
                sb.append("short");
            } else if (this.elementType == Integer.TYPE) {
                sb.append("int");
            } else if (this.elementType == Long.TYPE) {
                sb.append("long");
            } else if (this.elementType == Float.TYPE) {
                sb.append("float");
            } else if (this.elementType == Double.TYPE) {
                sb.append("double");
            } else {
                throw new AssertionError((Object)"Illegal element type");
            }
            sb.append('\n');
            sb.append(MatrixInfo.BYTE_ORDER_PROPERTY_NAME).append('=').append(this.byteOrder == ByteOrder.BIG_ENDIAN ? "BE\n" : "LE\n");
            sb.append(MatrixInfo.SIZE_PROPERTY_NAME).append('=').append(this.size).append('\n');
            sb.append(MatrixInfo.DIMENSIONS_PROPERTY_NAME).append('=').append(this.dimensions[0]);
            for (int k = 1; k < this.dimensions.length; ++k) {
                sb.append("x").append(this.dimensions[k]);
            }
            sb.append('\n');
            sb.append(MatrixInfo.DATA_OFFSET_PROPERTY_NAME).append('=').append(this.dataOffset).append('\n');
            for (Map.Entry<String, String> entry : this.additionalProperties.entrySet()) {
                String name = entry.getKey();
                if (!Version1_2.isCorrectAdditionalPropertyName(name)) {
                    throw new AssertionError((Object)("Violation of invariants of " + String.valueOf(this.getClass()) + ": illegal property name \"" + name + "\""));
                }
                String encodedValue = URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8);
                sb.append(name).append('=').append(encodedValue).append('\n');
                if (sb.length() <= 8191) continue;
                throw new IllegalStateException("Too huge set of additional properties in " + String.valueOf(this) + ": summary number of characters is greater than 8192");
            }
            sb.append('\n');
            return sb.toString();
        }
    }
}

