/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.NonConstantMatrixContinuationModeException;
import net.algart.arrays.NotSubMatrixException;
import net.algart.arrays.NotTiledMatrixException;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.IRectangularArea;

public interface Matrix<T extends Array>
extends Cloneable {
    public static final int MAX_DIM_COUNT_FOR_SOME_ALGORITHMS = 9;

    public T array();

    public Class<?> elementType();

    public Object toJavaArray();

    default public byte[] toByte() {
        return this.toByte(null);
    }

    default public byte[] toByte(byte[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toByte(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toByte(result);
    }

    default public char[] toChar() {
        return this.toChar(null);
    }

    default public char[] toChar(char[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toChar(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toChar(result);
    }

    default public short[] toShort() {
        return this.toShort(null);
    }

    default public short[] toShort(short[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toShort(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toShort(result);
    }

    default public int[] toInt() {
        return this.toInt(null);
    }

    default public int[] toInt(int[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toInt(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toInt(result);
    }

    default public long[] toLong() {
        return this.toLong(null);
    }

    default public long[] toLong(long[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toLong(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toLong(result);
    }

    default public float[] toFloat() {
        return this.toFloat(null);
    }

    default public float[] toFloat(float[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toFloat(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toFloat(result);
    }

    default public double[] toDouble() {
        return this.toDouble(null);
    }

    default public double[] toDouble(double[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toDouble(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toDouble(result);
    }

    default public boolean[] toBoolean() {
        return this.toBoolean(null);
    }

    default public boolean[] toBoolean(boolean[] result) {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using toBoolean(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.toBoolean(result);
    }

    public Object ja();

    default public byte[] jaByte() {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using jaByte(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.jaByte();
    }

    default public char[] jaChar() {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using jaChar(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.jaChar();
    }

    default public short[] jaShort() {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using jaShort(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.jaShort();
    }

    default public int[] jaInt() {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using jaInt(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.jaInt();
    }

    default public long[] jaLong() {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using jaLong(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.jaLong();
    }

    default public float[] jaFloat() {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using jaFloat(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.jaFloat();
    }

    default public double[] jaDouble() {
        T t = this.array();
        if (!(t instanceof PArray)) {
            throw new UnsupportedOperationException("Matrix, containing non-primitive (Object) elements, cannot be accessed using jaDouble(): " + String.valueOf(this));
        }
        PArray a = (PArray)t;
        return a.jaDouble();
    }

    default public long size() {
        return this.array().length();
    }

    default public int size32() {
        return this.array().length32();
    }

    default public boolean isEmpty() {
        return this.array().isEmpty();
    }

    public Class<? extends Array> type();

    public Class<? extends UpdatableArray> updatableType();

    public <U extends Array> Class<? extends U> type(Class<U> var1);

    public <U extends Array> Class<? extends U> updatableType(Class<U> var1);

    public boolean isPrimitive();

    public boolean isFloatingPoint();

    public boolean isFixedPoint();

    public boolean isUnsigned();

    public long bitsPerElement();

    public double maxPossibleValue(double var1);

    public double maxPossibleValue();

    public long[] dimensions();

    public int dimCount();

    public long dim(int var1);

    default public int dim32(int n) {
        long result = this.dim(n);
        if (result < 0L) {
            throw new AssertionError((Object)("Negative result " + result + " of dim() method"));
        }
        if (result > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large matrix dimension #" + n + " (" + result + " >= 2^31): " + String.valueOf(this));
        }
        return (int)result;
    }

    default public long dimX() {
        return this.dim(0);
    }

    default public int dimX32() {
        return this.dim32(0);
    }

    default public long dimY() {
        return this.dim(1);
    }

    default public int dimY32() {
        return this.dim32(1);
    }

    default public long dimZ() {
        return this.dim(2);
    }

    default public int dimZ32() {
        return this.dim32(2);
    }

    public boolean dimEquals(Matrix<?> var1);

    public boolean dimEquals(long ... var1);

    public long index(long ... var1);

    public long index(long var1, long var3);

    public long index(long var1, long var3, long var5);

    public long[] coordinates(long var1, long[] var3);

    public long uncheckedIndex(long ... var1);

    public long cyclicIndex(long ... var1);

    public long pseudoCyclicIndex(long ... var1);

    public long mirrorCyclicIndex(long ... var1);

    public boolean inside(long ... var1);

    public boolean inside(long var1, long var3);

    public boolean inside(long var1, long var3, long var5);

    public <U extends Array> Matrix<U> matrix(U var1);

    public <U extends Array> Matrix<U> cast(Class<U> var1);

    public Matrix<T> subMatrix(long[] var1, long[] var2);

    public Matrix<T> subMatrix(IRectangularArea var1);

    public Matrix<T> subMatrix(long var1, long var3, long var5, long var7);

    public Matrix<T> subMatrix(long var1, long var3, long var5, long var7, long var9, long var11);

    public Matrix<T> subMatrix(long[] var1, long[] var2, ContinuationMode var3);

    public Matrix<T> subMatrix(IRectangularArea var1, ContinuationMode var2);

    public Matrix<T> subMatrix(long var1, long var3, long var5, long var7, ContinuationMode var9);

    public Matrix<T> subMatrix(long var1, long var3, long var5, long var7, long var9, long var11, ContinuationMode var13);

    public Matrix<T> subMatr(long[] var1, long[] var2);

    public Matrix<T> subMatr(long var1, long var3, long var5, long var7);

    public Matrix<T> subMatr(long var1, long var3, long var5, long var7, long var9, long var11);

    public Matrix<T> subMatr(long[] var1, long[] var2, ContinuationMode var3);

    public Matrix<T> subMatr(long var1, long var3, long var5, long var7, ContinuationMode var9);

    public Matrix<T> subMatr(long var1, long var3, long var5, long var7, long var9, long var11, ContinuationMode var13);

    public boolean isSubMatrix();

    public Matrix<T> subMatrixParent() throws NotSubMatrixException;

    public long[] subMatrixFrom() throws NotSubMatrixException;

    public long[] subMatrixTo() throws NotSubMatrixException;

    public ContinuationMode subMatrixContinuationMode() throws NotSubMatrixException;

    public Matrix<T> structureLike(Matrix<?> var1);

    public boolean isStructuredLike(Matrix<?> var1);

    public Matrix<T> tile(long ... var1);

    public Matrix<T> tile();

    public boolean isTiled();

    public Matrix<T> tileParent() throws NotTiledMatrixException;

    public long[] tileDimensions() throws NotTiledMatrixException;

    default public List<Matrix<T>> asLayers() {
        return Matrices.asLayers(this);
    }

    public boolean isImmutable();

    public boolean isCopyOnNextWrite();

    public boolean isDirectAccessible();

    public Matrix<T> clone();

    public Matrix<T> clone(ArrayContext var1);

    public void flushResources(ArrayContext var1);

    public void freeResources(ArrayContext var1);

    public void freeResources();

    public String toString();

    public int hashCode();

    public boolean equals(Object var1);

    public static Matrix<UpdatablePArray> newMatrix(MemoryModel memoryModel, Class<?> elementType, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(elementType, "Null element type");
        if (!elementType.isPrimitive()) {
            throw new IllegalArgumentException("Not a primitive type: " + String.valueOf(elementType));
        }
        return memoryModel.newMatrix(UpdatablePArray.class, elementType, dim);
    }

    public static Matrix<UpdatablePArray> newMatrix(Class<?> elementType, long ... dim) {
        return Matrix.newMatrix(Arrays.SMM, elementType, dim);
    }

    public static Matrix<UpdatableBitArray> newBitMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newBitMatrix(dim);
    }

    public static Matrix<UpdatableBitArray> newBitMatrix(long ... dim) {
        return Arrays.SMM.newBitMatrix(dim);
    }

    public static Matrix<UpdatableCharArray> newCharMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newCharMatrix(dim);
    }

    public static Matrix<UpdatableCharArray> newCharMatrix(long ... dim) {
        return Arrays.SMM.newCharMatrix(dim);
    }

    public static Matrix<UpdatableByteArray> newByteMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newByteMatrix(dim);
    }

    public static Matrix<UpdatableByteArray> newByteMatrix(long ... dim) {
        return Arrays.SMM.newByteMatrix(dim);
    }

    public static Matrix<UpdatableShortArray> newShortMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newShortMatrix(dim);
    }

    public static Matrix<UpdatableShortArray> newShortMatrix(long ... dim) {
        return Arrays.SMM.newShortMatrix(dim);
    }

    public static Matrix<UpdatableIntArray> newIntMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newIntMatrix(dim);
    }

    public static Matrix<UpdatableIntArray> newIntMatrix(long ... dim) {
        return Arrays.SMM.newIntMatrix(dim);
    }

    public static Matrix<UpdatableLongArray> newLongMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newLongMatrix(dim);
    }

    public static Matrix<UpdatableLongArray> newLongMatrix(long ... dim) {
        return Arrays.SMM.newLongMatrix(dim);
    }

    public static Matrix<UpdatableFloatArray> newFloatMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newFloatMatrix(dim);
    }

    public static Matrix<UpdatableFloatArray> newFloatMatrix(long ... dim) {
        return Arrays.SMM.newFloatMatrix(dim);
    }

    public static Matrix<UpdatableDoubleArray> newDoubleMatrix(MemoryModel memoryModel, long ... dim) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newDoubleMatrix(dim);
    }

    public static Matrix<UpdatableDoubleArray> newDoubleMatrix(long ... dim) {
        return Arrays.SMM.newDoubleMatrix(dim);
    }

    public static Matrix<UpdatablePArray> as(Object array, long ... dim) {
        return SimpleMemoryModel.asMatrix(array, dim);
    }

    public static class ContinuationMode {
        public static final ContinuationMode NONE = new ContinuationMode("not-continued mode");
        public static final ContinuationMode CYCLIC = new ContinuationMode("cyclically-continued mode");
        public static final ContinuationMode PSEUDO_CYCLIC = new ContinuationMode("pseudo-cyclically-continued mode");
        public static final ContinuationMode MIRROR_CYCLIC = new ContinuationMode("mirroring-cyclically-continued mode");
        public static final ContinuationMode NULL_CONSTANT = ContinuationMode.newConstantImpl(null);
        public static final ContinuationMode ZERO_CONSTANT = ContinuationMode.newConstantImpl(0.0);
        public static final ContinuationMode NAN_CONSTANT = ContinuationMode.newConstantImpl(Double.NaN);
        private final String description;

        public static ContinuationMode getConstantMode(Object continuationConstant) {
            if (continuationConstant == null) {
                return NULL_CONSTANT;
            }
            if (ZERO_CONSTANT.continuationConstant().equals(continuationConstant)) {
                return ZERO_CONSTANT;
            }
            if (NAN_CONSTANT.continuationConstant().equals(continuationConstant)) {
                return NAN_CONSTANT;
            }
            return new ConstantImpl(continuationConstant);
        }

        private ContinuationMode(String description) {
            assert (description != null);
            this.description = description;
        }

        public boolean isConstant() {
            return false;
        }

        public boolean isPrimitiveTypeOrNullConstant() {
            return false;
        }

        public Object continuationConstant() {
            throw new NonConstantMatrixContinuationModeException(String.valueOf(this) + " has no continuation constant");
        }

        public String toString() {
            return this.description;
        }

        public int hashCode() {
            Object constant = this.isConstant() ? this.continuationConstant() : null;
            return this.description.hashCode() ^ (constant != null ? constant.hashCode() : 157);
        }

        public boolean equals(Object o) {
            if (!this.isConstant() || this == o) {
                return this == o;
            }
            if (!(o instanceof ContinuationMode) || !((ContinuationMode)o).isConstant()) {
                return false;
            }
            Object constant = this.continuationConstant();
            return constant == null ? ((ContinuationMode)o).continuationConstant() == null : constant.equals(((ContinuationMode)o).continuationConstant());
        }

        private static ContinuationMode newConstantImpl(Object continuationConstant) {
            return new ConstantImpl(continuationConstant);
        }

        private static class ConstantImpl
        extends ContinuationMode {
            private final Object continuationConstant;
            private final boolean primitiveTypeOrNullConstant;

            ConstantImpl(Object continuationConstant) {
                super("constantly-continued (by " + String.valueOf(continuationConstant) + ") mode");
                this.continuationConstant = continuationConstant;
                this.primitiveTypeOrNullConstant = continuationConstant == null || continuationConstant instanceof Boolean || continuationConstant instanceof Character || continuationConstant instanceof Byte || continuationConstant instanceof Short || continuationConstant instanceof Integer || continuationConstant instanceof Long || continuationConstant instanceof Float || continuationConstant instanceof Double;
            }

            @Override
            public boolean isConstant() {
                return true;
            }

            @Override
            public Object continuationConstant() {
                return this.continuationConstant;
            }

            @Override
            public boolean isPrimitiveTypeOrNullConstant() {
                return this.primitiveTypeOrNullConstant;
            }
        }
    }
}

