/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteOrder;
import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataByteBuffer;
import net.algart.arrays.DataCharBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DataIntBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.DataObjectBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.MutableCharArray;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.MutableObjectArray;
import net.algart.arrays.MutableShortArray;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.functions.Func;

class CopiesArraysImpl {
    CopiesArraysImpl() {
    }

    static class CopiesObjectArray<E>
    implements ObjectArray<E>,
    CopiesArray {
        final long length;
        final E element;
        Class<?> elementType = Object.class;

        CopiesObjectArray(long length, E element) {
            this.length = length;
            this.element = element;
        }

        @Override
        public Class<E> elementType() {
            return (Class)InternalUtils.cast(this.element == null ? this.elementType : this.element.getClass());
        }

        @Override
        public Class<? extends ObjectArray<E>> type() {
            return (Class)InternalUtils.cast(ObjectArray.class);
        }

        @Override
        public Class<? extends UpdatableObjectArray<E>> updatableType() {
            return (Class)InternalUtils.cast(UpdatableObjectArray.class);
        }

        @Override
        public Class<? extends MutableObjectArray<E>> mutableType() {
            return (Class)InternalUtils.cast(MutableObjectArray.class);
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillObjectArray((Object[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            Object[] dest = (Object[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillObjectArray(dest, 0, count, this.element);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesObjectArray<E>(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesObjectArray<E>(count, this.element);
        }

        @Override
        public DataObjectBuffer<E> buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataObjectBuffer)InternalUtils.cast(AbstractArray.defaultBuffer(this, mode, capacity));
        }

        @Override
        public DataObjectBuffer<E> buffer(DataBuffer.AccessMode mode) {
            return (DataObjectBuffer)InternalUtils.cast(this.buffer(mode, AbstractArray.defaultBufferCapacity(this)));
        }

        @Override
        public DataObjectBuffer<E> buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataObjectBuffer<E> buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ObjectArray<E> asImmutable() {
            return this;
        }

        @Override
        public ObjectArray<E> asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesObjectArray<E>(this.length, this.element);
        }

        @Override
        public MutableObjectArray<E> mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableObjectArray)InternalUtils.cast(memoryModel.newArray(this).copy(this));
        }

        @Override
        public UpdatableObjectArray<E> updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableObjectArray)InternalUtils.cast(memoryModel.newUnresizableArray(this).copy(this));
        }

        @Override
        public E[] ja() {
            return this.toJavaArray();
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && Objects.equals(value, this.element) ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && Objects.equals(value, this.element) ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public String toString() {
            return this.length + " copies of " + this.elementType().getName() + " value " + String.valueOf(this.element);
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectArray)) {
                return false;
            }
            ObjectArray a = (ObjectArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesObjectArray) {
                E e = ((CopiesObjectArray)a).element;
                return Objects.equals(e, this.element);
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public E get(long index) {
            return (E)InternalUtils.cast(this.getElement(index));
        }

        @Override
        public <D> ObjectArray<D> cast(Class<D> elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType())) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return (ObjectArray)InternalUtils.cast(this);
        }
    }

    static class CopiesDoubleArray
    implements DoubleArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        private final long length;
        private final double element;
        private final Func f;
        private final boolean truncateOverflows;

        CopiesDoubleArray(long length, double element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesDoubleArray(long length, double element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Double.TYPE;
        }

        @Override
        public Class<? extends DoubleArray> type() {
            return DoubleArray.class;
        }

        @Override
        public Class<? extends UpdatableDoubleArray> updatableType() {
            return UpdatableDoubleArray.class;
        }

        @Override
        public Class<? extends MutableDoubleArray> mutableType() {
            return MutableDoubleArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillDoubleArray((double[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            double[] dest = (double[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillDoubleArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || this.element == 0.0;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesDoubleArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesDoubleArray(count, this.element);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataDoubleBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataDoubleBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataDoubleBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public DoubleArray asImmutable() {
            return this;
        }

        @Override
        public DoubleArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesDoubleArray(this.length, this.element);
        }

        @Override
        public MutableDoubleArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableDoubleArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableDoubleArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableDoubleArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public double[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 64L;
        }

        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return (long)this.element;
        }

        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return (int)this.element;
        }

        public long indexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.indexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.lastIndexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of double value " + this.element;
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof DoubleArray)) {
                return false;
            }
            DoubleArray a = (DoubleArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesDoubleArray) {
                double e = ((CopiesDoubleArray)a).element;
                return Double.doubleToLongBits(e) == Double.doubleToLongBits(this.element);
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }
    }

    static class CopiesLongArray
    implements LongArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        private final long length;
        private final long element;
        private final Func f;
        private final boolean truncateOverflows;

        CopiesLongArray(long length, long element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesLongArray(long length, long element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Long.TYPE;
        }

        @Override
        public Class<? extends LongArray> type() {
            return LongArray.class;
        }

        @Override
        public Class<? extends UpdatableLongArray> updatableType() {
            return UpdatableLongArray.class;
        }

        @Override
        public Class<? extends MutableLongArray> mutableType() {
            return MutableLongArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillLongArray((long[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            long[] dest = (long[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillLongArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || this.element == 0L;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesLongArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesLongArray(count, this.element);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataLongBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataLongBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataLongBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public LongArray asImmutable() {
            return this;
        }

        @Override
        public LongArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesLongArray(this.length, this.element);
        }

        @Override
        public MutableLongArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableLongArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableLongArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableLongArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public long[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 64L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.indexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.lastIndexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return Arrays.truncateLongToInt(this.element);
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of long value " + this.element;
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LongArray)) {
                return false;
            }
            LongArray a = (LongArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesLongArray) {
                long e = ((CopiesLongArray)a).element;
                return e == this.element;
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public long maxPossibleValue() {
            return Long.MAX_VALUE;
        }
    }

    static class CopiesIntArray
    implements IntArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        private final long length;
        private final int element;
        private final Func f;
        private final boolean truncateOverflows;

        CopiesIntArray(long length, int element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesIntArray(long length, int element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Integer.TYPE;
        }

        @Override
        public Class<? extends IntArray> type() {
            return IntArray.class;
        }

        @Override
        public Class<? extends UpdatableIntArray> updatableType() {
            return UpdatableIntArray.class;
        }

        @Override
        public Class<? extends MutableIntArray> mutableType() {
            return MutableIntArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillIntArray((int[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            int[] dest = (int[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillIntArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || this.element == 0;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesIntArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesIntArray(count, this.element);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataIntBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataIntBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataIntBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public IntArray asImmutable() {
            return this;
        }

        @Override
        public IntArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesIntArray(this.length, this.element);
        }

        @Override
        public MutableIntArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableIntArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableIntArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableIntArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public int[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 32L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of int value " + this.element;
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof IntArray)) {
                return false;
            }
            IntArray a = (IntArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesIntArray) {
                int e = ((CopiesIntArray)a).element;
                return e == this.element;
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public long maxPossibleValue() {
            return Integer.MAX_VALUE;
        }
    }

    static class CopiesShortArray
    implements ShortArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        private final long length;
        private final short element;
        private final Func f;
        private final boolean truncateOverflows;

        CopiesShortArray(long length, short element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesShortArray(long length, short element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Short.TYPE;
        }

        @Override
        public Class<? extends ShortArray> type() {
            return ShortArray.class;
        }

        @Override
        public Class<? extends UpdatableShortArray> updatableType() {
            return UpdatableShortArray.class;
        }

        @Override
        public Class<? extends MutableShortArray> mutableType() {
            return MutableShortArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillShortArray((short[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            short[] dest = (short[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillShortArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFFFF;
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || this.element == 0;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesShortArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesShortArray(count, this.element);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataShortBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataShortBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataShortBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ShortArray asImmutable() {
            return this;
        }

        @Override
        public ShortArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesShortArray(this.length, this.element);
        }

        @Override
        public MutableShortArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableShortArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableShortArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableShortArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public short[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 16L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFFFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFFFF;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFFFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFFFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of short value " + this.element + (String)(this.element >= 0 ? "" : "=(short)" + (this.element & 0xFFFF));
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ShortArray)) {
                return false;
            }
            ShortArray a = (ShortArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesShortArray) {
                short e = ((CopiesShortArray)a).element;
                return e == this.element;
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 65535L;
        }
    }

    static class CopiesByteArray
    implements ByteArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        private final long length;
        private final byte element;
        private final Func f;
        private final boolean truncateOverflows;

        CopiesByteArray(long length, byte element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesByteArray(long length, byte element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Byte.TYPE;
        }

        @Override
        public Class<? extends ByteArray> type() {
            return ByteArray.class;
        }

        @Override
        public Class<? extends UpdatableByteArray> updatableType() {
            return UpdatableByteArray.class;
        }

        @Override
        public Class<? extends MutableByteArray> mutableType() {
            return MutableByteArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillByteArray((byte[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            byte[] dest = (byte[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillByteArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFF;
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || this.element == 0;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesByteArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesByteArray(count, this.element);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataByteBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataByteBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataByteBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ByteArray asImmutable() {
            return this;
        }

        @Override
        public ByteArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesByteArray(this.length, this.element);
        }

        @Override
        public MutableByteArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableByteArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableByteArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableByteArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public byte[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 8L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFF;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element & 0xFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of byte value " + this.element + (String)(this.element >= 0 ? "" : "=(byte)" + (this.element & 0xFF));
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ByteArray)) {
                return false;
            }
            ByteArray a = (ByteArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesByteArray) {
                byte e = ((CopiesByteArray)a).element;
                return e == this.element;
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 255L;
        }
    }

    static class CopiesCharArray
    implements CharArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        private final long length;
        private final char element;
        private final Func f;
        private final boolean truncateOverflows;

        CopiesCharArray(long length, char element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesCharArray(long length, char element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Character.TYPE;
        }

        @Override
        public Class<? extends CharArray> type() {
            return CharArray.class;
        }

        @Override
        public Class<? extends UpdatableCharArray> updatableType() {
            return UpdatableCharArray.class;
        }

        @Override
        public Class<? extends MutableCharArray> mutableType() {
            return MutableCharArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillCharArray((char[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            char[] dest = (char[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillCharArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return Character.valueOf(this.element);
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || this.element == '\u0000';
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesCharArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesCharArray(count, this.element);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataCharBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataCharBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataCharBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public CharArray asImmutable() {
            return this;
        }

        @Override
        public CharArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesCharArray(this.length, this.element);
        }

        @Override
        public MutableCharArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableCharArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableCharArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableCharArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public char[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 16L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of char value (char)" + this.element;
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof CharArray)) {
                return false;
            }
            CharArray a = (CharArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesCharArray) {
                char e = ((CopiesCharArray)a).element;
                return e == this.element;
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 65535L;
        }
    }

    static class CopiesBitArray
    implements BitArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        final long length;
        final boolean element;
        final Func f;
        final boolean truncateOverflows;

        CopiesBitArray(long length, boolean element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesBitArray(long length, boolean element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Boolean.TYPE;
        }

        @Override
        public Class<? extends BitArray> type() {
            return BitArray.class;
        }

        @Override
        public Class<? extends UpdatableBitArray> updatableType() {
            return UpdatableBitArray.class;
        }

        @Override
        public Class<? extends MutableBitArray> mutableType() {
            return MutableBitArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillBooleanArray((boolean[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            boolean[] dest = (boolean[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillBooleanArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || !this.element;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesBitArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesBitArray(count, this.element);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataBitBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataBitBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataBitBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public BitArray asImmutable() {
            return this;
        }

        @Override
        public BitArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesBitArray(this.length, this.element);
        }

        @Override
        public MutableBitArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableBitArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableBitArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableBitArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public boolean[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 1L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element ? 1.0 : 0.0;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.indexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.lastIndexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element ? 1L : 0L;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element ? 1 : 0;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.indexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.lastIndexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of boolean value " + this.element;
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof BitArray)) {
                return false;
            }
            BitArray a = (BitArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesBitArray) {
                boolean e = ((CopiesBitArray)a).element;
                return e == this.element;
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 1L;
        }

        @Override
        public long getBits64(long arrayPos, int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            return this.element && count > 0 ? (2L << count - 1) - 1L : 0L;
        }

        @Override
        public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - count) {
                throw AbstractArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
            }
            PackedBitArrays.fillBits(destArray, destArrayOffset, count, this.element);
        }

        @Override
        public long nextQuickPosition(long position) {
            return position >= this.length ? -1L : (position < 0L ? 0L : position);
        }
    }

    static class CopiesFloatArray
    implements FloatArray,
    CopiesArray,
    ArraysFuncImpl.FuncArray {
        private final long length;
        private final float element;
        private final Func f;
        private final boolean truncateOverflows;

        CopiesFloatArray(long length, float element) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = false;
            this.f = null;
        }

        CopiesFloatArray(long length, float element, boolean truncateOverflows, Func f) {
            this.length = length;
            this.element = element;
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public Class<?> elementType() {
            return Float.TYPE;
        }

        @Override
        public Class<? extends FloatArray> type() {
            return FloatArray.class;
        }

        @Override
        public Class<? extends UpdatableFloatArray> updatableType() {
            return UpdatableFloatArray.class;
        }

        @Override
        public Class<? extends MutableFloatArray> mutableType() {
            return MutableFloatArray.class;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long capacity() {
            return this.length;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - (long)count) {
                throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.getClass());
            }
            JArrays.fillFloatArray((float[])destArray, destArrayOffset, count, this.element);
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            float[] dest = (float[])destArray;
            if (arrayPos < 0L || arrayPos > this.length) {
                throw AbstractArray.rangeException(arrayPos, this.length, this.getClass());
            }
            int count = dest.length;
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            JArrays.fillFloatArray(dest, 0, count, this.element);
        }

        @Override
        public Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return Float.valueOf(this.element);
        }

        @Override
        public boolean isZeroFilled() {
            return this.length == 0L || this.element == 0.0f;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
            }
            if (toIndex > this.length()) {
                throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new CopiesFloatArray(toIndex - fromIndex, this.element);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw AbstractArray.rangeException(position, this.length(), this.getClass());
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length() - count) {
                throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
            }
            return new CopiesFloatArray(count, this.element);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataFloatBuffer)AbstractArray.defaultBuffer(this, mode, capacity);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode) {
            return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
        }

        @Override
        public DataFloatBuffer buffer(long capacity) {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
        }

        @Override
        public DataFloatBuffer buffer() {
            return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public FloatArray asImmutable() {
            return this;
        }

        @Override
        public FloatArray asTrustedImmutable() {
            return this;
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return false;
        }

        @Override
        public boolean isNew() {
            return true;
        }

        @Override
        public boolean isNewReadOnlyView() {
            return false;
        }

        @Override
        public boolean isLazy() {
            return false;
        }

        @Override
        public ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        public Array shallowClone() {
            return new CopiesFloatArray(this.length, this.element);
        }

        @Override
        public MutableFloatArray mutableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (MutableFloatArray)memoryModel.newArray(this).copy(this);
        }

        @Override
        public UpdatableFloatArray updatableClone(MemoryModel memoryModel) {
            Objects.requireNonNull(memoryModel, "Null memory model");
            return (UpdatableFloatArray)memoryModel.newUnresizableArray(this).copy(this);
        }

        @Override
        public float[] ja() {
            return this.toJavaArray();
        }

        @Override
        public long bitsPerElement() {
            return 32L;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return (long)this.element;
        }

        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return (int)this.element;
        }

        public long indexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw AbstractArray.rangeException(index, this.length, this.getClass());
            }
            return this.element;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? lowIndex : -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            return lowIndex < highIndex && value == this.element ? highIndex - 1L : -1L;
        }

        @Override
        public void loadResources(ArrayContext context) {
        }

        @Override
        public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public String toString() {
            return this.length + " copies of float value " + this.element;
        }

        @Override
        public int hashCode() {
            return AbstractArray.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FloatArray)) {
                return false;
            }
            FloatArray a = (FloatArray)obj;
            long n = this.length;
            if (a.length() != n) {
                return false;
            }
            if (n == 0L && a.isEmpty()) {
                return true;
            }
            if (a instanceof CopiesFloatArray) {
                float e = ((CopiesFloatArray)a).element;
                return Float.floatToIntBits(e) == Float.floatToIntBits(this.element);
            }
            return AbstractArray.equals(this, a);
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }
    }

    static interface CopiesArray {
    }
}

