/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.math.functions.LinearFunc;

public class ColorMatrices {
    public static final double INTENSITY_R_WEIGHT = 0.299;
    public static final double INTENSITY_B_WEIGHT = 0.114;
    public static final double INTENSITY_G_WEIGHT = 0.587;

    private ColorMatrices() {
    }

    public static Matrix<? extends PArray> toRGBIntensity(List<? extends Matrix<? extends PArray>> channels) {
        Objects.requireNonNull(channels, "Null color channels");
        return channels.size() < 3 ? channels.get(0) : ColorMatrices.asRGBIntensity(channels.get(0), channels.get(1), channels.get(2)).clone(ArrayContext.DEFAULT_SINGLE_THREAD);
    }

    public static Matrix<? extends PArray> asRGBIntensity(List<? extends Matrix<? extends PArray>> channels) {
        Objects.requireNonNull(channels, "Null color channels");
        return channels.size() < 3 ? channels.get(0) : ColorMatrices.asRGBIntensity(channels.get(0), channels.get(1), channels.get(2));
    }

    public static Matrix<? extends PArray> asRGBIntensity(Matrix<? extends PArray> r, Matrix<? extends PArray> g, Matrix<? extends PArray> b) {
        Objects.requireNonNull(r, "Null r matrix");
        Objects.requireNonNull(g, "Null g matrix");
        Objects.requireNonNull(b, "Null b matrix");
        if (g.type() == r.type() && g.type() == r.type()) {
            return ColorMatrices.asRGBIntensity(g.type(PArray.class), r, g, b);
        }
        if (r.array().bitsPerElement() <= 8L && g.array().bitsPerElement() <= 8L && b.array().bitsPerElement() <= 8L) {
            return ColorMatrices.asRGBIntensity(ByteArray.class, r, g, b);
        }
        if (r.array().bitsPerElement() <= 16L && g.array().bitsPerElement() <= 16L && b.array().bitsPerElement() <= 16L) {
            return ColorMatrices.asRGBIntensity(ShortArray.class, r, g, b);
        }
        return ColorMatrices.asRGBIntensity(FloatArray.class, r, g, b);
    }

    public static <T extends PArray> Matrix<T> asRGBIntensity(Class<T> resultType, Matrix<? extends PArray> r, Matrix<? extends PArray> g, Matrix<? extends PArray> b) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(r, "Null r matrix");
        Objects.requireNonNull(g, "Null g matrix");
        Objects.requireNonNull(b, "Null b matrix");
        if (r.type() == resultType && g.type() == resultType && g.type() == resultType) {
            double increment = r.isFloatingPoint() ? 0.0 : 0.5;
            return Matrices.asFuncMatrix(LinearFunc.getInstance(increment, 0.299, 0.587, 0.114), resultType, r, g, b);
        }
        double scale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix(LinearFunc.getInstance(0.0, 0.299 * scale / Arrays.maxPossibleValue(r.type(), 1.0), 0.587 * scale / Arrays.maxPossibleValue(g.type(), 1.0), 0.114 * scale / Arrays.maxPossibleValue(b.type(), 1.0)), resultType, r, g, b);
    }

    public static <T extends PArray> Matrix<T> asHue(Class<T> resultType, Matrix<? extends PArray> r, Matrix<? extends PArray> g, Matrix<? extends PArray> b) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(r, "Null r matrix");
        Objects.requireNonNull(g, "Null g matrix");
        Objects.requireNonNull(b, "Null b matrix");
        double rScaleInv = 1.0 / r.array().maxPossibleValue(1.0);
        double gScaleInv = 1.0 / g.array().maxPossibleValue(1.0);
        double bScaleInv = 1.0 / b.array().maxPossibleValue(1.0);
        double scale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> scale * ColorMatrices.rgbToHue(x0 * rScaleInv, x1 * gScaleInv, x2 * bScaleInv), resultType, r, g, b);
    }

    public static <T extends PArray> Matrix<T> asHSVSaturation(Class<T> resultType, Matrix<? extends PArray> r, Matrix<? extends PArray> g, Matrix<? extends PArray> b) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(r, "Null r matrix");
        Objects.requireNonNull(g, "Null g matrix");
        Objects.requireNonNull(b, "Null b matrix");
        double rScaleInv = 1.0 / r.array().maxPossibleValue(1.0);
        double gScaleInv = 1.0 / g.array().maxPossibleValue(1.0);
        double bScaleInv = 1.0 / b.array().maxPossibleValue(1.0);
        double scale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> scale * ColorMatrices.rgbToSaturationHsv(x0 * rScaleInv, x1 * gScaleInv, x2 * bScaleInv), resultType, r, g, b);
    }

    public static <T extends PArray> Matrix<T> asHSVValue(Class<T> resultType, Matrix<? extends PArray> r, Matrix<? extends PArray> g, Matrix<? extends PArray> b) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(r, "Null r matrix");
        Objects.requireNonNull(g, "Null g matrix");
        Objects.requireNonNull(b, "Null b matrix");
        double rScaleInv = 1.0 / r.array().maxPossibleValue(1.0);
        double gScaleInv = 1.0 / g.array().maxPossibleValue(1.0);
        double bScaleInv = 1.0 / b.array().maxPossibleValue(1.0);
        double scale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> scale * ColorMatrices.rgbToValue(x0 * rScaleInv, x1 * gScaleInv, x2 * bScaleInv), resultType, r, g, b);
    }

    public static <T extends PArray> Matrix<T> asHSLSaturation(Class<T> resultType, Matrix<? extends PArray> r, Matrix<? extends PArray> g, Matrix<? extends PArray> b) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(r, "Null r matrix");
        Objects.requireNonNull(g, "Null g matrix");
        Objects.requireNonNull(b, "Null b matrix");
        double rScaleInv = 1.0 / r.array().maxPossibleValue(1.0);
        double gScaleInv = 1.0 / g.array().maxPossibleValue(1.0);
        double bScaleInv = 1.0 / b.array().maxPossibleValue(1.0);
        double scale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> scale * ColorMatrices.rgbToSaturationHsl(x0 * rScaleInv, x1 * gScaleInv, x2 * bScaleInv), resultType, r, g, b);
    }

    public static <T extends PArray> Matrix<T> asHSLLightness(Class<T> resultType, Matrix<? extends PArray> r, Matrix<? extends PArray> g, Matrix<? extends PArray> b) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(r, "Null r matrix");
        Objects.requireNonNull(g, "Null g matrix");
        Objects.requireNonNull(b, "Null b matrix");
        double rScaleInv = 1.0 / r.array().maxPossibleValue(1.0);
        double gScaleInv = 1.0 / g.array().maxPossibleValue(1.0);
        double bScaleInv = 1.0 / b.array().maxPossibleValue(1.0);
        double scale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> scale * ColorMatrices.rgbToLightness(x0 * rScaleInv, x1 * gScaleInv, x2 * bScaleInv), resultType, r, g, b);
    }

    public static <T extends PArray> Matrix<T> asRedFromHSV(Class<T> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> value) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(value, "Null value matrix");
        double hScaleInv = 1.0 / hue.array().maxPossibleValue(1.0);
        double sScaleInv = 1.0 / saturation.array().maxPossibleValue(1.0);
        double vScaleInv = 1.0 / value.array().maxPossibleValue(1.0);
        double resultScale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> resultScale * ColorMatrices.hsvToRed(x0 * hScaleInv, x1 * sScaleInv, x2 * vScaleInv), resultType, hue, saturation, value);
    }

    public static <T extends PArray> Matrix<T> asGreenFromHSV(Class<T> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> value) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(value, "Null value matrix");
        double hScaleInv = 1.0 / hue.array().maxPossibleValue(1.0);
        double sScaleInv = 1.0 / saturation.array().maxPossibleValue(1.0);
        double vScaleInv = 1.0 / value.array().maxPossibleValue(1.0);
        double resultScale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> resultScale * ColorMatrices.hsvToGreen(x0 * hScaleInv, x1 * sScaleInv, x2 * vScaleInv), resultType, hue, saturation, value);
    }

    public static <T extends PArray> Matrix<T> asBlueFromHSV(Class<T> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> value) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(value, "Null value matrix");
        double hScaleInv = 1.0 / hue.array().maxPossibleValue(1.0);
        double sScaleInv = 1.0 / saturation.array().maxPossibleValue(1.0);
        double vScaleInv = 1.0 / value.array().maxPossibleValue(1.0);
        double resultScale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> resultScale * ColorMatrices.hsvToBlue(x0 * hScaleInv, x1 * sScaleInv, x2 * vScaleInv), resultType, hue, saturation, value);
    }

    public static <T extends PArray> Matrix<T> asRedFromHSL(Class<T> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> lightness) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(lightness, "Null lightness matrix");
        double hScaleInv = 1.0 / hue.array().maxPossibleValue(1.0);
        double sScaleInv = 1.0 / saturation.array().maxPossibleValue(1.0);
        double lScaleInv = 1.0 / lightness.array().maxPossibleValue(1.0);
        double resultScale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> resultScale * ColorMatrices.hslToRed(x0 * hScaleInv, x1 * sScaleInv, x2 * lScaleInv), resultType, hue, saturation, lightness);
    }

    public static <T extends PArray> Matrix<T> asGreenFromHSL(Class<T> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> lightness) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(lightness, "Null lightness matrix");
        double hScaleInv = 1.0 / hue.array().maxPossibleValue(1.0);
        double sScaleInv = 1.0 / saturation.array().maxPossibleValue(1.0);
        double lScaleInv = 1.0 / lightness.array().maxPossibleValue(1.0);
        double resultScale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> resultScale * ColorMatrices.hslToGreen(x0 * hScaleInv, x1 * sScaleInv, x2 * lScaleInv), resultType, hue, saturation, lightness);
    }

    public static <T extends PArray> Matrix<T> asBlueFromHSL(Class<T> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> lightness) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(lightness, "Null lightness matrix");
        double hScaleInv = 1.0 / hue.array().maxPossibleValue(1.0);
        double sScaleInv = 1.0 / saturation.array().maxPossibleValue(1.0);
        double lScaleInv = 1.0 / lightness.array().maxPossibleValue(1.0);
        double resultScale = Arrays.maxPossibleValue(resultType, 1.0);
        return Matrices.asFuncMatrix((x0, x1, x2) -> resultScale * ColorMatrices.hslToBlue(x0 * hScaleInv, x1 * sScaleInv, x2 * lScaleInv), resultType, hue, saturation, lightness);
    }

    public static List<Matrix<? extends PArray>> asRGBFromHSV(Class<? extends PArray> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> value) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(value, "Null value matrix");
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        result.add(ColorMatrices.asRedFromHSV(resultType, hue, saturation, value));
        result.add(ColorMatrices.asGreenFromHSV(resultType, hue, saturation, value));
        result.add(ColorMatrices.asBlueFromHSV(resultType, hue, saturation, value));
        return result;
    }

    public static List<Matrix<? extends PArray>> asRGBFromHSL(Class<? extends PArray> resultType, Matrix<? extends PArray> hue, Matrix<? extends PArray> saturation, Matrix<? extends PArray> lightness) {
        Objects.requireNonNull(resultType, "Null resultType");
        Objects.requireNonNull(hue, "Null hue matrix");
        Objects.requireNonNull(saturation, "Null saturation matrix");
        Objects.requireNonNull(lightness, "Null lightness matrix");
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        result.add(ColorMatrices.asRedFromHSL(resultType, hue, saturation, lightness));
        result.add(ColorMatrices.asGreenFromHSL(resultType, hue, saturation, lightness));
        result.add(ColorMatrices.asBlueFromHSL(resultType, hue, saturation, lightness));
        return result;
    }

    public static double rgbToHue(double r, double g, double b) {
        double cMin;
        double cMax = Math.max(r, g);
        if (b > cMax) {
            cMax = b;
        }
        if (b < (cMin = Math.min(r, g))) {
            cMin = b;
        }
        if (cMin == cMax) {
            return 0.0;
        }
        double hue = r == cMax ? (g - b) / (cMax - cMin) : (g == cMax ? 2.0 + (b - r) / (cMax - cMin) : 4.0 + (r - g) / (cMax - cMin));
        if ((hue *= 0.16666666666666666) < 0.0) {
            hue += 1.0;
        }
        return hue;
    }

    public static double rgbToSaturationHsv(double r, double g, double b) {
        double cMin;
        double cMax = Math.max(r, g);
        if (b > cMax) {
            cMax = b;
        }
        if (b < (cMin = Math.min(r, g))) {
            cMin = b;
        }
        if (cMax == 0.0) {
            return 0.0;
        }
        return (cMax - cMin) / cMax;
    }

    public static double rgbToValue(double r, double g, double b) {
        double rgMax = Math.max(r, g);
        return Math.max(b, rgMax);
    }

    public static double rgbToSaturationHsl(double r, double g, double b) {
        double cMin;
        double cMax = Math.max(r, g);
        if (b > cMax) {
            cMax = b;
        }
        if (b < (cMin = Math.min(r, g))) {
            cMin = b;
        }
        double sum = cMax + cMin;
        double diff = cMax - cMin;
        if (sum == 0.0 || diff == 0.0) {
            return 0.0;
        }
        if (sum == 2.0) {
            return 1.0;
        }
        if (sum <= 1.0) {
            return diff / sum;
        }
        return diff / (2.0 - sum);
    }

    public static double rgbToLightness(double r, double g, double b) {
        double cMin;
        double cMax = Math.max(r, g);
        if (b > cMax) {
            cMax = b;
        }
        if (b < (cMin = Math.min(r, g))) {
            cMin = b;
        }
        return 0.5 * (cMax + cMin);
    }

    public static double hsvToRed(double h, double s, double v) {
        if (s == 0.0) {
            return v;
        }
        h = (h - StrictMath.floor(h)) * 6.0;
        return switch ((int)h) {
            case 0, 5 -> v;
            case 1 -> v * (1.0 - s * (h - StrictMath.floor(h)));
            case 2, 3 -> v * (1.0 - s);
            case 4 -> v * (1.0 - s * (1.0 - (h - StrictMath.floor(h))));
            default -> 0.0;
        };
    }

    public static double hsvToGreen(double h, double s, double v) {
        if (s == 0.0) {
            return v;
        }
        h = (h - StrictMath.floor(h)) * 6.0;
        return switch ((int)h) {
            case 0 -> v * (1.0 - s * (1.0 - (h - StrictMath.floor(h))));
            case 1, 2 -> v;
            case 3 -> v * (1.0 - s * (h - StrictMath.floor(h)));
            case 4, 5 -> v * (1.0 - s);
            default -> 0.0;
        };
    }

    public static double hsvToBlue(double h, double s, double v) {
        if (v == 0.0) {
            return v;
        }
        h = (h - StrictMath.floor(h)) * 6.0;
        return switch ((int)h) {
            case 0, 1 -> v * (1.0 - s);
            case 2 -> v * (1.0 - s * (1.0 - (h - StrictMath.floor(h))));
            case 3, 4 -> v;
            case 5 -> v * (1.0 - s * (h - StrictMath.floor(h)));
            default -> 0.0;
        };
    }

    public static double hslToRed(double h, double s, double l) {
        if (s == 0.0) {
            return l;
        }
        double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double p = 2.0 * l - q;
        h += 0.3333333333333333;
        h = (h - StrictMath.floor(h)) * 6.0;
        return switch ((int)h) {
            case 0 -> p + (q - p) * h;
            case 1, 2 -> q;
            case 3 -> p + (q - p) * (4.0 - h);
            case 4, 5 -> p;
            default -> 0.0;
        };
    }

    public static double hslToGreen(double h, double s, double l) {
        if (s == 0.0) {
            return l;
        }
        double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double p = 2.0 * l - q;
        h = (h - StrictMath.floor(h)) * 6.0;
        return switch ((int)h) {
            case 0 -> p + (q - p) * h;
            case 1, 2 -> q;
            case 3 -> p + (q - p) * (4.0 - h);
            case 4, 5 -> p;
            default -> 0.0;
        };
    }

    public static double hslToBlue(double h, double s, double l) {
        if (s == 0.0) {
            return l;
        }
        double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double p = 2.0 * l - q;
        h -= 0.3333333333333333;
        h = (h - StrictMath.floor(h)) * 6.0;
        return switch ((int)h) {
            case 0 -> p + (q - p) * h;
            case 1, 2 -> q;
            case 3 -> p + (q - p) * (4.0 - h);
            case 4, 5 -> p;
            default -> 0.0;
        };
    }
}

