/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractBitArray;
import net.algart.arrays.AbstractByteArray;
import net.algart.arrays.AbstractCharArray;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.AbstractFloatArray;
import net.algart.arrays.AbstractIntArray;
import net.algart.arrays.AbstractLongArray;
import net.algart.arrays.AbstractObjectArray;
import net.algart.arrays.AbstractShortArray;
import net.algart.arrays.AbstractUpdatableBitArray;
import net.algart.arrays.AbstractUpdatableByteArray;
import net.algart.arrays.AbstractUpdatableCharArray;
import net.algart.arrays.AbstractUpdatableDoubleArray;
import net.algart.arrays.AbstractUpdatableFloatArray;
import net.algart.arrays.AbstractUpdatableIntArray;
import net.algart.arrays.AbstractUpdatableLongArray;
import net.algart.arrays.AbstractUpdatableObjectArray;
import net.algart.arrays.AbstractUpdatableShortArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;

class ArraysTileMatrixImpl {
    private static final boolean DEBUG_MODE = false;

    ArraysTileMatrixImpl() {
    }

    public static boolean isPowerOfTwo(long[] tileDim) {
        for (long d : tileDim) {
            if ((d & d - 1L) == 0L) continue;
            return false;
        }
        return true;
    }

    private static class IndexerForPowerOfTwo3D
    extends IndexerForPowerOfTwo {
        final long baseDimXY;

        IndexerForPowerOfTwo3D(Array baseArray, long[] baseDim, long[] tileDim) {
            super(baseArray, baseDim, tileDim);
            assert (this.n == 3);
            this.baseDimXY = this.baseDimMul[2];
        }

        @Override
        long translate(long index) {
            assert (index >= 0L);
            long a = index;
            long coordZ = a / this.baseDimXY;
            long coordY = (a -= coordZ * this.baseDimXY) / this.baseDim[0];
            long coordX = a - coordY * this.baseDim[0];
            long cStartX = coordX & (this.tileDimMask[0] ^ 0xFFFFFFFFFFFFFFFFL);
            long cStartY = coordY & (this.tileDimMask[1] ^ 0xFFFFFFFFFFFFFFFFL);
            long cStartZ = coordZ & (this.tileDimMask[2] ^ 0xFFFFFFFFFFFFFFFFL);
            long restX = this.baseDim[0] - cStartX;
            long currentTileDimX = Math.min(this.tileDim[0], restX);
            long restY = this.baseDim[1] - cStartY;
            long currentTileDimY = Math.min(this.tileDim[1], restY);
            long restZ = this.baseDim[2] - cStartZ;
            long currentTileDimZ = Math.min(this.tileDim[2], restZ);
            long previousVolume = this.baseDimXY * cStartZ + this.baseDim[0] * cStartY * currentTileDimZ + cStartX * currentTileDimY * currentTileDimZ;
            long indexInTile = ((coordZ - cStartZ) * currentTileDimY + (coordY - cStartY)) * currentTileDimX + (coordX - cStartX);
            long indexInBase = previousVolume + indexInTile;
            assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase < this.baseLength) : "A bug in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
            return indexInBase;
        }
    }

    private static class IndexerForPowerOfTwo2D
    extends IndexerForPowerOfTwo {
        IndexerForPowerOfTwo2D(Array baseArray, long[] baseDim, long[] tileDim) {
            super(baseArray, baseDim, tileDim);
            assert (this.n == 2);
        }

        @Override
        long translate(long index) {
            assert (index >= 0L);
            long coordY = index / this.baseDim0;
            long coordX = index - coordY * this.baseDim0;
            long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
            long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
            long restX = this.baseDim0 - cStartX;
            long currentTileDimX = Math.min(this.tileDim0, restX);
            long restY = this.baseDimLast - cStartY;
            long currentTileDimY = Math.min(this.tileDimLast, restY);
            long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
            long indexInTile = (coordY - cStartY) * currentTileDimX + (coordX - cStartX);
            long indexInBase = previousVolume + indexInTile;
            assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase < this.baseLength) : "A bug in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
            return indexInBase;
        }

        @Override
        public long indexOfBit(long lowIndex, long highIndex, boolean value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillBits(long position, long count, boolean value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseBitArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfChar(long lowIndex, long highIndex, char value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillChars(long position, long count, char value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseCharArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfByte(long lowIndex, long highIndex, byte value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillBytes(long position, long count, byte value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseByteArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfShort(long lowIndex, long highIndex, short value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillShorts(long position, long count, short value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseShortArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfInt(long lowIndex, long highIndex, int value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillInts(long position, long count, int value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseIntArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfLong(long lowIndex, long highIndex, long value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillLongs(long position, long count, long value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseLongArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfFloat(long lowIndex, long highIndex, float value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillFloats(long position, long count, float value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseFloatArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfDouble(long lowIndex, long highIndex, double value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillDoubles(long position, long count, double value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseDoubleArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfObject(long lowIndex, long highIndex, Object value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillObjects(long position, long count, Object value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL);
                long cStartY = coordY & (this.tileDimMaskLast ^ 0xFFFFFFFFFFFFFFFFL);
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseObjectArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }
    }

    private static class IndexerForPowerOfTwo
    extends Indexer {
        final long[] tileDimMask;
        final long tileDimMask0;
        final long tileDimMaskLast;
        final int[] tileDimLog;

        IndexerForPowerOfTwo(Array baseArray, long[] baseDim, long[] tileDim) {
            super(baseArray, baseDim, tileDim);
            int k;
            if (!ArraysTileMatrixImpl.isPowerOfTwo(tileDim)) {
                throw new AssertionError((Object)("Some tile dimension is not 2^k: " + JArrays.toString(tileDim, "x", 1000)));
            }
            this.tileDimMask = new long[this.n];
            for (k = 0; k < this.n; ++k) {
                this.tileDimMask[k] = tileDim[k] - 1L;
            }
            this.tileDimMask0 = this.tileDimMask[0];
            this.tileDimMaskLast = this.tileDimMask[this.n - 1];
            this.tileDimLog = new int[this.n];
            for (k = 0; k < this.n; ++k) {
                this.tileDimLog[k] = 63 - Long.numberOfLeadingZeros(tileDim[k]);
            }
        }

        @Override
        long translate(long index) {
            assert (index >= 0L);
            if (this.n == 1) {
                return index;
            }
            long previousVolume = 0L;
            long a = index;
            long currentTileDimMul = 1L;
            for (int k = this.n - 1; k > 0; --k) {
                long coordinate = a / this.baseDimMul[k];
                a -= coordinate * this.baseDimMul[k];
                long cStart = coordinate & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                long rest = this.baseDim[k] - cStart;
                if (this.tileDim[k] <= rest) {
                    currentTileDimMul <<= this.tileDimLog[k];
                    continue;
                }
                currentTileDimMul *= rest;
            }
            previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
            long indexInTile = 0L;
            a = index;
            currentTileDimMul = 1L;
            for (int k = 0; k < this.n - 1; ++k) {
                long dim = this.baseDim[k];
                long b = a / dim;
                long coord = a - b * dim;
                long coordInTile = coord & this.tileDimMask[k];
                indexInTile += coordInTile * currentTileDimMul;
                long cStart = coord - coordInTile;
                long rest = dim - cStart;
                currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                a = b;
            }
            long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
            assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase < this.baseLength) : "A bug in translate() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
            return indexInBase;
        }

        @Override
        void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - (long)count);
            assert (count >= 0);
            long index = arrayPos;
            while (count > 0) {
                int len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                int n = len = restInTile0 < (long)count ? (int)restInTile0 : count;
                assert (len > 0) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + (long)len <= this.baseLength) : "A bug in getData() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + ((long)count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.baseArray.getData(indexInBase, destArray, destArrayOffset, len);
                index += (long)len;
                destArrayOffset += len;
                count -= len;
            }
        }

        @Override
        void setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - (long)count);
            assert (count >= 0);
            long index = arrayPos;
            while (count > 0) {
                int len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                int n = len = restInTile0 < (long)count ? (int)restInTile0 : count;
                assert (len > 0) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + (long)len <= this.baseLength) : "A bug in setData() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + ((long)count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.updatableBaseArray);
                this.updatableBaseArray.setData(indexInBase, srcArray, srcArrayOffset, len);
                index += (long)len;
                srcArrayOffset += len;
                count -= len;
            }
        }

        @Override
        void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - count);
            assert (count >= 0L);
            long index = arrayPos;
            while (count > 0L) {
                long len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long l = len = restInTile0 < count ? restInTile0 : count;
                assert (len > 0L) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in getBits() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + (count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseBitArray);
                this.baseBitArray.getBits(indexInBase, destArray, destArrayOffset, len);
                index += len;
                destArrayOffset += len;
                count -= len;
            }
        }

        @Override
        void setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - count);
            assert (count >= 0L);
            long index = arrayPos;
            while (count > 0L) {
                long len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long l = len = restInTile0 < count ? restInTile0 : count;
                assert (len > 0L) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in setBits() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + (count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.updatableBaseBitArray);
                this.updatableBaseBitArray.setBits(indexInBase, srcArray, srcArrayOffset, len);
                index += len;
                srcArrayOffset += len;
                count -= len;
            }
        }

        @Override
        public long indexOfBit(long lowIndex, long highIndex, boolean value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillBits(long position, long count, boolean value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseBitArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfChar(long lowIndex, long highIndex, char value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillChars(long position, long count, char value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseCharArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfByte(long lowIndex, long highIndex, byte value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillBytes(long position, long count, byte value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseByteArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfShort(long lowIndex, long highIndex, short value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillShorts(long position, long count, short value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseShortArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfInt(long lowIndex, long highIndex, int value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillInts(long position, long count, int value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseIntArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfLong(long lowIndex, long highIndex, long value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillLongs(long position, long count, long value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseLongArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfFloat(long lowIndex, long highIndex, float value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillFloats(long position, long count, float value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseFloatArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfDouble(long lowIndex, long highIndex, double value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillDoubles(long position, long count, double value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseDoubleArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfObject(long lowIndex, long highIndex, Object value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillObjects(long position, long count, Object value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord & (this.tileDimMask[k] ^ 0xFFFFFFFFFFFFFFFFL);
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    if (this.tileDim[k] <= rest) {
                        currentTileDimMul <<= this.tileDimLog[k];
                        continue;
                    }
                    currentTileDimMul *= rest;
                }
                previousVolume += (a & (this.tileDimMask0 ^ 0xFFFFFFFFFFFFFFFFL)) * currentTileDimMul;
                long coord0InTile = a & this.tileDimMask0;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord & this.tileDimMask[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul = this.tileDim[k] <= rest ? (currentTileDimMul <<= this.tileDimLog[k]) : (currentTileDimMul *= rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += (a & this.tileDimMaskLast) * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseObjectArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }
    }

    private static class Indexer3D
    extends Indexer {
        final long baseDimXY;

        Indexer3D(Array baseArray, long[] baseDim, long[] tileDim) {
            super(baseArray, baseDim, tileDim);
            assert (this.n == 3);
            this.baseDimXY = this.baseDimMul[2];
        }

        @Override
        long translate(long index) {
            assert (index >= 0L);
            long a = index;
            long coordZ = a / this.baseDimXY;
            long coordY = (a -= coordZ * this.baseDimXY) / this.baseDim[0];
            long coordX = a - coordY * this.baseDim[0];
            long cStartX = coordX - coordX % this.tileDim[0];
            long cStartY = coordY - coordY % this.tileDim[1];
            long cStartZ = coordZ - coordZ % this.tileDim[2];
            long restX = this.baseDim[0] - cStartX;
            long currentTileDimX = Math.min(this.tileDim[0], restX);
            long restY = this.baseDim[1] - cStartY;
            long currentTileDimY = Math.min(this.tileDim[1], restY);
            long restZ = this.baseDim[2] - cStartZ;
            long currentTileDimZ = Math.min(this.tileDim[2], restZ);
            long previousVolume = this.baseDimXY * cStartZ + this.baseDim[0] * cStartY * currentTileDimZ + cStartX * currentTileDimY * currentTileDimZ;
            long indexInTile = ((coordZ - cStartZ) * currentTileDimY + (coordY - cStartY)) * currentTileDimX + (coordX - cStartX);
            long indexInBase = previousVolume + indexInTile;
            assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase < this.baseLength) : "A bug in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
            return indexInBase;
        }
    }

    private static class Indexer2D
    extends Indexer {
        Indexer2D(Array baseArray, long[] baseDim, long[] tileDim) {
            super(baseArray, baseDim, tileDim);
            assert (this.n == 2);
        }

        @Override
        long translate(long index) {
            assert (index >= 0L);
            long coordY = index / this.baseDim0;
            long coordX = index - coordY * this.baseDim0;
            long cStartX = coordX - coordX % this.tileDim0;
            long cStartY = coordY - coordY % this.tileDimLast;
            long restX = this.baseDim0 - cStartX;
            long currentTileDimX = Math.min(this.tileDim0, restX);
            long restY = this.baseDimLast - cStartY;
            long currentTileDimY = Math.min(this.tileDimLast, restY);
            long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
            long indexInTile = (coordY - cStartY) * currentTileDimX + (coordX - cStartX);
            long indexInBase = previousVolume + indexInTile;
            assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase < this.baseLength) : "A bug in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
            return indexInBase;
        }

        @Override
        public long indexOfBit(long lowIndex, long highIndex, boolean value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillBits(long position, long count, boolean value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseBitArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfChar(long lowIndex, long highIndex, char value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillChars(long position, long count, char value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseCharArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfByte(long lowIndex, long highIndex, byte value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillBytes(long position, long count, byte value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseByteArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfShort(long lowIndex, long highIndex, short value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillShorts(long position, long count, short value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseShortArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfInt(long lowIndex, long highIndex, int value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillInts(long position, long count, int value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseIntArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfLong(long lowIndex, long highIndex, long value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillLongs(long position, long count, long value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseLongArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfFloat(long lowIndex, long highIndex, float value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillFloats(long position, long count, float value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseFloatArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfDouble(long lowIndex, long highIndex, double value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillDoubles(long position, long count, double value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseDoubleArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        @Override
        public long indexOfObject(long lowIndex, long highIndex, Object value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long coordY = lowIndex / this.baseDim0;
                long coordX = lowIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        @Override
        public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long coordY = highIndex / this.baseDim0;
                long coordX = highIndex - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long len = Math.min(coordXInTile + 1L, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        @Override
        public void fillObjects(long position, long count, Object value) {
            while (count > 0L) {
                long coordY = position / this.baseDim0;
                long coordX = position - coordY * this.baseDim0;
                long cStartX = coordX - coordX % this.tileDim0;
                long cStartY = coordY - coordY % this.tileDimLast;
                long restX = this.baseDim0 - cStartX;
                long currentTileDimX = Math.min(this.tileDim0, restX);
                long restY = this.baseDimLast - cStartY;
                long currentTileDimY = Math.min(this.tileDimLast, restY);
                long previousVolume = this.baseDim0 * cStartY + cStartX * currentTileDimY;
                long coordXInTile = coordX - cStartX;
                long coordYInTile = coordY - cStartY;
                long restInTile0 = currentTileDimX - coordXInTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                long indexInTile = coordYInTile * currentTileDimX + coordXInTile;
                long indexInBase = previousVolume + indexInTile;
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseObjectArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }
    }

    private static class Indexer1D
    extends Indexer {
        Indexer1D(Array baseArray, long[] baseDim, long[] tileDim) {
            super(baseArray, baseDim, tileDim);
            assert (this.n == 1);
        }

        @Override
        long translate(long index) {
            return index;
        }

        @Override
        void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.baseArray.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        void setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            this.updatableBaseArray.setData(arrayPos, srcArray, srcArrayOffset, count);
        }

        @Override
        void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            this.baseBitArray.getBits(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        void setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
            this.updatableBaseBitArray.setBits(arrayPos, srcArray, srcArrayOffset, count);
        }

        @Override
        public long indexOfBit(long lowIndex, long highIndex, boolean value) {
            return this.baseBitArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
            return this.baseBitArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillBits(long position, long count, boolean value) {
            this.updatableBaseBitArray.fill(position, count, value);
        }

        @Override
        public long indexOfChar(long lowIndex, long highIndex, char value) {
            return this.baseCharArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
            return this.baseCharArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillChars(long position, long count, char value) {
            this.updatableBaseCharArray.fill(position, count, value);
        }

        @Override
        public long indexOfByte(long lowIndex, long highIndex, byte value) {
            return this.baseByteArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
            return this.baseByteArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillBytes(long position, long count, byte value) {
            this.updatableBaseByteArray.fill(position, count, value);
        }

        @Override
        public long indexOfShort(long lowIndex, long highIndex, short value) {
            return this.baseShortArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
            return this.baseShortArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillShorts(long position, long count, short value) {
            this.updatableBaseShortArray.fill(position, count, value);
        }

        @Override
        public long indexOfInt(long lowIndex, long highIndex, int value) {
            return this.baseIntArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
            return this.baseIntArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillInts(long position, long count, int value) {
            this.updatableBaseIntArray.fill(position, count, value);
        }

        @Override
        public long indexOfLong(long lowIndex, long highIndex, long value) {
            return this.baseLongArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
            return this.baseLongArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillLongs(long position, long count, long value) {
            this.updatableBaseLongArray.fill(position, count, value);
        }

        @Override
        public long indexOfFloat(long lowIndex, long highIndex, float value) {
            return this.baseFloatArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
            return this.baseFloatArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillFloats(long position, long count, float value) {
            this.updatableBaseFloatArray.fill(position, count, value);
        }

        @Override
        public long indexOfDouble(long lowIndex, long highIndex, double value) {
            return this.baseDoubleArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
            return this.baseDoubleArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillDoubles(long position, long count, double value) {
            this.updatableBaseDoubleArray.fill(position, count, value);
        }

        @Override
        public long indexOfObject(long lowIndex, long highIndex, Object value) {
            return this.baseObjectArray.indexOf(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
            return this.baseObjectArray.lastIndexOf(lowIndex, highIndex, value);
        }

        @Override
        public void fillObjects(long position, long count, Object value) {
            this.updatableBaseObjectArray.fill(position, count, value);
        }
    }

    static class Indexer {
        final Array baseArray;
        final UpdatableArray updatableBaseArray;
        final BitArray baseBitArray;
        final UpdatableBitArray updatableBaseBitArray;
        final CharArray baseCharArray;
        final UpdatableCharArray updatableBaseCharArray;
        final ByteArray baseByteArray;
        final UpdatableByteArray updatableBaseByteArray;
        final ShortArray baseShortArray;
        final UpdatableShortArray updatableBaseShortArray;
        final IntArray baseIntArray;
        final UpdatableIntArray updatableBaseIntArray;
        final LongArray baseLongArray;
        final UpdatableLongArray updatableBaseLongArray;
        final FloatArray baseFloatArray;
        final UpdatableFloatArray updatableBaseFloatArray;
        final DoubleArray baseDoubleArray;
        final UpdatableDoubleArray updatableBaseDoubleArray;
        final ObjectArray<Object> baseObjectArray;
        final UpdatableObjectArray<Object> updatableBaseObjectArray;
        final long baseLength;
        final long[] baseDim;
        final long baseDim0;
        final long baseDimLast;
        final long[] baseDimMul;
        final long[] tileDim;
        final long tileDim0;
        final long tileDimLast;
        final int n;

        Indexer(Array baseArray, long[] baseDim, long[] tileDim) {
            this.baseArray = baseArray;
            this.updatableBaseArray = this.baseArray instanceof UpdatableArray ? (UpdatableArray)this.baseArray : null;
            this.baseBitArray = this.baseArray instanceof BitArray ? (BitArray)this.baseArray : null;
            this.updatableBaseBitArray = this.baseArray instanceof UpdatableBitArray ? (UpdatableBitArray)this.baseArray : null;
            this.baseCharArray = this.baseArray instanceof CharArray ? (CharArray)this.baseArray : null;
            this.updatableBaseCharArray = this.baseArray instanceof UpdatableCharArray ? (UpdatableCharArray)this.baseArray : null;
            this.baseByteArray = this.baseArray instanceof ByteArray ? (ByteArray)this.baseArray : null;
            this.updatableBaseByteArray = this.baseArray instanceof UpdatableByteArray ? (UpdatableByteArray)this.baseArray : null;
            this.baseShortArray = this.baseArray instanceof ShortArray ? (ShortArray)this.baseArray : null;
            this.updatableBaseShortArray = this.baseArray instanceof UpdatableShortArray ? (UpdatableShortArray)this.baseArray : null;
            this.baseIntArray = this.baseArray instanceof IntArray ? (IntArray)this.baseArray : null;
            this.updatableBaseIntArray = this.baseArray instanceof UpdatableIntArray ? (UpdatableIntArray)this.baseArray : null;
            this.baseLongArray = this.baseArray instanceof LongArray ? (LongArray)this.baseArray : null;
            this.updatableBaseLongArray = this.baseArray instanceof UpdatableLongArray ? (UpdatableLongArray)this.baseArray : null;
            this.baseFloatArray = this.baseArray instanceof FloatArray ? (FloatArray)this.baseArray : null;
            this.updatableBaseFloatArray = this.baseArray instanceof UpdatableFloatArray ? (UpdatableFloatArray)this.baseArray : null;
            this.baseDoubleArray = this.baseArray instanceof DoubleArray ? (DoubleArray)this.baseArray : null;
            this.updatableBaseDoubleArray = this.baseArray instanceof UpdatableDoubleArray ? (UpdatableDoubleArray)this.baseArray : null;
            this.baseObjectArray = this.baseArray instanceof ObjectArray ? ((ObjectArray)this.baseArray).cast(Object.class) : null;
            this.updatableBaseObjectArray = this.baseArray instanceof UpdatableObjectArray ? ((UpdatableObjectArray)this.baseArray).cast(Object.class) : null;
            this.baseLength = this.baseArray.length();
            this.n = baseDim.length;
            assert (tileDim.length == this.n);
            this.baseDim = baseDim;
            this.tileDim = tileDim;
            this.baseDim0 = baseDim[0];
            this.baseDimLast = baseDim[this.n - 1];
            this.tileDim0 = tileDim[0];
            this.tileDimLast = tileDim[this.n - 1];
            this.baseDimMul = new long[this.n];
            for (int k = 0; k < this.n; ++k) {
                this.baseDimMul[k] = k == 0 ? 1L : this.baseDimMul[k - 1] * this.baseDim[k - 1];
            }
        }

        public static Indexer getInstance(Matrix<? extends Array> baseMatrix, long[] tileDim) {
            Objects.requireNonNull(tileDim, "Null tile dimensions Java array");
            int n = baseMatrix.dimCount();
            if (tileDim.length != n) {
                throw new IllegalArgumentException("Number of tile dimensions is not equal to number of matrix dimensions");
            }
            for (int k = 0; k < n; ++k) {
                if (tileDim[k] > 0L) continue;
                throw new IllegalArgumentException("Negative or zero tile dimension #" + k + ": " + tileDim[k]);
            }
            long tileSize = Arrays.longMul(tileDim);
            if (tileSize == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Too large tile dimensions: dim[0] * dim[1] * ... = " + JArrays.toString(tileDim, " * ", 100) + " > Long.MAX_VALUE");
            }
            int q = 0;
            long collapsedDimensions = 1L;
            while (q < tileDim.length - 1 && tileDim[q] >= baseMatrix.dim(q)) {
                collapsedDimensions *= baseMatrix.dim(q);
                ++q;
                --n;
            }
            assert (n > 0);
            long[] actualBaseDim = new long[n];
            long[] actualTileDim = new long[n];
            for (int k = 0; k < n; ++k) {
                actualBaseDim[k] = baseMatrix.dim(k + q);
                actualTileDim[k] = tileDim[k + q];
            }
            actualBaseDim[0] = actualBaseDim[0] * collapsedDimensions;
            actualTileDim[0] = actualTileDim[0] * collapsedDimensions;
            if (ArraysTileMatrixImpl.isPowerOfTwo(actualTileDim) && n > 1) {
                return switch (n) {
                    case 2 -> new IndexerForPowerOfTwo2D(baseMatrix.array(), actualBaseDim, actualTileDim);
                    case 3 -> new IndexerForPowerOfTwo3D(baseMatrix.array(), actualBaseDim, actualTileDim);
                    default -> new IndexerForPowerOfTwo(baseMatrix.array(), actualBaseDim, actualTileDim);
                };
            }
            return switch (n) {
                case 1 -> new Indexer1D(baseMatrix.array(), actualBaseDim, actualTileDim);
                case 2 -> new Indexer2D(baseMatrix.array(), actualBaseDim, actualTileDim);
                case 3 -> new Indexer3D(baseMatrix.array(), actualBaseDim, actualTileDim);
                default -> new Indexer(baseMatrix.array(), actualBaseDim, actualTileDim);
            };
        }

        long translate(long index) {
            assert (index >= 0L);
            if (this.n == 1) {
                return index;
            }
            long previousVolume = 0L;
            long a = index;
            long currentTileDimMul = 1L;
            for (int k = this.n - 1; k > 0; --k) {
                long coordinate = a / this.baseDimMul[k];
                a -= coordinate * this.baseDimMul[k];
                long cStart = coordinate - coordinate % this.tileDim[k];
                previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                long rest = this.baseDim[k] - cStart;
                currentTileDimMul *= Math.min(this.tileDim[k], rest);
            }
            previousVolume += (a - a % this.tileDim0) * currentTileDimMul;
            long indexInTile = 0L;
            a = index;
            currentTileDimMul = 1L;
            for (int k = 0; k < this.n - 1; ++k) {
                long dim = this.baseDim[k];
                long b = a / dim;
                long coordinate = a - b * dim;
                long coordInTile = coordinate % this.tileDim[k];
                indexInTile += coordInTile * currentTileDimMul;
                long cStart = coordinate - coordInTile;
                long rest = dim - cStart;
                currentTileDimMul *= Math.min(this.tileDim[k], rest);
                a = b;
            }
            long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
            assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase < this.baseLength) : "A bug in translate() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
            return indexInBase;
        }

        void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - (long)count);
            assert (count >= 0);
            long index = arrayPos;
            while (count > 0) {
                int len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                int n = len = restInTile0 < (long)count ? (int)restInTile0 : count;
                assert (len > 0) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + (long)len <= this.baseLength) : "A bug in getData() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + ((long)count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.baseArray.getData(indexInBase, destArray, destArrayOffset, len);
                index += (long)len;
                destArrayOffset += len;
                count -= len;
            }
        }

        void setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - (long)count);
            assert (count >= 0);
            long index = arrayPos;
            while (count > 0) {
                int len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                int n = len = restInTile0 < (long)count ? (int)restInTile0 : count;
                assert (len > 0) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + (long)len <= this.baseLength) : "A bug in setData() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + ((long)count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.updatableBaseArray);
                this.updatableBaseArray.setData(indexInBase, srcArray, srcArrayOffset, len);
                index += (long)len;
                srcArrayOffset += len;
                count -= len;
            }
        }

        void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - count);
            assert (count >= 0L);
            long index = arrayPos;
            while (count > 0L) {
                long len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long l = len = restInTile0 < count ? restInTile0 : count;
                assert (len > 0L) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in getBits() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + (count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseBitArray);
                this.baseBitArray.getBits(indexInBase, destArray, destArrayOffset, len);
                index += len;
                destArrayOffset += len;
                count -= len;
            }
        }

        void setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
            assert (arrayPos >= 0L && arrayPos <= this.baseLength - count);
            assert (count >= 0L);
            long index = arrayPos;
            while (count > 0L) {
                long len;
                long previousVolume = 0L;
                long a = index;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                assert (index == arrayPos || coord0InTile == 0L) : "Non-aligned index for non-first tile";
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long l = len = restInTile0 < count ? restInTile0 : count;
                assert (len > 0L) : "Zero len";
                a = index / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in setBits() in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + index + " translated to " + indexInBase + "(+" + len + "), arrayPos = " + arrayPos + ", count = " + count + ", original count = " + (count + index - arrayPos) + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.updatableBaseBitArray);
                this.updatableBaseBitArray.setBits(indexInBase, srcArray, srcArrayOffset, len);
                index += len;
                srcArrayOffset += len;
                count -= len;
            }
        }

        public long indexOfBit(long lowIndex, long highIndex, boolean value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseBitArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillBits(long position, long count, boolean value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfBit in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseBitArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfChar(long lowIndex, long highIndex, char value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseCharArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillChars(long position, long count, char value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfChar in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseCharArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfByte(long lowIndex, long highIndex, byte value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseByteArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillBytes(long position, long count, byte value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfByte in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseByteArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfShort(long lowIndex, long highIndex, short value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseShortArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillShorts(long position, long count, short value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfShort in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseShortArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfInt(long lowIndex, long highIndex, int value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseIntArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillInts(long position, long count, int value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfInt in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseIntArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfLong(long lowIndex, long highIndex, long value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseLongArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillLongs(long position, long count, long value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfLong in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseLongArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfFloat(long lowIndex, long highIndex, float value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseFloatArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillFloats(long position, long count, float value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfFloat in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseFloatArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfDouble(long lowIndex, long highIndex, double value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseDoubleArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillDoubles(long position, long count, double value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfDouble in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseDoubleArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }

        public long indexOfObject(long lowIndex, long highIndex, Object value) {
            long len;
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            for (long count = highIndex - lowIndex; count > 0L; count -= len) {
                long previousVolume = 0L;
                long a = lowIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = lowIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + lowIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.indexOf(indexInBase, indexInBase + len, value);
                if (result != -1L) {
                    return lowIndex + result - indexInBase;
                }
                lowIndex += len;
            }
            return -1L;
        }

        public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.baseLength) {
                highIndex = this.baseLength;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long count = highIndex - lowIndex;
            --highIndex;
            while (count > 0L) {
                long previousVolume = 0L;
                long a = highIndex;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long len = Math.min(coord0InTile + 1L, count);
                assert (len > 0L) : "Zero len";
                a = highIndex / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= len - 1L && indexInBase <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + highIndex + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                long result = this.baseObjectArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
                if (result != -1L) {
                    return highIndex + result - indexInBase;
                }
                highIndex -= len;
                count -= len;
            }
            return -1L;
        }

        public void fillObjects(long position, long count, Object value) {
            while (count > 0L) {
                long previousVolume = 0L;
                long a = position;
                long currentTileDimMul = 1L;
                for (int k = this.n - 1; k > 0; --k) {
                    long coord = a / this.baseDimMul[k];
                    a -= coord * this.baseDimMul[k];
                    long cStart = coord - coord % this.tileDim[k];
                    previousVolume += cStart * this.baseDimMul[k] * currentTileDimMul;
                    long rest = this.baseDim[k] - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                }
                long coord0InTile = a % this.tileDim0;
                previousVolume += (a - coord0InTile) * currentTileDimMul;
                long c0Start = a - coord0InTile;
                long indexInTile = coord0InTile;
                long rest0 = this.baseDim0 - c0Start;
                currentTileDimMul = Math.min(this.tileDim0, rest0);
                long restInTile0 = currentTileDimMul - coord0InTile;
                long len = Math.min(restInTile0, count);
                assert (len > 0L) : "Zero len";
                a = position / this.baseDim0;
                for (int k = 1; k < this.n - 1; ++k) {
                    long dim = this.baseDim[k];
                    long b = a / dim;
                    long coord = a - b * dim;
                    long coordInTile = coord % this.tileDim[k];
                    indexInTile += coordInTile * currentTileDimMul;
                    long cStart = coord - coordInTile;
                    long rest = dim - cStart;
                    currentTileDimMul *= Math.min(this.tileDim[k], rest);
                    a = b;
                }
                long indexInBase = previousVolume + (indexInTile += a % this.tileDimLast * currentTileDimMul);
                assert (previousVolume >= 0L && indexInTile >= 0L && indexInBase >= 0L && indexInBase + len <= this.baseLength) : "A bug in indexOfObject in " + String.valueOf(this.getClass()) + ": previousVolume = " + previousVolume + ", " + position + " translated to " + indexInBase + "(+" + len + "), count = " + count + ", baseAndTileDimMul = " + JArrays.toString(this.baseDimMul, ",", 1000) + ", " + String.valueOf(this.baseArray);
                this.updatableBaseObjectArray.fill(indexInBase, len, value);
                position += len;
                count -= len;
            }
        }
    }

    static class TileMatrixUpdatableObjectArray<E>
    extends AbstractUpdatableObjectArray<E>
    implements TileMatrixArray {
        private final Matrix<? extends ObjectArray<E>> baseMatrix;
        private final UpdatableObjectArray<E> baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableObjectArray(Matrix<? extends UpdatableObjectArray<E>> baseMatrix, long[] tileDim) {
            super(baseMatrix.array().elementType(), baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public E get(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.get(index);
        }

        @Override
        public void set(long index, E value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.set(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, E value) {
            return this.indexer.indexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, E value) {
            return this.indexer.lastIndexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableObjectArray<E> fill(long position, long count, E value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillObjects(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray " + this.elementType().getName() + "[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixObjectArray<E>
    extends AbstractObjectArray<E>
    implements TileMatrixArray {
        private final Matrix<? extends ObjectArray<E>> baseMatrix;
        private final ObjectArray<E> baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixObjectArray(Matrix<? extends ObjectArray<E>> baseMatrix, long[] tileDim) {
            super(baseMatrix.array().elementType(), baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public E get(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.get(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, E value) {
            return this.indexer.indexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, E value) {
            return this.indexer.lastIndexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray " + this.elementType().getName() + "[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableDoubleArray
    extends AbstractUpdatableDoubleArray
    implements TileMatrixArray {
        private final Matrix<? extends DoubleArray> baseMatrix;
        private final UpdatableDoubleArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableDoubleArray(Matrix<? extends UpdatableDoubleArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getDouble(index);
        }

        @Override
        public void setDouble(long index, double value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setDouble(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return this.indexer.indexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return this.indexer.lastIndexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, double value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillDoubles(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray double[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixDoubleArray
    extends AbstractDoubleArray
    implements TileMatrixArray {
        private final Matrix<? extends DoubleArray> baseMatrix;
        private final DoubleArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixDoubleArray(Matrix<? extends DoubleArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getDouble(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return this.indexer.indexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return this.indexer.lastIndexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray double[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableFloatArray
    extends AbstractUpdatableFloatArray
    implements TileMatrixArray {
        private final Matrix<? extends FloatArray> baseMatrix;
        private final UpdatableFloatArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableFloatArray(Matrix<? extends UpdatableFloatArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getFloat(index);
        }

        @Override
        public void setFloat(long index, float value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setFloat(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, float value) {
            return this.indexer.indexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, float value) {
            return this.indexer.lastIndexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, float value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillFloats(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray float[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixFloatArray
    extends AbstractFloatArray
    implements TileMatrixArray {
        private final Matrix<? extends FloatArray> baseMatrix;
        private final FloatArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixFloatArray(Matrix<? extends FloatArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getFloat(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, float value) {
            return this.indexer.indexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, float value) {
            return this.indexer.lastIndexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray float[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableLongArray
    extends AbstractUpdatableLongArray
    implements TileMatrixArray {
        private final Matrix<? extends LongArray> baseMatrix;
        private final UpdatableLongArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableLongArray(Matrix<? extends UpdatableLongArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getLong(index);
        }

        @Override
        public void setLong(long index, long value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setLong(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return this.indexer.indexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return this.indexer.lastIndexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, long value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillLongs(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray long[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixLongArray
    extends AbstractLongArray
    implements TileMatrixArray {
        private final Matrix<? extends LongArray> baseMatrix;
        private final LongArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixLongArray(Matrix<? extends LongArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getLong(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return this.indexer.indexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return this.indexer.lastIndexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray long[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableIntArray
    extends AbstractUpdatableIntArray
    implements TileMatrixArray {
        private final Matrix<? extends IntArray> baseMatrix;
        private final UpdatableIntArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableIntArray(Matrix<? extends UpdatableIntArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getInt(index);
        }

        @Override
        public void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setInt(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, int value) {
            return this.indexer.indexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, int value) {
            return this.indexer.lastIndexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, int value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillInts(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray int[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixIntArray
    extends AbstractIntArray
    implements TileMatrixArray {
        private final Matrix<? extends IntArray> baseMatrix;
        private final IntArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixIntArray(Matrix<? extends IntArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getInt(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, int value) {
            return this.indexer.indexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, int value) {
            return this.indexer.lastIndexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray int[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableShortArray
    extends AbstractUpdatableShortArray
    implements TileMatrixArray {
        private final Matrix<? extends ShortArray> baseMatrix;
        private final UpdatableShortArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableShortArray(Matrix<? extends UpdatableShortArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getShort(index);
        }

        @Override
        public void setShort(long index, short value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setShort(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, short value) {
            return this.indexer.indexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, short value) {
            return this.indexer.lastIndexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, short value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillShorts(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray short[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixShortArray
    extends AbstractShortArray
    implements TileMatrixArray {
        private final Matrix<? extends ShortArray> baseMatrix;
        private final ShortArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixShortArray(Matrix<? extends ShortArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getShort(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, short value) {
            return this.indexer.indexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, short value) {
            return this.indexer.lastIndexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray short[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableByteArray
    extends AbstractUpdatableByteArray
    implements TileMatrixArray {
        private final Matrix<? extends ByteArray> baseMatrix;
        private final UpdatableByteArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableByteArray(Matrix<? extends UpdatableByteArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getByte(index);
        }

        @Override
        public void setByte(long index, byte value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setByte(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, byte value) {
            return this.indexer.indexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, byte value) {
            return this.indexer.lastIndexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, byte value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillBytes(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray byte[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixByteArray
    extends AbstractByteArray
    implements TileMatrixArray {
        private final Matrix<? extends ByteArray> baseMatrix;
        private final ByteArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixByteArray(Matrix<? extends ByteArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getByte(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, byte value) {
            return this.indexer.indexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, byte value) {
            return this.indexer.lastIndexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray byte[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableCharArray
    extends AbstractUpdatableCharArray
    implements TileMatrixArray {
        private final Matrix<? extends CharArray> baseMatrix;
        private final UpdatableCharArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableCharArray(Matrix<? extends UpdatableCharArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getChar(index);
        }

        @Override
        public void setChar(long index, char value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setChar(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, char value) {
            return this.indexer.indexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, char value) {
            return this.indexer.lastIndexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, char value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillChars(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray char[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixCharArray
    extends AbstractCharArray
    implements TileMatrixArray {
        private final Matrix<? extends CharArray> baseMatrix;
        private final CharArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixCharArray(Matrix<? extends CharArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getChar(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, char value) {
            return this.indexer.indexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, char value) {
            return this.indexer.lastIndexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray char[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixUpdatableBitArray
    extends AbstractUpdatableBitArray
    implements TileMatrixArray {
        private final Matrix<? extends BitArray> baseMatrix;
        private final UpdatableBitArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixUpdatableBitArray(Matrix<? extends UpdatableBitArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getBit(index);
        }

        @Override
        public void setBit(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            this.baseArray.setBit(index, value);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw TileMatrixUpdatableBitArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - count) {
                throw TileMatrixUpdatableBitArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
            }
            this.indexer.getBits(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public UpdatableBitArray setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw TileMatrixUpdatableBitArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - count) {
                throw TileMatrixUpdatableBitArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
            }
            this.indexer.setBits(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long nextQuickPosition(long position) {
            return position >= this.length ? -1L : (position < 0L ? 0L : position);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, boolean value) {
            return this.indexer.indexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            return this.indexer.lastIndexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, boolean value) {
            this.checkSubArrArguments(position, count);
            this.indexer.fillBits(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray boolean[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static class TileMatrixBitArray
    extends AbstractBitArray
    implements TileMatrixArray {
        private final Matrix<? extends BitArray> baseMatrix;
        private final BitArray baseArray;
        private final long[] tileDim;
        private final Indexer indexer;

        TileMatrixBitArray(Matrix<? extends BitArray> baseMatrix, long[] tileDim) {
            super(baseMatrix.size(), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.tileDim = (long[])tileDim.clone();
            this.indexer = Indexer.getInstance(baseMatrix, this.tileDim);
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public long[] tileDimensions() {
            return (long[])this.tileDim.clone();
        }

        @Override
        public Indexer indexer() {
            return this.indexer;
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            index = this.indexer.translate(index);
            return this.baseArray.getBit(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw TileMatrixBitArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - count) {
                throw TileMatrixBitArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
            }
            this.indexer.getBits(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long nextQuickPosition(long position) {
            return position >= this.length ? -1L : (position < 0L ? 0L : position);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, boolean value) {
            return this.indexer.indexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            return this.indexer.lastIndexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray boolean[" + this.length + "] tiled by " + JArrays.toString(this.tileDim, "x", 1000) + " from " + String.valueOf(this.baseMatrix);
        }
    }

    static interface TileMatrixArray {
        public Matrix<? extends Array> baseMatrix();

        public long[] tileDimensions();

        public Indexer indexer();
    }
}

