/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.ShortArray;
import net.algart.math.functions.Func;

class ArraysShortTableGetDataOp {
    private final ReentrantLock lock = new ReentrantLock();
    private final ShortArray x0;
    private final DataShortBuffer dBuf;
    boolean[] booleanTable;
    char[] charTable;
    byte[] byteTable;
    short[] shortTable;
    int[] intTable;
    long[] longTable;
    float[] floatTable;
    double[] doubleTable;
    private final int destElementTypeCode;

    ArraysShortTableGetDataOp(boolean truncateOverflows, ShortArray x0, Func f, int destElementTypeCode) {
        this.x0 = x0;
        this.dBuf = (DataShortBuffer)Arrays.bufferInternal(x0, DataBuffer.AccessMode.READ);
        switch (destElementTypeCode) {
            case 1: {
                this.booleanTable = new boolean[65536];
                for (int k = 0; k < this.booleanTable.length; ++k) {
                    this.booleanTable[k] = f.get((double)k) != 0.0;
                }
                break;
            }
            case 2: {
                this.charTable = new char[65536];
                if (truncateOverflows) {
                    for (int k = 0; k < this.charTable.length; ++k) {
                        int v = (int)f.get((double)k);
                        this.charTable[k] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                    }
                } else {
                    for (int k = 0; k < this.charTable.length; ++k) {
                        this.charTable[k] = (char)f.get((double)k);
                    }
                }
                break;
            }
            case 3: {
                this.byteTable = new byte[65536];
                if (truncateOverflows) {
                    for (int k = 0; k < this.byteTable.length; ++k) {
                        int v = (int)f.get((double)k);
                        this.byteTable[k] = (byte)(v < 0 ? 0 : (byte)(v > 255 ? -1 : (byte)v));
                    }
                } else {
                    for (int k = 0; k < this.byteTable.length; ++k) {
                        this.byteTable[k] = (byte)f.get((double)k);
                    }
                }
                break;
            }
            case 4: {
                this.shortTable = new short[65536];
                if (truncateOverflows) {
                    for (int k = 0; k < this.shortTable.length; ++k) {
                        int v = (int)f.get((double)k);
                        this.shortTable[k] = (short)(v < 0 ? 0 : (short)(v > 65535 ? -1 : (short)v));
                    }
                } else {
                    for (int k = 0; k < this.shortTable.length; ++k) {
                        this.shortTable[k] = (short)f.get((double)k);
                    }
                }
                break;
            }
            case 5: {
                this.intTable = new int[65536];
                if (truncateOverflows) {
                    for (int k = 0; k < this.intTable.length; ++k) {
                        this.intTable[k] = (int)f.get((double)k);
                    }
                } else {
                    for (int k = 0; k < this.intTable.length; ++k) {
                        this.intTable[k] = (int)f.get((double)k);
                    }
                }
                break;
            }
            case 6: {
                this.longTable = new long[65536];
                for (int k = 0; k < this.longTable.length; ++k) {
                    this.longTable[k] = (long)f.get((double)k);
                }
                break;
            }
            case 7: {
                this.floatTable = new float[65536];
                for (int k = 0; k < this.floatTable.length; ++k) {
                    this.floatTable[k] = (float)f.get((double)k);
                }
                break;
            }
            case 8: {
                this.doubleTable = new double[65536];
                for (int k = 0; k < this.doubleTable.length; ++k) {
                    this.doubleTable[k] = f.get((double)k);
                }
                break;
            }
        }
        this.destElementTypeCode = destElementTypeCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x0.length(), this.x0.getClass());
        }
        if (arrayPos > this.x0.length() - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.x0.length(), this.x0.getClass());
        }
        while (count > 0) {
            int len;
            boolean usePool = false;
            short[] data = null;
            try {
                int to;
                int from;
                boolean bl = usePool = !this.dBuf.isDirect();
                if (usePool) {
                    data = (short[])ArraysFuncImpl.SHORT_BUFFERS.requestArray();
                    len = Math.min(count, data.length);
                    this.x0.getData(arrayPos, data, 0, len);
                    from = 0;
                    to = len;
                } else {
                    this.lock.lock();
                    try {
                        this.dBuf.map(arrayPos, count);
                        len = this.dBuf.cnt();
                        assert ((long)len == this.dBuf.count()) : "too large buffer";
                        data = this.dBuf.data();
                        from = this.dBuf.from();
                        to = this.dBuf.to();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                switch (this.destElementTypeCode) {
                    case 1: {
                        Object[] dest = (boolean[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.booleanTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 2: {
                        Object[] dest = (char[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.charTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 3: {
                        Object[] dest = (byte[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.byteTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 4: {
                        Object[] dest = (short[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.shortTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 5: {
                        Object[] dest = (int[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.intTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 6: {
                        Object[] dest = (long[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.longTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 7: {
                        Object[] dest = (float[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.floatTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 8: {
                        Object[] dest = (double[])destArray;
                        int j = from;
                        while (j < to) {
                            dest[destArrayOffset] = this.doubleTable[data[j] & 0xFFFF];
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Illegal destElementTypeCode");
                    }
                }
                if (usePool) {
                    ArraysFuncImpl.SHORT_BUFFERS.releaseArray(data);
                }
            }
            catch (Throwable throwable) {
                if (usePool) {
                    ArraysFuncImpl.SHORT_BUFFERS.releaseArray(data);
                }
                throw throwable;
            }
            arrayPos += (long)len;
            count -= len;
        }
    }
}

