/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataBuffersImpl;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;

class ArraysSerializationImpl {
    ArraysSerializationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream outputStream, PArray array, ByteOrder byteOrder) throws IOException {
        block23: {
            Objects.requireNonNull(outputStream, "Null outputStream array");
            Objects.requireNonNull(array, "Null array argument");
            Objects.requireNonNull(byteOrder, "Null byteOrder argument");
            long n = array.length();
            if (array instanceof BitArray) {
                long[] bits = (long[])DataBuffersImpl.LONG_BUFFERS.requestArray();
                try {
                    int len;
                    BitArray bitArray = (BitArray)array;
                    ByteBuffer byteBuffer = ByteBuffer.allocate(8 * (int)Math.min((long)bits.length, n + 63L >>> 6));
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byte[] bytes = byteBuffer.array();
                    LongBuffer longBuffer = byteBuffer.asLongBuffer();
                    for (long p = 0L; p < n; p += (long)len) {
                        len = (int)Math.min(n - p, (long)bits.length * 64L);
                        int packedLen = len + 63 >>> 6;
                        bitArray.getBits(p, bits, 0L, len);
                        if ((len & 0x3F) != 0) {
                            PackedBitArrays.fillBits(bits, len, 64 - (len & 0x3F), false);
                        }
                        longBuffer.rewind();
                        longBuffer.put(bits, 0, packedLen);
                        outputStream.write(bytes, 0, packedLen * 8);
                    }
                }
                finally {
                    DataBuffersImpl.LONG_BUFFERS.releaseArray(bits);
                }
            }
            DataBuffer buf = Arrays.bufferInternal(array, DataBuffer.AccessMode.READ, AbstractArray.largeBufferCapacity(array), true);
            Arrays.enableCaching(buf);
            try {
                if (array instanceof ByteArray) {
                    buf.map(0L);
                    while (buf.hasData()) {
                        outputStream.write((byte[])buf.data(), buf.from(), buf.cnt());
                        buf.mapNext();
                    }
                    break block23;
                }
                int sizeOfElement = (int)array.bitsPerElement() >>> 3;
                byte[] bytes = new byte[sizeOfElement * (int)Math.min(buf.capacity(), n)];
                ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
                byteBuffer.order(byteOrder);
                if (array instanceof CharArray) {
                    CharBuffer charBuffer = byteBuffer.asCharBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        charBuffer.rewind();
                        charBuffer.put((char[])buf.data(), buf.from(), buf.cnt());
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        byteBuffer.rewind();
                        byteBuffer.get(bytes, 0, numberOfBytes);
                        outputStream.write(bytes, 0, numberOfBytes);
                        buf.mapNext();
                    }
                    break block23;
                }
                if (array instanceof ShortArray) {
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        shortBuffer.rewind();
                        shortBuffer.put((short[])buf.data(), buf.from(), buf.cnt());
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        byteBuffer.rewind();
                        byteBuffer.get(bytes, 0, numberOfBytes);
                        outputStream.write(bytes, 0, numberOfBytes);
                        buf.mapNext();
                    }
                    break block23;
                }
                if (array instanceof IntArray) {
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        intBuffer.rewind();
                        intBuffer.put((int[])buf.data(), buf.from(), buf.cnt());
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        byteBuffer.rewind();
                        byteBuffer.get(bytes, 0, numberOfBytes);
                        outputStream.write(bytes, 0, numberOfBytes);
                        buf.mapNext();
                    }
                    break block23;
                }
                if (array instanceof LongArray) {
                    LongBuffer longBuffer = byteBuffer.asLongBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        longBuffer.rewind();
                        longBuffer.put((long[])buf.data(), buf.from(), buf.cnt());
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        byteBuffer.rewind();
                        byteBuffer.get(bytes, 0, numberOfBytes);
                        outputStream.write(bytes, 0, numberOfBytes);
                        buf.mapNext();
                    }
                    break block23;
                }
                if (array instanceof FloatArray) {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        floatBuffer.rewind();
                        floatBuffer.put((float[])buf.data(), buf.from(), buf.cnt());
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        byteBuffer.rewind();
                        byteBuffer.get(bytes, 0, numberOfBytes);
                        outputStream.write(bytes, 0, numberOfBytes);
                        buf.mapNext();
                    }
                    break block23;
                }
                if (array instanceof DoubleArray) {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        doubleBuffer.rewind();
                        doubleBuffer.put((double[])buf.data(), buf.from(), buf.cnt());
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        byteBuffer.rewind();
                        byteBuffer.get(bytes, 0, numberOfBytes);
                        outputStream.write(bytes, 0, numberOfBytes);
                        buf.mapNext();
                    }
                    break block23;
                }
                throw new AssertionError((Object)("Unallowed type of passed argument: " + String.valueOf(array.getClass())));
            }
            finally {
                Arrays.dispose(buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(InputStream inputStream, UpdatablePArray array, ByteOrder byteOrder) throws IOException {
        block22: {
            Objects.requireNonNull(inputStream, "Null inputStream array");
            Objects.requireNonNull(array, "Null array argument");
            Objects.requireNonNull(byteOrder, "Null byteOrder argument");
            long n = array.length();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (array instanceof BitArray) {
                long[] bits = (long[])DataBuffersImpl.LONG_BUFFERS.requestArray();
                try {
                    int len;
                    UpdatableBitArray bitArray = (UpdatableBitArray)array;
                    ByteBuffer byteBuffer = ByteBuffer.allocate(8 * (int)Math.min((long)bits.length, n + 63L >>> 6));
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byte[] bytes = byteBuffer.array();
                    LongBuffer longBuffer = byteBuffer.asLongBuffer();
                    for (long p = 0L; p < n; p += (long)len) {
                        len = (int)Math.min(n - p, (long)bits.length * 64L);
                        int packedLen = len + 63 >>> 6;
                        dataInputStream.readFully(bytes, 0, packedLen * 8);
                        longBuffer.rewind();
                        longBuffer.get(bits, 0, packedLen);
                        bitArray.setBits(p, bits, 0L, len);
                    }
                }
                finally {
                    DataBuffersImpl.LONG_BUFFERS.releaseArray(bits);
                }
            }
            DataBuffer buf = Arrays.bufferInternal(array, DataBuffer.AccessMode.READ_WRITE, AbstractArray.largeBufferCapacity(array), true);
            Arrays.enableCaching(buf);
            try {
                if (array instanceof ByteArray) {
                    buf.map(0L);
                    while (buf.hasData()) {
                        dataInputStream.readFully((byte[])buf.data(), buf.from(), buf.cnt());
                        buf.force();
                        buf.mapNext();
                    }
                    break block22;
                }
                int sizeOfElement = (int)array.bitsPerElement() >>> 3;
                byte[] bytes = new byte[sizeOfElement * (int)Math.min(buf.capacity(), n)];
                ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
                byteBuffer.order(byteOrder);
                if (array instanceof CharArray) {
                    CharBuffer charBuffer = byteBuffer.asCharBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        dataInputStream.readFully(bytes, 0, numberOfBytes);
                        byteBuffer.rewind();
                        byteBuffer.put(bytes, 0, numberOfBytes);
                        charBuffer.rewind();
                        charBuffer.get((char[])buf.data(), buf.from(), buf.cnt());
                        buf.force();
                        buf.mapNext();
                    }
                    break block22;
                }
                if (array instanceof ShortArray) {
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        dataInputStream.readFully(bytes, 0, numberOfBytes);
                        byteBuffer.rewind();
                        byteBuffer.put(bytes, 0, numberOfBytes);
                        shortBuffer.rewind();
                        shortBuffer.get((short[])buf.data(), buf.from(), buf.cnt());
                        buf.force();
                        buf.mapNext();
                    }
                    break block22;
                }
                if (array instanceof IntArray) {
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        dataInputStream.readFully(bytes, 0, numberOfBytes);
                        byteBuffer.rewind();
                        byteBuffer.put(bytes, 0, numberOfBytes);
                        intBuffer.rewind();
                        intBuffer.get((int[])buf.data(), buf.from(), buf.cnt());
                        buf.force();
                        buf.mapNext();
                    }
                    break block22;
                }
                if (array instanceof LongArray) {
                    LongBuffer longBuffer = byteBuffer.asLongBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        dataInputStream.readFully(bytes, 0, numberOfBytes);
                        byteBuffer.rewind();
                        byteBuffer.put(bytes, 0, numberOfBytes);
                        longBuffer.rewind();
                        longBuffer.get((long[])buf.data(), buf.from(), buf.cnt());
                        buf.force();
                        buf.mapNext();
                    }
                    break block22;
                }
                if (array instanceof FloatArray) {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        dataInputStream.readFully(bytes, 0, numberOfBytes);
                        byteBuffer.rewind();
                        byteBuffer.put(bytes, 0, numberOfBytes);
                        floatBuffer.rewind();
                        floatBuffer.get((float[])buf.data(), buf.from(), buf.cnt());
                        buf.force();
                        buf.mapNext();
                    }
                    break block22;
                }
                if (array instanceof DoubleArray) {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    buf.map(0L);
                    while (buf.hasData()) {
                        int numberOfBytes = buf.cnt() * sizeOfElement;
                        dataInputStream.readFully(bytes, 0, numberOfBytes);
                        byteBuffer.rewind();
                        byteBuffer.put(bytes, 0, numberOfBytes);
                        doubleBuffer.rewind();
                        doubleBuffer.get((double[])buf.data(), buf.from(), buf.cnt());
                        buf.force();
                        buf.mapNext();
                    }
                    break block22;
                }
                throw new AssertionError((Object)("Unallowed type of passed argument: " + String.valueOf(array.getClass())));
            }
            finally {
                Arrays.dispose(buf);
            }
        }
    }
}

