/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.math.functions.Func;

class ArraysAnyFuncGetDataOp {
    private static final int ANY_FUNC_BUFFER_LENGTH = 16384;
    private static final boolean OPTIMIZE_ANY_FUNC_FOR_JARRAYS = true;
    private static final JArrayPool BOOLEAN_BUFFERS = JArrayPool.getInstance(Boolean.TYPE, 16384);
    private static final JArrayPool CHAR_BUFFERS = JArrayPool.getInstance(Character.TYPE, 16384);
    private static final JArrayPool BYTE_BUFFERS = JArrayPool.getInstance(Byte.TYPE, 16384);
    private static final JArrayPool SHORT_BUFFERS = JArrayPool.getInstance(Short.TYPE, 16384);
    private static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, 16384);
    private static final JArrayPool LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 16384);
    private static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 16384);
    private static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 16384);
    private final boolean truncateOverflows;
    private final PArray[] x;
    private final long length;
    private final Func f;
    private final Object[] ja;
    private final long[] saShift;
    private final long[] subArrayOffset;
    private final int[] srcElementTypeCode;
    private final int destElementTypeCode;
    private final JArrayPool arrayOfDoubleBuffersPool;
    private final JArrayPool argsPool;

    ArraysAnyFuncGetDataOp(boolean truncateOverflows, PArray[] x, Func f, int destElementTypeCode) {
        int k;
        this.truncateOverflows = truncateOverflows;
        this.x = (PArray[])x.clone();
        this.length = this.x[0].length();
        for (PArray xk : this.x) {
            if (xk.length() != this.length) {
                throw new AssertionError((Object)"Different x[] lengths");
            }
        }
        this.f = f;
        this.ja = new Object[this.x.length];
        this.subArrayOffset = new long[this.x.length];
        this.saShift = new long[this.x.length];
        for (k = 0; k < this.x.length; ++k) {
            Array array = this.x[k];
            if (Arrays.isShifted(array)) {
                this.saShift[k] = Arrays.getShift(array);
                array = Arrays.getUnderlyingArrays(array)[0];
            }
            this.ja[k] = Arrays.javaArrayInternal(array);
            if (this.ja[k] == null) continue;
            assert (!(array instanceof BitArray));
            this.subArrayOffset[k] = Arrays.javaArrayOffsetInternal(array);
        }
        this.srcElementTypeCode = new int[x.length];
        for (k = 0; k < this.x.length; ++k) {
            if (this.x[k] instanceof BitArray) {
                this.srcElementTypeCode[k] = 1;
                continue;
            }
            if (this.x[k] instanceof CharArray) {
                this.srcElementTypeCode[k] = 2;
                continue;
            }
            if (this.x[k] instanceof ByteArray) {
                this.srcElementTypeCode[k] = 3;
                continue;
            }
            if (this.x[k] instanceof ShortArray) {
                this.srcElementTypeCode[k] = 4;
                continue;
            }
            if (this.x[k] instanceof IntArray) {
                this.srcElementTypeCode[k] = 5;
                continue;
            }
            if (this.x[k] instanceof LongArray) {
                this.srcElementTypeCode[k] = 6;
                continue;
            }
            if (this.x[k] instanceof FloatArray) {
                this.srcElementTypeCode[k] = 7;
                continue;
            }
            if (this.x[k] instanceof DoubleArray) {
                this.srcElementTypeCode[k] = 8;
                continue;
            }
            throw new AssertionError((Object)("Illegal PArray type: " + String.valueOf(this.x[k].getClass())));
        }
        this.destElementTypeCode = destElementTypeCode;
        this.arrayOfDoubleBuffersPool = JArrayPool.getInstance(double[].class, this.x.length);
        this.argsPool = JArrayPool.getInstance(Double.TYPE, this.x.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x[0].length(), this.x[0].getClass());
        }
        if (arrayPos > this.x[0].length() - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.x[0].length(), this.x[0].getClass());
        }
        while (count > 0) {
            int k;
            int len = Math.min(count, 16384);
            double[] args = (double[])this.argsPool.requestArray();
            double[][] doubleBufs = (double[][])this.arrayOfDoubleBuffersPool.requestArray();
            try {
                block45: for (k = 0; k < this.x.length; ++k) {
                    boolean optimizeJArray;
                    doubleBufs[k] = (double[])DOUBLE_BUFFERS.requestArray();
                    double[] doubleBuf = doubleBufs[k];
                    long p = arrayPos;
                    boolean bl = optimizeJArray = this.ja[k] != null;
                    if (optimizeJArray && (p -= this.saShift[k]) < 0L && (p += this.length) >= this.length - (long)len) {
                        optimizeJArray = false;
                    }
                    switch (this.srcElementTypeCode[k]) {
                        case 1: {
                            int j;
                            Object[] src = (boolean[])BOOLEAN_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src, 0, len);
                                for (j = 0; j < len; ++j) {
                                    doubleBuf[j] = src[j] ? 1.0 : 0.0;
                                }
                                continue block45;
                            }
                            finally {
                                BOOLEAN_BUFFERS.releaseArray(src);
                            }
                        }
                        case 2: {
                            int destPos;
                            int srcPos;
                            int j;
                            Object[] src;
                            if (optimizeJArray) {
                                src = (char[])this.ja[k];
                                srcPos = (int)(p + this.subArrayOffset[k]);
                                for (destPos = 0; destPos < len; ++destPos) {
                                    doubleBuf[destPos] = (double)src[srcPos];
                                    ++srcPos;
                                }
                                continue block45;
                            }
                            src = (char[])CHAR_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src, 0, len);
                                for (j = 0; j < len; ++j) {
                                    doubleBuf[j] = (double)src[j];
                                }
                                continue block45;
                            }
                            finally {
                                CHAR_BUFFERS.releaseArray(src);
                            }
                        }
                        case 3: {
                            int destPos;
                            int srcPos;
                            int j;
                            Object[] src;
                            if (optimizeJArray) {
                                src = (byte[])this.ja[k];
                                srcPos = (int)(p + this.subArrayOffset[k]);
                                for (destPos = 0; destPos < len; ++destPos) {
                                    doubleBuf[destPos] = src[srcPos] & 0xFF;
                                    ++srcPos;
                                }
                                continue block45;
                            }
                            src = (byte[])BYTE_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src, 0, len);
                                for (j = 0; j < len; ++j) {
                                    doubleBuf[j] = src[j] & 0xFF;
                                }
                                continue block45;
                            }
                            finally {
                                BYTE_BUFFERS.releaseArray(src);
                            }
                        }
                        case 4: {
                            int destPos;
                            int srcPos;
                            int j;
                            Object[] src;
                            if (optimizeJArray) {
                                src = (short[])this.ja[k];
                                srcPos = (int)(p + this.subArrayOffset[k]);
                                for (destPos = 0; destPos < len; ++destPos) {
                                    doubleBuf[destPos] = src[srcPos] & 0xFFFF;
                                    ++srcPos;
                                }
                                continue block45;
                            }
                            src = (short[])SHORT_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src, 0, len);
                                for (j = 0; j < len; ++j) {
                                    doubleBuf[j] = src[j] & 0xFFFF;
                                }
                                continue block45;
                            }
                            finally {
                                SHORT_BUFFERS.releaseArray(src);
                            }
                        }
                        case 5: {
                            int destPos;
                            int srcPos;
                            int j;
                            Object[] src;
                            if (optimizeJArray) {
                                src = (int[])this.ja[k];
                                srcPos = (int)(p + this.subArrayOffset[k]);
                                for (destPos = 0; destPos < len; ++destPos) {
                                    doubleBuf[destPos] = (double)src[srcPos];
                                    ++srcPos;
                                }
                                continue block45;
                            }
                            src = (int[])INT_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src, 0, len);
                                for (j = 0; j < len; ++j) {
                                    doubleBuf[j] = (double)src[j];
                                }
                                continue block45;
                            }
                            finally {
                                INT_BUFFERS.releaseArray(src);
                            }
                        }
                        case 6: {
                            int destPos;
                            int srcPos;
                            int j;
                            Object[] src;
                            if (optimizeJArray) {
                                src = (long[])this.ja[k];
                                srcPos = (int)(p + this.subArrayOffset[k]);
                                for (destPos = 0; destPos < len; ++destPos) {
                                    doubleBuf[destPos] = (double)src[srcPos];
                                    ++srcPos;
                                }
                                continue block45;
                            }
                            src = (long[])LONG_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src, 0, len);
                                for (j = 0; j < len; ++j) {
                                    doubleBuf[j] = (double)src[j];
                                }
                                continue block45;
                            }
                            finally {
                                LONG_BUFFERS.releaseArray(src);
                            }
                        }
                        case 7: {
                            int destPos;
                            int srcPos;
                            int j;
                            Object[] src;
                            if (optimizeJArray) {
                                src = (float[])this.ja[k];
                                srcPos = (int)(p + this.subArrayOffset[k]);
                                for (destPos = 0; destPos < len; ++destPos) {
                                    doubleBuf[destPos] = (double)src[srcPos];
                                    ++srcPos;
                                }
                                continue block45;
                            }
                            src = (float[])FLOAT_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src, 0, len);
                                for (j = 0; j < len; ++j) {
                                    doubleBuf[j] = (double)src[j];
                                }
                                continue block45;
                            }
                            finally {
                                FLOAT_BUFFERS.releaseArray(src);
                            }
                        }
                        case 8: {
                            this.x[k].getData(arrayPos, doubleBuf, 0, len);
                            continue block45;
                        }
                        default: {
                            throw new AssertionError((Object)("Illegal srcElementTypeCode[" + k + "]"));
                        }
                    }
                }
                switch (this.destElementTypeCode) {
                    case 1: {
                        Object[] dest = (boolean[])destArray;
                        int j = 0;
                        while (j < len) {
                            for (int k2 = 0; k2 < args.length; ++k2) {
                                args[k2] = doubleBufs[k2][j];
                            }
                            double v = this.f.get(args);
                            dest[destArrayOffset] = v != 0.0;
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 2: {
                        Object[] dest = (char[])destArray;
                        int j = 0;
                        while (j < len) {
                            for (int k3 = 0; k3 < args.length; ++k3) {
                                args[k3] = doubleBufs[k3][j];
                            }
                            double v = this.f.get(args);
                            dest[destArrayOffset] = this.truncateOverflows ? (char)(v < 0.0 ? 0 : (char)(v > 65535.0 ? 65535 : (char)v)) : (char)v;
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 3: {
                        Object[] dest = (byte[])destArray;
                        int j = 0;
                        while (j < len) {
                            for (int k4 = 0; k4 < args.length; ++k4) {
                                args[k4] = doubleBufs[k4][j];
                            }
                            double v = this.f.get(args);
                            dest[destArrayOffset] = this.truncateOverflows ? (byte)(v < 0.0 ? 0 : (byte)(v > 255.0 ? -1 : (byte)v)) : (byte)v;
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 4: {
                        Object[] dest = (short[])destArray;
                        int j = 0;
                        while (j < len) {
                            for (int k5 = 0; k5 < args.length; ++k5) {
                                args[k5] = doubleBufs[k5][j];
                            }
                            double v = this.f.get(args);
                            dest[destArrayOffset] = this.truncateOverflows ? (short)(v < 0.0 ? 0 : (short)(v > 65535.0 ? -1 : (short)v)) : (short)v;
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 5: {
                        Object[] dest = (int[])destArray;
                        int j = 0;
                        while (j < len) {
                            for (int k6 = 0; k6 < args.length; ++k6) {
                                args[k6] = doubleBufs[k6][j];
                            }
                            double v = this.f.get(args);
                            dest[destArrayOffset] = this.truncateOverflows ? (int)v : (int)v;
                            ++j;
                            ++destArrayOffset;
                        }
                        break;
                    }
                    case 6: {
                        int j;
                        Object[] dest = (long[])destArray;
                        if (args.length == 1) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = (long)this.f.get(doubleBufs[0][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (args.length == 2) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = (long)this.f.get(doubleBufs[0][j], doubleBufs[1][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (args.length == 3) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = (long)this.f.get(doubleBufs[0][j], doubleBufs[1][j], doubleBufs[2][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                for (int k7 = 0; k7 < args.length; ++k7) {
                                    args[k7] = doubleBufs[k7][j];
                                }
                                dest[destArrayOffset] = (long)this.f.get(args);
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 7: {
                        int j;
                        Object[] dest = (float[])destArray;
                        if (args.length == 1) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = (float)this.f.get(doubleBufs[0][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (args.length == 2) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = (float)this.f.get(doubleBufs[0][j], doubleBufs[1][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (args.length == 3) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = (float)this.f.get(doubleBufs[0][j], doubleBufs[1][j], doubleBufs[2][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                for (int k8 = 0; k8 < args.length; ++k8) {
                                    args[k8] = doubleBufs[k8][j];
                                }
                                dest[destArrayOffset] = (float)this.f.get(args);
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 8: {
                        int j;
                        Object[] dest = (double[])destArray;
                        if (args.length == 1) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = this.f.get(doubleBufs[0][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (args.length == 2) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = this.f.get(doubleBufs[0][j], doubleBufs[1][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (args.length == 3) {
                            j = 0;
                            while (j < len) {
                                dest[destArrayOffset] = this.f.get(doubleBufs[0][j], doubleBufs[1][j], doubleBufs[2][j]);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                for (int k9 = 0; k9 < args.length; ++k9) {
                                    args[k9] = doubleBufs[k9][j];
                                }
                                dest[destArrayOffset] = this.f.get(args);
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Illegal destElementTypeCode");
                    }
                }
            }
            finally {
                for (k = this.x.length - 1; k >= 0; --k) {
                    DOUBLE_BUFFERS.releaseArray(doubleBufs[k]);
                }
                this.arrayOfDoubleBuffersPool.releaseArray(doubleBufs);
                this.argsPool.releaseArray(args);
            }
            arrayPos += (long)len;
            count -= len;
        }
    }
}

