/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractShortArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableShortArray;

public abstract class AbstractUpdatableShortArray
extends AbstractShortArray
implements UpdatableShortArray {
    protected AbstractUpdatableShortArray(long initialCapacity, long initialLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        super(initialCapacity, initialLength, underlyingArraysAreParallel, underlyingArrays);
    }

    protected AbstractUpdatableShortArray(long initialCapacityAndLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        this(initialCapacityAndLength, initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
    }

    @Override
    public UpdatableShortArray subArray(long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        final AbstractUpdatableShortArray parent = this;
        final long offset = fromIndex;
        return new AbstractUpdatableShortArray(this, toIndex - fromIndex, this.underlyingArraysAreParallel, this.underlyingArrays){

            @Override
            public int getShort(long index) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                return parent.getShort(offset + index);
            }

            @Override
            public void setShort(long index, short value) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                parent.setShort(offset + index, value);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, short value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.indexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, short value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.lastIndexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.getData(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.setData(offset + arrayPos, srcArray, srcArrayOffset, count);
                return this;
            }

            @Override
            public UpdatableShortArray fill(long position, long count, short value) {
                this.checkSubArrArguments(position, count);
                parent.fill(offset + position, count, value);
                return this;
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, offset + fromIndex, offset + toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableShortArray subArr(long position, long count) {
        return this.subArray(position, position + count);
    }

    @Override
    public void setDouble(long index, double value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setLong(long index, long value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setInt(long index, int value) {
        this.setShort(index, (short)value);
    }

    @Override
    public abstract void setShort(long var1, short var3);

    @Override
    public final UpdatableShortArray fill(double value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableShortArray fill(long position, long count, double value) {
        return this.fill(position, count, (short)value);
    }

    @Override
    public final UpdatableShortArray fill(long value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableShortArray fill(long position, long count, long value) {
        return this.fill(position, count, (short)value);
    }

    @Override
    public final UpdatableShortArray fill(short value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableShortArray fill(long position, long count, short value) {
        UpdatableShortArray a = position == 0L && count == this.length() ? this : this.subArr(position, count);
        a.copy(Arrays.nShortCopies(count, value));
        return this;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public ShortArray asImmutable() {
        final AbstractUpdatableShortArray parent = this;
        return new AbstractShortArray(this, this.length, false, this.underlyingArrays){

            @Override
            public int getShort(long index) {
                return parent.getShort(index);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, short value) {
                return parent.indexOf(lowIndex, highIndex, value);
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, short value) {
                return parent.lastIndexOf(lowIndex, highIndex, value);
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                parent.getData(arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public void getData(long arrayPos, Object destArray) {
                parent.getData(arrayPos, destArray);
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, fromIndex, toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableArray shallowClone() {
        return (UpdatableArray)super.shallowClone();
    }

    @Override
    public void setElement(long index, Object value) {
        this.setShort(index, (Short)value);
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        short[] a = (short[])srcArray;
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw this.rangeException(arrayPos);
        }
        if (arrayPos > this.length - (long)count) {
            throw this.rangeException(arrayPos + (long)count - 1L);
        }
        long arrayPosMax = arrayPos + (long)count;
        while (arrayPos < arrayPosMax) {
            this.setShort(arrayPos, a[srcArrayOffset]);
            ++arrayPos;
            ++srcArrayOffset;
        }
        return this;
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        if (arrayPos < 0L || arrayPos > this.length) {
            throw this.rangeException(arrayPos);
        }
        int count = ((short[])srcArray).length;
        if ((long)count > this.length - arrayPos) {
            count = (int)(this.length - arrayPos);
        }
        this.setData(arrayPos, srcArray, 0, count);
        return this;
    }

    @Override
    public void copy(long destIndex, long srcIndex) {
        this.setShort(destIndex, (short)this.getShort(srcIndex));
    }

    @Override
    public void copy(long destIndex, long srcIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        if (srcIndex <= destIndex && srcIndex + count > destIndex) {
            srcIndex += count;
            destIndex += count;
            for (long k = 0L; k < count; ++k) {
                this.copy(--destIndex, --srcIndex);
            }
        } else {
            for (long k = 0L; k < count; ++k) {
                this.copy(destIndex++, srcIndex++);
            }
        }
    }

    @Override
    public void swap(long firstIndex, long secondIndex) {
        short temp = (short)this.getShort(firstIndex);
        this.setShort(firstIndex, (short)this.getShort(secondIndex));
        this.setShort(secondIndex, temp);
    }

    @Override
    public void swap(long firstIndex, long secondIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        for (long k = 0L; k < count; ++k) {
            this.swap(firstIndex++, secondIndex++);
        }
    }

    @Override
    public UpdatableArray copy(Array src) {
        AbstractUpdatableShortArray.defaultCopy(this, src);
        return this;
    }

    @Override
    public UpdatableArray swap(UpdatableArray another) {
        AbstractUpdatableShortArray.defaultSwap(this, another);
        return this;
    }

    @Override
    public void setNonNew() {
        this.setNewStatus(false);
    }

    @Override
    public UpdatableArray asCopyOnNextWrite() {
        return this.updatableClone(Arrays.SMM);
    }

    @Override
    public UpdatableShortArray asUnresizable() {
        return this;
    }

    @Override
    public String toString() {
        return "unresizable AlgART array short[" + this.length + "]" + (String)(this.underlyingArrays.length == 0 ? "" : " based on " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : ""));
    }
}

