/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.LongArray;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableLongArray;

public abstract class AbstractLongArray
extends AbstractArray
implements LongArray {
    final boolean underlyingArraysAreParallel;

    protected AbstractLongArray(long initialCapacity, long initialLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        super(initialCapacity, initialLength, underlyingArrays);
        if (initialLength < 0L) {
            throw new IllegalArgumentException("Negative initialLength argument");
        }
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initialCapacity argument");
        }
        if (initialLength > initialCapacity) {
            throw new IllegalArgumentException("initialCapacity argument must not be less than initialLength");
        }
        Objects.requireNonNull(underlyingArrays, "Null underlyingArrays argument");
        this.underlyingArraysAreParallel = underlyingArraysAreParallel;
        long len = -1L;
        for (int k = 0; k < underlyingArrays.length; ++k) {
            Objects.requireNonNull(underlyingArrays[k], "Null underlyingArrays[" + k + "] argument");
            if (!underlyingArraysAreParallel) continue;
            if (k == 0) {
                len = underlyingArrays[k].length();
                continue;
            }
            if (underlyingArrays[k].length() == len) continue;
            throw new SizeMismatchException("underlyingArrays[" + k + "].length() and underlyingArrays[0].length() mismatch");
        }
    }

    protected AbstractLongArray(long initialCapacityAndLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        this(initialCapacityAndLength, initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
    }

    @Override
    public Class<?> elementType() {
        return Long.TYPE;
    }

    @Override
    public Class<? extends LongArray> type() {
        return LongArray.class;
    }

    @Override
    public Class<? extends UpdatableLongArray> updatableType() {
        return UpdatableLongArray.class;
    }

    @Override
    public Class<? extends MutableLongArray> mutableType() {
        return MutableLongArray.class;
    }

    @Override
    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        long[] a = (long[])destArray;
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw this.rangeException(arrayPos);
        }
        if (arrayPos > this.length - (long)count) {
            throw this.rangeException(arrayPos + (long)count - 1L);
        }
        long arrayPosMax = arrayPos + (long)count;
        while (arrayPos < arrayPosMax) {
            a[destArrayOffset] = this.getLong(arrayPos);
            ++arrayPos;
            ++destArrayOffset;
        }
    }

    @Override
    public void getData(long arrayPos, Object destArray) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (arrayPos < 0L || arrayPos > this.length) {
            throw this.rangeException(arrayPos);
        }
        int count = ((long[])destArray).length;
        if ((long)count > this.length - arrayPos) {
            count = (int)(this.length - arrayPos);
        }
        this.getData(arrayPos, destArray, 0, count);
    }

    @Override
    public Object getElement(long index) {
        return this.getLong(index);
    }

    @Override
    public Array subArray(long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        final AbstractLongArray parent = this;
        final long offset = fromIndex;
        return new AbstractLongArray(this, toIndex - fromIndex, this.underlyingArraysAreParallel, this.underlyingArrays){

            @Override
            public long getLong(long index) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                return parent.getLong(offset + index);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, long value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.indexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, long value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.lastIndexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.getData(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, offset + fromIndex, offset + toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public DataLongBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
        return (DataLongBuffer)super.buffer(mode, capacity);
    }

    @Override
    public DataLongBuffer buffer(DataBuffer.AccessMode mode) {
        return (DataLongBuffer)super.buffer(mode);
    }

    @Override
    public DataLongBuffer buffer(long capacity) {
        return (DataLongBuffer)super.buffer(capacity);
    }

    @Override
    public DataLongBuffer buffer() {
        return (DataLongBuffer)super.buffer();
    }

    @Override
    public long bitsPerElement() {
        return 64L;
    }

    @Override
    public double getDouble(long index) {
        return this.getLong(index);
    }

    @Override
    public long indexOf(long lowIndex, long highIndex, double value) {
        return value == (double)((long)value) ? this.indexOf(lowIndex, highIndex, (long)value) : -1L;
    }

    @Override
    public long lastIndexOf(long lowIndex, long highIndex, double value) {
        return value == (double)((long)value) ? this.lastIndexOf(lowIndex, highIndex, (long)value) : -1L;
    }

    @Override
    public int getInt(long index) {
        return Arrays.truncateLongToInt(this.getLong(index));
    }

    @Override
    public abstract long getLong(long var1);

    @Override
    public long indexOf(long lowIndex, long highIndex, long value) {
        long n = Math.min(this.length(), highIndex);
        for (long k = Math.max(lowIndex, 0L); k < n; ++k) {
            if (this.getLong(k) != value) continue;
            return k;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(long lowIndex, long highIndex, long value) {
        long k = Math.min(this.length(), highIndex);
        long low = Math.max(lowIndex, 0L);
        while (k > low) {
            if (this.getLong(--k) != value) continue;
            return k;
        }
        return -1L;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isUnresizable() {
        return true;
    }

    @Override
    public void checkUnallowedMutation() throws UnallowedMutationError {
    }

    @Override
    public LongArray asTrustedImmutable() {
        return this.asImmutable();
    }

    @Override
    public Array asCopyOnNextWrite() {
        return this;
    }

    @Override
    public boolean isCopyOnNextWrite() {
        return false;
    }

    @Override
    public LongArray asImmutable() {
        return this;
    }

    @Override
    public MutableLongArray mutableClone(MemoryModel memoryModel) {
        return (MutableLongArray)super.mutableClone(memoryModel);
    }

    @Override
    public UpdatableLongArray updatableClone(MemoryModel memoryModel) {
        return (UpdatableLongArray)super.updatableClone(memoryModel);
    }

    @Override
    public long[] ja() {
        return (long[])super.ja();
    }

    @Override
    public void loadResources(ArrayContext context) {
        this.loadResources(context, 0L, this.length());
    }

    @Override
    public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        this.flushResources(context, 0L, this.length(), forcePhysicalWriting);
    }

    @Override
    public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        this.freeResources(context, 0L, this.length(), forcePhysicalWriting);
    }

    protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).loadResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length));
            }
        }
    }

    protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).flushResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
            }
        } else {
            super.flushResources(context, forcePhysicalWriting);
        }
    }

    protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).freeResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
            }
        } else {
            super.freeResources(context, forcePhysicalWriting);
        }
    }

    @Override
    public String toString() {
        return "immutable AlgART array long[" + this.length + "]" + (String)(this.underlyingArrays.length == 0 ? "" : " based on " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : ""));
    }

    @Override
    Object javaArrayInternal() {
        return null;
    }

    @Override
    int javaArrayOffsetInternal() {
        return 0;
    }

    @Override
    public double minPossibleValue(double valueForFloatingPoint) {
        return this.minPossibleValue();
    }

    @Override
    public double maxPossibleValue(double valueForFloatingPoint) {
        return this.maxPossibleValue();
    }

    @Override
    public long minPossibleValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public long maxPossibleValue() {
        return Long.MAX_VALUE;
    }
}

