/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import java.util.Objects;
import net.algart.executors.api.data.SScalar;
import org.graalvm.polyglot.Value;

public class GraalValues {
    private GraalValues() {
    }

    public static boolean toSmartBoolean(Value value) {
        Objects.requireNonNull(value, "Null value");
        if (value.isNull()) {
            return false;
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        String s = String.valueOf(value.as(Object.class));
        return Boolean.parseBoolean(s);
    }

    public static double toSmartDouble(Value value) {
        Objects.requireNonNull(value, "Null value");
        if (value.isNumber()) {
            if (value.fitsInDouble()) {
                return value.asDouble();
            }
            if (value.fitsInLong()) {
                return value.asLong();
            }
        }
        Object object = value.isNull() ? null : value.as(Object.class);
        return object == null ? Double.NaN : Double.parseDouble(object.toString());
    }

    public static String toSmartString(Value value, boolean briefIntegerForm) {
        Objects.requireNonNull(value, "Null value");
        if (value.isNull()) {
            return null;
        }
        if (briefIntegerForm && value.isNumber() && value.fitsInDouble()) {
            double v = value.asDouble();
            if (v == (double)((int)v)) {
                return String.valueOf((int)v);
            }
            return String.valueOf(v);
        }
        Object object = value.as(Object.class);
        if (object instanceof SScalar) {
            SScalar scalar = (SScalar)object;
            return scalar.getValue();
        }
        return String.valueOf(object);
    }
}

