/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.conversions;

import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.scalars.copying.CopyScalar;

public class NumericRangeToConstant
extends CopyScalar {
    private Double min = 0.0;
    private Double max = 0.0;
    private String replacement = "";

    public Double getMin() {
        return this.min;
    }

    public NumericRangeToConstant setMin(Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public NumericRangeToConstant setMax(Double max) {
        this.max = max;
        return this;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public NumericRangeToConstant setReplacement(String replacement) {
        this.replacement = NumericRangeToConstant.nonNull(replacement);
        return this;
    }

    @Override
    public void process() {
        SScalar input = this.getInputScalar(true);
        if (this.needToReplace(input.getValue())) {
            NumericRangeToConstant.logDebug(() -> "Replacing scalar " + String.valueOf(input) + " with \"" + this.replacement + "\"");
            this.getScalar().setTo(this.replacement);
        } else {
            super.process();
        }
    }

    private boolean needToReplace(String inputValue) {
        double value;
        if (inputValue == null) {
            return false;
        }
        try {
            value = Double.parseDouble(inputValue);
        }
        catch (NumberFormatException ignored) {
            return false;
        }
        if (this.min != null && value < this.min) {
            return false;
        }
        if (this.max != null && value > this.max) {
            return false;
        }
        return this.min != null || this.max != null;
    }
}

