/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.statistics;

import java.util.Arrays;
import java.util.Locale;
import net.algart.arrays.ArrayComparator;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.NumberArrayFilter;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.PowerFunc;

public final class NumbersStatistics
extends NumberArrayFilter
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_HISTOGRAM = "histogram";
    public static final String OUTPUT_MEAN = "mean";
    public static final String OUTPUT_SUM = "sum";
    public static final String OUTPUT_VARIANCE = "variance";
    public static final String OUTPUT_STANDARD_DEVIATION = "standard_deviation";
    public static final String OUTPUT_PERCENTILES_PREFIX = "percentile_";
    public static final String OUTPUT_ALL_PERCENTILES = "percentiles";
    public static final String OUTPUT_NUMBER_OF_BLOCKS = "number_of_blocks";
    public static final String OUTPUT_BLOCK_LENGTH = "block_length";
    public static final String OUTPUT_ARRAY_LENGTH = "array_length";
    public static final String OUTPUT_HASH = "hash";
    private int numberOfHistogramColumns = 100;
    private Double histogramFrom = null;
    private Double histogramTo = null;
    private double[] percentileLevels = new double[0];

    public NumbersStatistics() {
        this.useVisibleResultParameter();
        this.setDefaultOutputNumbers(OUTPUT_HISTOGRAM);
        this.addOutputScalar(OUTPUT_MEAN);
        this.addOutputScalar(OUTPUT_SUM);
        this.addOutputScalar(OUTPUT_VARIANCE);
        this.addOutputScalar(OUTPUT_STANDARD_DEVIATION);
        this.addOutputScalar(NumbersStatistics.outputPercentilePortName(0));
        this.addOutputScalar(NumbersStatistics.outputPercentilePortName(1));
        this.addOutputNumbers(OUTPUT_ALL_PERCENTILES);
        this.addOutputScalar(OUTPUT_NUMBER_OF_BLOCKS);
        this.addOutputScalar(OUTPUT_BLOCK_LENGTH);
        this.addOutputScalar(OUTPUT_ARRAY_LENGTH);
        this.addOutputScalar(OUTPUT_HASH);
    }

    public int getNumberOfHistogramColumns() {
        return this.numberOfHistogramColumns;
    }

    public NumbersStatistics setNumberOfHistogramColumns(int numberOfHistogramColumns) {
        this.numberOfHistogramColumns = NumbersStatistics.positive(numberOfHistogramColumns);
        return this;
    }

    public Double getHistogramFrom() {
        return this.histogramFrom;
    }

    public NumbersStatistics setHistogramFrom(Double histogramFrom) {
        this.histogramFrom = histogramFrom;
        return this;
    }

    public NumbersStatistics setHistogramFrom(String histogramFrom) {
        return this.setHistogramFrom(NumbersStatistics.doubleOrNull(histogramFrom));
    }

    public Double getHistogramTo() {
        return this.histogramTo;
    }

    public NumbersStatistics setHistogramTo(Double histogramTo) {
        this.histogramTo = histogramTo;
        return this;
    }

    public NumbersStatistics setHistogramTo(String histogramTo) {
        return this.setHistogramTo(NumbersStatistics.doubleOrNull(histogramTo));
    }

    public double[] getPercentileLevels() {
        return (double[])this.percentileLevels.clone();
    }

    public NumbersStatistics setPercentileLevels(double[] percentileLevels) {
        this.percentileLevels = NumbersStatistics.nonNull(percentileLevels);
        return this;
    }

    public NumbersStatistics setPercentileLevels(String percentileLevels) {
        this.percentileLevels = new SScalar(NumbersStatistics.nonNull(percentileLevels)).toDoubles();
        return this;
    }

    @Override
    public PArray process(UpdatablePNumberArray array, int blockLength, int numberOfBlocks) {
        PArray result;
        long t1 = NumbersStatistics.debugTime();
        if (this.isOutputNecessary(this.defaultOutputPortName())) {
            long[] histogram = NumbersStatistics.analyseHistogram((PArray)array, this.numberOfHistogramColumns, this.histogramFrom, this.histogramTo);
            result = net.algart.arrays.Arrays.asFuncArray((Func)Func.IDENTITY, IntArray.class, (PArray[])new PArray[]{SimpleMemoryModel.asUpdatableLongArray((long[])histogram)});
        } else {
            result = null;
        }
        double sum = net.algart.arrays.Arrays.sumOf((PArray)array);
        this.getScalar(OUTPUT_SUM).setTo(sum);
        double average = sum / (double)array.length();
        this.getScalar(OUTPUT_MEAN).setTo(average);
        double variance = NumbersStatistics.analyseVariance((PArray)array, average);
        this.getScalar(OUTPUT_VARIANCE).setTo(variance);
        this.getScalar(OUTPUT_STANDARD_DEVIATION).setTo(Math.sqrt(variance));
        double[] percentiles = NumbersStatistics.analysePercentiles((UpdatablePArray)array, this.percentileLevels);
        for (int k = 0; k < percentiles.length; ++k) {
            String portName = NumbersStatistics.outputPercentilePortName(k);
            if (!this.hasOutputPort(portName)) continue;
            this.getScalar(portName).setTo(percentiles[k]);
        }
        this.getNumbers(OUTPUT_ALL_PERCENTILES).setTo(percentiles, 1);
        long t2 = NumbersStatistics.debugTime();
        NumbersStatistics.logDebug(String.format(Locale.US, "Calculating statistics for %dx%d numbers: %.3f ms (%.3f ns/block)", blockLength, numberOfBlocks, (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / (double)numberOfBlocks));
        this.getScalar(OUTPUT_NUMBER_OF_BLOCKS).setTo(numberOfBlocks);
        this.getScalar(OUTPUT_BLOCK_LENGTH).setTo(blockLength);
        this.getScalar(OUTPUT_ARRAY_LENGTH).setTo(array.length());
        if (this.isOutputNecessary(OUTPUT_HASH)) {
            this.getScalar(OUTPUT_HASH).setTo(array.hashCode());
        }
        return result;
    }

    public static long[] analyseHistogram(PArray array, int numberOfHistogramColumns, Double histogramFrom, Double histogramTo) {
        double to;
        long[] histogram = new long[numberOfHistogramColumns];
        if (numberOfHistogramColumns == 0) {
            return histogram;
        }
        Range range = histogramFrom == null || histogramTo == null ? net.algart.arrays.Arrays.rangeOf((PArray)array) : null;
        double from = histogramFrom == null ? range.min() : histogramFrom.doubleValue();
        if (histogramTo == null) {
            double increasedSize = (range.max() - from) * ((double)histogram.length / ((double)histogram.length - 1.0));
            to = from + increasedSize;
        } else {
            to = histogramTo;
        }
        if (from == to) {
            BitArray nonEqual = (BitArray)net.algart.arrays.Arrays.asFuncArray((Func)LinearFunc.getInstance((double)from, (double[])new double[]{-1.0}), BitArray.class, (PArray[])new PArray[]{array});
            histogram[0] = array.length() - net.algart.arrays.Arrays.cardinality((BitArray)nonEqual);
        } else {
            net.algart.arrays.Arrays.histogramOf((PArray)array, (long[])histogram, (double)from, (double)to);
        }
        return histogram;
    }

    public static double analyseVariance(PArray array, double average) {
        DoubleArray arrayMinusAverage = (DoubleArray)net.algart.arrays.Arrays.asFuncArray((Func)LinearFunc.getInstance((double)(-average), (double[])new double[]{1.0}), DoubleArray.class, (PArray[])new PArray[]{array});
        DoubleArray differenceSquares = (DoubleArray)net.algart.arrays.Arrays.asFuncArray((Func)PowerFunc.getInstance((double)2.0), DoubleArray.class, (PArray[])new PArray[]{arrayMinusAverage});
        return net.algart.arrays.Arrays.sumOf((PArray)differenceSquares) / (double)array.length();
    }

    public static double[] analysePercentiles(UpdatablePArray array, double[] percentileLevels) {
        for (int k = 0; k < percentileLevels.length; ++k) {
            if (!(percentileLevels[k] < 0.0) && !(percentileLevels[k] > 1.0)) continue;
            throw new IllegalArgumentException("Illegal percentile level #" + k + " = " + percentileLevels[k] + ": it is out of range 0..1");
        }
        double[] result = new double[percentileLevels.length];
        if (result.length == 0) {
            return result;
        }
        NumbersStatistics.sort(array);
        long n = array.length();
        for (int k = 0; k < result.length; ++k) {
            result[k] = n == 0L ? Double.NaN : array.getDouble(Math.round(percentileLevels[k] * (double)(n - 1L)));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void sort(UpdatablePArray array) {
        if (array instanceof DirectAccessible) {
            DirectAccessible da = (DirectAccessible)array;
            if (((DirectAccessible)array).hasJavaArray()) {
                int offset = da.javaArrayOffset();
                int length = da.javaArrayLength();
                if (array instanceof ByteArray) {
                    Arrays.parallelSort((byte[])da.javaArray(), offset, offset + length);
                    return;
                }
                if (array instanceof ShortArray) {
                    Arrays.parallelSort((short[])da.javaArray(), offset, offset + length);
                    return;
                }
                if (array instanceof IntArray) {
                    Arrays.parallelSort((int[])da.javaArray(), offset, offset + length);
                    return;
                }
                if (array instanceof LongArray) {
                    Arrays.parallelSort((long[])da.javaArray(), offset, offset + length);
                    return;
                }
                if (array instanceof FloatArray) {
                    Arrays.parallelSort((float[])da.javaArray(), offset, offset + length);
                    return;
                }
                if (array instanceof DoubleArray) {
                    Arrays.parallelSort((double[])da.javaArray(), offset, offset + length);
                    return;
                }
                net.algart.arrays.Arrays.sort((UpdatableArray)array, (ArrayComparator)net.algart.arrays.Arrays.normalOrderComparator((UpdatableArray)array));
                return;
            }
        }
        net.algart.arrays.Arrays.sort((UpdatableArray)array, (ArrayComparator)net.algart.arrays.Arrays.normalOrderComparator((UpdatableArray)array));
    }

    @Override
    protected Integer resultBlockLength() {
        return 1;
    }

    @Override
    protected boolean resultRequired() {
        return false;
    }

    private static String outputPercentilePortName(int index) {
        return OUTPUT_PERCENTILES_PREFIX + (index + 1);
    }
}

