/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

public enum ValuesDistanceMetric {
    ELEMENTWISE_ABSOLUTE_DIFFERENCE{

        @Override
        public double distance(double[] a, double[] b, double[] valuesWeights) {
            throw new UnsupportedOperationException(String.valueOf((Object)this) + " does not allow return single number");
        }

        @Override
        public void distance(double[] result, double[] a, double[] b, double[] valuesWeights) {
            ValuesDistanceMetric.check(a, b, valuesWeights);
            for (int k = 0; k < a.length; ++k) {
                result[k] = Math.abs(a[k] - b[k]);
            }
        }
    }
    ,
    EUCLIDEAN{

        @Override
        public double distance(double[] a, double[] b, double[] valuesWeights) {
            return Math.sqrt(SUM_OF_SQUARES.distance(a, b, valuesWeights));
        }
    }
    ,
    NORMALIZED_EUCLIDEAN{

        @Override
        public double distance(double[] a, double[] b, double[] valuesWeights) {
            return Math.sqrt(SUM_OF_SQUARES.distance(a, b, valuesWeights) / (double)a.length);
        }
    }
    ,
    SUM_OF_SQUARES{

        @Override
        public double distance(double[] a, double[] b, double[] valuesWeights) {
            ValuesDistanceMetric.check(a, b, valuesWeights);
            double sum = 0.0;
            for (int k = 0; k < a.length; ++k) {
                double d = (a[k] - b[k]) * valuesWeights[k];
                sum += d * d;
            }
            return sum;
        }
    }
    ,
    MEAN_ABSOLUTE_DIFFERENCE{

        @Override
        public double distance(double[] a, double[] b, double[] valuesWeights) {
            return SUM_OF_ABSOLUTE_DIFFERENCES.distance(a, b, valuesWeights) / (double)a.length;
        }
    }
    ,
    SUM_OF_ABSOLUTE_DIFFERENCES{

        @Override
        public double distance(double[] a, double[] b, double[] valuesWeights) {
            ValuesDistanceMetric.check(a, b, valuesWeights);
            double sum = 0.0;
            for (int k = 0; k < a.length; ++k) {
                double d = (a[k] - b[k]) * valuesWeights[k];
                sum += Math.abs(d);
            }
            return sum;
        }
    }
    ,
    MAX_ABSOLUTE_DIFFERENCE{

        @Override
        public double distance(double[] a, double[] b, double[] valuesWeights) {
            ValuesDistanceMetric.check(a, b, valuesWeights);
            double max = 0.0;
            for (int k = 0; k < a.length; ++k) {
                double d = Math.abs(a[k] - b[k]) * valuesWeights[k];
                if (!(d > max)) continue;
                max = d;
            }
            return max;
        }
    };


    public boolean isSingleNumber() {
        return this != ELEMENTWISE_ABSOLUTE_DIFFERENCE;
    }

    public int resultLength(int sourceLength) {
        return this == ELEMENTWISE_ABSOLUTE_DIFFERENCE ? sourceLength : 1;
    }

    public void distance(double[] result, double[] a, double[] b, double[] valuesWeights) {
        result[0] = this.distance(a, b, valuesWeights);
    }

    public abstract double distance(double[] var1, double[] var2, double[] var3);

    private static void check(double[] a, double[] b, double[] weights) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Different array lengths: a.length=" + a.length + ", b.length=" + b.length);
        }
        if (a.length != weights.length) {
            throw new IllegalArgumentException("Different array lengths: a.length=b.length=" + a.length + ", weights.length=" + weights.length);
        }
    }
}

