/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import net.algart.arrays.ArraySorter;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.executors.modules.core.numbers.misc.InvertTable;

public final class SortNumbers
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_SORTED_INDEXES = "sorted_indexes";
    public static final String OUTPUT_REVERSE_INDEXES = "reverse_indexes";
    private int sortedIndexInBlock = 0;
    private boolean descending = false;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public SortNumbers() {
        this.addOutputNumbers(OUTPUT_SORTED_INDEXES);
        this.addOutputNumbers(OUTPUT_REVERSE_INDEXES);
    }

    public int getSortedIndexInBlock() {
        return this.sortedIndexInBlock;
    }

    public SortNumbers setSortedIndexInBlock(int sortedIndexInBlock) {
        this.sortedIndexInBlock = SortNumbers.nonNegative(sortedIndexInBlock);
        return this;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public SortNumbers setDescending(boolean descending) {
        this.descending = descending;
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public SortNumbers setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = SortNumbers.nonNull(indexingBase);
        return this;
    }

    @Override
    protected SNumbers processNumbers(SNumbers source) {
        int blockLength = source.getBlockLength();
        if (this.sortedIndexInBlock < 0 || this.sortedIndexInBlock >= blockLength) {
            throw new IllegalArgumentException("Sorted index " + this.sortedIndexInBlock + " is out of range 0.." + (blockLength - 1));
        }
        SNumbers r = source.clone();
        int[] indexes = new int[r.n()];
        for (int k = 0; k < indexes.length; ++k) {
            indexes[k] = k + this.indexingBase.start;
        }
        ArraySorter.getQuickSorter().sort(0, r.n(), (firstIndex, secondIndex) -> {
            double v1 = r.getValue(firstIndex, this.sortedIndexInBlock);
            double v2 = r.getValue(secondIndex, this.sortedIndexInBlock);
            return this.descending ? v1 > v2 || v1 == v2 && indexes[firstIndex] > indexes[secondIndex] : v1 < v2 || v1 == v2 && indexes[firstIndex] < indexes[secondIndex];
        }, (firstIndex, secondIndex) -> {
            Object block1 = r.getBlockValues(firstIndex, null);
            Object block2 = r.getBlockValues(secondIndex, null);
            r.setBlockValues(firstIndex, block2);
            r.setBlockValues(secondIndex, block1);
            int temp = indexes[firstIndex];
            indexes[firstIndex] = indexes[secondIndex];
            indexes[secondIndex] = temp;
        });
        this.getNumbers(OUTPUT_SORTED_INDEXES).setTo(indexes, 1);
        int[] reverse = InvertTable.invert(indexes, this.indexingBase.start);
        this.getNumbers(OUTPUT_REVERSE_INDEXES).setTo(reverse, 1);
        return r;
    }
}

