/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.IRange;

public enum SimpleArrayStatistics {
    MEAN("mean", n -> Arrays.sumOf((PArray)n.asNumberArray()) / (double)n.getArrayLength()),
    SUM("sum", n -> Arrays.sumOf((PArray)n.asNumberArray())),
    MIN("min", (n, r) -> n.minInColumnRange((int)r.min(), (int)r.size(), false)),
    MAX("max", (n, r) -> n.maxInColumnRange((int)r.min(), (int)r.size(), false)),
    MAX_ABS("max_abs", (n, r) -> n.maxAbsInColumnRange((int)r.min(), (int)r.size(), false)),
    MIN_OF_ORDINARY("min_of_ordinary", (n, r) -> n.minInColumnRange((int)r.min(), (int)r.size(), true)),
    MAX_OF_ORDINARY("max_of_ordinary", (n, r) -> n.maxInColumnRange((int)r.min(), (int)r.size(), true)),
    MAX_ABS_OF_ORDINARY("max_abs_of_ordinary", (n, r) -> n.maxAbsInColumnRange((int)r.min(), (int)r.size(), true)),
    HASH("hash", SNumbers::hashCode);

    private final boolean quickRangeInBlockProcessing;
    private final String statisticsName;
    private final ToDoubleFunction<SNumbers> fullStatistics;
    private final ToDoubleBiFunction<SNumbers, IRange> rangeStatistics;

    private SimpleArrayStatistics(String statisticsName, ToDoubleFunction<SNumbers> fullStatistics) {
        this.statisticsName = statisticsName;
        this.quickRangeInBlockProcessing = false;
        this.fullStatistics = fullStatistics;
        this.rangeStatistics = null;
    }

    private SimpleArrayStatistics(String statisticsName, ToDoubleBiFunction<SNumbers, IRange> rangeStatistics) {
        this.statisticsName = statisticsName;
        this.quickRangeInBlockProcessing = true;
        this.fullStatistics = null;
        this.rangeStatistics = rangeStatistics;
    }

    public String statisticsName() {
        return this.statisticsName;
    }

    public boolean isQuickRangeInBlockProcessing() {
        return this.quickRangeInBlockProcessing;
    }

    public double statistics(SNumbers numbers, int indexInBlock, int lengthInBlock) {
        numbers.checkStartIndexAndLenthInBlock(indexInBlock, lengthInBlock, true);
        if (this.quickRangeInBlockProcessing) {
            IRange range = IRange.valueOf((long)indexInBlock, (long)(indexInBlock + lengthInBlock - 1));
            return this.rangeStatistics.applyAsDouble(numbers, range);
        }
        if (indexInBlock != 0 || lengthInBlock != numbers.getBlockLength()) {
            numbers = numbers.columnRange(indexInBlock, lengthInBlock);
        }
        return this.fullStatistics.applyAsDouble(numbers);
    }
}

