/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.math.RectangularArea;

public final class RectangularAreaToScalars
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_MIN_X = "min_x";
    public static final String OUTPUT_MAX_X = "max_x";
    public static final String OUTPUT_MIN_Y = "min_y";
    public static final String OUTPUT_MAX_Y = "max_y";
    public static final String OUTPUT_MIN_Z = "min_z";
    public static final String OUTPUT_MAX_Z = "max_z";

    public RectangularAreaToScalars() {
        this.setDefaultInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputScalar(OUTPUT_MIN_X);
        this.addOutputScalar(OUTPUT_MAX_X);
        this.addOutputScalar(OUTPUT_MIN_Y);
        this.addOutputScalar(OUTPUT_MAX_Y);
        this.addOutputScalar(OUTPUT_MIN_Z);
        this.addOutputScalar(OUTPUT_MAX_Z);
    }

    @Override
    public void process() {
        RectangularArea area = this.getInputNumbers(this.defaultInputPortName()).toRectangularArea();
        this.getScalar(OUTPUT_MIN_X).setTo(area.minX());
        this.getScalar(OUTPUT_MAX_X).setTo(area.maxX());
        if (area.coordCount() >= 2) {
            this.getScalar(OUTPUT_MIN_Y).setTo(area.minY());
            this.getScalar(OUTPUT_MAX_Y).setTo(area.maxY());
        }
        if (area.coordCount() >= 3) {
            this.getScalar(OUTPUT_MIN_Z).setTo(area.minZ());
            this.getScalar(OUTPUT_MAX_Z).setTo(area.maxZ());
        }
    }
}

