/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;
import net.algart.executors.modules.core.numbers.conversions.MergeNumbers;

public final class CombineNamedNumbersColumns
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String COLUMN_NAMES_PREFIX = "columnNames";
    public static final String OUTPUT_COLUMN_NAMES = "column_names";
    private static final int INPUT_PORT_PREFIX_LENGTH = "input_".length();
    private boolean requireAllColumns = false;
    private MergeNumbers.ResultElementType resultElementType = MergeNumbers.ResultElementType.FIRST_INPUT;
    private String resultColumnNames = "";
    private List<String> resultColumnNamesList = Collections.emptyList();
    private Set<String> resultColumnNamesSet = Collections.emptySet();
    private final Map<Integer, List<String>> columnNames = new HashMap<Integer, List<String>>();

    public CombineNamedNumbersColumns() {
        super(new String[0]);
        this.addOutputScalar(OUTPUT_COLUMN_NAMES);
    }

    public boolean requireAllColumns() {
        return this.requireAllColumns;
    }

    public CombineNamedNumbersColumns setRequireAllColumns(boolean requireAllColumns) {
        this.requireAllColumns = requireAllColumns;
        return this;
    }

    public MergeNumbers.ResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public CombineNamedNumbersColumns setResultElementType(MergeNumbers.ResultElementType resultElementType) {
        this.resultElementType = CombineNamedNumbersColumns.nonNull(resultElementType);
        return this;
    }

    public String resultColumnNames() {
        return this.resultColumnNames;
    }

    public CombineNamedNumbersColumns setResultColumnNames(String resultColumnNames) {
        this.resultColumnNamesList = SScalar.splitJsonOrTrimmedLinesWithoutComments(CombineNamedNumbersColumns.nonNull(resultColumnNames));
        this.resultColumnNames = resultColumnNames;
        this.resultColumnNamesSet = new HashSet<String>(this.resultColumnNamesList);
        return this;
    }

    public List<String> getColumnNames(int indexStartingFrom1) {
        return this.columnNames.getOrDefault(indexStartingFrom1, Collections.emptyList());
    }

    public CombineNamedNumbersColumns setColumnNames(int indexStartingFrom1, List<String> columnNames) {
        this.columnNames.put(indexStartingFrom1, CombineNamedNumbersColumns.nonNull(columnNames));
        return this;
    }

    @Override
    public void onChangeParameter(String name) {
        if (name.startsWith(COLUMN_NAMES_PREFIX)) {
            int index;
            try {
                index = Integer.parseInt(name.substring(COLUMN_NAMES_PREFIX.length()));
            }
            catch (NumberFormatException ignored) {
                return;
            }
            String value = this.parameters().getString(name);
            this.setColumnNames(index, SScalar.splitJsonOrTrimmedLinesWithoutComments(value));
            return;
        }
        super.onChangeParameter(name);
    }

    @Override
    public Boolean checkInputNecessary(Port inputPort) {
        if (inputPort == null) {
            return null;
        }
        String inputPortName = inputPort.getName();
        int length = inputPortName.length();
        if (length < INPUT_PORT_PREFIX_LENGTH || !"input_".equals(inputPortName.substring(0, INPUT_PORT_PREFIX_LENGTH))) {
            return null;
        }
        int index = Integer.parseInt(inputPortName.substring(INPUT_PORT_PREFIX_LENGTH));
        return this.isSourceNecessary(index);
    }

    @Override
    public SNumbers processNumbers(List<SNumbers> sources) {
        if (this.resultColumnNamesList.isEmpty()) {
            return new SNumbers();
        }
        if (sources.stream().noneMatch(Objects::nonNull)) {
            if (this.requireAllColumns) {
                throw new IllegalArgumentException("There are no initialized input arrays");
            }
            return new SNumbers();
        }
        Class<?> resultElementType = MergeNumbers.findElementType(sources, this.resultElementType);
        assert (resultElementType != null) : "must not be null if there are non-null sources: " + String.valueOf(sources);
        int n = sources.stream().filter(Objects::nonNull).findFirst().map(SNumbers::n).orElse(0);
        ArrayList<SNumbers> actualSources = new ArrayList<SNumbers>();
        long t1 = CombineNamedNumbersColumns.debugTime();
        int m = sources.size();
        for (int i = 0; i < m; ++i) {
            SNumbers source = sources.get(i);
            if (source != null && source.elementType() != resultElementType && this.isSourceNecessary(i + 1).booleanValue()) {
                source = source.toPrecision(resultElementType);
            }
            actualSources.add(source);
        }
        long t2 = CombineNamedNumbersColumns.debugTime();
        List<ColumnIndex> columnIndexes = this.findColumnIndexes(actualSources);
        boolean allFloat = resultElementType == Float.TYPE && columnIndexes.stream().allMatch(ColumnIndex::isFloatOrNull);
        int resultBlockLength = columnIndexes.size();
        SNumbers result = SNumbers.zeros(resultElementType, n, resultBlockLength);
        if (!allFloat && !columnIndexes.stream().allMatch(Objects::nonNull)) {
            result.fillValue(Double.NaN);
        }
        long t3 = CombineNamedNumbersColumns.debugTime();
        if (allFloat) {
            CombineNamedNumbersColumns.combineFloats(result, columnIndexes);
        } else {
            for (int j = 0; j < resultBlockLength; ++j) {
                ColumnIndex columnIndex = columnIndexes.get(j);
                if (columnIndex == null) continue;
                result.replaceColumnRange(j, columnIndex.source, columnIndex.index, 1);
            }
        }
        long t4 = CombineNamedNumbersColumns.debugTime();
        CombineNamedNumbersColumns.logDebug(() -> String.format(Locale.US, "Combining %d named columns (%d rows): %.3f ms = %.3f ms cast + %.3f ms creating  + %.3f ms combining", result.getBlockLength(), result.n(), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
        this.getScalar(OUTPUT_COLUMN_NAMES).setTo(String.join((CharSequence)"\n", this.resultColumnNamesList));
        return result;
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return super.visibleResultsInformation().addPorts(this.getOutputPort(OUTPUT_COLUMN_NAMES));
    }

    @Override
    protected boolean allowAllUninitializedInputs() {
        return true;
    }

    @Override
    protected boolean numberOfBlocksEqualityRequired() {
        return true;
    }

    @Override
    protected boolean blockLengthEqualityRequired() {
        return false;
    }

    private Boolean isSourceNecessary(int indexStartingFrom1) {
        for (String name : this.getColumnNames(indexStartingFrom1)) {
            if (!this.resultColumnNamesSet.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static void combineFloats(SNumbers result, List<ColumnIndex> columnIndexes) {
        float[] resultArray = (float[])result.arrayReference();
        ColumnIndex[] columnIndexesArray = columnIndexes.toArray(new ColumnIndex[0]);
        int n = result.n();
        int resultBlockLength = result.getBlockLength();
        assert (resultBlockLength == columnIndexesArray.length);
        boolean allNonNull = columnIndexes.stream().allMatch(Objects::nonNull);
        IntStream.range(0, n + 255 >>> 8).parallel().forEach(allNonNull ? block -> {
            int i;
            int disp = i * resultBlockLength;
            int to = (int)Math.min((long)i + 256L, (long)n);
            for (i = block << 8; i < to; ++i) {
                for (ColumnIndex columnIndex : columnIndexesArray) {
                    resultArray[disp++] = columnIndex.getValue(i);
                }
            }
        } : block -> {
            int i;
            int disp = i * resultBlockLength;
            int to = (int)Math.min((long)i + 256L, (long)n);
            for (i = block << 8; i < to; ++i) {
                for (ColumnIndex columnIndex : columnIndexesArray) {
                    resultArray[disp++] = columnIndex == null ? Float.NaN : columnIndex.getValue(i);
                }
            }
        });
    }

    private List<ColumnIndex> findColumnIndexes(List<SNumbers> sources) {
        int i = 0;
        for (SNumbers source : sources) {
            List<String> sourceNames = this.getColumnNames(++i);
            if (source == null || sourceNames.size() <= source.getBlockLength()) continue;
            throw new IllegalArgumentException("The input array #" + i + " has only " + source.getBlockLength() + " columns, but " + sourceNames.size() + " column names are specified for it: " + String.valueOf(sourceNames));
        }
        ArrayList<ColumnIndex> result = new ArrayList<ColumnIndex>();
        for (String name : this.resultColumnNamesList) {
            ColumnIndex columnIndex = null;
            i = 0;
            for (SNumbers source : sources) {
                List<String> sourceNames;
                int index;
                if ((index = (sourceNames = this.getColumnNames(++i)).indexOf(name)) == -1) continue;
                if (source == null) {
                    throw new IllegalArgumentException("The input array #" + i + " is not initialized, though it is required for calculating result column \"" + name + "\"");
                }
                columnIndex = new ColumnIndex(source, index);
                break;
            }
            if (columnIndex == null && this.requireAllColumns) {
                throw new IllegalArgumentException("Result column name \"" + name + "\" is not found among column names of the source arrays");
            }
            result.add(columnIndex);
        }
        return result;
    }

    private static class ColumnIndex {
        final SNumbers source;
        final int index;
        final float[] floats;
        final int blockLength;

        ColumnIndex(SNumbers source, int index) {
            this.source = Objects.requireNonNull(source);
            this.index = index;
            this.floats = source.isFloatArray() ? (float[])source.arrayReference() : null;
            this.blockLength = source.getBlockLength();
        }

        float getValue(int rowIndex) {
            return this.floats[rowIndex * this.blockLength + this.index];
        }

        static boolean isFloatOrNull(ColumnIndex columnIndex) {
            return columnIndex == null || columnIndex.source.isFloatArray();
        }
    }
}

