/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.json.Jsons;

public final class ScaleAndExtractColumns
extends NumbersFilter {
    public static final String INPUT_WEIGHTS = "weights";
    public static final String INPUT_COLUMN_NAMES = "column_names";
    public static final String INPUT_WEIGHTS_JSON = "weights_json";
    public static final String OUTPUT_COLUMN_NAMES = "column_names";
    private boolean removeColumnsWithZeroWeight = false;
    private boolean removeColumnsAbsentInWeightJson = false;
    private boolean removeColumnsFilledByNaN = false;
    private boolean requireNonEmptyResult = true;

    public ScaleAndExtractColumns() {
        this.addInputNumbers(INPUT_WEIGHTS);
        this.addInputScalar("column_names");
        this.addInputScalar(INPUT_WEIGHTS_JSON);
        this.addOutputScalar("column_names");
    }

    public boolean isRemoveColumnsWithZeroWeight() {
        return this.removeColumnsWithZeroWeight;
    }

    public ScaleAndExtractColumns setRemoveColumnsWithZeroWeight(boolean removeColumnsWithZeroWeight) {
        this.removeColumnsWithZeroWeight = removeColumnsWithZeroWeight;
        return this;
    }

    public boolean isRemoveColumnsAbsentInWeightJson() {
        return this.removeColumnsAbsentInWeightJson;
    }

    public ScaleAndExtractColumns setRemoveColumnsAbsentInWeightJson(boolean removeColumnsAbsentInWeightJson) {
        this.removeColumnsAbsentInWeightJson = removeColumnsAbsentInWeightJson;
        return this;
    }

    public boolean isRemoveColumnsFilledByNaN() {
        return this.removeColumnsFilledByNaN;
    }

    public ScaleAndExtractColumns setRemoveColumnsFilledByNaN(boolean removeColumnsFilledByNaN) {
        this.removeColumnsFilledByNaN = removeColumnsFilledByNaN;
        return this;
    }

    public boolean isRequireNonEmptyResult() {
        return this.requireNonEmptyResult;
    }

    public ScaleAndExtractColumns setRequireNonEmptyResult(boolean requireNonEmptyResult) {
        this.requireNonEmptyResult = requireNonEmptyResult;
        return this;
    }

    @Override
    public SNumbers processNumbers(SNumbers source) {
        SNumbers weightsNumbers = this.getInputNumbers(INPUT_WEIGHTS, true);
        String[] columnNames = this.getInputScalar("column_names", true).toTrimmedLinesWithoutCommentsArray();
        String s = this.getInputScalar(INPUT_WEIGHTS_JSON, true).getValue();
        JsonObject weightsJson = s == null ? null : Jsons.toJson(s, true);
        return this.scaleAndExtractColumns(source, weightsNumbers, columnNames, weightsJson);
    }

    public SNumbers scaleAndExtractColumns(SNumbers source, SNumbers weightsNumbers, String[] columnNames, JsonObject weightsJson) {
        if (!source.isInitialized()) {
            return source;
        }
        int blockLength = source.getBlockLength();
        if (weightsJson != null && columnNames == null) {
            throw new IllegalArgumentException("Column names are not specified, but they are required when weights JSON is used");
        }
        if (columnNames != null) {
            if (columnNames.length < blockLength) {
                throw new IllegalArgumentException("Too short list of column names: only " + columnNames.length + " names, but array has " + blockLength + " columns");
            }
            if (columnNames.length > blockLength) {
                columnNames = Arrays.copyOf(columnNames, blockLength);
            }
        }
        double[] weights = weightsJson != null ? ScaleAndExtractColumns.jsonToWeightsArray(weightsJson, columnNames) : ScaleAndExtractColumns.numbersToWeightsArray(weightsNumbers, blockLength);
        boolean[] removeColumns = this.findRemovedColumns(weights, weightsJson, columnNames, source);
        int resultBlockLength = ScaleAndExtractColumns.resultBlockLength(removeColumns);
        if (columnNames != null) {
            this.getScalar("column_names").setTo(ScaleAndExtractColumns.extractColumnNames(columnNames, removeColumns));
        }
        if (resultBlockLength == 0) {
            if (this.requireNonEmptyResult) {
                throw new IllegalArgumentException("No columns in the result; maybe source weights are empty or incorrect");
            }
            return null;
        }
        if (resultBlockLength == blockLength && Arrays.stream(weights).allMatch(w -> w == 1.0)) {
            return source;
        }
        SNumbers result = SNumbers.zeros(source.elementType(), source.n(), resultBlockLength);
        double[] values = new double[blockLength];
        double[] resultValues = new double[resultBlockLength];
        int length = source.getArrayLength();
        int disp = 0;
        int resultDisp = 0;
        while (disp < length) {
            source.getDoubleValues(disp, blockLength, values);
            int k = 0;
            for (int i = 0; i < values.length; ++i) {
                if (removeColumns[i]) continue;
                resultValues[k++] = values[i] * weights[i];
            }
            result.setDoubleValues(resultDisp, resultBlockLength, resultValues);
            disp += blockLength;
            resultDisp += resultBlockLength;
        }
        return result;
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return super.visibleResultsInformation().addPorts(this.getOutputPort("column_names"));
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }

    @Override
    protected boolean resultRequired() {
        return false;
    }

    private static int resultBlockLength(boolean[] removeColumns) {
        return (int)IntStream.range(0, removeColumns.length).filter(k -> !removeColumns[k]).count();
    }

    private boolean[] findRemovedColumns(double[] weights, JsonObject weightsJson, String[] columnNames, SNumbers source) {
        int k;
        int blockLength = source.getBlockLength();
        assert (blockLength == weights.length);
        boolean[] removeColumns = new boolean[blockLength];
        if (weightsJson != null) {
            assert (columnNames != null);
            for (k = 0; k < blockLength; ++k) {
                if (!this.removeColumnsAbsentInWeightJson || weightsJson.containsKey((Object)columnNames[k])) continue;
                removeColumns[k] = true;
            }
        }
        if (this.removeColumnsWithZeroWeight) {
            for (k = 0; k < blockLength; ++k) {
                if (weights[k] != 0.0) continue;
                removeColumns[k] = true;
            }
        }
        int length = source.getArrayLength();
        if (this.removeColumnsFilledByNaN && length > 0 && source.isFloatingPoint()) {
            for (int k2 = 0; k2 < blockLength; ++k2) {
                if (removeColumns[k2]) continue;
                boolean remove = true;
                for (int disp = k2; disp < length; disp += blockLength) {
                    if (Double.isNaN(source.getValue(disp))) continue;
                    remove = false;
                }
                removeColumns[k2] = remove;
            }
        }
        return removeColumns;
    }

    private static String extractColumnNames(String[] columnNames, boolean[] removeColumns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < removeColumns.length; ++i) {
            if (removeColumns[i]) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(columnNames[i]);
        }
        return sb.toString();
    }

    private static double[] jsonToWeightsArray(JsonObject weightsJson, String[] columnNames) {
        assert (weightsJson != null);
        double[] result = new double[columnNames.length];
        for (int k = 0; k < result.length; ++k) {
            String name = columnNames[k];
            JsonValue jsonValue = (JsonValue)weightsJson.get((Object)name);
            if (jsonValue == null) {
                result[k] = 1.0;
                continue;
            }
            Double weight = ScaleAndExtractColumns.parseDoubleIfPossible(jsonValue);
            if (weight == null) {
                throw new JsonException("Weights JSON for column name \"" + name + "\" contains non-numeric value " + String.valueOf(jsonValue) + ", that cannot be converted to a reasonable number");
            }
            result[k] = weight;
        }
        return result;
    }

    private static double[] numbersToWeightsArray(SNumbers weightsNumbers, int blockLength) {
        double[] result = weightsNumbers.toDoubleArray();
        if (result == null) {
            result = new double[]{};
        }
        if (result.length != blockLength) {
            int oldLength = result.length;
            result = Arrays.copyOf(result, blockLength);
            for (int i = oldLength; i < blockLength; ++i) {
                result[i] = 1.0;
            }
        }
        return result;
    }

    private static Double parseDoubleIfPossible(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).doubleValue();
            }
            case STRING: {
                try {
                    return Double.parseDouble(((JsonString)jsonValue).getString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case FALSE: {
                return 0.0;
            }
            case TRUE: {
                return 1.0;
            }
        }
        return null;
    }
}

