/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.List;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumberArraysOperation;
import net.algart.math.functions.Func;

public final class NumbersDifference
extends SeveralNumberArraysOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private Operation operation = Operation.ABSOLUTE_DIFFERENCE;
    private Class<?> elementType = Float.TYPE;

    public NumbersDifference() {
        super(INPUT_X, INPUT_Y);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public NumbersDifference setOperation(Operation operation) {
        this.operation = NumbersDifference.nonNull(operation);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public NumbersDifference setElementType(Class<?> elementType) {
        this.elementType = NumbersDifference.nonNull(elementType, "element type");
        return this;
    }

    public NumbersDifference setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    @Override
    public PArray process(List<PNumberArray> sources, int ... blockLengths) {
        PNumberArray x = sources.get(0);
        PNumberArray y = sources.get(1);
        return this.operation.reverseOrder ? Arrays.asFuncArray((Func)this.operation.diffFunc, (Class)Arrays.type(PNumberArray.class, this.elementType), (PArray[])new PArray[]{y, x}) : Arrays.asFuncArray((Func)this.operation.diffFunc, (Class)Arrays.type(PNumberArray.class, this.elementType), (PArray[])new PArray[]{x, y});
    }

    public static enum Operation {
        ABSOLUTE_DIFFERENCE(Func.ABS_DIFF, false),
        POSITIVE_DIFFERENCE(Func.POSITIVE_DIFF, false),
        REVERSE_POSITIVE_DIFFERENCE(Func.POSITIVE_DIFF, true),
        SUBTRACT((Func)Func.X_MINUS_Y, false),
        REVERSE_SUBTRACT((Func)Func.X_MINUS_Y, true);

        private final Func diffFunc;
        private final boolean reverseOrder;

        private Operation(Func diffFunc, boolean reverseOrder) {
            this.diffFunc = diffFunc;
            this.reverseOrder = reverseOrder;
        }
    }
}

