/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class CheckNumbersEquality
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private ActionOnFail actionOnFail = ActionOnFail.THROW_EXCEPTION;

    public CheckNumbersEquality() {
        this.addInputNumbers(INPUT_X);
        this.addInputNumbers(INPUT_Y);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public ActionOnFail actionOnFail() {
        return this.actionOnFail;
    }

    public CheckNumbersEquality setActionOnFail(ActionOnFail actionOnFail) {
        this.actionOnFail = CheckNumbersEquality.nonNull(actionOnFail);
        return this;
    }

    @Override
    public void process() {
        SNumbers x = this.getInputNumbers(INPUT_X, true);
        SNumbers y = this.getInputNumbers(INPUT_Y, true);
        boolean result = Objects.equals(x, y);
        this.getScalar().setTo(result);
        if (!result && this.actionOnFail == ActionOnFail.THROW_EXCEPTION) {
            throw new AssertionError((Object)("Different arrays: " + String.valueOf(x) + " and " + String.valueOf(y)));
        }
    }

    public static enum ActionOnFail {
        RETURN_FALSE,
        THROW_EXCEPTION;

    }
}

