/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.misc;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToSeveralScalars;
import net.algart.executors.modules.core.matrices.misc.SimpleImageStatistics;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixInfo
extends MultiMatrixToSeveralScalars {
    private static final String NUMBER_OF_DIMENSIONS = "number_of_dimensions";
    private static final String DIM_X = "dim_x";
    private static final String DIM_Y = "dim_y";
    private static final String DIM_Z = "dim_z";
    private static final String ELEMENT_TYPE = "element_type";
    private static final String MAX_POSSIBLE = "max_possible";
    private static final String NUMBER_OF_CHANNELS = "number_of_channels";
    private static final String DESCRIPTION = "description";
    private static final String[] QUICK_RESULT_PORTS = new String[]{"dim_x", "dim_y", "element_type", "max_possible", "number_of_channels", "description"};
    private boolean rawValues = false;

    public MatrixInfo() {
        this.useVisibleResultParameter();
        for (String string : QUICK_RESULT_PORTS) {
            this.addOutputScalar(string);
        }
        for (SimpleImageStatistics simpleImageStatistics : SimpleImageStatistics.values()) {
            this.addOutputNumbers(simpleImageStatistics.statisticsName());
        }
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public MatrixInfo setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    @Override
    public void analyse(Map<String, SScalar> results, MultiMatrix source) {
        this.analyse(results, this.allOutputContainers(SNumbers.class, true), source);
    }

    public void analyse(Map<String, SScalar> scalars, Map<String, SNumbers> numbers, MultiMatrix source) {
        Objects.requireNonNull(scalars, "Null scalars");
        if (source == null) {
            SScalar.setTo(scalars, DESCRIPTION, () -> "No input matrix");
        } else {
            SScalar.setTo(scalars, NUMBER_OF_DIMENSIONS, source::dimCount);
            SScalar.setTo(scalars, DIM_X, () -> source.dim(0));
            SScalar.setTo(scalars, DIM_Y, () -> source.dim(1));
            SScalar.setTo(scalars, DIM_Z, () -> source.dim(2));
            SScalar.setTo(scalars, ELEMENT_TYPE, source::elementType);
            SScalar.setTo(scalars, MAX_POSSIBLE, source::maxPossibleValue);
            SScalar.setTo(scalars, NUMBER_OF_CHANNELS, source::numberOfChannels);
            SScalar.setTo(scalars, DESCRIPTION, () -> String.format("%s[%d channels, %s] (%d-bit%s)", source.elementType(), source.numberOfChannels(), JArrays.toString((long[])source.dimensions(), (String)"x", (int)1000), source.bitsPerElement(), source.isUnsigned() || source.isFloatingPoint() ? "" : ", signed"));
        }
        for (SimpleImageStatistics statistics : SimpleImageStatistics.values()) {
            SNumbers result = numbers.get(statistics.statisticsName());
            if (result == null) continue;
            long t1 = MatrixInfo.debugTime();
            Object statisticsResult = statistics.allChannelsStatistics(source, this.rawValues);
            long t2 = MatrixInfo.debugTime();
            MatrixInfo.logDebug(() -> String.format(Locale.US, "Calculating %s for %s: %.3f ms", new Object[]{statistics, source, (double)(t2 - t1) * 1.0E-6}));
            result.setToArray(statisticsResult, statistics.channelBlockLength(source));
        }
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

